/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class CFpointObs
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String datatype = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        if (datatype == null) {
            datatype = ds.findAttValueIgnoreCase(null, "CF-featureType", null);
        }
        if (datatype == null) {
            datatype = ds.findAttValueIgnoreCase(null, "CFfeatureType", null);
        }
        if (datatype == null) {
            return false;
        }
        if (CF.FeatureType.valueOf(datatype) == null) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.startsWith("CF")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        if (ftypeS == null) {
            ftypeS = ds.findAttValueIgnoreCase(null, "CF-featureType", null);
        }
        if (ftypeS == null) {
            ftypeS = ds.findAttValueIgnoreCase(null, "CFfeatureType", null);
        }
        CF.FeatureType ftype = ftypeS == null ? CF.FeatureType.point : CF.FeatureType.valueOf(ftypeS);
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, errlog);
            }
            case stationTimeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case stationProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("invalid ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getPointConfig(NetcdfDataset ds, Formatter errlog) {
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(0);
        boolean hasStruct = Evaluator.hasRecordStructure(ds);
        TableConfig obs = new TableConfig(Table.Type.Structure, obsDim.getName());
        obs.structName = hasStruct ? "record" : obsDim.getName();
        obs.isPsuedoStructure = !hasStruct;
        obs.dim = obsDim;
        obs.time = time.getName();
        obs.featureType = FeatureType.POINT;
        CoordSysEvaluator.findCoords(obs, ds);
        return obs;
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        boolean needFinish = false;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        boolean stnIsScalar = lat.getRank() == 0;
        boolean stnIsSingle = lat.getRank() == 1 && lat.getSize() == 1L;
        Dimension stationDim = null;
        if (!stnIsScalar) {
            if (lat.getDimension(0) != lon.getDimension(0)) {
                errlog.format("Lat and Lon coordinate must have same size", new Object[0]);
                return null;
            }
            stationDim = lat.getDimension(0);
        }
        boolean stnIsStruct = Evaluator.hasRecordStructure(ds) && stationDim.isUnlimited();
        Table.Type stationTableType = stnIsScalar ? Table.Type.Top : Table.Type.Structure;
        TableConfig stnTable = new TableConfig(stationTableType, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.isPsuedoStructure = !stnIsStruct;
        stnTable.dim = stationDim;
        stnTable.structName = stnIsStruct ? "record" : stationDim.getName();
        stnTable.lat = lat.getName();
        stnTable.lon = lon.getName();
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (alt != null) {
            stnTable.stnAlt = alt.getName();
        }
        stnTable.stnId = Evaluator.getVariableWithAttribute(ds, "standard_name", "station_id");
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id", new Object[0]);
            return null;
        }
        Variable stnId = ds.findVariable(stnTable.stnId);
        if (!stnIsScalar && !stnId.getDimension(0).equals(stationDim)) {
            errlog.format("Station id outer dimension must match latitude/longitude dimension", new Object[0]);
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        Table.Type obsTableType = null;
        String ragged_parentIndex = Evaluator.getVariableWithAttribute(ds, "standard_name", "ragged_parentIndex");
        String ragged_rowSize = Evaluator.getVariableWithAttribute(ds, "standard_name", "ragged_rowSize");
        if (ragged_parentIndex != null) {
            obsTableType = Table.Type.ParentIndex;
        } else if (ragged_rowSize != null) {
            obsTableType = Table.Type.Contiguous;
        }
        ArrayList<String> obsVars = null;
        if (obsTableType == null) {
            List<Variable> vars = ds.getVariables();
            ArrayList<String> stnVars = new ArrayList<String>(vars.size());
            obsVars = new ArrayList<String>(vars.size());
            for (Variable orgV : vars) {
                Dimension dim0;
                if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(stationDim)) continue;
                if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                    stnVars.add(orgV.getShortName());
                    continue;
                }
                Dimension dim1 = orgV.getDimension(1);
                if (dim1 == null || !dim1.equals(obsDim)) continue;
                obsVars.add(orgV.getShortName());
            }
            if (obsVars.size() > 0) {
                stnTable.vars = stnIsStruct ? null : stnVars;
                Table.Type type = obsTableType = stnIsStruct ? Table.Type.MultiDimInner : Table.Type.MultiDimStructurePsuedo;
            }
        }
        if (obsTableType == null) {
            errlog.format("Unknown Station/Obs", new Object[0]);
            return null;
        }
        TableConfig obs = new TableConfig(obsTableType, obsDim.getName());
        obs.dim = obsDim;
        obs.time = time.getName();
        stnTable.addChild(obs);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && obsDim.isUnlimited();
        obs.structName = obsIsStruct ? "record" : obsDim.getName();
        boolean bl = obs.isPsuedoStructure = !obsIsStruct;
        if (obsTableType == Table.Type.MultiDimInner || obsTableType == Table.Type.MultiDimStructurePsuedo) {
            obs.isPsuedoStructure = !stnIsStruct;
            obs.dim = stationDim;
            obs.inner = obsDim;
            obs.structName = stnIsStruct ? "record" : stationDim.getName();
            obs.vars = obsVars;
            if (time.getRank() == 1) {
                obs.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
            }
        } else if (obsTableType == Table.Type.Contiguous) {
            obs.numRecords = ragged_rowSize;
            obs.start = "raggedStartVar";
            Variable v = ds.findVariable(ragged_rowSize);
            if (!v.getDimension(0).equals(stationDim)) {
                errlog.format("Station - contiguous numRecords must use station dimension", new Object[0]);
                return null;
            }
            Array numRecords = v.read();
            Array startRecord = Array.factory(v.getDataType(), v.getShape());
            int i = 0;
            long count = 0L;
            while (numRecords.hasNext()) {
                startRecord.setLong(i++, count);
                count += numRecords.nextLong();
            }
            VariableDS startV = new VariableDS(ds, v.getParentGroup(), v.getParentStructure(), obs.start, v.getDataType(), v.getDimensionsString(), null, "starting record number for station");
            startV.setCachedData(startRecord, false);
            ds.addVariable(v.getParentGroup(), startV);
            needFinish = true;
        } else if (obsTableType == Table.Type.ParentIndex) {
            Variable rpIndex = ds.findVariable(ragged_parentIndex);
            Array index = rpIndex.read();
            int childIndex = 0;
            HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>((int)(2L * index.getSize()));
            while (index.hasNext()) {
                int parent = index.nextInt();
                ArrayList<Integer> list = (ArrayList<Integer>)map.get(parent);
                if (list == null) {
                    list = new ArrayList<Integer>();
                    map.put(parent, list);
                }
                list.add(childIndex);
                ++childIndex;
            }
            obs.indexMap = map;
        }
        if (needFinish) {
            ds.finish();
        }
        return stnTable;
    }

    protected TableConfig getProfileConfig(NetcdfDataset ds, Formatter errlog) {
        return null;
    }

    protected TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig nt = new TableConfig(Table.Type.Structure, "trajectory");
        nt.featureType = FeatureType.TRAJECTORY;
        CoordSysEvaluator.findCoords(nt, ds);
        TableConfig obs = new TableConfig(Table.Type.MultiDimInner, "record");
        obs.dim = ds.findDimension("sample");
        obs.outer = ds.findDimension("traj");
        nt.addChild(obs);
        return nt;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) {
        return null;
    }
}

