/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFlagTables {
    private static Logger log = LoggerFactory.getLogger(CodeFlagTables.class);
    private static Map<Short, CodeFlagTables> tableMap;
    private short fxy;
    private String name;
    private Map<Integer, String> map;

    public static CodeFlagTables getTable(short id) {
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        return tableMap.get(id);
    }

    public static boolean hasTable(short id) {
        CodeFlagTables result;
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        return (result = tableMap.get(id)) != null;
    }

    static void init() {
        tableMap = new HashMap<Short, CodeFlagTables>(100);
        String filename = "/resources/bufrTables/codes/Code-FlagTables.xml";
        InputStream is = CodeFlagTables.class.getResourceAsStream(filename);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(is);
            Element root = tdoc.getRootElement();
            for (Element elem : root.getChildren("table")) {
                List cElems;
                String kind = elem.getAttributeValue("kind");
                if (kind == null || !kind.equals("code") || (cElems = elem.getChildren("code")).size() == 0) continue;
                String name = elem.getAttributeValue("name");
                String desc = elem.getAttributeValue("desc");
                CodeFlagTables ct = new CodeFlagTables(name, desc);
                tableMap.put(ct.fxy, ct);
                for (Element cElem : cElems) {
                    String valueS = cElem.getAttributeValue("value").trim();
                    String text = cElem.getText();
                    if (text.toLowerCase().startsWith("reserved") || text.toLowerCase().startsWith("not used")) continue;
                    try {
                        int value = Integer.parseInt(valueS);
                        ct.addValue(value, text);
                    }
                    catch (NumberFormatException e) {
                        log.warn("NumberFormatException on '" + valueS + "' for CodeTable " + name + " in " + filename);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Can't read BUFR code table " + filename, e);
        }
    }

    private CodeFlagTables(String id, String name) {
        this.fxy = this.getFxy(id);
        this.name = StringUtil.replace(name, ' ', "_");
        this.map = new HashMap<Integer, String>(20);
    }

    private short getFxy(String name) {
        try {
            String[] tok = name.split(" ");
            int f = tok.length > 0 ? Integer.parseInt(tok[0]) : 0;
            int x = tok.length > 1 ? Integer.parseInt(tok[1]) : 0;
            int y = tok.length > 2 ? Integer.parseInt(tok[2]) : 0;
            return (short)((f << 14) + (x << 8) + y);
        }
        catch (NumberFormatException e) {
            log.warn("Illegal table name=" + name);
            return 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    private void addValue(int value, String text) {
        this.map.put(value, text);
    }
}

