/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CodeTableGen {
    static String root = "C:/dev/tds/bufr/resources/resources/bufr/codes/";
    static String orgXml = root + "Code-FlagTables-11-2007.xml";
    static String trans1 = root + "Code-FlagTables-11-2007.trans1.xml";
    static String trans2 = root + "Code-FlagTables-11-2007.trans2.xml";
    Formatter out = new Formatter(System.out);
    BufferedReader dataIS;
    String line;
    static Formatter f = new Formatter(System.out);

    CodeTableGen(String filename) throws IOException {
        this.dataIS = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        this.getNextLine();
        for (int count = 0; this.readCodeTable() && count < 100; ++count) {
            this.out.format("%d ", count);
        }
        this.out.flush();
        this.dataIS.close();
    }

    private boolean getNextLine() throws IOException {
        this.line = this.dataIS.readLine();
        return this.line != null;
    }

    private boolean readCodeTable() throws IOException {
        int x = Integer.parseInt(this.line.substring(0, 3));
        int y = Integer.parseInt(this.line.substring(3, 6));
        int ncodes = Integer.parseInt(this.line.substring(7, 11));
        this.out.format("Code 0-%d-%d ncodes=%d %n", x, y, ncodes);
        int countCodes = 0;
        boolean first = true;
        while (this.readOneCode(first)) {
            if (!this.getNextLine()) {
                return false;
            }
            first = false;
            ++countCodes;
        }
        if (countCodes != ncodes) {
            this.out.format("*** Really %d codes %n", countCodes);
        }
        return true;
    }

    private boolean readOneCode(boolean first) throws IOException {
        if (!first && this.line.substring(0, 3).trim().length() != 0) {
            return false;
        }
        int code = Integer.parseInt(this.line.substring(12, 16));
        int nlines = Integer.parseInt(this.line.substring(17, 19));
        String value = this.line.substring(20);
        if (nlines > 1) {
            for (int j = 1; j < nlines; ++j) {
                if (!this.getNextLine()) {
                    return false;
                }
                value = value + this.line.substring(20);
            }
        }
        this.out.format("   code %d = %s %n", code, value);
        return true;
    }

    public static void prettyPrint() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build("C:/docs/bufr/wmo/Code-FlagTables-11-2007.xml");
            Format pretty = Format.getPrettyFormat();
            String sep = pretty.getLineSeparator();
            String ind = pretty.getIndent();
            String mine = "\r\n";
            pretty.setLineSeparator(mine);
            XMLOutputter fmt = new XMLOutputter(pretty);
            FileWriter pw = new FileWriter("C:/docs/bufr/wmo/wordNice.txt");
            fmt.output(doc, (Writer)pw);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void transform(Element elem, Element telem) {
        String s;
        Element nelem;
        String name = elem.getName();
        if (name.equals("sub-section") || name.equals("tc")) {
            nelem = new Element(name);
            telem.addContent(nelem);
            telem = nelem;
        }
        if (name.equals("r") && !CodeTableGen.hasAncestor(telem, "tc")) {
            nelem = new Element(name);
            telem.addContent(nelem);
            telem = nelem;
        }
        if ((s = elem.getText()) != null && (s = s.trim()).length() > 0) {
            telem.addContent(s);
        }
        if (name.equals("noBreakHyphen")) {
            telem.addContent("-");
            return;
        }
        for (Object o : elem.getChildren()) {
            Element e = (Element)o;
            CodeTableGen.transform(e, telem);
        }
    }

    static boolean hasAncestor(Element e, String name) {
        while (e != null) {
            if (e.getName().equals(name)) {
                return true;
            }
            e = e.getParentElement();
        }
        return false;
    }

    public static void passOne() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document orgDoc = builder.build(orgXml);
            Document tdoc = new Document();
            Element root = new Element("tdoc");
            tdoc.setRootElement(root);
            CodeTableGen.transform(orgDoc.getRootElement(), root);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static void transform2(Element root, Element nroot) {
        String lastRtext = null;
        for (Element e : root.getChildren("sub-section")) {
            lastRtext = CodeTableGen.subSection(e, lastRtext, nroot);
        }
    }

    private static String subSection(Element elem, String lastRtext, Element nroot) {
        String desc;
        List rElems = elem.getChildren("r");
        List tcElems = elem.getChildren("tc");
        String string = desc = rElems.size() > 0 ? ((Element)rElems.get(0)).getText() : "unknown";
        if (lastRtext == null || lastRtext.equals("0 20 003") || lastRtext.equals("0 31 031") || lastRtext.equals("0 35 000")) {
            f.format("skip %s %s %n", lastRtext, desc);
        } else {
            Element tableElem = new Element("table");
            nroot.addContent(tableElem);
            tableElem.setAttribute("name", lastRtext);
            tableElem.setAttribute("desc", desc);
            f.format("------%n%s == %s%n", lastRtext, desc);
            if (tcElems.size() > 0) {
                String kinds = ((Element)tcElems.get(0)).getText().toLowerCase();
                String kind = kinds.startsWith("code") ? "code" : (kinds.startsWith("bit") ? "bit" : "unknown");
                tableElem.setAttribute("kind", kind);
            }
            for (int i = 2; i < tcElems.size(); i += 2) {
                String value = ((Element)tcElems.get(i)).getText();
                String text = i + 1 < tcElems.size() ? ((Element)tcElems.get(i + 1)).getText() : "unknown";
                Element codeElem = new Element("code");
                tableElem.addContent(codeElem);
                codeElem.setAttribute("value", value);
                codeElem.addContent(text);
                f.format("%s == %s %n", value, text);
            }
        }
        return rElems.size() > 0 ? ((Element)rElems.get(rElems.size() - 1)).getText() : null;
    }

    public static void passTwo() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(trans1);
            Document ndoc = new Document();
            Element nroot = new Element("ndoc");
            ndoc.setRootElement(nroot);
            CodeTableGen.transform2(tdoc.getRootElement(), nroot);
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            Writer pw = new FileWriter(trans2);
            fmt.output(ndoc, pw);
            pw = new PrintWriter(System.out);
            fmt.output(ndoc, pw);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static void transform3(Element root) {
        for (Element elem : root.getChildren("table")) {
            boolean tableShown = false;
            String name = elem.getAttributeValue("name");
            String desc = elem.getAttributeValue("desc");
            List cElems = elem.getChildren("code");
            if (cElems.size() == 0) continue;
            String kind = elem.getAttributeValue("kind");
            if (kind == null || kind.equals("unknown")) {
                f.format("%nTable %s %s kind=%s %n", name, desc, kind);
                tableShown = true;
            }
            for (Element cElem : cElems) {
                String value = cElem.getAttributeValue("value").trim();
                String text = cElem.getText();
                if (text.toLowerCase().startsWith("reserved") || text.toLowerCase().startsWith("not used")) continue;
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (!tableShown) {
                        f.format("%nTable %s %s kind=%s %n", name, desc, kind);
                    }
                    tableShown = true;
                    if (0 != CodeTableGen.parseAll(value)) continue;
                    f.format(" problem parsing code %s == %s %n", value, text);
                }
            }
        }
    }

    static int parseAll(String text) {
        String[] tok = text.split(" ");
        if (tok.length != 2) {
            return 0;
        }
        if (!tok[0].equalsIgnoreCase("all")) {
            return 0;
        }
        try {
            int n = Integer.parseInt(tok[1]);
            int n2 = (int)Math.pow(2.0, n) - 1;
            f.format(" parse %s == %d %n", text, n2);
            return n2;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void passThree() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(trans2);
            CodeTableGen.transform3(tdoc.getRootElement());
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void main(String[] args) throws IOException {
        CodeTableGen.passThree();
    }
}

