/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ucar.grib.GribChecker;
import ucar.grib.grib1.Grib1IndexExtender;
import ucar.grib.grib1.Grib1Indexer;
import ucar.grib.grib2.Grib2IndexExtender;
import ucar.grib.grib2.Grib2Indexer;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.unidata.io.RandomAccessFile;

public final class GribIndexer {
    private static final boolean removeGBX = false;
    private List<String> dirs = new ArrayList<String>();

    private boolean readConf(String conf) throws IOException {
        String line;
        FileInputStream ios = new FileInputStream(conf);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("#")) continue;
            this.dirs.add(line);
        }
        ((InputStream)ios).close();
        return true;
    }

    private void clearLocks() {
        for (String dir : this.dirs) {
            File f = new File(dir + "/IndexLock");
            if (f.exists()) {
                f.delete();
                System.out.println("Cleared lock " + dir + "/IndexLock");
                continue;
            }
            System.out.println("In directory " + dir);
        }
    }

    private void indexer() throws IOException {
        System.out.println("Start " + Calendar.getInstance().getTime().toString());
        long start = System.currentTimeMillis();
        for (String dir : this.dirs) {
            File d = new File(dir);
            if (!d.exists()) {
                System.out.println("Dir " + dir + " doesn't exists");
                continue;
            }
            File dl = new File(dir + "/IndexLock");
            if (dl.exists()) {
                System.out.println("Exiting " + dir + " another Indexer working here");
                continue;
            }
            dl.createNewFile();
            this.checkDirs(d);
            dl.delete();
        }
        System.out.println("End " + Calendar.getInstance().getTime().toString());
        System.out.println("Total time in ms " + (System.currentTimeMillis() - start));
    }

    private void checkDirs(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String aChildren : children = dir.list()) {
                if (aChildren.equals("IndexLock")) continue;
                File child = new File(dir, aChildren);
                if (child.isDirectory()) {
                    this.checkDirs(child);
                    continue;
                }
                if (aChildren.endsWith("gbx") || aChildren.endsWith("gbx2") || aChildren.endsWith("xml") || aChildren.endsWith("tmp") || aChildren.length() == 0) continue;
                this.checkIndex(dir, child);
            }
        }
    }

    private void checkIndex(File dir, File grib) throws IOException {
        String[] args = new String[2];
        File gbx = new File(dir, grib.getName() + ".gbx");
        args[0] = grib.getParent() + "/" + grib.getName();
        args[1] = grib.getParent() + "/" + gbx.getName();
        if (gbx.exists()) {
            if (System.currentTimeMillis() - grib.lastModified() > 10800000L) {
                return;
            }
            if (grib.length() == this.lengthGbx(args[1])) {
                return;
            }
            if (gbx.length() == 0L) {
                System.out.println("ERROR " + args[1] + " has length zero");
                return;
            }
        }
        if (grib.getName().endsWith("grib1")) {
            this.grib1check(grib, gbx, args);
        } else if (grib.getName().endsWith("grib2")) {
            this.grib2check(grib, gbx, args);
        } else {
            RandomAccessFile raf = new RandomAccessFile(args[0], "r");
            int result = GribChecker.getEdition(raf);
            if (result == 2) {
                this.grib2check(grib, gbx, args);
            } else if (result == 1) {
                this.grib1check(grib, gbx, args);
            } else {
                System.out.println("Not a Grib File " + args[0]);
            }
            raf.close();
        }
    }

    private void grib1check(File grib, File gbx, String[] args) {
        try {
            if (gbx.exists()) {
                System.out.println("IndexExtending " + grib.getName() + " " + Calendar.getInstance().getTime().toString());
                Grib1IndexExtender.main(args);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            } else {
                System.out.println("Indexing " + grib.getName() + " " + Calendar.getInstance().getTime().toString());
                Grib1Indexer.main(args);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Caught Exception doing index or inventory for " + grib.getName());
        }
    }

    private void grib2check(File grib, File gbx, String[] args) {
        try {
            if (gbx.exists()) {
                System.out.println("IndexExtending " + grib.getName() + " " + Calendar.getInstance().getTime().toString());
                Grib2IndexExtender.main(args);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            } else {
                System.out.println("Indexing " + grib.getName() + " " + Calendar.getInstance().getTime().toString());
                Grib2Indexer.main(args);
                ForecastModelRunInventory.open(null, args[0], 2, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Caught Exception doing index or inventory for " + grib.getName());
        }
    }

    private long lengthGbx(String gbx) throws IOException {
        String line;
        FileInputStream ios = new FileInputStream(gbx);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        long length = -1L;
        while ((line = dataIS.readLine()) != null && !line.startsWith("---")) {
            if (!line.startsWith("length")) continue;
            String len = line.substring(line.indexOf(" = ") + 3);
            length = Long.parseLong(len);
            break;
        }
        ((InputStream)ios).close();
        return length;
    }

    public static void main(String[] args) throws IOException {
        GribIndexer gi = new GribIndexer();
        boolean clear = false;
        for (String arg : args) {
            if (arg.equals("clear")) {
                clear = true;
                System.out.println("Clearing Index locks");
                continue;
            }
            File f = new File(arg);
            if (!f.exists()) {
                System.out.println("Conf file " + arg + " doesn't exist: ");
                return;
            }
            gi.readConf(arg);
        }
        if (clear) {
            gi.clearLocks();
            return;
        }
        gi.indexer();
    }
}

