/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridTimeCoord {
    private static Logger log = LoggerFactory.getLogger(GridTimeCoord.class);
    private DateFormatter formatter = new DateFormatter();
    private Calendar calendar;
    private String name;
    private GridTableLookup lookup;
    private List<Date> times = new ArrayList<Date>();
    private int seq = 0;

    GridTimeCoord() {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    GridTimeCoord(List<GridRecord> records, GridTableLookup lookup) {
        this();
        this.lookup = lookup;
        this.addTimes(records);
        Collections.sort(this.times);
    }

    GridTimeCoord(String name, double[] offsetHours, GridTableLookup lookup) {
        this();
        this.name = name;
        this.lookup = lookup;
        Date baseTime = lookup.getFirstBaseTime();
        String refDate = this.formatter.toDateTimeStringISO(baseTime);
        DateUnit convertUnit = null;
        try {
            convertUnit = new DateUnit("hours since " + refDate);
        }
        catch (Exception e) {
            log.error("TimeCoord not added, cant make DateUnit from String 'hours since " + refDate + "'", e);
            return;
        }
        this.times = new ArrayList<Date>(offsetHours.length);
        for (double offsetHour : offsetHours) {
            this.times.add(convertUnit.makeDate(offsetHour));
        }
    }

    void addTimes(List<GridRecord> records) {
        for (GridRecord record : records) {
            Date validTime = this.getValidTime(record, this.lookup);
            if (this.times.contains(validTime)) continue;
            this.times.add(validTime);
        }
    }

    boolean matchLevels(List<GridRecord> records) {
        ArrayList<Date> timeList = new ArrayList<Date>(records.size());
        for (GridRecord record : records) {
            Date validTime = this.getValidTime(record, this.lookup);
            if (timeList.contains(validTime)) continue;
            timeList.add(validTime);
        }
        Collections.sort(timeList);
        return ((Object)timeList).equals(this.times);
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.seq == 0 ? "time" : "time" + this.seq;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        Collections.sort(this.times);
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNTimes(), true));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        Variable v = new Variable(ncfile, g, null, this.getName());
        v.setDataType(DataType.INT);
        v.addAttribute(new Attribute("long_name", "forecast time"));
        int ntimes = this.getNTimes();
        int[] data = new int[ntimes];
        Date baseTime = this.lookup.getFirstBaseTime();
        String timeUnit = this.lookup.getFirstTimeRangeUnitName();
        String refDate = this.formatter.toDateTimeStringISO(baseTime);
        DateUnit dateUnit = null;
        try {
            dateUnit = new DateUnit(timeUnit + " since " + refDate);
        }
        catch (Exception e) {
            log.error("TimeCoord not added, cant make DateUnit from String '" + timeUnit + " since " + refDate + "'", e);
            return;
        }
        for (int i = 0; i < this.times.size(); ++i) {
            Date validTime = this.times.get(i);
            data[i] = (int)dateUnit.makeValue(validTime);
        }
        Array dataArray = Array.factory(DataType.INT, new int[]{ntimes}, (Object)data);
        v.setDimensions(v.getShortName());
        v.setCachedData(dataArray, false);
        Date d = this.lookup.getFirstBaseTime();
        v.addAttribute(new Attribute("units", timeUnit + " since " + refDate));
        if (this.lookup instanceof Grib2GridTableLookup) {
            Grib2GridTableLookup g2lookup = (Grib2GridTableLookup)this.lookup;
            v.addAttribute(new Attribute("GRIB_orgReferenceTime", this.formatter.toDateTimeStringISO(d)));
            v.addAttribute(new Attribute("GRIB2_significanceOfRTName", g2lookup.getFirstSignificanceOfRTName()));
        } else if (this.lookup instanceof Grib1GridTableLookup) {
            Grib1GridTableLookup g1lookup = (Grib1GridTableLookup)this.lookup;
            v.addAttribute(new Attribute("GRIB_orgReferenceTime", this.formatter.toDateTimeStringISO(d)));
            v.addAttribute(new Attribute("GRIB2_significanceOfRTName", g1lookup.getFirstSignificanceOfRTName()));
        }
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ncfile.addVariable(g, v);
    }

    int getIndex(GridRecord record) {
        Date validTime = this.getValidTime(record, this.lookup);
        return this.times.indexOf(validTime);
    }

    Date getValidTime(GridRecord record) {
        return this.getValidTime(record, this.lookup);
    }

    int getNTimes() {
        return this.times.size();
    }

    private Date getValidTime(GridRecord record, GridTableLookup lookup) {
        Date validTime = record.getValidTime();
        if (validTime != null) {
            return validTime;
        }
        try {
            validTime = this.formatter.getISODate(record.getReferenceTime().toString());
        }
        catch (Throwable e) {
            log.error("getValidTime(" + record.getReferenceTime() + ")", e);
            return null;
        }
        int calandar_unit = 10;
        int factor = 1;
        String timeUnit = lookup.getFirstTimeRangeUnitName();
        if (timeUnit.equalsIgnoreCase("hour") || timeUnit.equalsIgnoreCase("hours")) {
            factor = 1;
        } else if (timeUnit.equalsIgnoreCase("minutes") || timeUnit.equalsIgnoreCase("minute")) {
            calandar_unit = 12;
        } else if (timeUnit.equalsIgnoreCase("second") || timeUnit.equalsIgnoreCase("secs")) {
            calandar_unit = 13;
        } else if (timeUnit.equalsIgnoreCase("day") || timeUnit.equalsIgnoreCase("days")) {
            factor = 24;
        } else if (timeUnit.equalsIgnoreCase("month") || timeUnit.equalsIgnoreCase("months")) {
            factor = 720;
        } else if (timeUnit.equalsIgnoreCase("year") || timeUnit.equalsIgnoreCase("years") || timeUnit.equalsIgnoreCase("1year")) {
            factor = 8760;
        } else if (timeUnit.equalsIgnoreCase("decade")) {
            factor = 87600;
        } else if (timeUnit.equalsIgnoreCase("century")) {
            factor = 876000;
        } else if (timeUnit.equalsIgnoreCase("3hours")) {
            factor = 3;
        } else if (timeUnit.equalsIgnoreCase("6hours")) {
            factor = 6;
        } else if (timeUnit.equalsIgnoreCase("12hours")) {
            factor = 12;
        }
        this.calendar.setTime(validTime);
        this.calendar.add(calandar_unit, factor * record.getValidTimeOffset());
        validTime = this.calendar.getTime();
        return validTime;
    }
}

