/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import edu.wisc.ssec.mcidas.McIDASUtil;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.CancelTask;

public class McIDASSatConvention
extends CoordSysBuilder {
    public McIDASSatConvention() {
        this.conventionName = "McIDAS-Sat";
    }

    public static boolean isMine(NetcdfFile ncfile) {
        return null != ncfile.findVariable("imageDate") && null != ncfile.findVariable("imageTime") && null != ncfile.findVariable("imageDate") && null != ncfile.findDimension("lines") && null != ncfile.findDimension("elems") && null != ncfile.findDimension("bands") && null != ncfile.findVariable("data");
    }

    protected void findCoordinateAxes(NetcdfDataset ds) {
        for (CoordSysBuilder.VarProcess vp : this.varList) {
            String coordsString;
            if (vp.coordAxes != null || (coordsString = ds.findAttValueIgnoreCase(vp.v, "coordinates", null)) == null) continue;
            vp.coordinates = coordsString;
        }
        super.findCoordinateAxes(ds);
    }

    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getName();
        if (vname.equalsIgnoreCase("longitude")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("latitude")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("bands")) {
            return AxisType.GeoZ;
        }
        return null;
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        if (null != ds.findVariable("time")) {
            return;
        }
        Dimension dimx = ds.findDimension("elems");
        int nx = dimx.getLength();
        Dimension dimy = ds.findDimension("lines");
        int ny = dimy.getLength();
        Variable datav = ds.findVariable("data");
        String long_name = ds.findAttValueIgnoreCase(null, "channel", null);
        datav.addAttribute(new Attribute("units", ""));
        datav.addAttribute(new Attribute("coordinates", "longitude latitude"));
        Variable bandv = ds.findVariable("bands");
        Float missingValue = new Float(2.1432893E9f);
        Attribute missingAttr = new Attribute("missing_value", missingValue);
        ArrayFloat.D1 vrLat = new ArrayFloat.D1(2);
        vrLat.set(0, -90.0f);
        vrLat.set(1, 90.0f);
        Variable latv = ds.findVariable("latitude");
        latv.addAttribute(missingAttr);
        latv.addAttribute(new Attribute("valid_range", vrLat));
        latv.addAttribute(new Attribute("units", "degrees_north"));
        ArrayFloat.D1 vrLon = new ArrayFloat.D1(2);
        vrLon.set(0, -180.0f);
        vrLon.set(1, 180.0f);
        Variable lonv = ds.findVariable("longitude");
        lonv.addAttribute(missingAttr);
        lonv.addAttribute(new Attribute("valid_range", vrLon));
        lonv.addAttribute(new Attribute("units", "degrees_east"));
        int timeVal = 0;
        int dayVal = 0;
        try {
            Variable time = ds.findVariable("imageTime");
            timeVal = time.readScalarInt();
            Variable day = ds.findVariable("imageDate");
            dayVal = day.readScalarInt();
        }
        catch (Exception ioe) {
            // empty catch block
        }
        double secs = McIDASUtil.mcDayTimeToSecs(dayVal, timeVal);
        VariableDS timeVar = new VariableDS(ds, null, null, "time", DataType.DOUBLE, null, "seconds since 1970-01-01 00:00:00", "time");
        ArrayDouble.D1 varArray = new ArrayDouble.D1(1);
        varArray.set(0, secs);
        timeVar.setCachedData(varArray, false);
        ds.addVariable(null, timeVar);
        ds.finish();
    }

    private CoordinateAxis makeCoordAxis(NetcdfDataset ds, int num, String name, String axisName) {
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, name, DataType.INT, name, null, axisName + " on image");
        v.addAttribute(new Attribute("axis", axisName));
        ds.setValues(v, num, 0.0, 1.0);
        return v;
    }
}

