/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.stream.NcStreamRemote;

public class CdmRemoteDatasetFactory {
    private static boolean showXML = true;

    public static FeatureDataset factory(FeatureType wantFeatureType, String endpoint) throws IOException {
        if (endpoint.startsWith("cdmremote:")) {
            endpoint = endpoint.substring("cdmremote:".length());
        }
        Document doc = CdmRemoteDatasetFactory.getCapabilities(endpoint);
        Element root = doc.getRootElement();
        Element elem = root.getChild("featureDataset");
        String fType = elem.getAttribute("type").getValue();
        String datasetUri = elem.getAttribute("url").getValue();
        System.out.printf("CdmRemoteDatasetFactory endpoint %s getCapabilities= %s %s%n", endpoint, fType, datasetUri);
        FeatureType ft = FeatureType.valueOf(fType);
        NcStreamRemote ncremote = new NcStreamRemote(datasetUri, null);
        NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncremote, null);
        if (ft == null || ft == FeatureType.GRID) {
            return new GridDataset(ncd);
        }
        return new PointDatasetRemote(ft, ncd, ncremote);
    }

    private static Document getCapabilities(String endpoint) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            doc = builder.build(endpoint + "?getCapabilities");
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (showXML) {
            System.out.printf("*** endpoint = %s %n", endpoint);
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.printf("*** NetcdfDataset/showParsedXML = %n %s %n", xmlOut.outputString(doc));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String endpoint = "http://localhost:8080/thredds/ncstream/point/data";
        FeatureDatasetPoint fd = (FeatureDatasetPoint)CdmRemoteDatasetFactory.factory(FeatureType.ANY, endpoint);
        PointFeatureCollection pc = (PointFeatureCollection)fd.getPointFeatureCollectionList().get(0);
        PointFeatureIterator pfIter = pc.getPointFeatureIterator(-1);
        try {
            while (pfIter.hasNext()) {
                PointFeature pf = pfIter.next();
                System.out.println("pf= " + pf);
            }
            Object var7_6 = null;
            pfIter.finish();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            pfIter.finish();
            throw throwable;
        }
    }
}

