/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds.server;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import thredds.catalog.crawl.CatalogCrawler;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.thredds.ThreddsDataFactory;

public class TestGribAgg
implements CatalogCrawler.Listener {
    static boolean showAll = false;
    private ThreddsDataFactory tdataFactory = new ThreddsDataFactory();
    private PrintStream out = null;
    private ArrayList fileList = new ArrayList();
    private boolean first = true;
    private HashMap hash = new HashMap();

    TestGribAgg(String catalog, PrintStream out, boolean showTimeDims) throws IOException {
        this.out = out;
        CatalogCrawler crawler = new CatalogCrawler(0, false, this);
        crawler.crawl(catalog, null, out);
        this.report(out, showTimeDims);
        for (int i = 0; i < this.fileList.size(); ++i) {
            GridDataset ds = (GridDataset)this.fileList.get(i);
            ds.close();
        }
    }

    TestGribAgg(InvDataset top, PrintStream out) throws IOException {
        this.out = out;
        CatalogCrawler crawler = new CatalogCrawler(0, false, this);
        crawler.crawlDirectDatasets(top, null, out);
        this.report(out, false);
        for (int i = 0; i < this.fileList.size(); ++i) {
            GridDataset ds = (GridDataset)this.fileList.get(i);
            ds.close();
        }
    }

    public void getDataset(InvDataset dd) {
        if (null != dd.getAccess(ServiceType.RESOLVER)) {
            return;
        }
        if (this.first) {
            this.first = false;
            return;
        }
        try {
            ThreddsDataFactory.Result result = this.tdataFactory.openFeatureDataset(dd, null);
            if (result.fatalError) {
                this.out.println("***CAN'T OPEN " + dd.getName());
                return;
            }
            this.process(result.featureDataset.getNetcdfFile());
            this.fileList.add(result.featureDataset);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getCatalogRef(InvCatalogRef dd) {
        return true;
    }

    private void process(NetcdfFile ncd) {
        this.out.println(" process " + ncd.getLocation());
        List<Variable> vars = ncd.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = vars.get(i);
            if (v.isCoordinateVariable()) continue;
            UberVariable uv = (UberVariable)this.hash.get(v.getName());
            if (uv == null) {
                uv = new UberVariable(v);
                this.hash.put(v.getName(), uv);
                continue;
            }
            uv.vars.add(v);
        }
    }

    private void report(PrintStream out, boolean showTimeDims) {
        ArrayList values = new ArrayList(this.hash.values());
        Collections.sort(values);
        for (int i = 0; i < values.size(); ++i) {
            UberVariable uv = (UberVariable)values.get(i);
            uv.reportDims(out);
            if (!showTimeDims) continue;
            uv.reportTimeDims(out);
        }
    }

    private static void findDatasetScan(String catUrl, PrintStream out) throws IOException {
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogImpl cat = catFactory.readXML(catUrl);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
        out.println(" validation output=\n" + buff);
        if (!isValid) {
            return;
        }
        List<InvDataset> datasets = cat.getDatasets();
        TestGribAgg.findDatasetScan(datasets, out);
    }

    private static void findDatasetScan(List datasets, PrintStream out) throws IOException {
        for (int i = 0; i < datasets.size(); ++i) {
            InvDataset ds = (InvDataset)datasets.get(i);
            if (null != ds.findProperty("DatasetScan")) {
                out.println(ds.getName());
                new TestGribAgg(ds, out);
                continue;
            }
            TestGribAgg.findDatasetScan(ds.getDatasets(), out);
        }
    }

    public static void main(String[] args) throws IOException {
        FileOutputStream fos = new FileOutputStream("C:/dev/netcdf-java-2.2/doc/TestGribAgg.txt");
        PrintStream out = new PrintStream(fos);
        TestGribAgg.findDatasetScan("http://motherlode.ucar.edu:9080/thredds/idd/ruc_model.xml", out);
        TestGribAgg.findDatasetScan("http://motherlode.ucar.edu:9080/thredds/idd/nam_model.xml", out);
    }

    private class UberVariable
    implements Comparable {
        Variable firstv;
        ArrayList vars = new ArrayList();

        UberVariable(Variable v) {
            this.firstv = v;
        }

        public int compareTo(Object o) {
            UberVariable ov = (UberVariable)o;
            return this.getName().compareTo(ov.getName());
        }

        public String getName() {
            return this.firstv.getName();
        }

        private void reportTimeDims(PrintStream out) {
            boolean showed = false;
            int[] firstshape = this.firstv.getShape();
            int dim = 0;
            for (int i = 0; i < this.vars.size(); ++i) {
                Variable v = (Variable)this.vars.get(i);
                int[] shape = v.getShape();
                if (dim < shape.length && shape[dim] == firstshape[dim] && !showAll) continue;
                this.showTimeCoordinates(out);
                showed = true;
                break;
            }
            if (showed) {
                out.println();
            }
        }

        private void showTimeCoordinates(PrintStream out) {
            this.showTimeCoordinates(out, this.firstv);
            for (int i = 0; i < this.vars.size(); ++i) {
                Variable v = (Variable)this.vars.get(i);
                this.showTimeCoordinates(out, v);
            }
        }

        private void showTimeCoordinates(PrintStream out, Variable v) {
            if (v.getRank() == 0) {
                return;
            }
            Dimension d = v.getDimension(0);
            List<Variable> list = d.getCoordinateVariables();
            if (list.size() == 0) {
                return;
            }
            Variable timeV = list.get(0);
            Array data = null;
            try {
                data = timeV.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            NCdump.printArray(data, timeV.getName(), out, null);
        }

        private void reportDims(PrintStream out) {
            StringBuffer buff = new StringBuffer();
            this.firstv.getNameAndDimensions(buff);
            out.println(buff + ": ");
            boolean showed = false;
            int[] firstshape = this.firstv.getShape();
            block0: for (int dim = 0; dim < firstshape.length; ++dim) {
                for (int i = 0; i < this.vars.size(); ++i) {
                    Variable v = (Variable)this.vars.get(i);
                    int[] shape = v.getShape();
                    if (dim < shape.length && shape[dim] == firstshape[dim] && !showAll) continue;
                    this.showShape(out, dim);
                    showed = true;
                    continue block0;
                }
            }
            if (showed) {
                out.println();
            }
        }

        private void showShape(PrintStream out, int dim) {
            out.print(" dim " + dim + "=[");
            int[] shape = this.firstv.getShape();
            if (dim < shape.length) {
                out.print(shape[dim]);
            } else {
                out.print("*");
            }
            for (int i = 0; i < this.vars.size(); ++i) {
                Variable v = (Variable)this.vars.get(i);
                shape = v.getShape();
                if (dim < shape.length) {
                    out.print("," + shape[dim]);
                    continue;
                }
                out.print(",*");
            }
            out.println("]");
        }

        private void showDimNames(PrintStream out, int dim) {
            out.print(" dim " + dim + "=[");
            if (dim < this.firstv.getRank()) {
                out.print(this.firstv.getDimension(dim).getName());
            } else {
                out.print("*");
            }
            for (int i = 0; i < this.vars.size(); ++i) {
                Variable v = (Variable)this.vars.get(i);
                if (dim < v.getRank()) {
                    out.print("," + v.getDimension(dim).getName());
                    continue;
                }
                out.print(",*");
            }
            out.println("]");
        }
    }
}

