/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds.server;

import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import ucar.ma2.Section;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMotherlodeLatest
extends TimerTask {
    private static final String server1 = "http://motherlode.ucar.edu:8080/";
    private static final String server2 = "http://motherlode.ucar.edu:8081/";
    private static final String latestPrefix = "thredds/catalog/fmrc/";
    private static final String latestSuffix = "/files/latest.xml";
    private static final String bestPrefix = "thredds/dodsC/fmrc/";
    private static final String bestSuffix = "_best.ncd";
    private String suffix;
    private String model;

    TestMotherlodeLatest(String model, String suffix) {
        this.model = model;
        this.suffix = suffix;
    }

    @Override
    public void run() {
        try {
            System.out.printf("Run %s%n", new Date());
            this.doOne(this.model, this.suffix);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void doAll() throws IOException {
        for (String model : FmrcDefinition.fmrcDatasets) {
            this.doOne(model, this.suffix);
        }
    }

    void doOne(String model, String suffix) throws IOException {
        GridDataset gds1 = this.getDataset(this.makeDatasetURL(server1, model, suffix));
        GridDataset gds2 = this.getDataset(this.makeDatasetURL(server2, model, suffix));
        System.out.printf(" compare 1 to 2%n", new Object[0]);
        this.compare(gds1, gds2);
        System.out.printf(" compare 2 to 1%n", new Object[0]);
        this.compare(gds2, gds1);
        System.out.printf(" DONE%n%n", new Object[0]);
        gds1.close();
        gds2.close();
    }

    String makeDatasetURL(String server, String model, String suffix) {
        if (suffix.endsWith(".xml")) {
            return "thredds:resolve:" + server + latestPrefix + model + suffix;
        }
        return server + bestPrefix + model + suffix;
    }

    private GridDataset getDataset(String ds) throws IOException {
        Formatter errlog = new Formatter();
        FeatureDataset result = FeatureDatasetFactoryManager.open(FeatureType.GRID, ds, null, errlog);
        System.out.printf(" %s result errlog= %s%n", ds, errlog);
        assert (result != null);
        assert (result instanceof GridDataset);
        GridDataset dataset = (GridDataset)((Object)result);
        System.out.printf(" dataset=%s%n", dataset.getLocationURI());
        return dataset;
    }

    private void compare(GridDataset gds1, GridDataset gds2) {
        for (GridDatatype grid1 : gds1.getGrids()) {
            try {
                long size2;
                GridDatatype grid2 = gds2.findGridDatatype(grid1.getName());
                assert (grid2 != null) : "cant find " + grid1.getName();
                long size1 = new Section(grid1.getShape()).computeSize();
                if (size1 == (size2 = new Section(grid2.getShape()).computeSize())) continue;
                System.out.printf("%s size mismatch: %s != %s%n", grid1.getName(), this.show(grid1), this.show(grid2));
                throw new RuntimeException();
            }
            catch (Throwable e) {
                System.out.printf(" *** %s %n", e.getMessage());
            }
        }
    }

    private String show(GridDatatype grid) {
        Section s = new Section(grid.getShape());
        return s.toString();
    }

    private Map<String, CoordinateAxis1DTime> getTimes(GridDataset gds) throws Exception {
        HashMap<String, CoordinateAxis1DTime> map = new HashMap<String, CoordinateAxis1DTime>(5);
        for (GridDataset.Gridset gset : gds.getGridsets()) {
            GridCoordSystem gsys = gset.getGeoCoordSystem();
            CoordinateAxis1DTime time = gsys.getTimeAxis1D();
            map.put(time.getName(), time);
        }
        for (CoordinateAxis1DTime time : map.values()) {
            System.out.printf(" %s len = %d%n", time.getName(), time.getSize());
        }
        return map;
    }

    private void compare(Map<String, CoordinateAxis1DTime> map1, Map<String, CoordinateAxis1DTime> map2) throws Exception {
        for (CoordinateAxis1DTime time1 : map1.values()) {
            CoordinateAxis1DTime time2 = map2.get(time1.getName());
            assert (time2 != null);
            assert (time1.getSize() == time2.getSize());
        }
    }

    public static void main(String[] args) throws Exception {
        Timer timer = new Timer();
        TestMotherlodeLatest test1 = new TestMotherlodeLatest("NCEP/RUC2/CONUS_20km/pressure", bestSuffix);
        timer.schedule((TimerTask)test1, 0L, 120000L);
        TestMotherlodeLatest test2 = new TestMotherlodeLatest("NCEP/RUC2/CONUS_20km/pressure", latestSuffix);
        timer.schedule((TimerTask)test2, 0L, 120000L);
        TestMotherlodeLatest test3 = new TestMotherlodeLatest("NCEP/NAM/CONUS_12km", latestSuffix);
        timer.schedule((TimerTask)test3, 0L, 600000L);
        TestMotherlodeLatest test4 = new TestMotherlodeLatest("NCEP/NAM/CONUS_12km", bestSuffix);
        timer.schedule((TimerTask)test4, 0L, 600000L);
        test2.doAll();
    }
}

