/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.ui.BAMutil;
import thredds.ui.IndependentWindow;
import thredds.ui.PopupMenu;
import thredds.ui.TextHistoryPane;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureScan
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted ftTable;
    private JSplitPane split;
    private TextHistoryPane infoTA;
    private TextHistoryPane dumpTA;
    private IndependentWindow infoWindow;

    public FeatureScan(PreferencesExt prefs) {
        this.prefs = prefs;
        this.ftTable = new BeanTableSorted(FeatureDatasetBean.class, (PreferencesExt)prefs.node("FeatureDatasetBeans"), false);
        this.ftTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FeatureDatasetBean ftb = (FeatureDatasetBean)FeatureScan.this.ftTable.getSelectedBean();
                FeatureScan.this.setSelectedFeatureDataset(ftb);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.ftTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FeatureDatasetBean ftb = (FeatureDatasetBean)FeatureScan.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScan.this.firePropertyChange("openNetcdfFile", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Check CoordSystems", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FeatureDatasetBean ftb = (FeatureDatasetBean)FeatureScan.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScan.this.firePropertyChange("openCoordSystems", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as PointDataset", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FeatureDatasetBean ftb = (FeatureDatasetBean)FeatureScan.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScan.this.firePropertyChange("openPointFeatureDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as GridDataset", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FeatureDatasetBean ftb = (FeatureDatasetBean)FeatureScan.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScan.this.firePropertyChange("openGridDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as RadialDataset", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FeatureDatasetBean ftb = (FeatureDatasetBean)FeatureScan.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScan.this.firePropertyChange("openRadialDataset", null, ftb.f.getPath());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, this.ftTable, this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.ftTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
    }

    public boolean setScanDirectory(String dirName) {
        ArrayList<FeatureDatasetBean> beanList = new ArrayList<FeatureDatasetBean>();
        File top = new File(dirName);
        if (!top.exists()) {
            return false;
        }
        if (top.isDirectory()) {
            this.scanDirectory(top, beanList);
        } else {
            FeatureDatasetBean fdb = new FeatureDatasetBean(top);
            beanList.add(fdb);
        }
        this.ftTable.setBeans(beanList);
        return true;
    }

    private void scanDirectory(File dir, List<FeatureDatasetBean> beanList) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.scanDirectory(f, beanList);
                continue;
            }
            FeatureDatasetBean fdb = new FeatureDatasetBean(f);
            beanList.add(fdb);
        }
    }

    private void setSelectedFeatureDataset(FeatureDatasetBean ftb) {
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FeatureDatasetBean {
        File f;
        String iospName;
        String coordMap;
        FeatureType featureType;
        String ftype;
        String info;
        String ftImpl;
        Throwable problem;

        public FeatureDatasetBean() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FeatureDatasetBean(File f) {
            block16: {
                this.f = f;
                NetcdfDataset ds = null;
                try {
                    ds = NetcdfDataset.openDataset(f.getPath());
                    IOServiceProvider iosp = ds.getIosp();
                    this.iospName = iosp == null ? "" : iosp.getClass().getName();
                    this.setCoordMap(ds.getCoordinateSystems());
                    Formatter errlog = new Formatter();
                    try {
                        FeatureDataset featureDataset = FeatureDatasetFactoryManager.wrap(null, ds, null, errlog);
                        if (featureDataset != null) {
                            this.featureType = featureDataset.getFeatureType();
                            if (this.featureType != null) {
                                this.ftype = this.featureType.toString();
                            }
                            this.ftImpl = featureDataset.getImplementationName();
                            Formatter infof = new Formatter();
                            featureDataset.getDetailInfo(infof);
                            this.info = infof.toString();
                            break block16;
                        }
                        this.ftype = "FAIL: " + errlog.toString();
                    }
                    catch (Throwable t) {
                        this.ftype = "ERR: " + t.getMessage();
                        this.info = errlog.toString();
                        this.problem = t;
                    }
                }
                catch (Throwable t) {
                    this.iospName = "ERR: " + t.getMessage();
                    this.problem = t;
                }
                finally {
                    if (ds != null) {
                        try {
                            ds.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }

        public String getName() {
            return this.f.getPath();
        }

        public String getIosp() {
            return this.iospName;
        }

        public String getCoordMap() {
            return this.coordMap;
        }

        public void setCoordMap(List<CoordinateSystem> csysList) {
            CoordinateSystem use = null;
            for (CoordinateSystem csys : csysList) {
                if (use == null) {
                    use = csys;
                    continue;
                }
                if (csys.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
                use = csys;
            }
            this.coordMap = use == null ? "" : "f:D(" + use.getRankDomain() + ")->R(" + use.getRankRange() + ")";
        }

        public String getFeatureType() {
            return this.ftype;
        }

        public String getFeatureImpl() {
            return this.ftImpl;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("%s%n %s%n map = '%s'%n %s%n %s%n", this.getName(), this.getIosp(), this.getCoordMap(), this.getFeatureType(), this.getFeatureImpl());
            if (this.info != null) {
                f.format("\n%s", this.info);
            }
            if (this.problem != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
                this.problem.printStackTrace(new PrintStream(bout));
                f.format("\n%s", bout.toString());
            }
            return f.toString();
        }
    }
}

