/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.ui.BAMutil;
import thredds.ui.IndependentWindow;
import thredds.ui.PopupMenu;
import thredds.ui.TextHistoryPane;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Hdf5Table
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted objectTable;
    private BeanTableSorted messTable;
    private BeanTableSorted attTable;
    private JSplitPane splitH;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane dumpTA;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private String location;

    public Hdf5Table(PreferencesExt prefs) {
        this.prefs = prefs;
        this.objectTable = new BeanTableSorted(ObjectBean.class, (PreferencesExt)prefs.node("Hdf5Object"), false);
        this.objectTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Hdf5Table.this.messTable.setBeans(new ArrayList());
                ArrayList<MessageBean> beans = new ArrayList<MessageBean>();
                ObjectBean ob = (ObjectBean)Hdf5Table.this.objectTable.getSelectedBean();
                for (H5header.HeaderMessage m : ob.m.getMessages()) {
                    beans.add(new MessageBean(m));
                }
                Hdf5Table.this.messTable.setBeans(beans);
                ArrayList<AttributeBean> attBeans = new ArrayList<AttributeBean>();
                for (H5header.MessageAttribute m : ob.m.getAttributes()) {
                    attBeans.add(new AttributeBean(m));
                }
                Hdf5Table.this.attTable.setBeans(attBeans);
            }
        });
        this.messTable = new BeanTableSorted(MessageBean.class, (PreferencesExt)prefs.node("MessBean"), false);
        this.messTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MessageBean mb = (MessageBean)Hdf5Table.this.messTable.getSelectedBean();
                Hdf5Table.this.dumpTA.setText(mb.m.toString());
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messTable.getJTable(), "Options");
        varPopup.addAction("Show FractalHeap", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)Hdf5Table.this.messTable.getSelectedBean();
                if (Hdf5Table.this.infoTA == null) {
                    Hdf5Table.this.infoTA = new TextHistoryPane();
                    Hdf5Table.this.infoWindow = new IndependentWindow("Extra", BAMutil.getImage("netcdfUI"), Hdf5Table.this.infoTA);
                    Hdf5Table.this.infoWindow.setBounds(new Rectangle(300, 300, 500, 800));
                }
                Hdf5Table.this.infoTA.clear();
                Formatter f = new Formatter();
                mb.m.showFractalHeap(f);
                Hdf5Table.this.infoTA.appendLine(f.toString());
                Hdf5Table.this.infoTA.gotoTop();
                Hdf5Table.this.infoWindow.showIfNotIconified();
            }
        });
        this.attTable = new BeanTableSorted(AttributeBean.class, (PreferencesExt)prefs.node("AttBean"), false);
        this.attTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AttributeBean mb = (AttributeBean)Hdf5Table.this.attTable.getSelectedBean();
                Hdf5Table.this.dumpTA.setText(mb.att.toString());
            }
        });
        this.dumpTA = new TextHistoryPane();
        this.splitH = new JSplitPane(1, false, this.objectTable, this.dumpTA);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 600));
        this.split = new JSplitPane(0, false, this.splitH, this.messTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, this.attTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.objectTable.saveState(false);
        this.messTable.saveState(false);
        this.attTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
    }

    public void setHdf5File(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
        long start = System.nanoTime();
        ArrayList<ObjectBean> beanList = new ArrayList<ObjectBean>();
        MyNetcdfFile ncfile = new MyNetcdfFile();
        H5iosp iosp = new H5iosp();
        try {
            iosp.open(raf, ncfile, null);
        }
        catch (Throwable t) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(20000);
            PrintStream s = new PrintStream(bos);
            t.printStackTrace(s);
            this.dumpTA.setText(bos.toString());
        }
        H5header header = (H5header)iosp.sendIospMessage("header");
        for (H5header.DataObject dataObj : header.getDataObjects()) {
            beanList.add(new ObjectBean(dataObj));
        }
        this.objectTable.setBeans(beanList);
    }

    public class AttributeBean {
        H5header.MessageAttribute att;

        public AttributeBean() {
        }

        public AttributeBean(H5header.MessageAttribute att) {
            this.att = att;
        }

        public byte getVersion() {
            return this.att.getVersion();
        }

        public String getName() {
            return this.att.getName();
        }

        public String getMdt() {
            return this.att.getMdt().toString();
        }

        public String getMds() {
            return this.att.getMds().toString();
        }

        public long getDataPos() {
            return this.att.getDataPos();
        }
    }

    public class MessageBean {
        H5header.HeaderMessage m;

        public MessageBean() {
        }

        public MessageBean(H5header.HeaderMessage m) {
            this.m = m;
        }

        public String getMessageType() {
            return this.m.getMtype().toString();
        }

        public String getName() {
            return this.m.getName();
        }

        public short getSize() {
            return this.m.getSize();
        }

        public byte getFlags() {
            return this.m.getFlags();
        }

        public long getStart() {
            return this.m.getStart();
        }
    }

    public class ObjectBean {
        H5header.DataObject m;

        public ObjectBean() {
        }

        public ObjectBean(H5header.DataObject m) {
            this.m = m;
        }

        public long getAddress() {
            return this.m.getAddress();
        }

        public String getName() {
            return this.m.getName();
        }
    }

    private class MyNetcdfFile
    extends NetcdfFile {
        private MyNetcdfFile() {
        }
    }
}

