/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import edu.wisc.ssec.mcidas.adde.AddeURLStreamHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import opendap.dap.DConnect2;
import org.apache.commons.httpclient.HttpClient;
import org.bounce.text.LineNumberMargin;
import org.bounce.text.ScrollableEditorPanel;
import org.bounce.text.xml.XMLEditorKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDataset;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.query.DqcFactory;
import thredds.ui.BAMutil;
import thredds.ui.FileManager;
import thredds.ui.IndependentWindow;
import thredds.ui.PLAF;
import thredds.ui.ProgressMonitor;
import thredds.ui.ProgressMonitorTask;
import thredds.ui.TextHistoryPane;
import thredds.ui.URLDumpPane;
import thredds.ui.UrlAuthenticatorDialog;
import thredds.viewer.gis.shapefile.ShapeFileBean;
import thredds.viewer.gis.worldmap.WorldMapBean;
import thredds.wcs.Request;
import thredds.wcs.v1_0_0_1.GetCapabilities;
import thredds.wcs.v1_0_0_1.GetCapabilitiesBuilder;
import thredds.wcs.v1_0_0_1.WcsException;
import thredds.wcs.v1_0_0_1.WcsRequestBuilder;
import ucar.ma2.Array;
import ucar.nc2.FileWriter;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.fmrc.FmrcImpl;
import ucar.nc2.dt.fmrc.FmrcInventory;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.radial.StationRadarCollectionImpl;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.point.writer.WriterCFPointObsDataset;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.stream.NcStreamRemote;
import ucar.nc2.thredds.DqcRadarDatasetCollection;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.ui.AggTable;
import ucar.nc2.ui.BufrTable;
import ucar.nc2.ui.CoordSysTable;
import ucar.nc2.ui.DatasetViewer;
import ucar.nc2.ui.FeatureScan;
import ucar.nc2.ui.FmrcTable;
import ucar.nc2.ui.GeoGridTable;
import ucar.nc2.ui.GribTable;
import ucar.nc2.ui.Hdf5Table;
import ucar.nc2.ui.PointFeatureDatasetViewer;
import ucar.nc2.ui.PointObsViewer;
import ucar.nc2.ui.RadialDatasetTable;
import ucar.nc2.ui.StationObsViewer;
import ucar.nc2.ui.StationRadialViewer;
import ucar.nc2.ui.StopButton;
import ucar.nc2.ui.ThreddsUI;
import ucar.nc2.ui.TrajectoryObsViewer;
import ucar.nc2.ui.WmsViewer;
import ucar.nc2.ui.grid.GridUI;
import ucar.nc2.ui.image.ImageViewPanel;
import ucar.nc2.ui.util.Resource;
import ucar.nc2.ui.util.SocketMessage;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CompareNetcdf;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.net.HttpClientManager;
import ucar.nc2.util.net.URLStreamHandlerFactory;
import ucar.nc2.util.xml.RuntimeConfigParser;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.HTTPRandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;
import ucar.util.prefs.ui.ComboBox;
import ucar.util.prefs.ui.Debug;

public class ToolsUI
extends JPanel {
    private static Logger log = LoggerFactory.getLogger(ToolsUI.class);
    private static final String WorldDetailMap = "/optional/nj22/maps/Countries.zip";
    private static final String USMap = "/optional/nj22/maps/US.zip";
    private static final String FRAME_SIZE = "FrameSize";
    private static final String DEBUG_FRAME_SIZE = "DebugWindowSize";
    private static final String GRIDVIEW_FRAME_SIZE = "GridUIWindowSize";
    private static final String GRIDIMAGE_FRAME_SIZE = "GridImageWindowSize";
    private static boolean debugListen = false;
    private PreferencesExt mainPrefs;
    private AggPanel aggPanel;
    private BufrPanel bufrPanel;
    private CoordSysPanel coordSysPanel;
    private FeatureScanPanel ftPanel;
    private FmrcPanel fmrcPanel;
    private FmrcImplPanel fmrcImplPanel;
    private GeoGridPanel gridPanel;
    private GribPanel gribPanel;
    private Hdf5Panel hdf5Panel;
    private ImagePanel imagePanel;
    private NCdumpPanel ncdumpPanel;
    private OpPanel ncmlPanel;
    private OpPanel geotiffPanel;
    private PointObsPanel pointObsPanel;
    private StationObsPanel stationObsPanel;
    private PointFeaturePanel pointFeaturePanel;
    private StationRadialPanel stationRadialPanel;
    private RadialPanel radialPanel;
    private ThreddsUI threddsUI;
    private TrajectoryTablePanel trajTablePanel;
    private UnitsPanel unitsPanel;
    private URLDumpPane urlPanel;
    private ViewerPanel viewerPanel;
    private WmsPanel wmsPanel;
    private JTabbedPane tabbedPane;
    private JTabbedPane iospTabPane;
    private JTabbedPane ftTabPane;
    private JTabbedPane fmrcTabPane;
    private JTabbedPane ncmlTabPane;
    private JFrame parentFrame;
    private FileManager fileChooser;
    private AboutWindow aboutWindow = null;
    private ThreddsDataFactory threddsDataFactory = new ThreddsDataFactory();
    private DateFormatter formatter = new DateFormatter();
    private boolean setUseRecordStructure = false;
    private JMenu debugFlagMenu;
    private DebugFlags debugFlags;
    private boolean debug = false;
    private boolean debugTab = false;
    private boolean debugNcmlWrite = false;
    private boolean debugCB = false;
    private String downloadStatus = null;
    private static ToolsUI ui;
    private static JFrame frame;
    private static PreferencesExt prefs;
    private static XMLStore store;
    private static boolean done;
    private static String wantDataset;
    static boolean isCacheInit;
    static boolean isDiskCacheInit;

    public ToolsUI(PreferencesExt prefs, JFrame parentFrame) {
        this.mainPrefs = prefs;
        this.parentFrame = parentFrame;
        FileFilter[] filters = new FileFilter[]{new FileManager.HDF5ExtFilter(), new FileManager.NetcdfExtFilter()};
        this.fileChooser = new FileManager(parentFrame, null, filters, (PreferencesExt)prefs.node("FileManager"));
        this.tabbedPane = new JTabbedPane(1);
        this.iospTabPane = new JTabbedPane(1);
        this.ftTabPane = new JTabbedPane(1);
        this.fmrcTabPane = new JTabbedPane(1);
        this.ncmlTabPane = new JTabbedPane(1);
        this.viewerPanel = new ViewerPanel((PreferencesExt)this.mainPrefs.node("varTable"));
        this.tabbedPane.addTab("Viewer", this.viewerPanel);
        this.tabbedPane.addTab("NCDump", new JLabel("NCDump"));
        this.tabbedPane.addTab("Iosp", this.iospTabPane);
        this.tabbedPane.addTab("CoordSys", new JLabel("CoordSys"));
        this.tabbedPane.addTab("FeatureTypes", this.ftTabPane);
        this.tabbedPane.addTab("THREDDS", new JLabel("THREDDS"));
        this.tabbedPane.addTab("Fmrc", this.fmrcTabPane);
        this.tabbedPane.addTab("GeoTiff", new JLabel("GeoTiff"));
        this.tabbedPane.addTab("Units", new JLabel("Units"));
        this.tabbedPane.addTab("NcML", this.ncmlTabPane);
        this.tabbedPane.addTab("URLdump", new JLabel("URLdump"));
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.tabbedPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.tabbedPane.getSelectedIndex();
                    String title = ToolsUI.this.tabbedPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.tabbedPane, title);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.iospTabPane.addTab("BUFR", new JLabel("BUFR"));
        this.iospTabPane.addTab("GRIB", new JLabel("GRIB"));
        this.iospTabPane.addTab("HDF5", new JLabel("HDF5"));
        this.iospTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.iospTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.iospTabPane.getSelectedIndex();
                    String title = ToolsUI.this.iospTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.iospTabPane, title);
                }
            }
        });
        this.gridPanel = new GeoGridPanel((PreferencesExt)this.mainPrefs.node("grid"));
        this.ftTabPane.addTab("Grids", this.gridPanel);
        this.ftTabPane.addTab("WMS", new JLabel("WMS"));
        this.ftTabPane.addTab("PointFeature", new JLabel("PointFeature"));
        this.ftTabPane.addTab("PointObs", new JLabel("PointObs"));
        this.ftTabPane.addTab("StationObs", new JLabel("StationObs"));
        this.ftTabPane.addTab("Trajectory", new JLabel("Trajectory"));
        this.ftTabPane.addTab("Images", new JLabel("Images"));
        this.ftTabPane.addTab("Radial", new JLabel("Radial"));
        this.ftTabPane.addTab("StationRadial", new JLabel("StationRadial"));
        this.ftTabPane.addTab("FeatureScan", new JLabel("FeatureScan"));
        this.ftTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.ftTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.ftTabPane.getSelectedIndex();
                    String title = ToolsUI.this.ftTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.ftTabPane, title);
                }
            }
        });
        this.fmrcImplPanel = new FmrcImplPanel((PreferencesExt)this.mainPrefs.node("fmrcImpl"));
        this.fmrcTabPane.addTab("FmrcImpl", this.fmrcImplPanel);
        this.fmrcTabPane.addTab("Inventory", new JLabel("Inventory"));
        this.fmrcTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.fmrcTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.fmrcTabPane.getSelectedIndex();
                    String title = ToolsUI.this.fmrcTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.fmrcTabPane, title);
                }
            }
        });
        this.ncmlPanel = new NcmlPanel((PreferencesExt)this.mainPrefs.node("NcML"));
        this.ncmlTabPane.addTab("NcML", this.ncmlPanel);
        this.ncmlTabPane.addTab("Aggregation", new JLabel("Aggregation"));
        this.ncmlTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component c = ToolsUI.this.ncmlTabPane.getSelectedComponent();
                if (c instanceof JLabel) {
                    int idx = ToolsUI.this.ncmlTabPane.getSelectedIndex();
                    String title = ToolsUI.this.ncmlTabPane.getTitleAt(idx);
                    ToolsUI.this.makeComponent(ToolsUI.this.ncmlTabPane, title);
                }
            }
        });
        this.debugFlags = (DebugFlags)Proxy.newProxyInstance(DebugFlags.class.getClassLoader(), new Class[]{DebugFlags.class}, (InvocationHandler)new DebugProxyHandler());
        this.makeMenuBar();
        this.setDebugFlags();
    }

    private void makeComponent(JTabbedPane parent, String title) {
        JPanel c;
        String cTitle;
        int idx;
        if (parent == null) {
            parent = this.tabbedPane;
        }
        int n = parent.getTabCount();
        for (idx = 0; idx < n && !(cTitle = parent.getTitleAt(idx)).equals(title); ++idx) {
        }
        if (idx >= n) {
            if (this.debugTab) {
                System.out.println("Cant find " + title + " in " + parent);
            }
            return;
        }
        if (title.equals("Aggregation")) {
            c = this.aggPanel = new AggPanel((PreferencesExt)this.mainPrefs.node("NcML"));
        } else if (title.equals("BUFR")) {
            this.bufrPanel = new BufrPanel((PreferencesExt)this.mainPrefs.node("bufr"));
            c = this.bufrPanel;
        } else if (title.equals("GRIB")) {
            this.gribPanel = new GribPanel((PreferencesExt)this.mainPrefs.node("grib"));
            c = this.gribPanel;
        } else if (title.equals("CoordSys")) {
            this.coordSysPanel = new CoordSysPanel((PreferencesExt)this.mainPrefs.node("CoordSys"));
            c = this.coordSysPanel;
        } else if (title.equals("FmrcImpl")) {
            this.fmrcImplPanel = new FmrcImplPanel((PreferencesExt)this.mainPrefs.node("fmrcImpl"));
            c = this.fmrcImplPanel;
        } else if (title.equals("FeatureScan")) {
            this.ftPanel = new FeatureScanPanel((PreferencesExt)this.mainPrefs.node("ftPanel"));
            c = this.ftPanel;
        } else if (title.equals("GeoTiff")) {
            this.geotiffPanel = new GeotiffPanel((PreferencesExt)this.mainPrefs.node("WCS"));
            c = this.geotiffPanel;
        } else if (title.equals("Grids")) {
            this.gridPanel = new GeoGridPanel((PreferencesExt)this.mainPrefs.node("grid"));
            c = this.gridPanel;
        } else if (title.equals("HDF5")) {
            this.hdf5Panel = new Hdf5Panel((PreferencesExt)this.mainPrefs.node("hdf5"));
            c = this.hdf5Panel;
        } else if (title.equals("Images")) {
            this.imagePanel = new ImagePanel((PreferencesExt)this.mainPrefs.node("images"));
            c = this.imagePanel;
        } else if (title.equals("Inventory")) {
            this.fmrcPanel = new FmrcPanel((PreferencesExt)this.mainPrefs.node("fmrc"));
            c = this.fmrcPanel;
        } else if (title.equals("NCDump")) {
            this.ncdumpPanel = new NCdumpPanel((PreferencesExt)this.mainPrefs.node("NCDump"));
            c = this.ncdumpPanel;
        } else if (title.equals("NcML")) {
            this.ncmlPanel = new NcmlPanel((PreferencesExt)this.mainPrefs.node("NcML"));
            c = this.ncmlPanel;
        } else if (title.equals("PointObs")) {
            this.pointObsPanel = new PointObsPanel((PreferencesExt)this.mainPrefs.node("points"));
            c = this.pointObsPanel;
        } else if (title.equals("PointFeature")) {
            this.pointFeaturePanel = new PointFeaturePanel((PreferencesExt)this.mainPrefs.node("pointFeature"));
            c = this.pointFeaturePanel;
        } else if (title.equals("Radial")) {
            this.radialPanel = new RadialPanel((PreferencesExt)this.mainPrefs.node("radial"));
            c = this.radialPanel;
        } else if (title.equals("StationObs")) {
            this.stationObsPanel = new StationObsPanel((PreferencesExt)this.mainPrefs.node("stations"));
            c = this.stationObsPanel;
        } else if (title.equals("StationRadial")) {
            this.stationRadialPanel = new StationRadialPanel((PreferencesExt)this.mainPrefs.node("stationRadar"));
            c = this.stationRadialPanel;
        } else if (title.equals("Trajectory")) {
            this.trajTablePanel = new TrajectoryTablePanel((PreferencesExt)this.mainPrefs.node("trajectory"));
            c = this.trajTablePanel;
        } else if (title.equals("THREDDS")) {
            this.threddsUI = new ThreddsUI(this.parentFrame, (PreferencesExt)this.mainPrefs.node("thredds"));
            this.threddsUI.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("InvAccess")) {
                        InvAccess access = (InvAccess)e.getNewValue();
                        ToolsUI.this.setThreddsDatatype(access);
                    }
                    if (e.getPropertyName().equals("Dataset") || e.getPropertyName().equals("File")) {
                        InvDataset ds = (InvDataset)e.getNewValue();
                        ToolsUI.this.setThreddsDatatype(ds, e.getPropertyName().equals("File"));
                    }
                }
            });
            c = this.threddsUI;
        } else if (title.equals("Units")) {
            this.unitsPanel = new UnitsPanel((PreferencesExt)this.mainPrefs.node("units"));
            c = this.unitsPanel;
        } else if (title.equals("URLdump")) {
            this.urlPanel = new URLDumpPane((PreferencesExt)this.mainPrefs.node("urlDump"));
            c = this.urlPanel;
        } else if (title.equals("Viewer")) {
            c = this.viewerPanel;
        } else if (title.equals("WMS")) {
            this.wmsPanel = new WmsPanel((PreferencesExt)this.mainPrefs.node("wms"));
            c = this.wmsPanel;
        } else {
            System.out.println("tabbedPane unknown component " + title);
            return;
        }
        parent.setComponentAt(idx, c);
        if (this.debugTab) {
            System.out.println("tabbedPane changed " + title + " added ");
        }
    }

    private void makeMenuBar() {
        JMenuBar mb = new JMenuBar();
        JRootPane rootPane = this.parentFrame.getRootPane();
        rootPane.setJMenuBar(mb);
        JMenu sysMenu = new JMenu("System");
        sysMenu.setMnemonic('S');
        mb.add(sysMenu);
        AbstractAction clearHttpStateAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                HttpClientManager.clearState();
            }
        };
        BAMutil.setActionProperties(clearHttpStateAction, null, "Clear Http State", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, clearHttpStateAction);
        AbstractAction showCacheAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Formatter f = new Formatter();
                f.format("NetcdfFileCache contents\n", new Object[0]);
                FileCache cache = NetcdfDataset.getNetcdfFileCache();
                if (null != cache) {
                    cache.showCache(f);
                }
                ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.setText(f.toString());
                ((ToolsUI)ToolsUI.this).viewerPanel.detailWindow.show();
            }
        };
        BAMutil.setActionProperties(showCacheAction, null, "Show Caches", false, 83, -1);
        BAMutil.addActionToMenu(sysMenu, showCacheAction);
        AbstractAction clearCacheAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FileCache cache = NetcdfDataset.getNetcdfFileCache();
                if (cache != null) {
                    cache.clearCache(true);
                }
            }
        };
        BAMutil.setActionProperties(clearCacheAction, null, "Clear NetcdfDatasetCache", false, 67, -1);
        BAMutil.addActionToMenu(sysMenu, clearCacheAction);
        AbstractAction enableCache = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state == isCacheInit) {
                    return;
                }
                isCacheInit = state;
                if (isCacheInit) {
                    FileCache cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.enable();
                    } else {
                        NetcdfDataset.initNetcdfFileCache(10, 20, 600);
                    }
                } else {
                    FileCache cache = NetcdfDataset.getNetcdfFileCache();
                    if (cache != null) {
                        cache.disable();
                    }
                }
            }
        };
        BAMutil.setActionPropertiesToggle(enableCache, null, "enable NetcdfDatasetCache", isCacheInit, 78, -1);
        BAMutil.addActionToMenu(sysMenu, enableCache);
        AbstractAction showPropertiesAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.setText("System Properties\n");
                Properties sysp = System.getProperties();
                Enumeration<?> eprops = sysp.propertyNames();
                ArrayList<?> list = Collections.list(eprops);
                Collections.sort(list);
                for (Object aList : list) {
                    String name = (String)aList;
                    String value = System.getProperty(name);
                    ((ToolsUI)ToolsUI.this).viewerPanel.detailTA.appendLine("  " + name + " = " + value);
                }
                ((ToolsUI)ToolsUI.this).viewerPanel.detailWindow.show();
            }
        };
        BAMutil.setActionProperties(showPropertiesAction, null, "System Properties", false, 80, -1);
        BAMutil.addActionToMenu(sysMenu, showPropertiesAction);
        JMenu plafMenu = new JMenu("Look and Feel");
        plafMenu.setMnemonic('L');
        sysMenu.add(plafMenu);
        PLAF plaf = new PLAF(rootPane);
        plaf.addToMenu(plafMenu);
        AbstractAction exitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ToolsUI.exit();
            }
        };
        BAMutil.setActionProperties(exitAction, "Exit", "Exit", false, 88, -1);
        BAMutil.addActionToMenu(sysMenu, exitAction);
        JMenu modeMenu = new JMenu("Modes");
        modeMenu.setMnemonic('M');
        mb.add(modeMenu);
        this.makeModesMenu(modeMenu);
        JMenu debugMenu = new JMenu("Debug");
        debugMenu.setMnemonic('D');
        mb.add(debugMenu);
        this.debugFlagMenu = (JMenu)debugMenu.add(new JMenu("Debug Flags"));
        this.debugFlagMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                ToolsUI.this.setDebugFlags();
                Debug.constructMenu(ToolsUI.this.debugFlagMenu);
            }

            public void menuDeselected(MenuEvent e) {
                ToolsUI.this.setDebugFlags();
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        AbstractAction clearDebugFlagsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Debug.removeAll();
            }
        };
        BAMutil.setActionProperties(clearDebugFlagsAction, null, "Delete All Debug Flags", false, 67, -1);
        BAMutil.addActionToMenu(debugMenu, clearDebugFlagsAction);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        mb.add(helpMenu);
        AbstractAction aboutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if (ToolsUI.this.aboutWindow == null) {
                    ToolsUI.this.aboutWindow = new AboutWindow();
                }
                ToolsUI.this.aboutWindow.setVisible(true);
            }
        };
        BAMutil.setActionProperties(aboutAction, null, "About", false, 65, 0);
        BAMutil.addActionToMenu(helpMenu, aboutAction);
        AbstractAction logoAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                new SplashScreen();
            }
        };
        BAMutil.setActionProperties(logoAction, null, "Logo", false, 76, 0);
        BAMutil.addActionToMenu(helpMenu, logoAction);
    }

    public void setDebugFlags() {
        if (this.debug) {
            System.out.println("checkDebugFlags ");
        }
        NetcdfFile.setDebugFlags(this.debugFlags);
        H5iosp.setDebugFlags(this.debugFlags);
        NcMLReader.setDebugFlags(this.debugFlags);
        DODSNetcdfFile.setDebugFlags(this.debugFlags);
        GribServiceProvider.setDebugFlags(this.debugFlags);
        ThreddsDataFactory.setDebugFlags(this.debugFlags);
        FileWriter.setDebugFlags(this.debugFlags);
        PointDatasetStandardFactory.setDebugFlags(this.debugFlags);
    }

    private void makeModesMenu(JMenu modeMenu) {
        JMenu ncMenu = new JMenu("NetcdfFile");
        modeMenu.add(ncMenu);
        AbstractAction a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                ToolsUI.this.setUseRecordStructure = state;
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "nc3UseRecords", this.setUseRecordStructure, 86, -1);
        BAMutil.addActionToMenu(ncMenu, a);
        JMenu dsMenu = new JMenu("NetcdfDataset");
        modeMenu.add(dsMenu);
        a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoordSysBuilder.setUseMaximalCoordSys(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "set Use Maximal CoordSystem", CoordSysBuilder.getUseMaximalCoordSys(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setUseNaNs(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "set NaNs for missing values", NetcdfDataset.getUseNaNs(), 78, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setFillValueIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use _FillValue attribute for missing values", NetcdfDataset.getFillValueIsMissing(), 70, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setInvalidDataIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use valid_range attribute for missing values", NetcdfDataset.getInvalidDataIsMissing(), 86, -1);
        BAMutil.addActionToMenu(dsMenu, a);
        a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                NetcdfDataset.setMissingDataIsMissing(state);
            }
        };
        BAMutil.setActionPropertiesToggle(a, null, "use mssing_value attribute for missing values", NetcdfDataset.getMissingDataIsMissing(), 77, -1);
        BAMutil.addActionToMenu(dsMenu, a);
    }

    public void save() {
        this.fileChooser.save();
        if (this.aggPanel != null) {
            this.aggPanel.save();
        }
        if (this.bufrPanel != null) {
            this.bufrPanel.save();
        }
        if (this.coordSysPanel != null) {
            this.coordSysPanel.save();
        }
        if (this.ftPanel != null) {
            this.ftPanel.save();
        }
        if (this.fmrcPanel != null) {
            this.fmrcPanel.save();
        }
        if (this.fmrcImplPanel != null) {
            this.fmrcImplPanel.save();
        }
        if (this.geotiffPanel != null) {
            this.geotiffPanel.save();
        }
        if (this.gribPanel != null) {
            this.gribPanel.save();
        }
        if (this.gridPanel != null) {
            this.gridPanel.save();
        }
        if (this.hdf5Panel != null) {
            this.hdf5Panel.save();
        }
        if (this.imagePanel != null) {
            this.imagePanel.save();
        }
        if (this.ncdumpPanel != null) {
            this.ncdumpPanel.save();
        }
        if (this.ncmlPanel != null) {
            this.ncmlPanel.save();
        }
        if (this.pointFeaturePanel != null) {
            this.pointFeaturePanel.save();
        }
        if (this.pointObsPanel != null) {
            this.pointObsPanel.save();
        }
        if (this.radialPanel != null) {
            this.radialPanel.save();
        }
        if (this.stationObsPanel != null) {
            this.stationObsPanel.save();
        }
        if (this.stationRadialPanel != null) {
            this.stationRadialPanel.save();
        }
        if (this.trajTablePanel != null) {
            this.trajTablePanel.save();
        }
        if (this.threddsUI != null) {
            this.threddsUI.storePersistentData();
        }
        if (this.unitsPanel != null) {
            this.unitsPanel.save();
        }
        if (this.urlPanel != null) {
            this.urlPanel.save();
        }
        if (this.viewerPanel != null) {
            this.viewerPanel.save();
        }
        if (this.wmsPanel != null) {
            this.wmsPanel.save();
        }
    }

    private void openNetcdfFile(String datasetName) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private void openNetcdfFile(NetcdfFile ncfile) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.setDataset(ncfile);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private void openCoordSystems(String datasetName) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    private void openCoordSystems(NetcdfDataset dataset) {
        this.makeComponent(this.tabbedPane, "CoordSys");
        this.coordSysPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.coordSysPanel);
    }

    private void openPointFeatureDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "PointFeature");
        this.pointFeaturePanel.setPointFeatureDataset(null, datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
    }

    private void openGridDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openGridDataset(NetcdfDataset dataset) {
        this.makeComponent(this.ftTabPane, "Grids");
        this.gridPanel.setDataset(dataset);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.gridPanel);
    }

    private void openRadialDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "Radial");
        this.radialPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.radialPanel);
    }

    private void openWMSDataset(String datasetName) {
        this.makeComponent(this.ftTabPane, "WMS");
        this.wmsPanel.doit(datasetName);
        this.tabbedPane.setSelectedComponent(this.ftTabPane);
        this.ftTabPane.setSelectedComponent(this.wmsPanel);
    }

    private void setThreddsDatatype(InvDataset invDataset, boolean wantsViewer) {
        if (invDataset == null) {
            return;
        }
        try {
            if (wantsViewer) {
                this.showInViewer(this.threddsDataFactory.openDataset(invDataset, true, (CancelTask)null, (Formatter)null));
                return;
            }
            ThreddsDataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invDataset, null);
            if (threddsData == null) {
                JOptionPane.showMessageDialog(null, "Unknown datatype");
                return;
            }
            this.setThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error on setThreddsDataset = " + ioe.getMessage());
        }
    }

    private void setThreddsDatatype(InvAccess invAccess) {
        if (invAccess == null) {
            return;
        }
        InvService s = invAccess.getService();
        if (s.getServiceType() == ServiceType.HTTPServer) {
            this.downloadFile(invAccess.getStandardUrlName());
            return;
        }
        if (s.getServiceType() == ServiceType.WMS) {
            this.openWMSDataset(invAccess.getStandardUrlName());
            return;
        }
        InvDataset ds = invAccess.getDataset();
        if (ds.getDataType() == null) {
            try {
                this.showInViewer(this.threddsDataFactory.openDataset(invAccess, true, (CancelTask)null, (Formatter)null));
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Error on setThreddsDataset = " + ioe.getMessage());
            }
            return;
        }
        try {
            ThreddsDataFactory.Result threddsData = this.threddsDataFactory.openFeatureDataset(invAccess, null);
            this.setThreddsDatatype(threddsData);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Error on setThreddsDataset = " + ioe.getMessage());
        }
    }

    private void setThreddsDatatype(ThreddsDataFactory.Result threddsData) {
        if (threddsData.fatalError) {
            JOptionPane.showMessageDialog(this, "Cant open dataset=" + threddsData.errLog);
            return;
        }
        if (threddsData.featureType == FeatureType.GRID) {
            this.makeComponent(this.ftTabPane, "Grids");
            this.gridPanel.setDataset((NetcdfDataset)threddsData.featureDataset.getNetcdfFile());
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.gridPanel);
        } else if (threddsData.featureType == FeatureType.IMAGE) {
            this.makeComponent(this.ftTabPane, "Images");
            this.imagePanel.setImageLocation(threddsData.imageURL);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.imagePanel);
        } else if (threddsData.featureType == FeatureType.RADIAL) {
            this.makeComponent(this.ftTabPane, "Radial");
            this.radialPanel.setDataset((RadialDatasetSweep)threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.radialPanel);
        } else if (threddsData.featureType.isPointFeatureType()) {
            this.makeComponent(this.ftTabPane, "PointFeature");
            this.pointFeaturePanel.setPointFeatureDataset((PointDatasetImpl)threddsData.featureDataset);
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.pointFeaturePanel);
        } else if (threddsData.featureType == FeatureType.STATION_RADIAL) {
            this.makeComponent(this.ftTabPane, "StationRadial");
            this.stationRadialPanel.setStationRadialDataset((StationRadarCollectionImpl)((Object)threddsData.featureDataset));
            this.tabbedPane.setSelectedComponent(this.ftTabPane);
            this.ftTabPane.setSelectedComponent(this.stationRadialPanel);
        }
    }

    private void showInViewer(NetcdfDataset ds) {
        this.makeComponent(this.tabbedPane, "Viewer");
        this.viewerPanel.setDataset(ds);
        this.tabbedPane.setSelectedComponent(this.viewerPanel);
    }

    private NetcdfDataset openDataset(String location, boolean addCoords, CancelTask task) {
        try {
            NetcdfDataset ncd = NetcdfDataset.openDataset(location, addCoords, task);
            if (this.setUseRecordStructure) {
                ncd.sendIospMessage("AddRecordStructure");
            }
            return ncd;
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + ioe.getMessage());
            return null;
        }
    }

    private NetcdfFile openFile(String location, boolean addCoords, CancelTask task) {
        NetcdfFile ncfile = null;
        try {
            ncfile = addCoords ? NetcdfDataset.acquireDataset(location, task) : NetcdfDataset.acquireFile(location, task);
            if (ncfile == null) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location);
            } else if (this.setUseRecordStructure) {
                ncfile.sendIospMessage("AddRecordStructure");
            }
        }
        catch (IOException ioe) {
            String message = ioe.getMessage();
            if (null == message && ioe instanceof EOFException) {
                message = "Premature End of File";
            }
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location + "\n" + message);
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            ncfile = null;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + location + "\n" + e.getMessage());
            log.error("NetcdfDataset.open cant open " + location, e);
            try {
                if (ncfile != null) {
                    ncfile.close();
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            ncfile = null;
        }
        return ncfile;
    }

    private void downloadFile(String urlString) {
        int pos = urlString.lastIndexOf(47);
        String defFilename = pos >= 0 ? urlString.substring(pos) : urlString;
        String fileOutName = this.fileChooser.chooseFilename(defFilename);
        if (fileOutName == null) {
            return;
        }
        String[] values = new String[]{fileOutName, urlString};
        GetDataRunnable runner = new GetDataRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Object o) {
                String[] values = (String[])o;
                BufferedOutputStream out = null;
                try {
                    FileOutputStream fos = new FileOutputStream(values[0]);
                    out = new BufferedOutputStream(fos, 60000);
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error opening" + values[0] + "\n" + ioe.getMessage();
                    return;
                }
                try {
                    IO.copyUrlB(values[1], out, 60000);
                    ToolsUI.this.downloadStatus = values[1] + " written to " + values[0];
                }
                catch (IOException ioe) {
                    ToolsUI.this.downloadStatus = "Error reading " + values[1] + "\n" + ioe.getMessage();
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        };
        GetDataTask task = new GetDataTask(runner, urlString, values);
        ProgressMonitor pm = new ProgressMonitor(task);
        pm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, e.getActionCommand() + "\n" + ToolsUI.this.downloadStatus);
                ToolsUI.this.downloadStatus = null;
            }
        });
        pm.start(this, "Download", 30);
    }

    private String getVersion() {
        String version;
        try {
            InputStream is = Resource.getFileResource("/README");
            if (is == null) {
                return "N/A";
            }
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(is));
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sbuff.append(dataIS.readLine());
                sbuff.append("<br>");
            }
            version = sbuff.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            version = "version unknown";
        }
        return version;
    }

    private static void exit() {
        ui.save();
        Rectangle bounds = frame.getBounds();
        prefs.putBeanObject(FRAME_SIZE, bounds);
        try {
            store.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        done = true;
        FileCache cache = NetcdfDataset.getNetcdfFileCache();
        if (cache != null) {
            cache.clearCache(true);
        }
        NetcdfDataset.shutdown();
        System.exit(0);
    }

    private static void setDataset() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ui.makeComponent(null, "THREDDS");
                ui.threddsUI.setDataset(wantDataset);
                ui.tabbedPane.setSelectedComponent(ui.threddsUI);
            }
        });
    }

    public static void main(String[] args) {
        String filename;
        File f;
        FileInputStream fis;
        StringBuilder errlog;
        final SplashScreen splash = new SplashScreen();
        if (debugListen) {
            System.out.println("Arguments:");
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                System.out.println(" " + arg);
            }
        }
        if (args.length > 0) {
            SocketMessage sm;
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                sbuff.append(args[i]);
                sbuff.append(" ");
            }
            String arguments = sbuff.toString();
            System.out.println("ToolsUI arguments=" + arguments);
            if (arguments.startsWith("http:") && (sm = new SocketMessage(14444, wantDataset = arguments)).isAlreadyRunning()) {
                System.out.println("ToolsUI already running - pass argument= '" + wantDataset + "' to it and exit");
                System.exit(0);
            }
        } else {
            SocketMessage sm = new SocketMessage(14444, null);
            if (sm.isAlreadyRunning()) {
                System.out.println("ToolsUI already running - start up another copy");
                sm = null;
            } else {
                sm.addEventListener(new SocketMessage.EventListener(){

                    public void setMessage(SocketMessage.Event event) {
                        wantDataset = event.getMessage();
                        if (debugListen) {
                            System.out.println(" got message= '" + wantDataset);
                        }
                        ToolsUI.setDataset();
                    }
                });
            }
        }
        ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext("classpath:resources/nj22/ui/spring/application-config.xml");
        DODSNetcdfFile.setAllowCompression(true);
        boolean configRead = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-nj22Config") || i >= args.length - 1) continue;
            String runtimeConfig = args[i + 1];
            ++i;
            try {
                errlog = new StringBuilder();
                fis = new FileInputStream(runtimeConfig);
                RuntimeConfigParser.read(fis, errlog);
                configRead = true;
                System.out.println(errlog);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Error reading " + runtimeConfig + "=" + ioe.getMessage());
            }
        }
        if (!configRead && (f = new File(filename = XMLStore.makeStandardFilename(".unidata", "nj22Config.xml"))).exists()) {
            try {
                errlog = new StringBuilder();
                fis = new FileInputStream(filename);
                RuntimeConfigParser.read(fis, errlog);
                configRead = true;
                System.out.println(errlog);
            }
            catch (IOException ioe) {
                System.out.println("Error reading " + filename + "=" + ioe.getMessage());
            }
        }
        try {
            String prefStore = XMLStore.makeStandardFilename(".unidata", "NetcdfUI22.xml");
            store = XMLStore.createFromFile(prefStore, null);
            prefs = store.getPreferences();
            Debug.setStore(prefs.node("Debug"));
        }
        catch (IOException e) {
            System.out.println("XMLStore Creation failed " + e);
        }
        BAMutil.setResourcePath("/resources/nj22/ui/icons/");
        Aggregation.setPersistenceCache(new DiskCache2("/.unidata/cachePersist", true, 43200, 60));
        DqcFactory.setPersistenceCache(new DiskCache2("/.unidata/dqc", true, 525600, 60));
        frame = new JFrame("NetCDF (4.0) Tools");
        ui = new ToolsUI(prefs, frame);
        frame.setIconImage(BAMutil.getImage("netcdfUI"));
        frame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                splash.setVisible(false);
                splash.dispose();
            }

            public void windowClosing(WindowEvent e) {
                if (!done) {
                    ToolsUI.exit();
                }
            }
        });
        frame.getContentPane().add(ui);
        Rectangle bounds = (Rectangle)prefs.getBean(FRAME_SIZE, new Rectangle(50, 50, 800, 450));
        frame.setBounds(bounds);
        frame.pack();
        frame.setBounds(bounds);
        frame.setVisible(true);
        Authenticator.setDefault(new UrlAuthenticatorDialog(frame));
        UrlAuthenticatorDialog provider = new UrlAuthenticatorDialog(frame);
        HttpClient client = HttpClientManager.init(provider, "ToolsUI");
        DConnect2.setHttpClient(client);
        HTTPRandomAccessFile.setHttpClient(client);
        NcStreamRemote.setHttpClient(client);
        NetcdfDataset.setHttpClient(client);
        WmsViewer.setHttpClient(client);
        DODSNetcdfFile.setAllowSessions(true);
        URLStreamHandlerFactory.install();
        URLStreamHandlerFactory.register("adde", new AddeURLStreamHandler());
        if (wantDataset != null) {
            ToolsUI.setDataset();
        }
    }

    static {
        done = false;
        wantDataset = null;
        isCacheInit = false;
        isDiskCacheInit = false;
    }

    private static class SplashScreen
    extends JWindow {
        public SplashScreen() {
            Image image = Resource.getImage("/resources/nj22/ui/pix/ring2.jpg");
            ImageIcon icon = new ImageIcon(image);
            JLabel lab = new JLabel(icon);
            this.getContentPane().add(lab);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    SplashScreen.this.setVisible(false);
                }
            });
            this.setVisible(true);
        }
    }

    private class AboutWindow
    extends JWindow {
        public AboutWindow() {
            super(ToolsUI.this.parentFrame);
            JLabel lab1 = new JLabel("<html> <body bgcolor=\"#FFECEC\"> <center><h1>Netcdf Tools User Interface (ToolsUI)</h1><b>" + ToolsUI.this.getVersion() + "</b>" + "<br><i>http://www.unidata.ucar.edu/software/netcdf-java/</i>" + "<br><b><i>Developers:</b>John Caron, Ethan Davis, Robb Kambic, Yuan Ho</i></b>" + "</center>" + "<br><br>With thanks to these <b>Open Source</b> contributers:" + "<ul>" + "<li><b>ADDE/VisAD</b>: Bill Hibbard, Don Murray, Tom Whittaker, et al (http://www.ssec.wisc.edu/~billh/visad.html)</li>" + "<li><b>Apache Jakarta Commons</b> libraries: (http://http://jakarta.apache.org/commons/)</li>" + "<li><b>Apache Log4J</b> library: (http://logging.apache.org/log4j/) </li>" + "<li><b>IDV:</b> Don Murray, Jeff McWhirter (http://www.unidata.ucar.edu/software/IDV/)</li>" + "<li><b>JDOM</b> library: Jason Hunter, Brett McLaughlin et al (www.jdom.org)</li>" + "<li><b>JGoodies</b> library: Karsten Lentzsch (www.jgoodies.com)</li>" + "<li><b>JPEG-2000</b> Java library: (http://www.jpeg.org/jpeg2000/)</li>" + "<li><b>JUnit</b> library: Erich Gamma, Kent Beck, Erik Meade, et al (http://sourceforge.net/projects/junit/)</li>" + "<li><b>OPeNDAP Java</b> library: Nathan Potter, James Gallagher, Don Denbo, et. al.(http://opendap.org)</li>" + "<li><b>Spring lightweight framework</b> library: Rod Johnson, et. al.(http://www.springsource.org/)</li>" + "</ul><center>Special thanks to <b>Sun Microsystems</b> (java.sun.com) for the platform on which we stand." + "</center></body></html> ");
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(new LineBorder(Color.BLACK));
            main.setBackground(new Color(0xFFECEC));
            JLabel icon = new JLabel(new ImageIcon(BAMutil.getImage("netcdfUI")));
            icon.setOpaque(true);
            icon.setBackground(new Color(0xFFECEC));
            JLabel threddsLogo = new JLabel(Resource.getIcon(BAMutil.getResourcePath() + "threddsLogo.png", false));
            threddsLogo.setBackground(new Color(0xFFECEC));
            threddsLogo.setOpaque(true);
            main.add((Component)icon, "North");
            main.add((Component)lab1, "Center");
            main.add((Component)threddsLogo, "South");
            this.getContentPane().add(main);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    AboutWindow.this.setVisible(false);
                }
            });
            this.setVisible(true);
        }
    }

    private class DebugProxyHandler
    implements InvocationHandler {
        private DebugProxyHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return super.toString();
            }
            if (method.getName().equals("isSet")) {
                return new Boolean(Debug.isSet((String)args[0]));
            }
            if (method.getName().equals("set")) {
                Debug.set((String)args[0], (Boolean)args[1]);
                return null;
            }
            return Boolean.FALSE;
        }
    }

    private class GetDataTask
    extends ProgressMonitorTask
    implements CancelTask {
        GetDataRunnable getData;
        Object o;
        String name;
        String errMsg = null;
        Exception ex;

        GetDataTask(GetDataRunnable getData, String name, Object o) {
            this.getData = getData;
            this.name = name;
            this.o = o;
        }

        public void run() {
            try {
                this.getData.run(this.o);
            }
            catch (FileNotFoundException ioe) {
                this.errMsg = "Cant open " + this.name + " " + ioe.getMessage();
                this.success = false;
                this.done = true;
                return;
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                this.errMsg = bos.toString();
                this.ex = e;
                this.success = false;
                this.done = true;
                return;
            }
            this.success = true;
            this.done = true;
        }
    }

    private static interface GetDataRunnable {
        public void run(Object var1) throws IOException;
    }

    private class GeotiffPanel
    extends OpPanel {
        GeotiffPanel(PreferencesExt p) {
            super(p, "netcdf:", true, false);
            JButton readButton = new JButton("read geotiff");
            readButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String item = GeotiffPanel.this.cb.getSelectedItem().toString();
                    String fname = item.trim();
                    GeotiffPanel.this.read(fname);
                }
            });
            this.buttPanel.add(readButton);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean process(Object o) {
            String filename = (String)o;
            GridDataset gridDs = null;
            try {
                gridDs = GridDataset.open(filename);
                List<GridDatatype> grids = gridDs.getGrids();
                if (grids.size() == 0) {
                    System.out.println("No grids found.");
                    boolean bl = false;
                    return bl;
                }
                GridDatatype grid = grids.get(0);
                Array data = grid.readDataSlice(0, 0, -1, -1);
                String name = Integer.toString(filename.hashCode());
                String fileOut = "C:/temp/" + name + ".tif";
                GeotiffWriter writer = new GeotiffWriter(fileOut);
                writer.writeGrid(gridDs, grid, data, false);
                this.read(fileOut);
                JOptionPane.showMessageDialog(null, "File written to " + fileOut);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (gridDs != null) {
                        gridDs.close();
                    }
                }
                catch (IOException ioe) {}
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(String filename) {
            GeoTiff geotiff = null;
            try {
                geotiff = new GeoTiff(filename);
                geotiff.read();
                this.ta.setText(geotiff.showInfo());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (geotiff != null) {
                        geotiff.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class ImagePanel
    extends OpPanel {
        ImageViewPanel imagePanel;
        JSplitPane split;

        ImagePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.imagePanel = new ImageViewPanel(this.buttPanel);
            this.add((Component)this.imagePanel, "Center");
        }

        boolean process(Object o) {
            String command = (String)o;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (null != command) {
                    this.imagePanel.setImageFromUrl(command);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.appendLine(bos.toString());
                return false;
            }
            return true;
        }

        void setImageLocation(String location) {
            this.imagePanel.setImageFromUrl(location);
            this.setSelectedItem(location);
        }
    }

    private class TrajectoryTablePanel
    extends OpPanel {
        TrajectoryObsViewer viewer;
        JSplitPane split;
        TrajectoryObsDataset ds;

        TrajectoryTablePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.ds = null;
            this.viewer = new TrajectoryObsViewer(dbPrefs);
            this.add((Component)this.viewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String info;
                    if (TrajectoryTablePanel.this.ds != null && (info = TrajectoryTablePanel.this.ds.getDetailInfo()) != null) {
                        TrajectoryTablePanel.this.detailTA.setText(info);
                        TrajectoryTablePanel.this.detailTA.gotoTop();
                        TrajectoryTablePanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String location = (String)o;
            return this.setStationObsDataset(location);
        }

        void save() {
            super.save();
            this.viewer.save();
        }

        boolean setStationObsDataset(String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                StringBuilder errlog = new StringBuilder();
                this.ds = (TrajectoryObsDataset)TypedDatasetFactory.open(FeatureType.TRAJECTORY, location, null, errlog);
                if (this.ds == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + errlog);
                    return false;
                }
                this.viewer.setDataset(this.ds);
                this.setSelectedItem(location);
                return true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(ioe.getMessage());
                this.ta.appendLine(bos.toString());
                return false;
            }
        }

        boolean setStationObsDataset(TrajectoryObsDataset sobsDataset) {
            if (sobsDataset == null) {
                return false;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.viewer.setDataset(sobsDataset);
            this.ds = sobsDataset;
            this.setSelectedItem(this.ds.getLocationURI());
            return true;
        }
    }

    private class StationRadialPanel
    extends OpPanel {
        StationRadialViewer radialViewer;
        JSplitPane split;
        StationRadarCollectionImpl radarCollectionDataset;

        StationRadialPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.radarCollectionDataset = null;
            this.radialViewer = new StationRadialViewer(dbPrefs);
            this.add((Component)this.radialViewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String info;
                    if (StationRadialPanel.this.radarCollectionDataset != null && (info = StationRadialPanel.this.radarCollectionDataset.getDetailInfo()) != null) {
                        StationRadialPanel.this.detailTA.setText(info);
                        StationRadialPanel.this.detailTA.gotoTop();
                        StationRadialPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String location = (String)o;
            return this.setStationRadialDataset(location);
        }

        void save() {
        }

        boolean setStationRadialDataset(String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.radarCollectionDataset != null) {
                    this.radarCollectionDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            StringBuilder log = new StringBuilder();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.radarCollectionDataset = (StationRadarCollectionImpl)TypedDatasetFactory.open(FeatureType.STATION_RADIAL, location, null, log);
                if (this.radarCollectionDataset == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                    return false;
                }
                this.radialViewer.setDataset((DqcRadarDatasetCollection)this.radarCollectionDataset);
                this.setSelectedItem(location);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(log.toString());
                this.ta.appendLine(bos.toString());
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        boolean setStationRadialDataset(StationRadarCollectionImpl dataset) {
            if (dataset == null) {
                return false;
            }
            try {
                if (this.radarCollectionDataset != null) {
                    this.radarCollectionDataset.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.radarCollectionDataset = dataset;
            this.radialViewer.setDataset((DqcRadarDatasetCollection)this.radarCollectionDataset);
            this.setSelectedItem(this.radarCollectionDataset.getLocation());
            return true;
        }
    }

    private class WmsPanel
    extends OpPanel {
        WmsViewer wmsViewer;
        JSplitPane split;
        FeatureDatasetPoint pfDataset;
        JComboBox types;

        WmsPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.pfDataset = null;
            this.wmsViewer = new WmsViewer(dbPrefs, frame);
            this.add((Component)this.wmsViewer, "Center");
            this.buttPanel.add(new JLabel("version:"));
            this.types = new JComboBox();
            this.types.addItem("1.3.0");
            this.types.addItem("1.1.1");
            this.types.addItem("1.0.0");
            this.buttPanel.add(this.types);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    WmsPanel.this.detailTA.setText(WmsPanel.this.wmsViewer.getDetailInfo());
                    WmsPanel.this.detailTA.gotoTop();
                    WmsPanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String location = (String)o;
            return this.wmsViewer.setDataset((String)this.types.getSelectedItem(), location);
        }

        void save() {
            super.save();
            this.wmsViewer.save();
        }
    }

    private class PointFeaturePanel
    extends OpPanel {
        PointFeatureDatasetViewer pfViewer;
        JSplitPane split;
        FeatureDatasetPoint pfDataset;
        JComboBox types;

        PointFeaturePanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.pfDataset = null;
            this.pfViewer = new PointFeatureDatasetViewer(dbPrefs);
            this.add((Component)this.pfViewer, "Center");
            this.types = new JComboBox();
            for (FeatureType ft : FeatureType.values()) {
                this.types.addItem(ft);
            }
            this.types.getModel().setSelectedItem((Object)FeatureType.ANY_POINT);
            this.buttPanel.add(this.types);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    PointFeaturePanel.this.pfDataset.getDetailInfo(f);
                    PointFeaturePanel.this.detailTA.setText(f.toString());
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(infoButton);
            AbstractButton calcButton = BAMutil.makeButtcon("V3", "CalcBounds", false);
            calcButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PointFeaturePanel.this.pfDataset == null) {
                        return;
                    }
                    Formatter f = new Formatter();
                    try {
                        PointFeaturePanel.this.pfDataset.calcBounds();
                        PointFeaturePanel.this.pfDataset.getDetailInfo(f);
                        PointFeaturePanel.this.detailTA.setText(f.toString());
                    }
                    catch (IOException ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                        ioe.printStackTrace(new PrintStream(bos));
                        PointFeaturePanel.this.detailTA.setText(bos.toString());
                    }
                    PointFeaturePanel.this.detailTA.gotoTop();
                    PointFeaturePanel.this.detailWindow.show();
                }
            });
            this.buttPanel.add(calcButton);
            AbstractAction netcdfAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location = PointFeaturePanel.this.pfDataset.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".nc")) == null) {
                        return;
                    }
                    PointFeaturePanel.this.doWriteCF(filename);
                }
            };
            BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF-CF", false, 78, -1);
            BAMutil.addActionToContainer(this.buttPanel, netcdfAction);
        }

        boolean process(Object o) {
            String location = (String)o;
            return this.setPointFeatureDataset((FeatureType)((Object)this.types.getSelectedItem()), location);
        }

        void save() {
            super.save();
            this.pfViewer.save();
        }

        void doWriteCF(String filename) {
            try {
                int count = WriterCFPointObsDataset.writePointFeatureCollection(this.pfDataset, filename);
                JOptionPane.showMessageDialog(this, count + " records written");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }

        private boolean setPointFeatureDataset(FeatureType type, String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.pfDataset != null) {
                    this.pfDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.detailTA.clear();
            Formatter log = new Formatter();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                FeatureDataset featureDataset = FeatureDatasetFactoryManager.open(type, location, null, log);
                if (featureDataset == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                    return false;
                }
                if (!(featureDataset instanceof FeatureDatasetPoint)) {
                    JOptionPane.showMessageDialog(null, location + " could not be opened as a PointFeatureDataset");
                    return false;
                }
                this.pfDataset = (FeatureDatasetPoint)featureDataset;
                this.pfViewer.setDataset(this.pfDataset);
                this.setSelectedItem(location);
                return true;
            }
            catch (IOException e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                JOptionPane.showMessageDialog(this, message);
                return false;
            }
            catch (Throwable e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(log.toString());
                this.ta.appendLine(bos.toString());
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        private boolean setPointFeatureDataset(FeatureDatasetPoint pfd) {
            try {
                if (this.pfDataset != null) {
                    this.pfDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.detailTA.clear();
            Formatter log = new Formatter();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.pfDataset = pfd;
                this.pfViewer.setDataset(this.pfDataset);
                this.setSelectedItem(this.pfDataset.getLocation());
                return true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(log.toString());
                this.ta.appendLine(bos.toString());
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }
    }

    private class FeatureScanPanel
    extends OpPanel {
        RandomAccessFile raf;
        FeatureScan ftTable;
        final FileManager dirChooser;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        FeatureScanPanel(PreferencesExt p) {
            super(p, "dir:", false, false);
            this.raf = null;
            this.dirChooser = new FileManager(ToolsUI.this.parentFrame);
            this.useDefinition = false;
            this.ftTable = new FeatureScan(this.prefs);
            this.add((Component)this.ftTable, "Center");
            this.ftTable.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openPointFeatureDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openPointFeatureDataset(datasetName);
                    } else if (e.getPropertyName().equals("openNetcdfFile")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openNetcdfFile(datasetName);
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openCoordSystems(datasetName);
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openGridDataset(datasetName);
                    } else if (e.getPropertyName().equals("openRadialDataset")) {
                        String datasetName = (String)e.getNewValue();
                        ToolsUI.this.openRadialDataset(datasetName);
                    }
                }
            });
            this.dirChooser.getFileChooser().setFileSelectionMode(2);
            this.dirChooser.setCurrentDirectory(this.prefs.get("currDir", "."));
            AbstractAction fileAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String filename = FeatureScanPanel.this.dirChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    FeatureScanPanel.this.cb.setSelectedItem(filename);
                }
            };
            BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
            BAMutil.addActionToContainer(this.buttPanel, fileAction);
        }

        boolean process(Object o) {
            String command = (String)o;
            return this.ftTable.setScanDirectory(command);
        }

        void save() {
            this.ftTable.save();
            this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
            super.save();
        }
    }

    private class StationObsPanel
    extends OpPanel {
        StationObsViewer povTable;
        JSplitPane split;
        StationObsDataset sobsDataset;

        StationObsPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.sobsDataset = null;
            this.povTable = new StationObsViewer(dbPrefs);
            this.add((Component)this.povTable, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String info;
                    if (StationObsPanel.this.sobsDataset != null && (info = StationObsPanel.this.sobsDataset.getDetailInfo()) != null) {
                        StationObsPanel.this.detailTA.setText(info);
                        StationObsPanel.this.detailTA.gotoTop();
                        StationObsPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String location = (String)o;
            return this.setStationObsDataset(location);
        }

        void save() {
            super.save();
            this.povTable.save();
        }

        boolean setStationObsDataset(String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.sobsDataset != null) {
                    this.sobsDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            StringBuilder log = new StringBuilder();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.sobsDataset = (StationObsDataset)TypedDatasetFactory.open(FeatureType.STATION, location, null, log);
                if (this.sobsDataset == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                    return false;
                }
                this.povTable.setDataset(this.sobsDataset);
                this.setSelectedItem(location);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(log.toString());
                this.ta.appendLine(bos.toString());
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        boolean setStationObsDataset(StationObsDataset dataset) {
            if (dataset == null) {
                return false;
            }
            try {
                if (this.sobsDataset != null) {
                    this.sobsDataset.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.povTable.setDataset(dataset);
            this.sobsDataset = dataset;
            this.setSelectedItem(this.sobsDataset.getLocationURI());
            return true;
        }
    }

    private class PointObsPanel
    extends OpPanel {
        PointObsViewer povTable;
        JSplitPane split;
        PointObsDataset pobsDataset;

        PointObsPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.pobsDataset = null;
            this.povTable = new PointObsViewer(dbPrefs);
            this.add((Component)this.povTable, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Dataset Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String info;
                    if (PointObsPanel.this.pobsDataset != null && (info = PointObsPanel.this.pobsDataset.getDetailInfo()) != null) {
                        PointObsPanel.this.detailTA.setText(info);
                        PointObsPanel.this.detailTA.gotoTop();
                        PointObsPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String location = (String)o;
            return this.setPointObsDataset(location);
        }

        void save() {
            super.save();
            this.povTable.save();
        }

        boolean setPointObsDataset(String location) {
            if (location == null) {
                return false;
            }
            try {
                if (this.pobsDataset != null) {
                    this.pobsDataset.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            StringBuilder log = new StringBuilder();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.pobsDataset = (PointObsDataset)TypedDatasetFactory.open(FeatureType.POINT, location, null, log);
                if (this.pobsDataset == null) {
                    JOptionPane.showMessageDialog(null, "Can't open " + location + ": " + log);
                    return false;
                }
                this.povTable.setDataset(this.pobsDataset);
                this.setSelectedItem(location);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(log.toString());
                this.ta.appendLine(bos.toString());
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
        }

        boolean setPointObsDataset(PointObsDataset dataset) {
            if (dataset == null) {
                return false;
            }
            try {
                if (this.pobsDataset != null) {
                    this.pobsDataset.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.povTable.setDataset(dataset);
            this.pobsDataset = dataset;
            this.setSelectedItem(this.pobsDataset.getLocationURI());
            return true;
        }
    }

    private class ViewerPanel
    extends OpPanel {
        DatasetViewer dsViewer;
        JSplitPane split;
        NetcdfFile ncfile;

        ViewerPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:");
            this.ncfile = null;
            this.dsViewer = new DatasetViewer(dbPrefs);
            this.add((Component)this.dsViewer, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ViewerPanel.this.ncfile != null) {
                        ViewerPanel.this.detailTA.setText(ViewerPanel.this.ncfile.getDetailInfo());
                        ViewerPanel.this.detailTA.gotoTop();
                        ViewerPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            AbstractAction dumpAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    NetcdfFile ds = ViewerPanel.this.dsViewer.getDataset();
                    if (ds != null) {
                        if (ToolsUI.this.ncdumpPanel == null) {
                            ToolsUI.this.makeComponent(ToolsUI.this.tabbedPane, "NCDump");
                        }
                        ToolsUI.this.ncdumpPanel.setNetcdfFile(ds);
                        ToolsUI.this.tabbedPane.setSelectedComponent(ToolsUI.this.ncdumpPanel);
                    }
                }
            };
            BAMutil.setActionProperties(dumpAction, "Dump", "NCDump", false, 68, -1);
            BAMutil.addActionToContainer(this.buttPanel, dumpAction);
            AbstractAction netcdfAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location = ViewerPanel.this.ncfile.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".nc")) == null) {
                        return;
                    }
                    ViewerPanel.this.doWriteNetCDF(filename);
                }
            };
            BAMutil.setActionProperties(netcdfAction, "netcdf", "Write local netCDF file", false, 83, -1);
            BAMutil.addActionToContainer(this.buttPanel, netcdfAction);
            AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to another file", false);
            compareButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    String filename = ToolsUI.this.fileChooser.chooseFilename();
                    if (filename == null) {
                        return;
                    }
                    NetcdfFile compareFile = null;
                    try {
                        compareFile = ViewerPanel.this.addCoords ? NetcdfDataset.acquireDataset(filename, null) : NetcdfDataset.acquireFile(filename, null);
                        Formatter f = new Formatter();
                        CompareNetcdf cn = new CompareNetcdf(true, false, false);
                        cn.compare(ViewerPanel.this.ncfile, compareFile, f);
                        ViewerPanel.this.detailTA.setText(f.toString());
                        ViewerPanel.this.detailTA.gotoTop();
                        ViewerPanel.this.detailWindow.show();
                    }
                    catch (Exception ioe) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        ioe.printStackTrace(new PrintStream(bos));
                        ViewerPanel.this.detailTA.setText(bos.toString());
                        ViewerPanel.this.detailTA.gotoTop();
                        ViewerPanel.this.detailWindow.show();
                    }
                    finally {
                        if (compareFile != null) {
                            try {
                                compareFile.close();
                            }
                            catch (Exception eek) {}
                        }
                    }
                }
            });
            this.buttPanel.add(compareButton);
            AbstractAction attAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    ViewerPanel.this.dsViewer.showAtts();
                }
            };
            BAMutil.setActionProperties(attAction, "FontDecr", "global attributes", false, 65, -1);
            BAMutil.addActionToContainer(this.buttPanel, attAction);
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                NetcdfFile ncnew = ToolsUI.this.openFile(command, this.addCoords, null);
                if (ncnew != null) {
                    this.setDataset(ncnew);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void setDataset(NetcdfFile nc) {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
                this.ncfile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ncfile = nc;
            if (this.ncfile != null) {
                this.dsViewer.setDataset(nc);
                this.setSelectedItem(nc.getLocation());
            }
        }

        void save() {
            super.save();
            this.dsViewer.save();
        }

        void doWriteNetCDF(String filename) {
            try {
                FileWriter.writeToFile(this.ncfile, filename, false, -1);
                JOptionPane.showMessageDialog(this, "File successfully written");
            }
            catch (Exception ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private class RadialPanel
    extends OpPanel {
        RadialDatasetTable dsTable;
        JSplitPane split;
        IndependentWindow viewerWindow;
        RadialDatasetSweep ds;

        RadialPanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.ds = null;
            this.dsTable = new RadialDatasetTable(prefs);
            this.add((Component)this.dsTable, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String info;
                    RadialDatasetSweep radialDataset = RadialPanel.this.dsTable.getRadialDataset();
                    if (radialDataset != null && (info = radialDataset.getDetailInfo()) != null) {
                        RadialPanel.this.detailTA.setText(info);
                        RadialPanel.this.detailTA.gotoTop();
                        RadialPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset(command, true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                Formatter errlog = new Formatter();
                RadialDatasetSweep rds = (RadialDatasetSweep)FeatureDatasetFactoryManager.wrap(FeatureType.RADIAL, newds, null, errlog);
                if (rds == null) {
                    JOptionPane.showMessageDialog(null, "FeatureDatasetFactoryManager cant open " + command + "as RADIAL dataset\n" + errlog.toString());
                    err = true;
                } else {
                    this.setDataset(rds);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void setDataset(RadialDatasetSweep newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ds = newds;
            this.dsTable.setDataset(newds);
            this.setSelectedItem(newds.getLocationURI());
        }

        void save() {
            super.save();
            this.dsTable.save();
        }
    }

    private class GeoGridPanel
    extends OpPanel {
        GeoGridTable dsTable;
        JSplitPane split;
        IndependentWindow viewerWindow;
        IndependentWindow imageWindow;
        GridUI gridUI;
        ImageViewPanel imageViewer;
        NetcdfDataset ds;

        GeoGridPanel(PreferencesExt prefs) {
            super(prefs, "dataset:", true, false);
            this.gridUI = null;
            this.ds = null;
            this.dsTable = new GeoGridTable(prefs, true);
            this.add((Component)this.dsTable, "Center");
            AbstractButton viewButton = BAMutil.makeButtcon("alien", "Grid Viewer", false);
            viewButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        ucar.nc2.dt.GridDataset gridDataset = GeoGridPanel.this.dsTable.getGridDataset();
                        if (GeoGridPanel.this.gridUI == null) {
                            GeoGridPanel.this.makeGridUI();
                        }
                        GeoGridPanel.this.gridUI.setDataset(gridDataset);
                        GeoGridPanel.this.viewerWindow.show();
                    }
                }
            });
            this.buttPanel.add(viewButton);
            AbstractButton imageButton = BAMutil.makeButtcon("VCRMovieLoop", "Image Viewer", false);
            imageButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        GridDatatype grid = GeoGridPanel.this.dsTable.getGrid();
                        if (grid == null) {
                            return;
                        }
                        if (GeoGridPanel.this.imageWindow == null) {
                            GeoGridPanel.this.makeImageWindow();
                        }
                        GeoGridPanel.this.imageViewer.setImageFromGrid(grid);
                        GeoGridPanel.this.imageWindow.show();
                    }
                }
            });
            this.buttPanel.add(imageButton);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ucar.nc2.dt.GridDataset gridDataset = GeoGridPanel.this.dsTable.getGridDataset();
                    if (gridDataset != null && gridDataset instanceof GridDataset) {
                        GridDataset gdsImpl = (GridDataset)gridDataset;
                        GeoGridPanel.this.detailTA.clear();
                        GeoGridPanel.this.detailTA.appendLine(gdsImpl.getDetailInfo());
                        GeoGridPanel.this.detailTA.gotoTop();
                        GeoGridPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            JButton wcsButton = new JButton("WCS");
            wcsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GeoGridPanel.this.ds != null) {
                        ucar.nc2.dt.GridDataset gridDataset = GeoGridPanel.this.dsTable.getGridDataset();
                        URI gdUri = null;
                        try {
                            gdUri = new URI("http://none.such.server/thredds/wcs/dataset");
                        }
                        catch (URISyntaxException e1) {
                            e1.printStackTrace();
                            return;
                        }
                        GetCapabilities getCap = ((GetCapabilitiesBuilder)WcsRequestBuilder.newWcsRequestBuilder("1.0.0", Request.Operation.GetCapabilities, gridDataset, "")).setServerUri(gdUri).setSection(GetCapabilities.Section.All).buildGetCapabilities();
                        try {
                            String gc = getCap.writeCapabilitiesReportAsString();
                            GeoGridPanel.this.detailTA.setText(gc);
                            GeoGridPanel.this.detailTA.gotoTop();
                            GeoGridPanel.this.detailWindow.show();
                        }
                        catch (WcsException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.buttPanel.add(wcsButton);
        }

        private void makeGridUI() {
            this.viewerWindow = new IndependentWindow("Grid Viewer", BAMutil.getImage("netcdfUI"));
            this.gridUI = new GridUI((PreferencesExt)this.prefs.node("GridUI"), this.viewerWindow, ToolsUI.this.fileChooser, 800);
            this.gridUI.addMapBean(new WorldMapBean());
            this.gridUI.addMapBean(new ShapeFileBean("WorldDetailMap", "Global Detailed Map", "WorldDetailMap", ToolsUI.WorldDetailMap));
            this.gridUI.addMapBean(new ShapeFileBean("USDetailMap", "US Detailed Map", "USMap", ToolsUI.USMap));
            this.viewerWindow.setComponent(this.gridUI);
            this.viewerWindow.setBounds((Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDVIEW_FRAME_SIZE, new Rectangle(77, 22, 700, 900)));
        }

        private void makeImageWindow() {
            this.imageWindow = new IndependentWindow("Grid Image Viewer", BAMutil.getImage("netcdfUI"));
            this.imageViewer = new ImageViewPanel(null);
            this.imageWindow.setComponent(this.imageViewer);
            this.imageWindow.setBounds((Rectangle)ToolsUI.this.mainPrefs.getBean(ToolsUI.GRIDIMAGE_FRAME_SIZE, new Rectangle(77, 22, 700, 900)));
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                NetcdfDataset newds = NetcdfDataset.openDataset(command, true, null);
                if (newds == null) {
                    JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command);
                    return false;
                }
                this.setDataset(newds);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void setDataset(NetcdfDataset newds) {
            if (newds == null) {
                return;
            }
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.ds = newds;
            try {
                this.dsTable.setDataset(newds);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.setSelectedItem(newds.getLocation());
        }

        void save() {
            super.save();
            this.dsTable.save();
            if (this.gridUI != null) {
                this.gridUI.storePersistentData();
            }
            if (this.viewerWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDVIEW_FRAME_SIZE, this.viewerWindow.getBounds());
            }
            if (this.imageWindow != null) {
                ToolsUI.this.mainPrefs.putBeanObject(ToolsUI.GRIDIMAGE_FRAME_SIZE, this.imageWindow.getBounds());
            }
        }
    }

    private class FmrcImplPanel
    extends OpPanel {
        FmrcImpl fmrc;
        FmrcTable table;

        FmrcImplPanel(PreferencesExt dbPrefs) {
            super(dbPrefs, "dataset:", true, false);
            this.table = new FmrcTable(this.prefs);
            this.table.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        NetcdfDataset dataset = (NetcdfDataset)e.getNewValue();
                        ToolsUI.this.openNetcdfFile(dataset);
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        NetcdfDataset dataset = (NetcdfDataset)e.getNewValue();
                        ToolsUI.this.openCoordSystems(dataset);
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        NetcdfDataset dataset = (NetcdfDataset)e.getNewValue();
                        ToolsUI.this.openGridDataset(dataset);
                    }
                }
            });
            this.add((Component)this.table, "Center");
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Detail Info", false);
            infoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (FmrcImplPanel.this.fmrc != null) {
                        Formatter f = new Formatter();
                        try {
                            FmrcImplPanel.this.fmrc.dump(f);
                        }
                        catch (IOException ioe) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                            ioe.printStackTrace();
                            ioe.printStackTrace(new PrintStream(bos));
                            FmrcImplPanel.this.ta.appendLine(bos.toString());
                        }
                        FmrcImplPanel.this.detailTA.setText(f.toString());
                        FmrcImplPanel.this.detailTA.gotoTop();
                        FmrcImplPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
        }

        boolean process(Object o) {
            String command = (String)o;
            if (command == null) {
                return false;
            }
            if (this.fmrc != null) {
                try {
                    this.fmrc.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            try {
                this.fmrc = new FmrcImpl(command);
                this.table.setFmrc(this.fmrc);
                return true;
            }
            catch (Exception ioe) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                return false;
            }
        }
    }

    private class FmrcPanel
    extends OpPanel {
        private boolean useDefinition;
        private JComboBox defComboBox;
        private JComboBox catComboBox;
        private JComboBox dirComboBox;
        private JComboBox suffixCB;
        private IndependentWindow defWindow;
        private IndependentWindow catWindow;
        private IndependentWindow dirWindow;
        private AbstractButton defButt;
        private JSpinner catSpinner;
        private String[] catalogURLS;

        FmrcPanel(PreferencesExt p) {
            super(p, "ForecastModelRun:", true, false);
            this.useDefinition = false;
            this.catalogURLS = new String[]{"http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/NAM/CONUS_12km/files/catalog.xml", "http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/NAM/CONUS_12km_conduit/files/catalog.xml", "http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/GFS/Global_0p5deg/files/catalog.xml"};
            AbstractAction defineAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    FmrcPanel.this.useDefinition = state;
                    String tooltip = FmrcPanel.this.useDefinition ? "Use GRIB Definition File is ON" : "Use GRIB Definition File is OFF";
                    FmrcPanel.this.defButt.setToolTipText(tooltip);
                    if (FmrcPanel.this.useDefinition) {
                        if (null == FmrcPanel.this.defComboBox) {
                            FmrcPanel.this.defComboBox = new JComboBox<String>(FmrcDefinition.getDefinitionFiles());
                            FmrcPanel.this.defComboBox.setEditable(true);
                            FmrcPanel.this.defWindow = new IndependentWindow("GRIB Definition File", null, FmrcPanel.this.defComboBox);
                            FmrcPanel.this.defWindow.setLocationRelativeTo(FmrcPanel.this.defButt);
                            FmrcPanel.this.defWindow.setLocation(0, 100);
                        }
                        FmrcPanel.this.defWindow.show();
                    }
                }
            };
            String tooltip2 = this.useDefinition ? "Use GRIB Definition File is ON" : "Use GRIB Definition File is OFF";
            BAMutil.setActionProperties(defineAction, "dd", tooltip2, true, 68, -1);
            defineAction.putValue("state", new Boolean(this.useDefinition));
            this.defButt = BAMutil.addActionToContainer(this.buttPanel, defineAction);
            AbstractAction testDefAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (!FmrcPanel.this.useDefinition) {
                        return;
                    }
                    FmrcPanel.this.testDefinition();
                }
            };
            BAMutil.setActionProperties(testDefAction, "dd", "test file against current definition", false, 84, -1);
            BAMutil.addActionToContainer(this.buttPanel, testDefAction);
            AbstractAction catAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (null == FmrcPanel.this.catComboBox) {
                        FmrcPanel.this.catComboBox = new JComboBox();
                        FmrcPanel.this.catComboBox.setEditable(true);
                        FmrcPanel.this.makeCatalogDefaults(FmrcPanel.this.catComboBox);
                        FmrcPanel.this.catSpinner = new JSpinner();
                        JButton accept = new JButton("Accept");
                        JPanel catPanel = new JPanel(new BorderLayout());
                        JPanel leftPanel = new JPanel();
                        leftPanel.add(new JLabel("Num datasets:"));
                        leftPanel.add(FmrcPanel.this.catSpinner);
                        leftPanel.add(new JLabel("Catalog URL:"));
                        catPanel.add((Component)FmrcPanel.this.catComboBox, "Center");
                        catPanel.add((Component)leftPanel, "West");
                        catPanel.add((Component)accept, "East");
                        accept.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                FmrcPanel.this.defineFromCatalog((String)FmrcPanel.this.catComboBox.getSelectedItem(), FmrcPanel.this.catSpinner.getValue());
                            }
                        });
                        FmrcPanel.this.catWindow = new IndependentWindow("Catalogs", null, catPanel);
                        FmrcPanel.this.catWindow.setLocationRelativeTo(FmrcPanel.this.defButt);
                        FmrcPanel.this.catWindow.setLocation(100, 100);
                    }
                    FmrcPanel.this.catWindow.show();
                }
            };
            BAMutil.setActionProperties(catAction, "catalog", "make definition from catalog", false, 67, -1);
            BAMutil.addActionToContainer(this.buttPanel, catAction);
            AbstractAction dirAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (null == FmrcPanel.this.dirWindow) {
                        FmrcPanel.this.dirComboBox = new JComboBox();
                        FmrcPanel.this.dirComboBox.setEditable(true);
                        FmrcPanel.this.suffixCB = new JComboBox();
                        FmrcPanel.this.suffixCB.setEditable(true);
                        JButton accept = new JButton("Accept");
                        JPanel dirPanel = new JPanel(new BorderLayout());
                        JPanel leftPanel = new JPanel();
                        leftPanel.add(new JLabel("Suffix:"));
                        leftPanel.add(FmrcPanel.this.suffixCB);
                        leftPanel.add(new JLabel("Directory:"));
                        dirPanel.add((Component)leftPanel, "West");
                        dirPanel.add((Component)FmrcPanel.this.dirComboBox, "Center");
                        dirPanel.add((Component)accept, "East");
                        accept.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                FmrcPanel.this.defineFromDirectory((String)FmrcPanel.this.dirComboBox.getSelectedItem(), (String)FmrcPanel.this.suffixCB.getSelectedItem());
                            }
                        });
                        FmrcPanel.this.dirWindow = new IndependentWindow("Directory", null, dirPanel);
                        FmrcPanel.this.dirWindow.setLocationRelativeTo(FmrcPanel.this.defButt);
                        FmrcPanel.this.dirWindow.setLocation(100, 100);
                    }
                    FmrcPanel.this.dirWindow.show();
                }
            };
            BAMutil.setActionProperties(dirAction, "Dimension", "make definition from files in directory", false, 68, -1);
            BAMutil.addActionToContainer(this.buttPanel, dirAction);
            AbstractAction deleteAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String currentFile = (String)FmrcPanel.this.cb.getSelectedItem();
                    File file = new File(currentFile + ".gbx");
                    if (file.exists()) {
                        file.delete();
                        JOptionPane.showMessageDialog(null, "Index deleted, reopen= " + currentFile);
                        FmrcPanel.this.process(currentFile);
                    }
                }
            };
            BAMutil.setActionProperties(deleteAction, "Delete", "Delete Grib Index", false, 84, -1);
            BAMutil.addActionToContainer(this.buttPanel, deleteAction);
        }

        private void makeCatalogDefaults(JComboBox cb) {
            String server = "http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/";
            for (String ds : FmrcDefinition.fmrcDatasets) {
                cb.addItem(server + ds + "/files/catalog.xml");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            TypedDataset gds = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                FmrcDefinition spiObject = null;
                if (this.useDefinition) {
                    String currentDef = (String)this.defComboBox.getSelectedItem();
                    if (currentDef == null) {
                        JOptionPane.showMessageDialog(null, "cant open Definition file " + currentDef);
                        boolean fmrc_def = false;
                        return fmrc_def;
                    }
                    FmrcDefinition fmrc_def = new FmrcDefinition();
                    fmrc_def.readDefinitionXML(currentDef);
                    System.out.println("Read Definition file = " + currentDef);
                    spiObject = fmrc_def;
                    NetcdfDataset ds = NetcdfDataset.openDataset(command, true, -1, null, (Object)spiObject);
                    gds = new GridDataset(ds);
                } else {
                    gds = GridDataset.open(command);
                }
                if (gds == null) {
                    JOptionPane.showMessageDialog(null, "GridDataset.open cant open " + command);
                    boolean currentDef = false;
                    return currentDef;
                }
                ForecastModelRunInventory fmrInv = ForecastModelRunInventory.open((ucar.nc2.dt.GridDataset)gds, null);
                fmrInv.writeXML(bos);
                this.ta.setText("ForecastModelRunInventory output for a single model run:\n\n");
                this.ta.appendLine(bos.toString());
                this.ta.gotoTop();
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "GridDataset.open cant open " + command + "\n" + ioe.getMessage());
                err = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            finally {
                if (gds != null) {
                    try {
                        gds.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (err) return false;
            return true;
        }

        private void testDefinition() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                String currentDef = (String)this.defComboBox.getSelectedItem();
                if (currentDef == null) {
                    return;
                }
                String currentFilename = (String)this.cb.getSelectedItem();
                if (currentFilename == null) {
                    return;
                }
                FmrcDefinition fmrc_def = new FmrcDefinition();
                fmrc_def.readDefinitionXML(currentDef);
                NetcdfDataset ds = NetcdfDataset.openDataset(currentFilename, true, -1, null, (Object)fmrc_def);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
            }
        }

        private void defineFromDirectory(String dirName, String suffix) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                FmrcInventory fmrCollection = FmrcInventory.makeFromDirectory(null, "test", null, dirName, suffix, 2);
                FmrcDefinition def = new FmrcDefinition();
                def.makeFromCollectionInventory(fmrCollection);
                def.writeDefinitionXML(bos);
                this.ta.setText(bos.toString());
                this.ta.gotoTop();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
            }
        }

        private void defineFromCatalog(String catalogURLString, Object value) {
            int n = (Integer)value;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                FmrcInventory fmrCollection = FmrcInventory.makeFromCatalog(catalogURLString, catalogURLString, n, 2);
                FmrcDefinition def = new FmrcDefinition();
                def.makeFromCollectionInventory(fmrCollection);
                def.writeDefinitionXML(bos);
                this.ta.setText(bos.toString());
                this.ta.gotoTop();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                ioe.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
            }
        }
    }

    private class NcmlPanel
    extends OpPanel {
        NetcdfDataset ds;
        String ncmlLocation;
        JEditorPane editor;

        NcmlPanel(PreferencesExt p) {
            super(p, "dataset:");
            this.ds = null;
            this.ncmlLocation = null;
            this.editor = new JEditorPane();
            XMLEditorKit kit = new XMLEditorKit(false);
            kit.setWrapStyleWord(true);
            this.editor.setEditorKit(kit);
            this.editor.setFont(new Font("Courier", 0, 12));
            this.editor.getDocument().putProperty("tabSize", 2);
            this.editor.getDocument().putProperty("autoIndentation", true);
            this.editor.getDocument().putProperty("tagCompletion", true);
            kit.setFolding(true);
            kit.setStyle("attribute-name", Color.RED, 1);
            ScrollableEditorPanel editorPanel = new ScrollableEditorPanel(this.editor);
            JScrollPane scroller = new JScrollPane(editorPanel);
            scroller.setRowHeaderView(new LineNumberMargin(this.editor));
            AbstractAction wrapAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    XMLEditorKit kit;
                    kit.setLineWrappingEnabled(!(kit = (XMLEditorKit)NcmlPanel.this.editor.getEditorKit()).isLineWrapping());
                    NcmlPanel.this.editor.updateUI();
                }
            };
            BAMutil.setActionProperties(wrapAction, "Wrap", "Toggle Wrapping", false, 87, -1);
            BAMutil.addActionToContainer(this.buttPanel, wrapAction);
            AbstractAction saveAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location;
                    String string = location = NcmlPanel.this.ds == null ? NcmlPanel.this.ncmlLocation : NcmlPanel.this.ds.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".ncml")) == null) {
                        return;
                    }
                    NcmlPanel.this.doSave(NcmlPanel.this.editor.getText(), filename);
                }
            };
            BAMutil.setActionProperties(saveAction, "Save", "Save NcML", false, 83, -1);
            BAMutil.addActionToContainer(this.buttPanel, saveAction);
            AbstractAction netcdfAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String filename;
                    int pos;
                    String location;
                    String string = location = NcmlPanel.this.ds == null ? NcmlPanel.this.ncmlLocation : NcmlPanel.this.ds.getLocation();
                    if (location == null) {
                        location = "test";
                    }
                    if ((pos = location.lastIndexOf(".")) > 0) {
                        location = location.substring(0, pos);
                    }
                    if ((filename = ToolsUI.this.fileChooser.chooseFilenameToSave(location + ".nc")) == null) {
                        return;
                    }
                    NcmlPanel.this.doWriteNetCDF(NcmlPanel.this.editor.getText(), filename);
                }
            };
            BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF", false, 78, -1);
            BAMutil.addActionToContainer(this.buttPanel, netcdfAction);
            AbstractAction transAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    NcmlPanel.this.doTransform(NcmlPanel.this.editor.getText());
                }
            };
            BAMutil.setActionProperties(transAction, "Import", "read textArea through NcMLReader\n write NcML back out via resulting dataset", false, 84, -1);
            BAMutil.addActionToContainer(this.buttPanel, transAction);
            this.add((Component)scroller, "Center");
        }

        boolean process(Object o) {
            this.ncmlLocation = (String)o;
            if (this.ncmlLocation.endsWith(".xml") || this.ncmlLocation.endsWith(".ncml")) {
                if (!this.ncmlLocation.startsWith("http:") && !this.ncmlLocation.startsWith("file:")) {
                    this.ncmlLocation = "file:" + this.ncmlLocation;
                }
                String text = IO.readURLcontents(this.ncmlLocation);
                this.editor.setText(text);
            } else {
                this.writeNcml(this.ncmlLocation);
            }
            return true;
        }

        boolean writeNcml(String location) {
            boolean err = false;
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.ds = ToolsUI.this.openDataset(location, this.addCoords, null);
                if (this.ds == null) {
                    this.editor.setText("Failed to open <" + location + ">");
                } else {
                    String result = new NcMLWriter().writeXML(this.ds);
                    this.editor.setText(result);
                    this.editor.setCaretPosition(0);
                }
            }
            catch (FileNotFoundException ioe) {
                this.editor.setText("Failed to open <" + location + ">");
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.editor.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void doWriteNetCDF(String text, String filename) {
            if (ToolsUI.this.debugNcmlWrite) {
                System.out.println("filename=" + filename);
                System.out.println("text=" + text);
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(text.getBytes());
                NcMLReader.writeNcMLToFile(bis, filename);
                JOptionPane.showMessageDialog(this, "File successfully written");
            }
            catch (Exception ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }

        void doTransform(String text) {
            try {
                StringReader reader = new StringReader(text);
                NetcdfDataset ncd = NcMLReader.readNcML(reader, null);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                ncd.writeNcML(bos, null);
                this.editor.setText(bos.toString());
                this.editor.setCaretPosition(0);
                JOptionPane.showMessageDialog(this, "File successfully transformed");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }

        void doSave(String text, String filename) {
            if (ToolsUI.this.debugNcmlWrite) {
                System.out.println("filename=" + filename);
                System.out.println("text=" + text);
            }
            try {
                IO.writeToFile(text, new File(filename));
                JOptionPane.showMessageDialog(this, "File successfully written");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private class Hdf5Panel
    extends OpPanel {
        RandomAccessFile raf;
        Hdf5Table hdf5Table;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        Hdf5Panel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.useDefinition = false;
            this.hdf5Table = new Hdf5Table(this.prefs);
            this.add((Component)this.hdf5Table, "Center");
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.hdf5Table.setHdf5File(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                this.ta.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void save() {
            this.hdf5Table.save();
            super.save();
        }
    }

    private class GribPanel
    extends OpPanel {
        RandomAccessFile raf;
        GribTable gribTable;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        GribPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.useDefinition = false;
            this.gribTable = new GribTable(this.prefs);
            this.add((Component)this.gribTable, "Center");
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.gribTable.setGribFile(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                this.ta.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void save() {
            this.gribTable.save();
            super.save();
        }
    }

    private class BufrPanel
    extends OpPanel {
        RandomAccessFile raf;
        BufrTable bufrTable;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        BufrPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.raf = null;
            this.useDefinition = false;
            this.bufrTable = new BufrTable(this.prefs);
            this.add((Component)this.bufrTable, "Center");
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
                this.raf = new RandomAccessFile(command, "r");
                this.bufrTable.setBufrFile(this.raf);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                this.ta.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void save() {
            this.bufrTable.save();
            super.save();
        }
    }

    private class AggPanel
    extends OpPanel {
        AggTable aggTable;
        NetcdfDataset ncd;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        AggPanel(PreferencesExt p) {
            super(p, "file:", true, false);
            this.useDefinition = false;
            this.aggTable = new AggTable(this.prefs, this.buttPanel);
            this.aggTable.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("openNetcdfFile")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile != null) {
                            ToolsUI.this.openNetcdfFile(ncfile);
                        }
                    } else if (e.getPropertyName().equals("openCoordSystems")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile == null) {
                            return;
                        }
                        try {
                            NetcdfDataset ncd = NetcdfDataset.wrap(ncfile, NetcdfDataset.getDefaultEnhanceMode());
                            ToolsUI.this.openCoordSystems(ncd);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else if (e.getPropertyName().equals("openGridDataset")) {
                        NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                        if (ncfile == null) {
                            return;
                        }
                        try {
                            NetcdfDataset ncd = NetcdfDataset.wrap(ncfile, NetcdfDataset.getDefaultEnhanceMode());
                            ToolsUI.this.openGridDataset(ncd);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.add((Component)this.aggTable, "Center");
        }

        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ncd != null) {
                    try {
                        this.ncd.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                this.ncd = (NetcdfDataset)NetcdfDataset.openFile(command, null);
                this.aggTable.setAggDataset(this.ncd);
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                this.ta.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                err = true;
            }
            catch (Throwable e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
                e.printStackTrace(new PrintStream(bos));
                this.detailTA.setText(bos.toString());
                this.detailTA.gotoTop();
                this.detailWindow.show();
                err = true;
            }
            return !err;
        }

        void save() {
            this.aggTable.save();
            super.save();
        }
    }

    private class CoordSysPanel
    extends OpPanel {
        NetcdfDataset ds;
        CoordSysTable coordSysTable;
        boolean useDefinition;
        JComboBox defComboBox;
        IndependentWindow defWindow;
        AbstractButton defButt;

        CoordSysPanel(PreferencesExt p) {
            super(p, "dataset:", true, false);
            this.ds = null;
            this.useDefinition = false;
            this.coordSysTable = new CoordSysTable(this.prefs);
            this.add((Component)this.coordSysTable, "Center");
            AbstractAction defAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Boolean state = (Boolean)this.getValue("state");
                    CoordSysPanel.this.useDefinition = state;
                    String tooltip = CoordSysPanel.this.useDefinition ? "Use GRIB Definition File is ON" : "Use GRIB Definition File is OFF";
                    CoordSysPanel.this.defButt.setToolTipText(tooltip);
                    if (CoordSysPanel.this.useDefinition) {
                        CoordSysPanel.this.defWindow.show();
                    }
                }
            };
            String tooltip2 = this.useDefinition ? "Use GRIB Definition File is ON" : "Use GRIB Definition File is OFF";
            BAMutil.setActionProperties(defAction, "dd", tooltip2, true, 68, -1);
            defAction.putValue("state", new Boolean(this.useDefinition));
            this.defButt = BAMutil.addActionToContainer(this.buttPanel, defAction);
            this.defComboBox = new JComboBox<String>(FmrcDefinition.getDefinitionFiles());
            this.defWindow = new IndependentWindow("GRIB Definition File", null, this.defComboBox);
            this.defWindow.setLocationRelativeTo(this.defButt);
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Parse Info", false);
            infoButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent e) {
                    if (CoordSysPanel.this.ds != null) {
                        NetcdfDatasetInfo info = null;
                        try {
                            info = new NetcdfDatasetInfo(CoordSysPanel.this.ds.getLocation());
                            CoordSysPanel.this.detailTA.setText(info.writeXML());
                            CoordSysPanel.this.detailTA.appendLine("----------------------");
                            CoordSysPanel.this.detailTA.appendLine(info.getParseInfo());
                            CoordSysPanel.this.detailTA.gotoTop();
                        }
                        catch (IOException e1) {
                            PrintStream ps = new PrintStream(new ByteArrayOutputStream());
                            e1.printStackTrace(ps);
                            CoordSysPanel.this.detailTA.setText(ps.toString());
                        }
                        finally {
                            if (info != null) {
                                try {
                                    info.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        CoordSysPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(infoButton);
            JButton dsButton = new JButton("DSdump");
            dsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (CoordSysPanel.this.ds != null) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        NetcdfDataset.debugDump(new PrintStream(bos), CoordSysPanel.this.ds);
                        CoordSysPanel.this.detailTA.setText(bos.toString());
                        CoordSysPanel.this.detailTA.gotoTop();
                        CoordSysPanel.this.detailWindow.show();
                    }
                }
            });
            this.buttPanel.add(dsButton);
        }

        boolean process(Object o) {
            String currentDef;
            String command = (String)o;
            boolean err = false;
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            FmrcDefinition spiObject = null;
            if (this.useDefinition && (currentDef = (String)this.defComboBox.getSelectedItem()) != null) {
                FmrcDefinition fmrc_def = new FmrcDefinition();
                try {
                    fmrc_def.readDefinitionXML(currentDef);
                    spiObject = fmrc_def;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                this.ds = NetcdfDataset.openDataset(command, true, -1, null, spiObject);
                if (this.ds == null) {
                    this.ta.setText("Failed to open <" + command + ">");
                } else {
                    this.coordSysTable.setDataset(this.ds);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset cant open " + command + "\n" + ioe.getMessage());
                this.ta.setText("Failed to open <" + command + ">\n" + ioe.getMessage());
                err = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
                err = true;
            }
            return !err;
        }

        void setDataset(NetcdfDataset ncd) {
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
                this.ds = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ds = ncd;
            this.coordSysTable.setDataset(this.ds);
            this.setSelectedItem(this.ds.getLocation());
        }

        void save() {
            this.coordSysTable.save();
            super.save();
        }
    }

    private class DateFormatMark
    extends OpPanel {
        ComboBox testCB;
        DateFormatter dateFormatter;

        DateFormatMark(PreferencesExt prefs) {
            super(prefs, "dateFormatMark:", false, false);
            this.dateFormatter = new DateFormatter();
            this.testCB = new ComboBox(prefs);
            this.buttPanel.add(this.testCB);
            JButton compareButton = new JButton("Apply");
            compareButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DateFormatMark.this.apply(DateFormatMark.this.cb.getSelectedItem(), DateFormatMark.this.testCB.getSelectedItem());
                }
            });
            this.buttPanel.add(compareButton);
        }

        boolean process(Object o) {
            return false;
        }

        void apply(Object mark, Object testo) {
            String dateFormatMark = (String)mark;
            String filename = (String)testo;
            try {
                Date coordValueDate = DateFromString.getDateUsingDemarkatedCount(filename, dateFormatMark, '#');
                String coordValue = this.dateFormatter.toDateTimeStringISO(coordValueDate);
                this.ta.setText("got date= " + coordValue);
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                this.ta.setText(bos.toString());
            }
        }
    }

    private class UnitConvert
    extends OpPanel {
        UnitConvert(PreferencesExt prefs) {
            super(prefs, "unit:", false, false);
            JButton compareButton = new JButton("Compare");
            compareButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.compare(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(compareButton);
            JButton dateButton = new JButton("Date");
            dateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UnitConvert.this.checkDate(UnitConvert.this.cb.getSelectedItem());
                }
            });
            this.buttPanel.add(dateButton);
        }

        boolean process(Object o) {
            String command = (String)o;
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions(command);
                this.ta.setText("toString()=" + su.toString() + "\n");
                this.ta.appendLine("getCanonicalString()=" + su.getCanonicalString());
                this.ta.appendLine("class = " + su.getImplementingClass());
                if (su.isUnknownUnit()) {
                    this.ta.appendLine("UNKNOWN UNIT");
                }
                return true;
            }
            catch (Exception e) {
                if (Debug.isSet("Xdeveloper")) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                    e.printStackTrace(new PrintStream(bos));
                    this.ta.setText(bos.toString());
                } else {
                    this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
                }
                return false;
            }
        }

        void compare(Object o) {
            String command = (String)o;
            StringTokenizer stoke = new StringTokenizer(command);
            ArrayList<String> list = new ArrayList<String>();
            while (stoke.hasMoreTokens()) {
                list.add(stoke.nextToken());
            }
            try {
                String unitS1 = (String)list.get(0);
                String unitS2 = (String)list.get(1);
                SimpleUnit su1 = SimpleUnit.factoryWithExceptions(unitS1);
                SimpleUnit su2 = SimpleUnit.factoryWithExceptions(unitS2);
                this.ta.setText("<" + su1.toString() + "> isConvertable to <" + su2.toString() + ">=" + SimpleUnit.isCompatibleWithExceptions(unitS1, unitS2));
            }
            catch (Exception e) {
                if (Debug.isSet("Xdeveloper")) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                    e.printStackTrace(new PrintStream(bos));
                    this.ta.setText(bos.toString());
                }
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
        }

        void checkDate(Object o) {
            Date d;
            String command = (String)o;
            boolean isDate = false;
            try {
                DateUnit du = new DateUnit(command);
                this.ta.appendLine("\n<" + command + "> isDateUnit = " + du);
                Date d2 = du.getDate();
                this.ta.appendLine("getStandardDateString = " + ToolsUI.this.formatter.toDateTimeString(d2));
                this.ta.appendLine("getDateOrigin = " + ToolsUI.this.formatter.toDateTimeString(du.getDateOrigin()));
                isDate = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isDate) {
                try {
                    SimpleUnit su = SimpleUnit.factory(command);
                    boolean isTime = su instanceof TimeUnit;
                    this.ta.setText("<" + command + "> isDateUnit= " + isDate + " isTimeUnit= " + isTime);
                    if (isTime) {
                        TimeUnit du = (TimeUnit)su;
                        this.ta.appendLine("\nTimeUnit = " + du);
                    }
                }
                catch (Exception e) {
                    if (Debug.isSet("Xdeveloper")) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                        e.printStackTrace(new PrintStream(bos));
                        this.ta.setText(bos.toString());
                    }
                    this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
                }
            }
            if ((d = DateUnit.getStandardOrISO(command)) == null) {
                this.ta.appendLine("\nDateUnit.getStandardOrISO = false");
            } else {
                this.ta.appendLine("\nDateUnit.getStandardOrISO = " + ToolsUI.this.formatter.toDateTimeString(d));
            }
        }
    }

    private class UnitDatasetCheck
    extends OpPanel {
        UnitDatasetCheck(PreferencesExt p) {
            super(p, "dataset:");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean process(Object o) {
            String command = (String)o;
            boolean err = false;
            NetcdfDataset ncfile = null;
            try {
                ncfile = NetcdfDataset.openDataset(command, this.addCoords, null);
                this.ta.setText("Variables for " + command + ":");
                for (VariableEnhanced variableEnhanced : ncfile.getVariables()) {
                    String units = variableEnhanced.getUnitsString();
                    StringBuilder sb = new StringBuilder();
                    sb.append("   ").append(variableEnhanced.getName()).append(" has unit= <").append(units).append(">");
                    if (units != null) {
                        try {
                            SimpleUnit su = SimpleUnit.factoryWithExceptions(units);
                            sb.append(" unit convert = ").append(su.toString());
                            if (su.isUnknownUnit()) {
                                sb.append(" UNKNOWN UNIT");
                            }
                        }
                        catch (Exception ioe) {
                            sb.append(" unit convert failed ");
                            sb.insert(0, "**** Fail ");
                        }
                    }
                    this.ta.appendLine(sb.toString());
                }
            }
            catch (FileNotFoundException ioe) {
                this.ta.setText("Failed to open <" + command + ">");
                err = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                err = true;
            }
            finally {
                try {
                    if (ncfile != null) {
                        ((NetcdfFile)ncfile).close();
                    }
                }
                catch (IOException ioe) {}
            }
            return !err;
        }
    }

    private class UnitsPanel
    extends JPanel {
        PreferencesExt prefs;
        JSplitPane split;
        JSplitPane split2;
        UnitDatasetCheck unitDataset;
        UnitConvert unitConvert;
        DateFormatMark dateFormatMark;

        UnitsPanel(PreferencesExt prefs) {
            this.prefs = prefs;
            this.unitDataset = new UnitDatasetCheck((PreferencesExt)prefs.node("unitDataset"));
            this.unitConvert = new UnitConvert((PreferencesExt)prefs.node("unitConvert"));
            this.dateFormatMark = new DateFormatMark((PreferencesExt)prefs.node("dateFormatMark"));
            this.split2 = new JSplitPane(0, this.unitConvert, this.dateFormatMark);
            this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
            this.split = new JSplitPane(1, new JScrollPane(this.unitDataset), this.split2);
            this.split.setDividerLocation(prefs.getInt("splitPos", 500));
            this.setLayout(new BorderLayout());
            this.add((Component)this.split, "Center");
        }

        void save() {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
            this.unitConvert.save();
            this.unitDataset.save();
        }
    }

    private class NCdumpPanel
    extends OpPanel
    implements GetDataRunnable {
        private GetDataTask task;
        NetcdfFile ncfile;
        String filename;
        String command;
        String result;

        NCdumpPanel(PreferencesExt prefs) {
            super(prefs, "command:");
            this.ncfile = null;
            this.filename = null;
            this.command = null;
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (NCdumpPanel.this.task.isSuccess()) {
                        NCdumpPanel.this.ta.setText(NCdumpPanel.this.result);
                    } else {
                        NCdumpPanel.this.ta.setText(((NCdumpPanel)NCdumpPanel.this).task.errMsg);
                    }
                    if (NCdumpPanel.this.task.isCancel()) {
                        NCdumpPanel.this.ta.appendLine("\n***Cancelled by User");
                    }
                    NCdumpPanel.this.ta.gotoTop();
                    if (NCdumpPanel.this.task.isSuccess() && !NCdumpPanel.this.task.isCancel()) {
                        NCdumpPanel.this.cb.setSelectedItem(NCdumpPanel.this.filename);
                    }
                }
            });
        }

        boolean process(Object o) {
            int pos;
            String input = ((String)o).trim();
            if (input.indexOf(34) == 0 && (pos = input.indexOf(34, 1)) > 0) {
                this.filename = input.substring(1, pos);
                this.command = input.substring(pos + 1);
            } else if (input.indexOf(39) == 0 && (pos = input.indexOf(39, 1)) > 0) {
                this.filename = input.substring(1, pos);
                this.command = input.substring(pos + 1);
            } else {
                pos = input.indexOf(32);
                if (pos > 0) {
                    this.filename = input.substring(0, pos);
                    this.command = input.substring(pos);
                } else {
                    this.filename = input;
                    this.command = null;
                }
            }
            this.task = new GetDataTask(this, this.filename, null);
            this.stopButton.startProgressMonitorTask(this.task);
            this.defer = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Object o) throws IOException {
            try {
                this.ncfile = this.addCoords ? NetcdfDataset.openDataset(this.filename, true, null) : NetcdfDataset.openFile(this.filename, null);
                StringWriter writer = new StringWriter(50000);
                NCdumpW.print(this.ncfile, this.command, writer, this.task);
                this.result = writer.toString();
            }
            finally {
                try {
                    if (this.ncfile != null) {
                        this.ncfile.close();
                    }
                    this.ncfile = null;
                }
                catch (IOException iOException) {}
            }
        }

        void setNetcdfFile(NetcdfFile ncf) {
            this.ncfile = ncf;
            this.filename = ncf.getLocation();
            GetDataRunnable runner = new GetDataRunnable(){

                public void run(Object o) throws IOException {
                    StringWriter writer = new StringWriter(50000);
                    NCdumpW.print(NCdumpPanel.this.ncfile, NCdumpPanel.this.command, writer, NCdumpPanel.this.task);
                    NCdumpPanel.this.result = writer.toString();
                }
            };
            this.task = new GetDataTask(runner, this.filename, null);
            this.stopButton.startProgressMonitorTask(this.task);
        }
    }

    private abstract class OpPanel
    extends JPanel {
        PreferencesExt prefs;
        TextHistoryPane ta;
        ComboBox cb;
        JPanel buttPanel;
        AbstractButton coordButt = null;
        StopButton stopButton;
        boolean addCoords;
        boolean defer;
        boolean busy;
        long lastEvent = -1L;
        boolean eventOK = true;
        IndependentWindow detailWindow;
        TextHistoryPane detailTA;

        OpPanel(PreferencesExt prefs, String command) {
            this(prefs, command, true, true);
        }

        OpPanel(PreferencesExt prefs, String command, boolean addFileButton, boolean addCoordButton) {
            this.prefs = prefs;
            this.ta = new TextHistoryPane(true);
            this.cb = new ComboBox(prefs);
            this.cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ToolsUI.this.debugCB) {
                        System.out.println(" doit " + OpPanel.this.cb.getSelectedItem() + " cmd=" + e.getActionCommand() + " when=" + e.getWhen() + " class=" + OpPanel.this.getClass().getName());
                    }
                    if (OpPanel.this.eventOK && e.getWhen() > OpPanel.this.lastEvent + 10000L) {
                        OpPanel.this.doit(OpPanel.this.cb.getSelectedItem());
                        OpPanel.this.lastEvent = e.getWhen();
                    }
                }
            });
            this.buttPanel = new JPanel(new FlowLayout(0, 5, 0));
            if (addFileButton) {
                AbstractAction fileAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        String filename = ToolsUI.this.fileChooser.chooseFilename();
                        if (filename == null) {
                            return;
                        }
                        OpPanel.this.cb.setSelectedItem(filename);
                    }
                };
                BAMutil.setActionProperties(fileAction, "FileChooser", "open Local dataset...", false, 76, -1);
                BAMutil.addActionToContainer(this.buttPanel, fileAction);
            }
            if (addCoordButton) {
                AbstractAction coordAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        Boolean state = (Boolean)this.getValue("state");
                        OpPanel.this.addCoords = state;
                        String tooltip = OpPanel.this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                        OpPanel.this.coordButt.setToolTipText(tooltip);
                    }
                };
                this.addCoords = prefs.getBoolean("coordState", false);
                String tooltip2 = this.addCoords ? "add Coordinates is ON" : "add Coordinates is OFF";
                BAMutil.setActionProperties(coordAction, "addCoords", tooltip2, true, 67, -1);
                coordAction.putValue("state", new Boolean(this.addCoords));
                this.coordButt = BAMutil.addActionToContainer(this.buttPanel, coordAction);
            }
            if (this instanceof GetDataRunnable) {
                this.stopButton = new StopButton("Stop");
                this.buttPanel.add(this.stopButton);
            }
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)new JLabel(command), "West");
            topPanel.add((Component)this.cb, "Center");
            topPanel.add((Component)this.buttPanel, "East");
            this.setLayout(new BorderLayout());
            this.add((Component)topPanel, "North");
            this.add((Component)this.ta, "Center");
            this.detailTA = new TextHistoryPane();
            this.detailTA.setFont(new Font("Monospaced", 0, 12));
            this.detailWindow = new IndependentWindow("Details", BAMutil.getImage("netcdfUI"), new JScrollPane(this.detailTA));
            Rectangle bounds = (Rectangle)prefs.getBean(ToolsUI.FRAME_SIZE, new Rectangle(200, 50, 500, 700));
            this.detailWindow.setBounds(bounds);
        }

        void doit(Object command) {
            if (this.busy) {
                return;
            }
            if (command == null) {
                return;
            }
            if (command instanceof String) {
                command = ((String)command).trim();
            }
            if (ToolsUI.this.debug) {
                System.out.println(this.getClass().getName() + " process=" + command);
            }
            this.busy = true;
            if (this.process(command) && !this.defer) {
                this.cb.addItem(command);
            }
            this.busy = false;
        }

        abstract boolean process(Object var1);

        void save() {
            this.cb.save();
            if (this.coordButt != null) {
                this.prefs.putBoolean("coordState", this.coordButt.getModel().isSelected());
            }
            if (this.detailWindow != null) {
                this.prefs.putBeanObject(ToolsUI.FRAME_SIZE, this.detailWindow.getBounds());
            }
        }

        void setSelectedItem(Object item) {
            this.eventOK = false;
            this.cb.setSelectedItem(item);
            this.eventOK = true;
        }
    }
}

