/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.BaseUnit;
import visad.DerivedUnit;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;
import visad.data.units.UnitParser;

public class CommonUnit {
    public static Unit degree;
    public static Unit radian;
    public static Unit second;
    public static Unit meter;
    public static Unit meterPerSecond;
    public static Unit secondsSinceTheEpoch;
    public static Unit dimensionless;
    public static Unit promiscuous;

    public static void main(String[] args) throws UnitException {
        System.out.println("new ScaledUnit(1.0).equals(dimensionless)=" + new ScaledUnit(1.0).equals(dimensionless));
        System.out.println("dimensionless.equals(new ScaledUnit(1.0))=" + dimensionless.equals(new ScaledUnit(1.0)));
        System.out.println("CommonUnit.dimensionless.isConvertible(SI.radian) = " + dimensionless.isConvertible(SI.radian));
        System.out.println("CommonUnit.dimensionless.isConvertible(CommonUnit.degree) = " + dimensionless.isConvertible(degree));
        System.out.println("CommonUnit.degree.isConvertible(SI.radian) = " + degree.isConvertible(SI.radian));
    }

    static {
        radian = SI.radian;
        second = SI.second;
        meter = SI.meter;
        meterPerSecond = new DerivedUnit(new BaseUnit[]{SI.meter, SI.second}, new int[]{1, -1});
        secondsSinceTheEpoch = new OffsetUnit(UnitParser.encodeTimestamp(1970, 1, 1, 0, 0, 0.0f, 0), SI.second);
        dimensionless = new DerivedUnit();
        promiscuous = PromiscuousUnit.promiscuous;
        try {
            degree = SI.radian.scale(Math.PI / 180, true).clone("deg");
        }
        catch (UnitException unitException) {
            // empty catch block
        }
    }
}

