/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Field;
import visad.FunctionType;
import visad.GridCoordinateSystem;
import visad.GriddedSet;
import visad.RealTupleType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.VisADException;
import visad.util.Util;

public final class EmpiricalCoordinateSystem
extends CoordinateSystem
implements Serializable {
    private final GridCoordinateSystem worldCS;
    private final GridCoordinateSystem referenceCS;

    public EmpiricalCoordinateSystem(GriddedSet world, GriddedSet reference) throws VisADException {
        super(((SetType)reference.getType()).getDomain(), world.getSetUnits());
        this.worldCS = new GridCoordinateSystem(EmpiricalCoordinateSystem.ensureNoCoordinateSystem(world));
        this.referenceCS = new GridCoordinateSystem(EmpiricalCoordinateSystem.ensureNoCoordinateSystem(reference));
    }

    protected static GriddedSet ensureNoCoordinateSystem(GriddedSet griddedSet) throws VisADException {
        if (griddedSet.getCoordinateSystem() != null) {
            SetType setType = (SetType)griddedSet.getType();
            RealTupleType realTupleType = setType.getDomain();
            if (realTupleType.getCoordinateSystem() != null) {
                setType = new SetType(new RealTupleType(realTupleType.getRealComponents()));
            }
            griddedSet = GriddedSet.create(setType, griddedSet.getSamples(), griddedSet.getLengths(), null, griddedSet.getSetUnits(), griddedSet.getSetErrors());
        }
        return griddedSet;
    }

    public static EmpiricalCoordinateSystem create(Field field) throws SetException, VisADException, RemoteException {
        Set domainSet = field.getDomainSet();
        float[][] samples = field.getFloats(false);
        if (!(domainSet instanceof GriddedSet)) {
            throw new SetException("Domain set must be GriddedSet");
        }
        return new EmpiricalCoordinateSystem((GriddedSet)domainSet, GriddedSet.create(((FunctionType)field.getType()).getFlatRange(), samples, new int[]{samples[0].length}, null, null, null));
    }

    public static EmpiricalCoordinateSystem inverseCreate(Field field) throws SetException, VisADException, RemoteException {
        Set domainSet = field.getDomainSet();
        float[][] samples = field.getFloats(false);
        if (!(domainSet instanceof GriddedSet)) {
            throw new SetException("Domain set must be GriddedSet");
        }
        return new EmpiricalCoordinateSystem(GriddedSet.create(((FunctionType)field.getType()).getFlatRange(), samples, new int[]{samples[0].length}, null, null, null), (GriddedSet)domainSet);
    }

    public GriddedSet getWorldSet() {
        return this.worldCS.getGriddedSet();
    }

    public GriddedSet getReferenceSet() {
        return this.referenceCS.getGriddedSet();
    }

    public double[][] fromReference(double[][] values) throws SetException, VisADException {
        return this.worldCS.toReference(this.referenceCS.fromReference(values));
    }

    public double[][] toReference(double[][] values) throws SetException, VisADException {
        GriddedSet set = this.worldCS.getGriddedSet();
        double[][] samples = set.getDoubles(false);
        if (set.getLength() == values[0].length) {
            int[] lens = set.getLengths();
            int dim = lens.length;
            double[][] tvalues = new double[values.length][values[0].length];
            int[] save_index = new int[values[0].length];
            boolean start = false;
            boolean cnt = false;
            for (int i = 0; i < values[0].length; ++i) {
                int k;
                boolean all = true;
                for (k = 0; k < dim; ++k) {
                    if (Util.isApproximatelyEqual(values[k][i], samples[k][i])) continue;
                    all = false;
                }
                if (all) {
                    k = i;
                    int[] indexI = new int[dim];
                    for (int j = 0; j < dim - 1; ++j) {
                        tvalues[j][i] = k % lens[j];
                        k /= lens[j];
                    }
                } else {
                    return this.referenceCS.toReference(this.worldCS.fromReference(values));
                }
                tvalues[dim - 1][i] = k;
            }
            return this.referenceCS.toReference(tvalues);
        }
        return this.referenceCS.toReference(this.worldCS.fromReference(values));
    }

    public float[][] fromReference(float[][] values) throws SetException, VisADException {
        return this.worldCS.toReference(this.referenceCS.fromReference(values));
    }

    public float[][] toReference(float[][] values) throws SetException, VisADException {
        GriddedSet set = this.worldCS.getGriddedSet();
        float[][] samples = set.getSamples(false);
        if (set.getLength() == values[0].length) {
            int[] lens = set.getLengths();
            int dim = lens.length;
            float[][] tvalues = new float[values.length][values[0].length];
            boolean start = false;
            boolean cnt = false;
            for (int i = 0; i < values[0].length; ++i) {
                int k;
                boolean all = true;
                for (k = 0; k < dim; ++k) {
                    if (Util.isApproximatelyEqual(values[k][i], samples[k][i])) continue;
                    all = false;
                }
                if (all) {
                    k = i;
                    int[] indexI = new int[dim];
                    for (int j = 0; j < dim - 1; ++j) {
                        tvalues[j][i] = k % lens[j];
                        k /= lens[j];
                    }
                } else {
                    return this.referenceCS.toReference(this.worldCS.fromReference(values));
                }
                tvalues[dim - 1][i] = k;
            }
            return this.referenceCS.toReference(tvalues);
        }
        return this.referenceCS.toReference(this.worldCS.fromReference(values));
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmpiricalCoordinateSystem)) {
            return false;
        }
        EmpiricalCoordinateSystem that = (EmpiricalCoordinateSystem)object;
        return this.worldCS.equals(that.worldCS) && this.referenceCS.equals(that.referenceCS);
    }
}

