/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSetIface;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded1DSet
extends GriddedSet
implements Gridded1DSetIface {
    int LengthX;
    float LowX;
    float HiX;
    boolean Ascending;
    private static final WeakHashMap cache = new WeakHashMap();
    private int ig;

    public Gridded1DSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null);
    }

    public Gridded1DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded1DSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        block5: {
            int i;
            super(type, samples, Gridded1DSet.make_lengths(lengthX), coord_sys, units, errors, copy);
            this.ig = -1;
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.LengthX = this.Lengths[0];
            if (this.Samples == null || this.Lengths[0] <= 1) break block5;
            for (i = 0; i < this.Length; ++i) {
                if (this.Samples[0][i] == this.Samples[0][i]) continue;
                throw new SetException("Gridded1DSet: samples values may not be missing");
            }
            boolean bl = this.Ascending = this.Samples[0][this.LengthX - 1] > this.Samples[0][0];
            if (this.Ascending) {
                for (i = 1; i < this.LengthX; ++i) {
                    if (!(this.Samples[0][i] < this.Samples[0][i - 1])) continue;
                    throw new SetException("Gridded1DSet: samples do not form a valid grid (" + i + ")");
                }
            } else {
                for (i = 1; i < this.LengthX; ++i) {
                    if (!(this.Samples[0][i] > this.Samples[0][i - 1])) continue;
                    throw new SetException("Gridded1DSet: samples do not form a valid grid (" + i + ")");
                }
            }
        }
    }

    public static synchronized Gridded1DSet create(MathType type, float[] samples, CoordinateSystem coordSys, Unit unit, ErrorEstimate error) throws VisADException {
        Gridded1DSet newSet = new Gridded1DSet(type, (float[][])new float[][]{samples}, samples.length, coordSys, new Unit[]{unit}, new ErrorEstimate[]{error}, false);
        WeakReference ref = (WeakReference)cache.get(newSet);
        if (ref == null) {
            cache.put(newSet, new WeakReference<Gridded1DSet>(newSet));
        } else {
            Gridded1DSet oldSet = (Gridded1DSet)ref.get();
            if (oldSet == null) {
                cache.put(newSet, new WeakReference<Gridded1DSet>(newSet));
            } else {
                newSet = oldSet;
            }
        }
        return newSet;
    }

    static int[] make_lengths(int lengthX) {
        int[] lens = new int[]{lengthX};
        return lens;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            float[][] grid = new float[this.ManifoldDimension][length];
            for (int i = 0; i < length; ++i) {
                grid[0][i] = 0 <= index[i] && index[i] < this.Length ? (float)index[i] : -1.0f;
            }
            return this.gridToValue(grid);
        }
        float[][] values = new float[1][length];
        for (int i = 0; i < length; ++i) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? this.Samples[0][index[i]] : Float.NaN;
        }
        return values;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded1DSet.valueToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        float[][] grid = this.valueToGrid(value);
        float[] grid0 = grid[0];
        for (int i = 0; i < length; ++i) {
            float g = grid0[i];
            index[i] = Float.isNaN(g) ? -1 : (int)((double)g + 0.5);
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length < this.DomainDimension) {
            throw new SetException("Gridded1DSet.gridToValue: grid dimension " + grid.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = grid[0].length;
        float[][] value = new float[1][length];
        for (int i = 0; i < length; ++i) {
            float g = grid[0][i];
            if ((double)g < -0.5 || (double)g > (double)this.LengthX - 0.5) {
                value[0][i] = Float.NaN;
                continue;
            }
            if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                continue;
            }
            int ig = g < 0.0f ? 0 : (g >= (float)(this.LengthX - 1) ? this.LengthX - 2 : (int)g);
            float A = g - (float)ig;
            value[0][i] = (1.0f - A) * this.Samples[0][ig] + A * this.Samples[0][ig + 1];
        }
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded1DSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        float[] vals = value[0];
        int length = vals.length;
        float[] samps = this.Samples[0];
        float[][] grid = new float[1][length];
        if (this.ig < 0 || this.ig >= this.LengthX) {
            this.ig = (this.LengthX - 1) / 2;
        }
        for (int i = 0; i < length; ++i) {
            if (Float.isNaN(vals[i])) {
                grid[0][i] = Float.NaN;
                continue;
            }
            if (this.Length == 1) {
                grid[0][i] = 0.0f;
                continue;
            }
            int lower = 0;
            int upper = this.LengthX - 1;
            while (lower < upper && !((vals[i] - samps[this.ig]) * (vals[i] - samps[this.ig + 1]) <= 0.0f)) {
                if (this.Ascending ? samps[this.ig + 1] < vals[i] : samps[this.ig + 1] > vals[i]) {
                    lower = this.ig + 1;
                } else if (this.Ascending ? samps[this.ig] > vals[i] : samps[this.ig] < vals[i]) {
                    upper = this.ig;
                }
                if (lower >= upper) continue;
                this.ig = (lower + upper) / 2;
            }
            float solv = (float)this.ig + (vals[i] - samps[this.ig]) / (samps[this.ig + 1] - samps[this.ig]);
            if ((double)solv > -0.5 && (double)solv < (double)this.LengthX - 0.5) {
                grid[0][i] = solv;
                continue;
            }
            grid[0][i] = Float.NaN;
            this.ig = (this.LengthX - 1) / 2;
        }
        return grid;
    }

    public int getLengthX() {
        return this.LengthX;
    }

    public float getLowX() {
        return this.LowX;
    }

    public float getHiX() {
        return this.HiX;
    }

    public boolean isAscending() {
        return this.Ascending;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new Gridded1DSet(type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] args) throws VisADException {
        int i;
        InputStreamReader inStr = new InputStreamReader(System.in);
        int[] ints = new int[80];
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e) {
            System.out.println("Gridded1DSet: " + e);
        }
        int l = 0;
        while (ints[l] != 10) {
            try {
                ints[++l] = inStr.read();
            }
            catch (Exception e) {
                System.out.println("Gridded1DSet: " + e);
            }
        }
        char[] chars = new char[l];
        for (int i2 = 0; i2 < l; ++i2) {
            chars[i2] = (char)ints[i2];
        }
        int num_coords = Integer.parseInt(new String(chars));
        float[][] samp = new float[1][num_coords];
        System.out.println("num_dimensions = 1, num_coords = " + num_coords + "\n");
        try {
            ints[0] = inStr.read();
        }
        catch (Exception e) {
            System.out.println("Gridded1DSet: " + e);
        }
        for (int c = 0; c < num_coords; ++c) {
            l = 0;
            try {
                ints[0] = inStr.read();
            }
            catch (Exception e) {
                System.out.println("Gridded1DSet: " + e);
            }
            while (ints[l] != 32) {
                try {
                    ints[++l] = inStr.read();
                }
                catch (Exception e) {
                    System.out.println("Gridded1DSet: " + e);
                }
            }
            chars = new char[l];
            for (int i3 = 0; i3 < l; ++i3) {
                chars[i3] = (char)ints[i3];
            }
            samp[0][c] = Float.valueOf(new String(chars)).floatValue();
        }
        try {
            inStr.close();
        }
        catch (Exception e) {
            System.out.println("Gridded1DSet: " + e);
        }
        RealType vis_data = RealType.getRealType("vis_data");
        RealType[] vis_array = new RealType[]{vis_data};
        RealTupleType vis_tuple = new RealTupleType(vis_array);
        Gridded1DSet gSet1D = new Gridded1DSet((MathType)vis_tuple, samp, num_coords);
        System.out.println("Lengths = " + num_coords + " wedge = ");
        int[] wedge = gSet1D.getWedge();
        for (i = 0; i < wedge.length; ++i) {
            System.out.println(" " + wedge[i]);
        }
        System.out.println("Samples (" + gSet1D.LengthX + "):");
        for (i = 0; i < gSet1D.LengthX; ++i) {
            System.out.println("#" + i + ":\t" + gSet1D.Samples[0][i]);
        }
        System.out.println("\ngridToValue test:");
        int myLength = gSet1D.LengthX + 1;
        float[][] myGrid = new float[1][myLength];
        for (int i4 = 0; i4 < myLength; ++i4) {
            myGrid[0][i4] = (float)i4 - 0.5f;
        }
        float[] fArray = myGrid[0];
        fArray[0] = (float)((double)fArray[0] + 0.1);
        float[] fArray2 = myGrid[0];
        int n = myLength - 1;
        fArray2[n] = (float)((double)fArray2[n] - 0.1);
        float[][] myValue = gSet1D.gridToValue(myGrid);
        for (int i5 = 0; i5 < myLength; ++i5) {
            System.out.println("(" + (float)Math.round(1000000.0f * myGrid[0][i5]) / 1000000.0f + ")\t-->  " + (float)Math.round(1000000.0f * myValue[0][i5]) / 1000000.0f);
        }
        System.out.println("\nvalueToGrid test:");
        float[][] gridTwo = gSet1D.valueToGrid(myValue);
        for (int i6 = 0; i6 < gridTwo[0].length; ++i6) {
            System.out.println((float)Math.round(1000000.0f * myValue[0][i6]) / 1000000.0f + "  \t-->  (" + (float)Math.round(1000000.0f * gridTwo[0][i6]) / 1000000.0f + ")");
        }
        System.out.println();
    }
}

