/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedDoubleSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Linear1DSet
extends Gridded1DSet
implements LinearSet,
GriddedDoubleSet {
    private double First;
    private double Last;
    private double Step;
    private double Invstep;
    private boolean cacheSamples;

    public Linear1DSet(double first, double last, int length) throws VisADException {
        this((MathType)RealType.Generic, first, last, length, null, null, null);
    }

    public Linear1DSet(MathType type, double first, double last, int length) throws VisADException {
        this(type, first, last, length, null, null, null);
    }

    public Linear1DSet(MathType type, double first, double last, int length, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, first, last, length, coord_sys, units, errors, false);
    }

    public Linear1DSet(MathType type, double first, double last, int length, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, (float[][])null, length, coord_sys, units, errors);
        if (this.DomainDimension != 1) {
            throw new SetException("Linear1DSet: DomainDimension must be 1, not " + this.DomainDimension);
        }
        this.First = first;
        this.Last = last;
        this.Length = length;
        if (this.Length < 1) {
            throw new SetException("Linear1DSet: number of samples (" + this.Length + " must be greater than 0");
        }
        this.Step = this.Length < 2 ? 1.0 : (this.Last - this.First) / (double)(this.Length - 1);
        this.Invstep = 1.0 / this.Step;
        this.LowX = (float)Math.min(this.First, this.First + this.Step * (double)(this.Length - 1));
        this.HiX = (float)Math.max(this.First, this.First + this.Step * (double)(this.Length - 1));
        this.Low[0] = this.LowX;
        this.Hi[0] = this.HiX;
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
        this.cacheSamples = cache;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        float[][] values = new float[1][length];
        for (int i = 0; i < length; ++i) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? (float)(this.First + (double)index[i] * this.Step) : Float.NaN;
        }
        return values;
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        double[][] values = new double[1][length];
        for (int i = 0; i < length; ++i) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? this.First + (double)index[i] * this.Step : Double.NaN;
        }
        return values;
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Linear1DSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double l = -0.5;
        double h = (double)this.Length - 0.5;
        for (int i = 0; i < length; ++i) {
            double di = 0.5 + (value[0][i] - this.First) * this.Invstep;
            index[i] = 0.0 < di && di < (double)this.Length ? (int)di : -1;
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != 1) {
            throw new SetException("Linear1DSet.gridToValue: grid dimension should be 1, not " + grid.length);
        }
        int length = grid[0].length;
        float[][] value = new float[1][length];
        float[] value0 = value[0];
        float[] grid0 = grid[0];
        float l = -0.5f;
        float h = (float)this.Length - 0.5f;
        for (int i = 0; i < length; ++i) {
            float g = grid0[i];
            value0[i] = (float)(l < g && g < h ? this.First + (double)g * this.Step : Double.NaN);
        }
        return value;
    }

    public double[][] gridToDouble(double[][] grid) throws VisADException {
        if (grid.length != 1) {
            throw new SetException("Linear1DSet.gridToValue: grid dimension should be 1, not " + grid.length);
        }
        int length = grid[0].length;
        double[][] value = new double[1][length];
        double[] value0 = value[0];
        double[] grid0 = grid[0];
        double l = -0.5;
        double h = (double)this.Length - 0.5;
        for (int i = 0; i < length; ++i) {
            double g = grid0[i];
            value0[i] = l < g && g < h ? this.First + g * this.Step : Double.NaN;
        }
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length != 1) {
            throw new SetException("Linear1DSet.valueToGrid: value dimension should be 1, not " + value.length);
        }
        int length = value[0].length;
        float[][] grid = new float[1][length];
        float[] grid0 = grid[0];
        float[] value0 = value[0];
        float h = (float)(this.First + ((double)this.Length - 0.5) * this.Step);
        float l = (float)(this.First - 0.5 * this.Step);
        if (h < l) {
            float temp = l;
            l = h;
            h = temp;
        }
        for (int i = 0; i < length; ++i) {
            float v = value0[i];
            grid0[i] = (float)(l < v && v < h ? ((double)v - this.First) * this.Invstep : Double.NaN);
        }
        return grid;
    }

    public double[][] doubleToGrid(double[][] value) throws VisADException {
        if (value.length != 1) {
            throw new SetException("Linear1DSet.valueToGrid: value dimension should be 1, not " + value.length);
        }
        int length = value[0].length;
        double[][] grid = new double[1][length];
        double[] grid0 = grid[0];
        double[] value0 = value[0];
        double h = this.First + ((double)this.Length - 0.5) * this.Step;
        double l = this.First - 0.5 * this.Step;
        if (h < l) {
            double temp = l;
            l = h;
            h = temp;
        }
        for (int i = 0; i < length; ++i) {
            double v = value0[i];
            grid0[i] = l < v && v < h ? (v - this.First) * this.Invstep : Double.NaN;
        }
        return grid;
    }

    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        int j;
        if (value.length != this.DomainDimension) {
            throw new SetException("Linear1DSet.doubleToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("Linear1DSet.doubleToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("Linear1DSet.doubleToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        double[][] grid = this.doubleToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        double[] c = new double[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        for (j = 1; j < this.ManifoldDimension; ++j) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
        }
        for (int i = 0; i < length; ++i) {
            double[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)(grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (double)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[this.ManifoldDimension - 1];
            }
            for (j = this.ManifoldDimension - 2; j >= 0 && base >= 0; --j) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                    continue;
                }
                l[j] = (int)(grid[j][i] + 0.5);
                if (l[j] == this.Lengths[j]) {
                    int n = j;
                    l[n] = l[n] - 1;
                }
                c[j] = grid[j][i] - (double)l[j];
                if (!(l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[j] + this.Lengths[j] * base;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new double[length_is];
                is[0] = base;
                cs[0] = 1.0;
                int lis = 1;
                for (j = 0; j < this.ManifoldDimension; ++j) {
                    double b;
                    double a;
                    int isoff;
                    if (l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0) continue;
                    if (c[j] >= 0.0) {
                        isoff = off[j];
                        a = 1.0 - c[j];
                        b = c[j];
                    } else {
                        isoff = -off[j];
                        a = 1.0 + c[j];
                        b = -c[j];
                    }
                    int k = 0;
                    while (k < lis) {
                        is[k + lis] = is[k] + isoff;
                        cs[k + lis] = cs[k] * b;
                        int n = k++;
                        cs[n] = cs[n] * a;
                    }
                    lis *= 2;
                }
            }
            indices[i] = is;
            weights[i] = cs;
        }
    }

    public double getFirst() {
        return this.First;
    }

    public double getLast() {
        return this.Last;
    }

    public double getStep() {
        return this.Step;
    }

    public double getInvstep() {
        return this.Invstep;
    }

    public boolean isMissing() {
        return false;
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        double[][] samples = new double[1][this.Length];
        for (int i = 0; i < this.Length; ++i) {
            samples[0][i] = this.First + (double)i * this.Step;
        }
        return samples;
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        if (this.Samples != null) {
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        float[][] samples = this.makeSamples();
        if (this.cacheSamples) {
            this.Samples = samples;
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        return samples;
    }

    private float[][] makeSamples() throws VisADException {
        float[][] samples = new float[1][this.Length];
        for (int i = 0; i < this.Length; ++i) {
            samples[0][i] = (float)(this.First + (double)i * this.Step);
        }
        return samples;
    }

    public boolean equals(Object set) {
        boolean flag;
        if (!(set instanceof Linear1DSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            flag = this.First == ((Linear1DSet)set).getFirst() && this.Last == ((Linear1DSet)set).getLast() && this.Length == ((Linear1DSet)set).getLength();
        }
        catch (VisADException e) {
            return false;
        }
        return flag;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ new Double(this.First).hashCode() ^ new Double(this.Last).hashCode() ^ this.Length;
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int i) {
        if (i == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Invalid component index " + i);
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new Linear1DSet(type, this.First, this.Last, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.cacheSamples);
    }

    public String longString(String pre) throws VisADException {
        return pre + "Linear1DSet: Length = " + this.Length + " Range = " + this.First + " to " + this.Last + "\n";
    }
}

