/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.MathType;
import visad.RealType;
import visad.SampledSetIface;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;

public abstract class SampledSet
extends SimpleSet
implements SampledSetIface {
    float[][] Samples;
    float[] Low;
    float[] Hi;

    public SampledSet(MathType type, int manifold_dimension) throws VisADException {
        super(type, manifold_dimension);
    }

    public SampledSet(MathType type, int manifold_dimension, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, manifold_dimension, coord_sys, units, errors);
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
    }

    public SampledSet(MathType type) throws VisADException {
        this(type, null, null, null);
    }

    public SampledSet(MathType type, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, coord_sys, units, errors);
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
    }

    void init_samples(float[][] samples) throws VisADException {
        this.init_samples(samples, true);
    }

    void init_samples(float[][] samples, boolean copy) throws VisADException {
        if (samples.length != this.DomainDimension) {
            throw new SetException("SampledSet.init_samples: sample dimension " + samples.length + " doesn't match expected length " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = samples[0].length;
        } else if (this.Length != samples[0].length) {
            throw new SetException("SampledSet.init_samples: sample#0 length " + samples[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = copy ? new float[this.DomainDimension][this.Length] : samples;
        for (int j = 0; j < this.DomainDimension; ++j) {
            if (samples[j].length != this.Length) {
                throw new SetException("SampledSet.init_samples: sample#" + j + " length " + samples[j].length + " doesn't match expected length " + this.Length);
            }
            float[] samplesJ = samples[j];
            float[] SamplesJ = this.Samples[j];
            if (copy) {
                System.arraycopy(samplesJ, 0, SamplesJ, 0, this.Length);
            }
            this.Low[j] = Float.POSITIVE_INFINITY;
            this.Hi[j] = Float.NEGATIVE_INFINITY;
            float sum = 0.0f;
            for (int i = 0; i < this.Length; ++i) {
                if (SamplesJ[i] == SamplesJ[i] && !Float.isInfinite(SamplesJ[i])) {
                    if (SamplesJ[i] < this.Low[j]) {
                        this.Low[j] = SamplesJ[i];
                    }
                    if (SamplesJ[i] > this.Hi[j]) {
                        this.Hi[j] = SamplesJ[i];
                    }
                } else {
                    SamplesJ[i] = Float.NaN;
                }
                sum += SamplesJ[i];
            }
            if (this.SetErrors[j] == null) continue;
            this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), sum / (float)this.Length, this.Length, this.SetErrors[j].getUnit());
        }
    }

    public void cram_missing(boolean[] range_select) {
        int n = Math.min(range_select.length, this.Samples[0].length);
        for (int i = 0; i < n; ++i) {
            if (range_select[i]) continue;
            this.Samples[0][i] = Float.NaN;
        }
    }

    void cram_samples(float[][] samples) {
        this.Samples = samples;
    }

    public void getNeighbors(int[][] neighbors, float[][] weights) throws VisADException {
        this.getNeighbors(neighbors);
        float constant = 4.0f;
        float pi_squared = (float)(Math.PI * Math.PI);
        float[][] samples = this.Samples != null ? this.Samples : this.getSamples();
        for (int ii = 0; ii < this.Length; ++ii) {
            int n_points = neighbors[ii].length;
            weights[ii] = new float[n_points];
            for (int kk = 0; kk < n_points; ++kk) {
                float distance_squared = 0.0f;
                for (int tt = 0; tt < this.DomainDimension; ++tt) {
                    float diff = samples[tt][ii] - samples[tt][neighbors[ii][kk]];
                    distance_squared += diff * diff;
                }
                float lambda_squared = distance_squared * constant / pi_squared;
                weights[ii][kk] = (float)Math.exp(-1.0f * (distance_squared / lambda_squared));
            }
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        return copy ? Set.copyFloats(this.Samples) : this.Samples;
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException {
        int n = this.getDimension();
        double[][] ranges = new double[2][n];
        return this.computeRanges(type, shadow, ranges, false);
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow, double[][] ranges, boolean domain) throws VisADException {
        ShadowRealTupleType shad_ref;
        int i;
        if (this.isMissing()) {
            return shadow;
        }
        this.setAnimationSampling(type, shadow, domain);
        int[] indices = new int[this.DomainDimension];
        for (i = 0; i < this.DomainDimension; ++i) {
            ShadowRealType real = null;
            if (type instanceof ShadowSetType) {
                real = (ShadowRealType)((ShadowSetType)type).getDomain().getComponent(i);
            } else if (type instanceof ShadowRealTupleType) {
                real = (ShadowRealType)((ShadowRealTupleType)type).getComponent(i);
            } else {
                throw new TypeException("SampledSet.computeRanges: bad ShadowType " + type.getClass().getName());
            }
            indices[i] = real.getIndex();
        }
        for (i = 0; i < this.DomainDimension; ++i) {
            int k = indices[i];
            double min = this.Low[i];
            double max = this.Hi[i];
            Unit dunit = ((RealType)((SetType)this.Type).getDomain().getComponent(i)).getDefaultUnit();
            if (dunit != null && !dunit.equals(this.SetUnits[i])) {
                min = dunit.toThis(min, this.SetUnits[i]);
                max = dunit.toThis(max, this.SetUnits[i]);
            }
            if (ranges != null) {
                ranges[0][i] = min;
                ranges[1][i] = max;
            }
            if (k < 0 || k >= shadow.ranges[0].length) continue;
            shadow.ranges[0][k] = Math.min(shadow.ranges[0][k], min);
            shadow.ranges[1][k] = Math.max(shadow.ranges[1][k], max);
        }
        ShadowRealTupleType domain_type = null;
        if (type instanceof ShadowRealTupleType) {
            domain_type = (ShadowRealTupleType)type;
        } else if (type instanceof ShadowSetType) {
            domain_type = ((ShadowSetType)type).getDomain();
        }
        if (domain_type != null && ranges != null && (shad_ref = domain_type.getReference()) != null) {
            shadow = this.computeReferenceRanges(domain_type, this.DomainCoordinateSystem, ((SetType)this.Type).getDomain().getDefaultUnits(), shadow, shad_ref, ranges);
        }
        return shadow;
    }

    public VisADGeometryArray make1DGeometry(byte[][] color_values) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("SampledSet.make1DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 1) {
            throw new SetException("SampledSet.make1DGeometry: ManifoldDimension must be 1, not " + this.ManifoldDimension);
        }
        VisADGeometryArray array = null;
        if (this.Length == 0) {
            return null;
        }
        if (this.Length == 1) {
            array = new VisADPointArray();
        } else {
            array = new VisADLineStripArray();
            ((VisADLineStripArray)array).stripVertexCounts = new int[1];
            ((VisADLineStripArray)array).stripVertexCounts[0] = this.Length;
        }
        this.setGeometryArray(array, 4, color_values);
        return array;
    }

    public VisADGeometryArray[] make3DGeometry(byte[][] color_values) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new SetException("SampledSet.make3DGeometry: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        VisADGeometryArray array = this.makePointGeometry(color_values);
        return new VisADGeometryArray[]{array, array, array};
    }

    public VisADGeometryArray makePointGeometry(byte[][] color_values) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("SampledSet.makePointGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        VisADPointArray array = new VisADPointArray();
        this.setGeometryArray(array, 4, color_values);
        return array;
    }

    public void setGeometryArray(VisADGeometryArray array, int color_length, byte[][] color_values) throws VisADException {
        SampledSet.setGeometryArray(array, this.getSamples(false), color_length, color_values);
    }

    public static void setGeometryArray(VisADGeometryArray array, float[][] samples, int color_length, byte[][] color_values) throws VisADException {
        int len;
        if (samples == null) {
            throw new SetException("SampledSet.setGeometryArray: Null samples array");
        }
        if (samples.length != 3) {
            throw new SetException("SampledSet.setGeometryArray: Expected 3 dimensions in samples array, not " + samples.length);
        }
        array.vertexCount = len = samples[0].length;
        float[] coordinates = new float[3 * len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            coordinates[j++] = samples[0][i];
            coordinates[j++] = samples[1][i];
            coordinates[j++] = samples[2][i];
        }
        array.coordinates = coordinates;
        if (color_values != null) {
            color_length = Math.min(color_length, color_values.length);
            byte[] colors = new byte[color_length * len];
            j = 0;
            if (color_length == 4) {
                for (int i = 0; i < len; ++i) {
                    colors[j++] = color_values[0][i];
                    colors[j++] = color_values[1][i];
                    colors[j++] = color_values[2][i];
                    colors[j++] = color_values[3][i];
                }
            } else if (color_length == 3) {
                for (int i = 0; i < len; ++i) {
                    colors[j++] = color_values[0][i];
                    colors[j++] = color_values[1][i];
                    colors[j++] = color_values[2][i];
                }
            } else if (color_length == 0) {
                colors = null;
            } else {
                throw new SetException("SampledSet.setGeometryArray: color_length must be 0, 3 or 4, not " + color_length);
            }
            array.colors = colors;
        }
    }

    public float[] getLow() {
        float[] low = new float[this.Low.length];
        for (int i = 0; i < this.Low.length; ++i) {
            low[i] = this.Low[i];
        }
        return low;
    }

    public float[] getHi() {
        float[] hi = new float[this.Hi.length];
        for (int i = 0; i < this.Hi.length; ++i) {
            hi[i] = this.Hi[i];
        }
        return hi;
    }

    public Object clone() {
        SampledSet clone = (SampledSet)super.clone();
        if (clone.Samples != null) {
            clone.Samples = new float[this.Samples.length][];
            for (int i = 0; i < this.Samples.length; ++i) {
                clone.Samples[i] = (float[])this.Samples[i].clone();
            }
        }
        return clone;
    }
}

