/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.CommonUnit;
import visad.ContourControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.EarthVectorType;
import visad.Flow1Control;
import visad.Flow2Control;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.Integer2DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.PlotText;
import visad.ProjectionControl;
import visad.RangeControl;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShapeControl;
import visad.SingletonSet;
import visad.Stream2D;
import visad.TextControl;
import visad.TupleType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.util.HersheyFont;

public abstract class ShadowType
implements Serializable {
    public static final int NOTHING_MAPPED = 6;
    public static final int SIMPLE_TUPLE = 5;
    public static final int SIMPLE_ANIMATE_FIELD = 4;
    public static final int SIMPLE_FIELD = 3;
    public static final int NESTED = 2;
    public static final int LEGAL = 1;
    public static final String PROP_IMAGE_BY_REF = "visad.java3d.imageByRef";
    public static final boolean byReference = Boolean.parseBoolean(System.getProperty("visad.java3d.imageByRef", "false"));
    public static final boolean yUp = byReference;
    MathType Type;
    transient DataDisplayLink Link;
    transient DisplayImpl display;
    private transient Data data;
    private ShadowType Parent;
    int[] DisplayIndices;
    int[] ValueIndices;
    boolean MultipleSpatialDisplayScalar;
    boolean MultipleDisplayScalar;
    boolean MappedDisplayScalar;
    boolean isTerminal;
    int LevelOfDifficulty;
    boolean isTextureMap;
    boolean curvedTexture;
    boolean isTexture3D;
    boolean isLinearContour3D;
    boolean adjustProjectionSeam;
    int Dtype;
    int Rtype;
    static final int D0 = 0;
    static final int D1 = 1;
    static final int D2 = 2;
    static final int D3 = 3;
    static final int D4 = 4;
    static final int Dbad = 5;
    static final int R0 = 0;
    static final int R1 = 1;
    static final int R2 = 2;
    static final int R3 = 3;
    static final int R4 = 4;
    static final int Rbad = 5;
    DisplayTupleType spatialTuple = null;
    int spatialDimension;
    boolean anyContour;
    boolean anyFlow;
    boolean anyShape;
    boolean anyText;
    boolean streamline1;
    boolean streamline2;
    float streamlineDensity1;
    float streamlineDensity2;
    float arrowScale1;
    float arrowScale2;
    float stepFactor1;
    float stepFactor2;
    float packingFactor1;
    float packingFactor2;
    float cntrWeight1;
    float cntrWeight2;
    int n_pass1;
    int n_pass2;
    float reduction1;
    float reduction2;
    int[] cnt = new int[]{0};
    ProjectionControl p_cntrl = null;
    ContourControl c_cntrl = null;
    float[][] spatial_offset_values = null;
    int[] refToComponent;
    ShadowRealTupleType[] componentWithRef;
    int[] componentIndex;
    public static final float METERS_PER_DEGREE = 111137.0f;
    private static final float BACK_SCALE = -0.15f;
    private static final float PERP_SCALE = 0.15f;
    private static final double FONT_SCALE = 0.07;

    public ShadowType(MathType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        this.Type = type;
        this.Link = link;
        this.display = link.getDisplay();
        this.Parent = parent;
        this.data = link.getData();
        this.DisplayIndices = ShadowType.zeroIndices(this.display.getDisplayScalarCount());
        this.ValueIndices = ShadowType.zeroIndices(this.display.getValueArrayLength());
        this.isTerminal = false;
        this.isTextureMap = false;
        this.curvedTexture = false;
        this.isTexture3D = false;
        this.isLinearContour3D = false;
        this.adjustProjectionSeam = true;
        this.LevelOfDifficulty = 6;
        this.MultipleSpatialDisplayScalar = false;
        this.MultipleDisplayScalar = false;
        this.MappedDisplayScalar = false;
        this.p_cntrl = this.display.getProjectionControl();
    }

    public DataDisplayLink getLink() {
        return this.Link;
    }

    public int getLevelOfDifficulty() {
        return this.LevelOfDifficulty;
    }

    public boolean getIsTerminal() {
        return this.isTerminal;
    }

    public boolean getIsTextureMap() {
        return this.isTextureMap;
    }

    public boolean getCurvedTexture() {
        return this.curvedTexture;
    }

    public boolean getIsTexture3D() {
        return this.isTexture3D;
    }

    public boolean getIsLinearContour3D() {
        return this.isLinearContour3D;
    }

    public int[] getRefToComponent() {
        return this.refToComponent;
    }

    public ShadowRealTupleType[] getComponentWithRef() {
        return this.componentWithRef;
    }

    public int[] getComponentIndex() {
        return this.componentIndex;
    }

    public boolean getAdjustProjectionSeam() {
        return this.adjustProjectionSeam;
    }

    public ShadowRealType[] getComponents(ShadowType type, boolean doRef) throws VisADException {
        ShadowRealType[] reals;
        if (type == null) {
            return null;
        }
        if (doRef) {
            this.refToComponent = null;
            this.componentWithRef = null;
            this.componentIndex = null;
        }
        if (type instanceof ShadowRealType) {
            ShadowRealType[] r = new ShadowRealType[]{(ShadowRealType)type};
            return r;
        }
        if (type instanceof ShadowRealTupleType) {
            ShadowRealTupleType ref;
            int n = ((ShadowRealTupleType)type).getDimension();
            reals = new ShadowRealType[n];
            for (int i = 0; i < n; ++i) {
                reals[i] = (ShadowRealType)((ShadowRealTupleType)type).getComponent(i);
            }
            if (doRef && (ref = ((ShadowRealTupleType)type).getReference()) != null && ref.getMappedDisplayScalar()) {
                this.refToComponent = new int[1];
                this.componentWithRef = new ShadowRealTupleType[1];
                this.componentIndex = new int[1];
                this.refToComponent[0] = 0;
                this.componentWithRef[0] = (ShadowRealTupleType)type;
                this.componentIndex[0] = 0;
            }
        } else if (type instanceof ShadowTupleType) {
            int m = ((ShadowTupleType)type).getDimension();
            int n = 0;
            int nref = 0;
            for (int i = 0; i < m; ++i) {
                ShadowRealTupleType ref;
                ShadowType component = ((ShadowTupleType)type).getComponent(i);
                if (component instanceof ShadowRealType) {
                    ++n;
                    continue;
                }
                if (!(component instanceof ShadowRealTupleType)) continue;
                n += this.getComponents(component, false).length;
                if (!doRef || (ref = ((ShadowRealTupleType)component).getReference()) == null || !ref.getMappedDisplayScalar()) continue;
                ++nref;
            }
            reals = new ShadowRealType[n];
            int j = 0;
            if (nref == 0) {
                doRef = false;
            }
            if (doRef) {
                this.refToComponent = new int[nref];
                this.componentWithRef = new ShadowRealTupleType[nref];
                this.componentIndex = new int[nref];
            }
            int rj = 0;
            for (int i = 0; i < m; ++i) {
                ShadowRealTupleType ref;
                ShadowType component = ((ShadowTupleType)type).getComponent(i);
                if (!(component instanceof ShadowRealType) && !(component instanceof ShadowRealTupleType)) continue;
                if (doRef && component instanceof ShadowRealTupleType && (ref = ((ShadowRealTupleType)component).getReference()) != null && ref.getMappedDisplayScalar()) {
                    this.refToComponent[rj] = j;
                    this.componentWithRef[rj] = (ShadowRealTupleType)component;
                    this.componentIndex[rj] = i;
                    ++rj;
                }
                ShadowRealType[] r = this.getComponents(component, false);
                for (int k = 0; k < r.length; ++k) {
                    reals[j] = r[k];
                    ++j;
                }
            }
        } else {
            reals = null;
        }
        return reals;
    }

    public Data getData() {
        return this.data;
    }

    public ShadowType getAdaptedShadowType() {
        return this;
    }

    static int[] zeroIndices(int length) {
        int[] local_indices = new int[length];
        for (int i = 0; i < length; ++i) {
            local_indices[i] = 0;
        }
        return local_indices;
    }

    static int[] copyIndices(int[] indices) {
        int[] local_indices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            local_indices[i] = indices[i];
        }
        return local_indices;
    }

    static int[] addIndices(int[] indices, int[] indices2) throws VisADException {
        if (indices.length != indices2.length) {
            throw new DisplayException("ShadowType.addIndices: lengths don't match");
        }
        int[] local_indices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            local_indices[i] = indices[i] + indices2[i];
        }
        return local_indices;
    }

    public boolean getAnyContour() {
        return this.anyContour;
    }

    public boolean getAnyFlow() {
        return this.anyFlow;
    }

    public boolean getAnyShape() {
        return this.anyShape;
    }

    public boolean getAnyText() {
        return this.anyText;
    }

    boolean checkNested(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.Animation) || real.equals(Display.SelectValue) || real.equals(Display.SelectRange) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text)) continue;
            return false;
        }
        return true;
    }

    boolean checkR4(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.SelectRange) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.IsoContour)) continue;
            return false;
        }
        return true;
    }

    boolean checkR3(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.SelectRange) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.IsoContour)) continue;
            return false;
        }
        return true;
    }

    boolean checkR1D3(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkColorRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkColorAlphaRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkContourColorAlphaRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            if (display_indices[i] == 0) continue;
            DisplayRealType real = this.display.getDisplayScalar(i);
            DisplayTupleType tuple = real.getTuple();
            if (real.equals(Display.IsoContour) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkR2D2(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkSpatialOffsetColorAlphaRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkSpatialColorAlphaRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    boolean checkSpatialRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || real.equals(Display.SelectRange)) continue;
            return false;
        }
        return true;
    }

    int checkAnimationOrValue(int[] display_indices) throws RemoteException {
        int count = 0;
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            if (display_indices[i] == 0 || !(real = this.display.getDisplayScalar(i)).equals(Display.Animation) && !real.equals(Display.SelectValue)) continue;
            ++count;
        }
        return count;
    }

    boolean anyRange(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            if (display_indices[i] == 0 || !(real = this.display.getDisplayScalar(i)).equals(Display.SelectRange)) continue;
            return true;
        }
        return false;
    }

    boolean checkContour(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            if (display_indices[i] == 0 || !(real = this.display.getDisplayScalar(i)).equals(Display.IsoContour)) continue;
            return true;
        }
        return false;
    }

    boolean checkFlow(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            if (display_indices[i] == 0) continue;
            DisplayRealType real = this.display.getDisplayScalar(i);
            DisplayTupleType tuple = real.getTuple();
            if (tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple))) {
                return true;
            }
            if (tuple == null || !tuple.equals(Display.DisplayFlow2Tuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple))) continue;
            return true;
        }
        return false;
    }

    boolean checkShape(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            if (display_indices[i] == 0 || !(real = this.display.getDisplayScalar(i)).equals(Display.Shape)) continue;
            return true;
        }
        return false;
    }

    boolean checkText(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            if (display_indices[i] == 0 || !(real = this.display.getDisplayScalar(i)).equals(Display.Text)) continue;
            return true;
        }
        return false;
    }

    boolean checkAdjustProjectionSeam() throws RemoteException {
        float[] default_values = this.getLink().getDefaultValues();
        return default_values[this.display.getDisplayScalarIndex(Display.AdjustProjectionSeam)] > 0.5f;
    }

    boolean checkColor(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY)) continue;
            return false;
        }
        return true;
    }

    boolean checkColorOrAlpha(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha)) continue;
            return false;
        }
        return true;
    }

    boolean checkAny(int[] display_indices) throws RemoteException {
        for (int i = 0; i < display_indices.length; ++i) {
            if (display_indices[i] <= 0) continue;
            return true;
        }
        return false;
    }

    int testIndices(int[] indices, int[] display_indices, int levelOfDifficulty) throws VisADException, RemoteException {
        DisplayRealType real;
        int i;
        for (i = 0; i < indices.length; ++i) {
            if (indices[i] <= 1) continue;
            ScalarType real2 = this.display.getScalar(i);
            throw new BadMappingException("RealType " + real2.getName() + " occurs more than once: " + "ShadowType.testIndices");
        }
        for (i = 0; i < display_indices.length; ++i) {
            real = this.display.getDisplayScalar(i);
            if (display_indices[i] > 0) {
                this.isTerminal = true;
            }
            if (display_indices[i] <= 1 || !real.isSingle()) continue;
            throw new BadMappingException("Single DisplayRealType " + real.getName() + " occurs more than once: " + "ShadowType.testIndices");
        }
        this.spatialTuple = null;
        this.spatialDimension = 0;
        for (i = 0; i < display_indices.length; ++i) {
            DisplayTupleType rtuple;
            if (display_indices[i] <= 0 || (rtuple = (real = this.display.getDisplayScalar(i)).getTuple()) == null || !rtuple.equals(Display.DisplaySpatialCartesianTuple) && (rtuple.getCoordinateSystem() == null || !rtuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            if (this.spatialTuple != null && !this.spatialTuple.equals(rtuple)) {
                throw new BadMappingException("DisplayRealType-s occur from multiple spatial DisplayTupleType-s: ShadowType.testIndices");
            }
            this.spatialTuple = rtuple;
            ++this.spatialDimension;
        }
        this.LevelOfDifficulty = this.isTerminal ? (levelOfDifficulty == 1 ? 1 : 2) : 6;
        return this.LevelOfDifficulty;
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        this.adjustProjectionSeam = this.checkAdjustProjectionSeam();
        this.LevelOfDifficulty = this.testIndices(indices, display_indices, levelOfDifficulty);
        return this.LevelOfDifficulty;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public MathType getType() {
        return this.Type;
    }

    public boolean getMultipleDisplayScalar() {
        return this.MultipleDisplayScalar;
    }

    public boolean getMultipleSpatialDisplayScalar() {
        return this.MultipleSpatialDisplayScalar;
    }

    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public int[] getDisplayIndices() {
        int[] ii = new int[this.DisplayIndices.length];
        for (int i = 0; i < this.DisplayIndices.length; ++i) {
            ii[i] = this.DisplayIndices[i];
        }
        return ii;
    }

    public int[] getValueIndices() {
        int[] ii = new int[this.ValueIndices.length];
        for (int i = 0; i < this.ValueIndices.length; ++i) {
            ii[i] = this.ValueIndices[i];
        }
        return ii;
    }

    boolean testTransform() {
        int count = 0;
        for (int i = 0; i < this.DisplayIndices.length; ++i) {
            DisplayRealType real;
            if (this.DisplayIndices[i] == 0 || !(real = this.display.getDisplayScalar(i)).equals(Display.Animation) && !real.equals(Display.SelectValue) && !real.equals(Display.SelectRange) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    void markTransform(boolean[] isTransform) {
    }

    public static void mapValues(float[][] display_values, double[][] values, ShadowRealType[] reals) throws VisADException {
        int n = values.length;
        if (n != reals.length) {
            throw new DisplayException("lengths don't match " + n + " != " + reals.length + ": " + "ShadowType.mapValues");
        }
        for (int i = 0; i < n; ++i) {
            Enumeration maps = reals[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                int value_index = map.getValueIndex();
                display_values[value_index] = map.scaleValues(values[i]);
            }
        }
    }

    public static void mapValues(float[][] display_values, float[][] values, ShadowRealType[] reals) throws VisADException {
        ShadowType.mapValues(display_values, values, reals, true);
    }

    public static void mapValues(float[][] display_values, float[][] values, ShadowRealType[] reals, boolean copy) throws VisADException {
        int n = values.length;
        if (n != reals.length) {
            throw new DisplayException("lengths don't match: ShadowType.mapValues");
        }
        for (int i = 0; i < n; ++i) {
            boolean doCopy = copy;
            int size = reals[i].getSelectedMapVector().size();
            if (!copy && size > 1) {
                doCopy = true;
            }
            Enumeration maps = reals[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                int value_index = map.getValueIndex();
                display_values[value_index] = map.scaleValues(values[i], doCopy);
            }
        }
    }

    public static VisADGeometryArray makePointGeometry(float[][] spatial_values, byte[][] color_values) throws VisADException {
        return ShadowType.makePointGeometry(spatial_values, color_values, false);
    }

    public static VisADGeometryArray makePointGeometry(float[][] spatial_values, byte[][] color_values, boolean compress) throws VisADException {
        if (spatial_values == null) {
            throw new DisplayException("bad spatial_values: ShadowType.makePointGeometry: bad");
        }
        VisADPointArray array = new VisADPointArray();
        if (compress) {
            int len = spatial_values.length;
            int clen = color_values == null ? 0 : color_values.length;
            float[] f = spatial_values[0];
            int flen = f.length;
            int nan = 0;
            for (int i = 0; i < flen; ++i) {
                if (f[i] == f[i]) continue;
                ++nan;
            }
            if (nan > 0) {
                float[][] new_s_values = new float[len][flen - nan];
                byte[][] new_c_values = color_values;
                if (clen > 0) {
                    new_c_values = new byte[clen][flen - nan];
                }
                int c = 0;
                for (int i = 0; i < flen; ++i) {
                    int j;
                    if (f[i] != f[i]) continue;
                    for (j = 0; j < len; ++j) {
                        new_s_values[j][c] = spatial_values[j][i];
                    }
                    for (j = 0; j < clen; ++j) {
                        new_c_values[j][c] = color_values[j][i];
                    }
                    ++c;
                }
                spatial_values = new_s_values;
                color_values = new_c_values;
            }
        }
        SampledSet.setGeometryArray(array, spatial_values, 4, color_values);
        return array;
    }

    public VisADGeometryArray[] assembleShape(float[][] display_values, int valueArrayLength, int[] valueToMap, Vector MapVector, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, int index, ShadowType shadow_api) throws VisADException, RemoteException {
        if (spatial_values[0] == null) {
            return null;
        }
        int total_length = 0;
        Vector<VisADGeometryArray[]> array_vector = new Vector<VisADGeometryArray[]>();
        float x = spatial_values[0][0];
        float y = spatial_values[1][0];
        float z = spatial_values[2][0];
        byte r = 0;
        byte g = 0;
        byte b = 0;
        byte a = 0;
        int color_length = 0;
        if (color_values != null) {
            color_length = color_values.length;
            r = color_values[0][0];
            g = color_values[1][0];
            b = color_values[2][0];
            if (color_length > 3) {
                a = color_values[3][0];
            }
        }
        float[] scales = null;
        for (int i = 0; i < valueArrayLength; ++i) {
            int displayScalarIndex;
            DisplayRealType real;
            if (display_values[i] == null || !(real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i])).equals(Display.ShapeScale)) continue;
            if (index < 0) {
                scales = display_values[i];
                display_values[i] = null;
                continue;
            }
            scales = display_values[i].length == 1 ? new float[]{display_values[i][0]} : new float[]{display_values[i][index]};
        }
        if (scales == null) {
            int default_index = display.getDisplayScalarIndex(Display.ShapeScale);
            float default_scale = default_values[default_index];
            scales = new float[]{default_scale};
        }
        float[] values = null;
        ShapeControl control = null;
        for (int j = 0; j < valueArrayLength; ++j) {
            int displayScalarIndex;
            DisplayRealType real;
            if (display_values[j] == null || !(real = display.getDisplayScalar(displayScalarIndex = valueToScalar[j])).equals(Display.Shape)) continue;
            if (index < 0) {
                values = display_values[j];
                display_values[j] = null;
            } else {
                values = display_values[j].length == 1 ? new float[]{display_values[j][0]} : new float[]{display_values[j][index]};
            }
            control = (ShapeControl)((ScalarMap)MapVector.elementAt(valueToMap[j])).getControl();
            if (values == null || control == null) continue;
            int len = values.length;
            if (color_values != null && color_values[0].length > len) {
                len = color_values[0].length;
            }
            if (spatial_values[0].length > len) {
                len = spatial_values[0].length;
            }
            if (scales.length > len) {
                len = scales.length;
            }
            if (values.length < len) {
                float[] new_values = new float[len];
                for (int i = 0; i < len; ++i) {
                    new_values[i] = values[0];
                }
                values = new_values;
            }
            float cscale = control.getScale();
            VisADGeometryArray[] arrays = control.getShapes(values);
            for (int i = 0; i < arrays.length; ++i) {
                int k;
                VisADGeometryArray array;
                if (range_select[0] != null) {
                    if (range_select[0].length == 1) {
                        if (!range_select[0][0]) {
                            arrays[i] = null;
                        }
                    } else if (!range_select[0][i]) {
                        arrays[i] = null;
                    }
                }
                if ((array = arrays[i]) == null) continue;
                if (spatial_values[0].length > 1) {
                    x = spatial_values[0][i];
                    y = spatial_values[1][i];
                    z = spatial_values[2][i];
                }
                int npts = array.coordinates.length / 3;
                float scale = scales.length == 1 ? scales[0] : scales[i];
                scale *= cscale;
                for (k = 0; k < array.coordinates.length; k += 3) {
                    array.coordinates[k] = x + scale * array.coordinates[k];
                    array.coordinates[k + 1] = y + scale * array.coordinates[k + 1];
                    array.coordinates[k + 2] = z + scale * array.coordinates[k + 2];
                }
                if (array.colors != null || color_values == null) continue;
                array.colors = new byte[color_length * npts];
                if (color_values[0].length > 1) {
                    r = color_values[0][i];
                    g = color_values[1][i];
                    b = color_values[2][i];
                    if (color_length > 3) {
                        a = color_values[3][i];
                    }
                }
                for (k = 0; k < array.colors.length; k += color_length) {
                    array.colors[k] = r;
                    array.colors[k + 1] = g;
                    array.colors[k + 2] = b;
                    if (color_length <= 3) continue;
                    array.colors[k + 3] = a;
                }
            }
            total_length += arrays.length;
            array_vector.addElement(arrays);
        }
        if (total_length == 0) {
            return null;
        }
        VisADGeometryArray[] total_arrays = new VisADGeometryArray[total_length];
        Enumeration arrayses = array_vector.elements();
        int k = 0;
        while (arrayses.hasMoreElements()) {
            VisADGeometryArray[] arrays = (VisADGeometryArray[])arrayses.nextElement();
            System.arraycopy(arrays, 0, total_arrays, k, arrays.length);
            k += arrays.length;
        }
        DataRenderer renderer = this.getLink().getRenderer();
        if (this.getAdjustProjectionSeam()) {
            for (int i = 0; i < total_length; ++i) {
                if (total_arrays[i] == null) continue;
                total_arrays[i] = total_arrays[i].adjustLongitudeBulk(renderer);
            }
        }
        return total_arrays;
    }

    public Set assembleSpatial(float[][] spatial_values, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, Set domain_set, boolean allSpatial, boolean set_for_shape, int[] spatialDimensions, boolean[][] range_select, float[][] flow1_values, float[][] flow2_values, float[] flowScale, boolean[] swap, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        int i;
        int k;
        DisplayTupleType spatial_tuple = null;
        int len = 1;
        int spatialDimension = 0;
        int[] tuple_indices = new int[3];
        spatialDimensions[0] = 0;
        spatialDimensions[1] = 0;
        float[][] offset_values = new float[3][];
        boolean[] offset_copy = new boolean[]{false, false, false};
        Unit[] spatial_units = new Unit[]{null, null, null};
        double[] ranges = new double[]{Double.NaN, Double.NaN, Double.NaN};
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        for (int i2 = 0; i2 < valueArrayLength; ++i2) {
            int displayScalarIndex;
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_values[i2] == null || (tuple = (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i2])).getTuple()) == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            if (spatial_tuple != null && !spatial_tuple.equals(tuple)) {
                throw new DisplayException("multiple spatial display tuples: ShadowType.assembleSpatial");
            }
            spatial_tuple = tuple;
            int tuple_index = real.getTupleIndex();
            spatial_value_indices[tuple_index] = i2;
            spatial_values[tuple_index] = display_values[i2];
            len = Math.max(len, display_values[i2].length);
            display_values[i2] = null;
            spatialDimensions[0] = spatialDimensions[0] + 1;
            if (inherited_values[i2] == 0) {
                tuple_indices[spatialDimension] = tuple_index;
                ++spatialDimension;
            }
            ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i2]);
            double[] map_range = map.getRange();
            ranges[tuple_index] = map_range[1] - map_range[0];
            spatial_units[tuple_index] = ((RealType)map.getScalar()).getDefaultUnit();
        }
        if (spatial_tuple == null) {
            spatial_tuple = Display.DisplaySpatialCartesianTuple;
        }
        if (spatialDimension == 0) {
            spatialDimensions[1] = 0;
        } else if (domain_set == null) {
            spatialDimensions[1] = spatialDimension;
        } else if (!allSpatial) {
            spatialDimensions[1] = spatialDimension;
            if (set_for_shape) {
                RealType[] reals = new RealType[spatialDimension];
                float[][] samples = new float[spatialDimension][];
                for (int i3 = 0; i3 < spatialDimension; ++i3) {
                    reals[i3] = RealType.Generic;
                    samples[i3] = spatial_values[tuple_indices[i3]];
                }
                RealTupleType tuple_type = new RealTupleType(reals);
                try {
                    switch (spatialDimension) {
                        case 1: {
                            domain_set = new Irregular1DSet((MathType)tuple_type, (float[][])samples, null, null, null, false);
                            break;
                        }
                        case 2: {
                            domain_set = new Irregular2DSet((MathType)tuple_type, (float[][])samples, null, null, null, null, false);
                            break;
                        }
                        case 3: {
                            domain_set = new Irregular3DSet((MathType)tuple_type, (float[][])samples, null, null, null, null, false);
                        }
                    }
                }
                catch (VisADException e) {
                    domain_set = null;
                }
            } else {
                domain_set = null;
            }
        } else {
            spatialDimensions[1] = domain_set.getManifoldDimension();
        }
        boolean set_needed = domain_set != null && (set_for_shape || spatialDimensions[1] < 3);
        boolean[] missing_checked = new boolean[]{false, false, false};
        for (int i4 = 0; i4 < 3; ++i4) {
            if (spatial_values[i4] == null) {
                spatial_values[i4] = new float[len];
                int default_index = display.getDisplayScalarIndex((DisplayRealType)spatial_tuple.getComponent(i4));
                float default_value = default_values[default_index];
                for (int j = 0; j < len; ++j) {
                    spatial_values[i4][j] = default_value;
                }
                missing_checked[i4] = true;
                continue;
            }
            if (spatial_values[i4].length != 1) continue;
            float v = spatial_values[i4][0];
            missing_checked[i4] = true;
            if (v != v || Float.isInfinite(v)) {
                range_select[0] = new boolean[1];
                range_select[0][0] = false;
                return null;
            }
            if (len <= 1) continue;
            spatial_values[i4] = new float[len];
            for (int j = 0; j < len; ++j) {
                spatial_values[i4][j] = v;
            }
        }
        boolean anyFlow = false;
        int[] flen = new int[]{0, 0};
        float[][][] ff_values = new float[][][]{flow1_values, flow2_values};
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int i5 = 0; i5 < 3; ++i5) {
                if (ff_values[k2][i5] == null) continue;
                anyFlow = true;
                flen[k2] = Math.max(flen[k2], ff_values[k2][i5].length);
            }
        }
        len = Math.max(len, Math.max(flen[0], flen[1]));
        ShadowType.fillOut(spatial_values, len);
        if (flen[0] > 0) {
            ShadowType.fillOut(flow1_values, len);
        }
        if (flen[1] > 0) {
            ShadowType.fillOut(flow2_values, len);
        }
        boolean spatial_flow = anyFlow;
        block16: for (int i6 = 0; i6 < 3; ++i6) {
            if (ranges[i6] != ranges[i6]) continue;
            if (spatial_units[i6] == null) {
                spatial_flow = false;
                break;
            }
            for (int j = 0; j < 3; ++j) {
                if (ranges[j] != ranges[j]) continue;
                if (spatial_units[j] == null) {
                    spatial_flow = false;
                    continue block16;
                }
                if (Unit.canConvert(spatial_units[i6], spatial_units[j])) continue;
                spatial_flow = false;
                continue block16;
            }
        }
        if (spatial_flow) {
            int i7;
            double max_range = -1.0;
            for (i7 = 0; i7 < 3; ++i7) {
                double ar;
                if (ranges[i7] != ranges[i7] || !((ar = Math.abs(ranges[i7])) > max_range)) continue;
                max_range = ar;
            }
            for (i7 = 0; i7 < 3; ++i7) {
                ranges[i7] = ranges[i7] == ranges[i7] ? ranges[i7] / max_range : 1.0;
            }
            for (k = 0; k < 2; ++k) {
                if (renderer.getRealVectorTypes(k) instanceof EarthVectorType || ff_values[k][0] == null && ff_values[k][1] == null && ff_values[k][2] == null) continue;
                for (int j = 0; j < len; ++j) {
                    float old_speed = 0.0f;
                    float new_speed = 0.0f;
                    for (int i8 = 0; i8 < 3; ++i8) {
                        if (ff_values[k][i8] == null) continue;
                        old_speed += ff_values[k][i8][j] * ff_values[k][i8][j];
                        float[] fArray = ff_values[k][i8];
                        int n = j;
                        fArray[n] = (float)((double)fArray[n] * ranges[i8]);
                        new_speed += ff_values[k][i8][j] * ff_values[k][i8][j];
                    }
                    float ratio = (float)Math.sqrt(old_speed / new_speed);
                    if (Float.isNaN(ratio)) {
                        ratio = 0.0f;
                    }
                    for (int i9 = 0; i9 < 3; ++i9) {
                        if (ff_values[k][i9] == null) continue;
                        float[] fArray = ff_values[k][i9];
                        int n = j;
                        fArray[n] = fArray[n] * ratio;
                    }
                }
            }
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, ranges);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            float[][][] vector_ends = new float[2][][];
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, ranges);
            if (spatial_flow && anyFlow) {
                for (k = 0; k < 2; ++k) {
                    if (renderer.getRealVectorTypes(k) instanceof EarthVectorType || flen[k] <= 0) continue;
                    vector_ends[k] = new float[3][len];
                    for (int i10 = 0; i10 < 3; ++i10) {
                        int j;
                        if (ff_values[k][i10] != null) {
                            for (j = 0; j < len; ++j) {
                                vector_ends[k][i10][j] = spatial_values[i10][j] + flowScale[k] * ff_values[k][i10][j];
                            }
                            continue;
                        }
                        for (j = 0; j < len; ++j) {
                            vector_ends[k][i10][j] = spatial_values[i10][j];
                        }
                    }
                    vector_ends[k] = coord.toReference(vector_ends[k]);
                }
            }
            float[][] new_spatial_values = coord.toReference(spatial_values);
            for (int i11 = 0; i11 < 3; ++i11) {
                spatial_values[i11] = new_spatial_values[i11];
            }
            if (spatial_flow && anyFlow) {
                for (int k3 = 0; k3 < 2; ++k3) {
                    if (renderer.getRealVectorTypes(k3) instanceof EarthVectorType || flen[k3] <= 0) continue;
                    for (int i12 = 0; i12 < 3; ++i12) {
                        for (int j = 0; j < len; ++j) {
                            vector_ends[k3][i12][j] = (vector_ends[k3][i12][j] - spatial_values[i12][j]) / flowScale[k3];
                        }
                        ff_values[k3][i12] = vector_ends[k3][i12];
                    }
                }
            }
            missing_checked = new boolean[]{false, false, false};
        }
        swap[0] = false;
        if (allSpatial && spatialDimensions[1] == 2 && len > 1) {
            float simax = 0.0f;
            float max = -1.0f;
            int imax = -1;
            for (int i13 = 0; i13 < 3; ++i13) {
                float sdiff = spatial_values[i13][1] - spatial_values[i13][0];
                float diff = Math.abs(sdiff);
                if (!(diff > max)) continue;
                simax = sdiff;
                max = diff;
                imax = i13;
            }
            int ll = len - 1;
            if (domain_set != null && domain_set instanceof Gridded2DSet && (ll = ((Gridded2DSet)domain_set).getLength(0)) > len - 1) {
                ll = len - 1;
            }
            float sjmax = 0.0f;
            max = -1.0f;
            int jmax = -1;
            for (int i14 = 0; i14 < 3; ++i14) {
                float sdiff;
                float diff;
                if (i14 == imax || !((diff = Math.abs(sdiff = spatial_values[i14][ll] - spatial_values[i14][0])) > max)) continue;
                sjmax = sdiff;
                max = diff;
                jmax = i14;
            }
            if (imax == 0) {
                swap[0] = true;
                swap[1] = simax < 0.0f;
                swap[2] = sjmax < 0.0f;
            } else if (imax == 1) {
                swap[2] = sjmax < 0.0f;
                swap[1] = simax < 0.0f;
            } else if (jmax == 1) {
                swap[0] = true;
                swap[1] = simax < 0.0f;
                swap[2] = sjmax < 0.0f;
            } else {
                swap[2] = sjmax < 0.0f;
                swap[1] = simax < 0.0f;
            }
        }
        int offset_len = len;
        for (int i15 = 0; i15 < valueArrayLength; ++i15) {
            int displayScalarIndex;
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_values[i15] == null || !Display.DisplaySpatialOffsetTuple.equals(tuple = (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i15])).getTuple())) continue;
            int tuple_index = real.getTupleIndex();
            if (offset_values[tuple_index] == null) {
                offset_values[tuple_index] = display_values[i15];
            } else {
                int j;
                float[] off;
                int leno = offset_values[tuple_index].length;
                int lend = display_values[i15].length;
                if (leno > lend) {
                    if (offset_copy[tuple_index]) {
                        off = offset_values[tuple_index];
                    } else {
                        off = new float[leno];
                        offset_copy[tuple_index] = true;
                    }
                    for (j = 0; j < leno; ++j) {
                        off[j] = offset_values[tuple_index][j] + display_values[i15][0];
                    }
                    offset_values[tuple_index] = off;
                    off = null;
                } else if (leno < lend) {
                    off = new float[lend];
                    for (j = 0; j < lend; ++j) {
                        off[j] = offset_values[tuple_index][0] + display_values[i15][j];
                    }
                    offset_values[tuple_index] = off;
                    off = null;
                    offset_copy[tuple_index] = true;
                } else {
                    if (offset_copy[tuple_index]) {
                        off = offset_values[tuple_index];
                    } else {
                        off = new float[leno];
                        offset_copy[tuple_index] = true;
                    }
                    for (j = 0; j < leno; ++j) {
                        off[j] = offset_values[tuple_index][j] + display_values[i15][j];
                    }
                    offset_values[tuple_index] = off;
                    off = null;
                }
            }
            display_values[i15] = null;
            offset_len = Math.max(offset_len, offset_values[tuple_index].length);
        }
        boolean[] offset_missing_checked = new boolean[]{false, false, false};
        for (i = 0; i < 3; ++i) {
            if (offset_values[i] == null) {
                float default_value;
                DisplayRealType offset = (DisplayRealType)Display.DisplaySpatialOffsetTuple.getComponent(i);
                int default_index = display.getDisplayScalarIndex(offset);
                if (0 <= default_index && default_index < default_values.length && (default_value = default_values[default_index]) == default_value) {
                    offset_values[i] = new float[]{default_value};
                }
                offset_missing_checked[i] = true;
                continue;
            }
            if (offset_values[i].length != 1) continue;
            offset_missing_checked[i] = true;
            if (offset_values[i][0] == offset_values[i][0] && !Float.isInfinite(offset_values[i][0])) continue;
            range_select[0] = new boolean[1];
            range_select[0][0] = false;
            return null;
        }
        if (offset_len > len) {
            for (i = 0; i < 3; ++i) {
                float[] s = new float[offset_len];
                for (int k4 = 0; k4 < offset_len; ++k4) {
                    s[k4] = spatial_values[i][0];
                }
                spatial_values[i] = s;
                s = null;
            }
            len = offset_len;
        }
        for (i = 0; i < 3; ++i) {
            if (offset_values[i] != null) {
                int k5;
                int leno = offset_values[i].length;
                if (leno < len) {
                    k5 = 0;
                    while (k5 < offset_len) {
                        float[] fArray = spatial_values[i];
                        int n = k5++;
                        fArray[n] = fArray[n] + offset_values[i][0];
                    }
                } else {
                    for (k5 = 0; k5 < offset_len; ++k5) {
                        float[] fArray = spatial_values[i];
                        int n = k5;
                        fArray[n] = fArray[n] + offset_values[i][k5];
                    }
                }
                offset_values[i] = null;
                boolean bl = missing_checked[i] = missing_checked[i] && offset_missing_checked[i];
            }
            if (missing_checked[i]) continue;
            for (int j = 0; j < len; ++j) {
                if (spatial_values[i][j] == spatial_values[i][j] && !Float.isInfinite(spatial_values[i][j])) continue;
                if (range_select[0] == null) {
                    range_select[0] = new boolean[len];
                    for (int k6 = 0; k6 < len; ++k6) {
                        range_select[0][k6] = true;
                    }
                } else if (range_select[0].length < len) {
                    boolean[] r = new boolean[len];
                    for (int k7 = 0; k7 < len; ++k7) {
                        r[k7] = range_select[0][0];
                    }
                    range_select[0] = r;
                }
                range_select[0][j] = false;
                spatial_values[i][j] = Float.NaN;
            }
        }
        this.spatial_offset_values = offset_values;
        if (set_needed) {
            try {
                if (spatialDimension == 0) {
                    double[] values = new double[3];
                    for (int i16 = 0; i16 < 3; ++i16) {
                        values[i16] = spatial_values[i16][0];
                    }
                    RealTuple tuple = new RealTuple(Display.DisplaySpatialCartesianTuple, values);
                    return new SingletonSet(tuple);
                }
                SetType type = new SetType(Display.DisplaySpatialCartesianTuple);
                return shadow_api.makeSpatialSet(domain_set, type, spatial_values);
            }
            catch (VisADException e) {
                return null;
            }
        }
        return null;
    }

    public Set makeSpatialSet(Set domain_set, SetType type, float[][] spatial_values) throws VisADException {
        return domain_set.makeSpatial(type, spatial_values);
    }

    private static void fillOut(float[][] values, int flen) {
        for (int i = 0; i < values.length; ++i) {
            int len;
            if (values[i] == null || (len = values[i].length) >= flen) continue;
            float[] s = new float[flen];
            float v = values[i][0];
            for (int k = 0; k < flen; ++k) {
                s[k] = v;
            }
            values[i] = s;
        }
    }

    public void assembleFlow(float[][] flow1_values, float[][] flow2_values, float[] flowScale, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        int[] flen = new int[]{0, 0};
        float[][][] ff_values = new float[][][]{flow1_values, flow2_values};
        DisplayTupleType[] flow_tuple = new DisplayTupleType[]{Display.DisplayFlow1Tuple, Display.DisplayFlow2Tuple};
        DisplayTupleType[] actual_tuple = new DisplayTupleType[]{null, null};
        boolean anyFlow = false;
        for (int i = 0; i < valueArrayLength; ++i) {
            if (display_values[i] == null) continue;
            int displayScalarIndex = valueToScalar[i];
            DisplayRealType real = display.getDisplayScalar(displayScalarIndex);
            DisplayTupleType tuple = real.getTuple();
            for (int k = 0; k < 2; ++k) {
                float[] pp;
                if (tuple == null || !tuple.equals(flow_tuple[k]) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(flow_tuple[k]))) continue;
                if (actual_tuple[k] != null && !actual_tuple[k].equals(tuple)) {
                    throw new DisplayException("multiple flow " + k + " display tuples: " + "ShadowType.assembleFlow");
                }
                actual_tuple[k] = tuple;
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                FlowControl control = (FlowControl)map.getControl();
                flowScale[k] = control.getFlowScale();
                int flow_index = real.getTupleIndex();
                ff_values[k][flow_index] = display_values[i];
                flen[k] = Math.max(flen[k], display_values[i].length);
                display_values[i] = null;
                anyFlow = true;
                if (k == 0) {
                    this.streamline1 = control.streamlinesEnabled();
                    this.streamlineDensity1 = control.getStreamlineDensity();
                    this.arrowScale1 = control.getArrowScale();
                    this.stepFactor1 = control.getStepFactor();
                    this.packingFactor1 = control.getStreamlinePacking();
                    pp = control.getStreamlineSmoothing();
                    this.cntrWeight1 = pp[0];
                    this.n_pass1 = (int)pp[1];
                    this.reduction1 = control.getStreamlineReduction();
                }
                if (k != 1) continue;
                this.streamline2 = control.streamlinesEnabled();
                this.streamlineDensity2 = control.getStreamlineDensity();
                this.arrowScale2 = control.getArrowScale();
                this.stepFactor2 = control.getStepFactor();
                this.packingFactor2 = control.getStreamlinePacking();
                pp = control.getStreamlineSmoothing();
                this.cntrWeight2 = pp[0];
                this.n_pass2 = (int)pp[1];
                this.reduction2 = control.getStreamlineReduction();
            }
        }
        for (int k = 0; k < 2; ++k) {
            boolean[] missing_checked = new boolean[]{false, false, false};
            if (flen[k] > 0) {
                for (int i = 0; i < 3; ++i) {
                    if (ff_values[k][i] == null) {
                        ff_values[k][i] = new float[flen[k]];
                        int default_index = display.getDisplayScalarIndex((DisplayRealType)flow_tuple[k].getComponent(i));
                        float default_value = default_values[default_index];
                        for (int j = 0; j < flen[k]; ++j) {
                            ff_values[k][i][j] = default_value;
                        }
                        missing_checked[i] = true;
                        continue;
                    }
                    if (ff_values[k][i].length != 1) continue;
                    float v = ff_values[k][i][0];
                    missing_checked[i] = true;
                    if (v != v) {
                        range_select[0] = new boolean[1];
                        range_select[0][0] = false;
                        return;
                    }
                    if (flen[k] <= 1) continue;
                    ff_values[k][i] = new float[flen[k]];
                    for (int j = 0; j < flen[k]; ++j) {
                        ff_values[k][i][j] = v;
                    }
                }
            }
            if (actual_tuple[k] != null && !actual_tuple[k].equals(flow_tuple[k])) {
                missing_checked = new boolean[]{false, false, false};
                CoordinateSystem coord = actual_tuple[k].getCoordinateSystem();
                float[][] new_ff_values = coord.toReference(ff_values[k]);
                for (int i = 0; i < 3; ++i) {
                    ff_values[k][i] = new_ff_values[i];
                }
            }
            if (flen[k] <= 0) continue;
            for (int i = 0; i < 3; ++i) {
                if (missing_checked[i]) continue;
                for (int j = 0; j < flen[k]; ++j) {
                    if (ff_values[k][i][j] == ff_values[k][i][j]) continue;
                    if (range_select[0] == null) {
                        range_select[0] = new boolean[flen[k]];
                        for (int m = 0; m < flen[k]; ++m) {
                            range_select[0][m] = true;
                        }
                    } else if (range_select[0].length < flen[k]) {
                        boolean[] r = new boolean[flen[k]];
                        for (int m = 0; m < flen[k]; ++m) {
                            r[m] = range_select[0][0];
                        }
                        range_select[0] = r;
                    }
                    range_select[0][j] = false;
                    ff_values[k][i][j] = 0.0f;
                }
            }
        }
    }

    public static float[][] adjustFlowToEarth(int which, float[][] flow_values, float[][] spatial_values, float flowScale, DataRenderer renderer) throws VisADException {
        int j;
        float factor_lat;
        float[][] base_spatial_locs;
        float[][] earth_locs;
        if (!(renderer.getRealVectorTypes(which) instanceof EarthVectorType)) {
            return flow_values;
        }
        FlowControl fcontrol = null;
        DisplayImpl display = null;
        boolean shouldAdjust = true;
        DataDisplayLink link = renderer.getLinks()[0];
        if (link != null && (display = link.getDisplay()) != null) {
            if (which == 0) {
                fcontrol = (FlowControl)display.getControl(Flow1Control.class);
            } else if (which == 1) {
                fcontrol = (FlowControl)display.getControl(Flow2Control.class);
            }
            if (fcontrol == null) {
                throw new VisADException("adjustFlowToEarth: Unable to get FlowControl");
            }
            shouldAdjust = fcontrol.getAdjustFlowToEarth();
        }
        if (!shouldAdjust) {
            return flow_values;
        }
        int flen = flow_values[0].length;
        float scale = 0.0f;
        for (int j2 = 0; j2 < flen; ++j2) {
            if (Math.abs(flow_values[0][j2]) > scale) {
                scale = Math.abs(flow_values[0][j2]);
            }
            if (Math.abs(flow_values[1][j2]) > scale) {
                scale = Math.abs(flow_values[1][j2]);
            }
            if (!(Math.abs(flow_values[2][j2]) > scale)) continue;
            scale = Math.abs(flow_values[2][j2]);
        }
        float inv_scale = 1.0f / scale;
        if (inv_scale != inv_scale) {
            inv_scale = 1.0f;
        }
        if ((earth_locs = renderer.spatialToEarth(spatial_values, base_spatial_locs = new float[3][])) == null) {
            return flow_values;
        }
        int elen = earth_locs.length;
        boolean other_meters = false;
        Unit[] earth_units = renderer.getEarthUnits();
        if (earth_units != null) {
            if (Unit.canConvert(earth_units[0], CommonUnit.radian)) {
                earth_locs[0] = CommonUnit.radian.toThis(earth_locs[0], earth_units[0]);
            }
            if (Unit.canConvert(earth_units[1], CommonUnit.radian)) {
                earth_locs[1] = CommonUnit.radian.toThis(earth_locs[1], earth_units[1]);
            }
            if (elen == 3 && earth_units.length == 3 && Unit.canConvert(earth_units[2], CommonUnit.meter)) {
                other_meters = true;
                earth_locs[2] = CommonUnit.meter.toThis(earth_locs[2], earth_units[2]);
            }
        }
        if (elen == 3) {
            factor_lat = (float)((double)(inv_scale * 1000.0f) * (Math.PI / 180) / 111137.0);
            float factor_vert = inv_scale * 1000.0f;
            for (j = 0; j < flen; ++j) {
                float[] fArray = earth_locs[2];
                int n = j;
                fArray[n] = fArray[n] + factor_vert * flow_values[2][j];
                float[] fArray2 = earth_locs[1];
                int n2 = j;
                fArray2[n2] = fArray2[n2] + factor_lat * flow_values[0][j] / (float)Math.cos(earth_locs[0][j]);
                float[] fArray3 = earth_locs[0];
                int n3 = j;
                fArray3[n3] = fArray3[n3] + factor_lat * flow_values[1][j];
            }
        } else {
            factor_lat = 1.0E-5f * inv_scale * (0.5f * renderer.getLatLonRange());
            for (int j3 = 0; j3 < flen; ++j3) {
                float[] fArray = earth_locs[1];
                int n = j3;
                fArray[n] = fArray[n] + factor_lat * flow_values[0][j3] / (float)Math.cos(earth_locs[0][j3]);
                float[] fArray4 = earth_locs[0];
                int n4 = j3;
                fArray4[n4] = fArray4[n4] + factor_lat * flow_values[1][j3];
            }
        }
        if (earth_units != null) {
            if (Unit.canConvert(earth_units[0], CommonUnit.radian)) {
                earth_locs[0] = CommonUnit.radian.toThat(earth_locs[0], earth_units[0]);
            }
            if (Unit.canConvert(earth_units[1], CommonUnit.radian)) {
                earth_locs[1] = CommonUnit.radian.toThat(earth_locs[1], earth_units[1]);
            }
            if (elen == 3 && earth_units.length == 3 && Unit.canConvert(earth_units[2], CommonUnit.meter)) {
                earth_locs[2] = CommonUnit.meter.toThat(earth_locs[2], earth_units[2]);
            }
        }
        if (elen == 3) {
            earth_locs = renderer.earthToSpatial(earth_locs, null, base_spatial_locs);
        } else {
            float factor_vert = 1.0E-5f * inv_scale;
            float[] vert = new float[flen];
            for (j = 0; j < flen; ++j) {
                vert[j] = factor_vert * flow_values[2][j];
            }
            earth_locs = renderer.earthToSpatial(earth_locs, vert, base_spatial_locs);
            for (int i = 0; i < earth_locs.length; ++i) {
                if (earth_locs[i] != null) continue;
                earth_locs[i] = new float[flen];
                for (int j4 = 0; j4 < flen; ++j4) {
                    earth_locs[i][j4] = spatial_values[i][j4];
                }
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j5 = 0; j5 < flen; ++j5) {
                float[] fArray = earth_locs[i];
                int n = j5;
                fArray[n] = fArray[n] - spatial_values[i][j5];
            }
        }
        for (int j6 = 0; j6 < flen; ++j6) {
            float mag = (float)Math.sqrt(flow_values[0][j6] * flow_values[0][j6] + flow_values[1][j6] * flow_values[1][j6] + flow_values[2][j6] * flow_values[2][j6]);
            float new_mag = (float)Math.sqrt(earth_locs[0][j6] * earth_locs[0][j6] + earth_locs[1][j6] * earth_locs[1][j6] + earth_locs[2][j6] * earth_locs[2][j6]);
            float ratio = mag / new_mag;
            flow_values[0][j6] = ratio * earth_locs[0][j6];
            flow_values[1][j6] = ratio * earth_locs[1][j6];
            flow_values[2][j6] = ratio * earth_locs[2][j6];
        }
        ShadowType.testFlow("adjust", flow_values);
        return flow_values;
    }

    public VisADGeometryArray[] makeStreamline(int which, float[][] flow_values, float flowScale, float[][] spatial_values, Set spatial_set, int spatialManifoldDimension, byte[][] color_values, boolean[][] range_select, int valueArrayLength, int[] valueToMap, Vector MapVector) throws VisADException {
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_set == null) {
            return null;
        }
        if (which == 0 && !this.streamline1) {
            return null;
        }
        if (which == 1 && !this.streamline2) {
            return null;
        }
        if (!(spatial_set instanceof Gridded3DSet)) {
            return null;
        }
        FunctionType ftype = (FunctionType)this.Type;
        RealTupleType rtt = ftype.getFlatRange();
        RealType[] range_reals = rtt.getRealComponents();
        int flow_dim0 = -1;
        int flow_dim1 = -1;
        int cnt_flow_maps = 0;
        for (int k = 0; k < range_reals.length; ++k) {
            for (int i = 0; i < valueArrayLength; ++i) {
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                DisplayRealType dreal = map.getDisplayScalar();
                ScalarType scalar = map.getScalar();
                if (!scalar.equals(range_reals[k])) continue;
                if (dreal.equals(Display.Flow1X) || dreal.equals(Display.Flow2X) || dreal.equals(Display.Flow1Elevation) || dreal.equals(Display.Flow2Elevation)) {
                    if (flow_dim0 == -1) {
                        flow_dim0 = 0;
                    } else {
                        flow_dim0 = 0;
                        flow_dim1 = 1;
                    }
                    ++cnt_flow_maps;
                }
                if (dreal.equals(Display.Flow1Y) || dreal.equals(Display.Flow2Y) || dreal.equals(Display.Flow1Azimuth) || dreal.equals(Display.Flow2Azimuth)) {
                    if (flow_dim0 == -1) {
                        flow_dim0 = 1;
                    } else {
                        flow_dim1 = 1;
                    }
                    ++cnt_flow_maps;
                }
                if (!dreal.equals(Display.Flow1Z) && !dreal.equals(Display.Flow2Z) && !dreal.equals(Display.Flow1Radial) && !dreal.equals(Display.Flow2Radial)) continue;
                flow_dim1 = 2;
                ++cnt_flow_maps;
            }
        }
        if (cnt_flow_maps > 2) {
            throw new BadMappingException("only one or two ScalarMaps to Flow per data allowed if streamlines enabled");
        }
        if (range_select[0] != null) {
            if (range_select[0].length == 1 && !range_select[0][0]) {
                return null;
            }
            for (int ii = 0; ii < range_select[0].length; ++ii) {
                if (range_select[0][ii]) continue;
                flow_values[0][ii] = Float.NaN;
                flow_values[1][ii] = Float.NaN;
                flow_values[2][ii] = Float.NaN;
            }
        }
        DataRenderer renderer = this.getLink().getRenderer();
        flow_values = ShadowType.adjustFlowToEarth(which, flow_values, spatial_values, flowScale, renderer);
        float density = 1.0f;
        float arrowScale = 1.0f;
        float stepFactor = 2.0f;
        float packingFactor = 1.0f;
        float cntrWeight = 3.0f;
        int n_pass = 0;
        float reduction = 1.0f;
        int[] numl = new int[1];
        int[][] n_verts = new int[1][];
        float[][][] vr = new float[1][][];
        float[][][] vc = new float[1][][];
        if (which == 0) {
            density = this.streamlineDensity1;
        }
        if (which == 1) {
            density = this.streamlineDensity2;
        }
        if (which == 0) {
            arrowScale = this.arrowScale1;
        }
        if (which == 1) {
            arrowScale = this.arrowScale2;
        }
        if (which == 0) {
            stepFactor = this.stepFactor1;
        }
        if (which == 1) {
            stepFactor = this.stepFactor2;
        }
        if (which == 0) {
            packingFactor = this.packingFactor1;
        }
        if (which == 1) {
            packingFactor = this.packingFactor2;
        }
        if (which == 0) {
            cntrWeight = this.cntrWeight1;
        }
        if (which == 1) {
            cntrWeight = this.cntrWeight2;
        }
        if (which == 0) {
            n_pass = this.n_pass1;
        }
        if (which == 1) {
            n_pass = this.n_pass2;
        }
        if (which == 0) {
            reduction = this.reduction1;
        }
        if (which == 1) {
            reduction = this.reduction2;
        }
        if (spatialManifoldDimension != 2) {
            throw new VisADException("only manifoldDimension==2 supported for streamlimes");
        }
        int nc = ((Gridded3DSet)spatial_set).LengthX;
        int nr = ((Gridded3DSet)spatial_set).LengthY;
        Gridded2DSet gset = new Gridded2DSet(RealTupleType.Generic2D, new float[][]{spatial_values[flow_dim0], spatial_values[flow_dim1]}, nc, nr, null, null, null, false, false);
        Stream2D.stream(flow_values[flow_dim0], flow_values[flow_dim1], nr, nc, density, stepFactor, arrowScale, vr, vc, n_verts, numl, gset, packingFactor, cntrWeight, n_pass, reduction);
        VisADGeometryArray[] arrays = new VisADLineArray[numl[0]];
        Integer2DSet grid_set = new Integer2DSet(nc, nr);
        for (int kk = 0; kk < arrays.length; ++kk) {
            arrays[kk] = new VisADLineArray();
            float[][] grid = new float[2][n_verts[0][kk]];
            System.arraycopy(vr[0][kk], 0, grid[1], 0, n_verts[0][kk]);
            System.arraycopy(vc[0][kk], 0, grid[0], 0, n_verts[0][kk]);
            float[][] spatial_set_vals = ((Gridded3DSet)spatial_set).gridToValue(grid);
            byte[][] intrp_color_values = null;
            if (color_values != null) {
                int len = color_values.length;
                intrp_color_values = new byte[len][n_verts[0][kk]];
                int[] indices = grid_set.valueToIndex(grid);
                for (int cc = 0; cc < n_verts[0][kk]; ++cc) {
                    if (indices[cc] >= 0) {
                        intrp_color_values[0][cc] = color_values[0][indices[cc]];
                        intrp_color_values[1][cc] = color_values[1][indices[cc]];
                        intrp_color_values[2][cc] = color_values[2][indices[cc]];
                        if (len <= 3) continue;
                        intrp_color_values[3][cc] = color_values[3][indices[cc]];
                        continue;
                    }
                    intrp_color_values[0][cc] = -1;
                    intrp_color_values[1][cc] = 0;
                    intrp_color_values[2][cc] = 0;
                    if (len <= 3) continue;
                    intrp_color_values[3][cc] = color_values[3][indices[cc]];
                }
            }
            Gridded3DSet.setGeometryArray(arrays[kk], spatial_set_vals, 4, intrp_color_values);
            arrays[kk] = (VisADLineArray)((VisADLineArray)arrays[kk]).removeMissing();
        }
        return arrays;
    }

    private static void testFlow(String id, float[][] flow_values) {
        int flen = flow_values[0].length;
        for (int i = 0; i < flen; ++i) {
            if (flow_values[0][i] == flow_values[0][i] && flow_values[1][i] == flow_values[1][i] && flow_values[2][i] == flow_values[2][i] && !Float.isInfinite(flow_values[0][i]) && !Float.isInfinite(flow_values[1][i]) && !Float.isInfinite(flow_values[2][i])) continue;
            flow_values[0][i] = 0.0f;
            flow_values[1][i] = 0.0f;
            flow_values[2][i] = 0.0f;
        }
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        VisADLineArray array = new VisADLineArray();
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            for (int j = 0; j < range_select[0].length; ++j) {
                if (!range_select[0][j]) continue;
                ++rlen;
            }
        }
        if (rlen == 0) {
            return null;
        }
        DataRenderer renderer = this.getLink().getRenderer();
        flow_values = ShadowType.adjustFlowToEarth(which, flow_values, spatial_values, flowScale, renderer);
        array.vertexCount = 6 * rlen;
        float[] coordinates = new float[18 * rlen];
        int m = 0;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float a0 = 0.0f;
        float a1 = 0.0f;
        float a2 = 0.0f;
        float b0 = 0.0f;
        float b1 = 0.0f;
        float b2 = 0.0f;
        for (int j = 0; j < len; ++j) {
            if (range_select[0] != null && !range_select[0][j]) continue;
            if (flen == 1) {
                f0 = flowScale * flow_values[0][0];
                f1 = flowScale * flow_values[1][0];
                f2 = flowScale * flow_values[2][0];
            } else {
                f0 = flowScale * flow_values[0][j];
                f1 = flowScale * flow_values[1][j];
                f2 = flowScale * flow_values[2][j];
            }
            int k = m;
            coordinates[m++] = spatial_values[0][j];
            coordinates[m++] = spatial_values[1][j];
            coordinates[m++] = spatial_values[2][j];
            int n = m;
            coordinates[m++] = coordinates[k++] + f0;
            coordinates[m++] = coordinates[k++] + f1;
            coordinates[m++] = coordinates[k++] + f2;
            k = n;
            coordinates[m++] = coordinates[n++];
            coordinates[m++] = coordinates[n++];
            coordinates[m++] = coordinates[n++];
            boolean mode2d = this.display.getDisplayRenderer().getMode2D();
            b0 = a0 = -0.15f * f0;
            b1 = a1 = -0.15f * f1;
            b2 = a2 = -0.15f * f2;
            if (mode2d || Math.abs(f2) <= Math.abs(f0) && Math.abs(f2) <= Math.abs(f1)) {
                a0 += 0.15f * f1;
                a1 -= 0.15f * f0;
                b0 -= 0.15f * f1;
                b1 += 0.15f * f0;
            } else if (Math.abs(f1) <= Math.abs(f0)) {
                a0 += 0.15f * f2;
                a2 -= 0.15f * f0;
                b0 -= 0.15f * f2;
                b2 += 0.15f * f0;
            } else {
                a1 += 0.15f * f2;
                a2 -= 0.15f * f1;
                b1 -= 0.15f * f2;
                b2 += 0.15f * f1;
            }
            k = n;
            coordinates[m++] = coordinates[n++] + a0;
            coordinates[m++] = coordinates[n++] + a1;
            coordinates[m++] = coordinates[n++] + a2;
            n = k;
            coordinates[m++] = coordinates[k++];
            coordinates[m++] = coordinates[k++];
            coordinates[m++] = coordinates[k++];
            coordinates[m++] = coordinates[n++] + b0;
            coordinates[m++] = coordinates[n++] + b1;
            coordinates[m++] = coordinates[n++] + b2;
        }
        array.coordinates = coordinates;
        if (color_values != null) {
            int c_len = color_values.length;
            byte[] colors = new byte[6 * c_len * rlen];
            m = 0;
            float c0 = 0.0f;
            float c1 = 0.0f;
            float c2 = 0.0f;
            for (int j = 0; j < len; ++j) {
                if (range_select[0] != null && !range_select[0][j]) continue;
                int k1 = m;
                int k2 = m;
                int k3 = m;
                int k4 = m;
                int k5 = m;
                colors[m++] = color_values[0][j];
                colors[m++] = color_values[1][j];
                colors[m++] = color_values[2][j];
                if (c_len == 4) {
                    colors[m++] = color_values[3][j];
                }
                colors[m++] = colors[k1++];
                colors[m++] = colors[k1++];
                colors[m++] = colors[k1++];
                if (c_len == 4) {
                    colors[m++] = colors[k1++];
                }
                colors[m++] = colors[k2++];
                colors[m++] = colors[k2++];
                colors[m++] = colors[k2++];
                if (c_len == 4) {
                    colors[m++] = colors[k2++];
                }
                colors[m++] = colors[k3++];
                colors[m++] = colors[k3++];
                colors[m++] = colors[k3++];
                if (c_len == 4) {
                    colors[m++] = colors[k3++];
                }
                colors[m++] = colors[k4++];
                colors[m++] = colors[k4++];
                colors[m++] = colors[k4++];
                if (c_len == 4) {
                    colors[m++] = colors[k4++];
                }
                colors[m++] = colors[k5++];
                colors[m++] = colors[k5++];
                colors[m++] = colors[k5++];
                if (c_len != 4) continue;
                colors[m++] = colors[k5++];
            }
            array.colors = colors;
        }
        if (this.getAdjustProjectionSeam()) {
            array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
        }
        return new VisADGeometryArray[]{array};
    }

    static void rotateVectors(double[] base, double[] up, double rotationDegrees) {
        double rotation = Math.PI / 180 * rotationDegrees;
        double sinRotation = Math.sin(rotation);
        double cosRotation = Math.cos(rotation);
        double[] newBase = new double[3];
        double[] newUp = new double[3];
        if (rotationDegrees == 0.0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            newBase[i] = cosRotation * base[i] - sinRotation * up[i];
            newUp[i] = sinRotation * base[i] + cosRotation * up[i];
        }
        System.arraycopy(newBase, 0, base, 0, 3);
        System.arraycopy(newUp, 0, up, 0, 3);
    }

    public VisADGeometryArray makeText(String[] text_values, TextControl text_control, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        int n;
        if (text_values == null || text_values.length == 0 || text_control == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        byte r = 0;
        byte g = 0;
        byte b = 0;
        byte a = 0;
        int color_length = 0;
        if (color_values != null) {
            color_length = color_values.length;
            r = color_values[0][0];
            g = color_values[1][0];
            b = color_values[2][0];
            if (color_length > 3) {
                a = color_values[3][0];
            }
        }
        if ((n = text_values.length) > spatial_values[0].length) {
            n = spatial_values[0].length;
        }
        VisADGeometryArray[] as = new VisADGeometryArray[n];
        TextControl.Justification justification = text_control.getJustification();
        TextControl.Justification verticalJustification = text_control.getVerticalJustification();
        double size = text_control.getSize();
        Font font = text_control.getFont();
        HersheyFont hfont = text_control.getHersheyFont();
        double rotation = text_control.getRotation();
        double characterRotation = text_control.getCharacterRotation();
        double scale = text_control.getScale();
        double[] offset = text_control.getOffset();
        boolean sphere = text_control.getSphere();
        float[][] spatial_sphere = null;
        if (sphere) {
            spatial_sphere = Display.DisplaySphericalCoordSys.fromReference(spatial_values);
        }
        double[] start = new double[3];
        double[] base = new double[]{size * 0.07, 0.0, 0.0};
        double[] up = new double[]{0.0, size * 0.07, 0.0};
        ShadowType.rotateVectors(base, up, text_control.getRotation());
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (range_select[0] != null && range_select[0].length != 1 && !range_select[0][i]) continue;
            if (sphere) {
                int len;
                double size_in_radians = size * 0.07 / (double)spatial_sphere[2][i];
                double size_in_degrees = size_in_radians * 57.29577951308232;
                double lon_size_in_degrees = size_in_degrees / Math.cos(Math.PI / 180 * (double)spatial_sphere[0][i]);
                start = new double[]{spatial_sphere[0][i], spatial_sphere[1][i], spatial_sphere[2][i]};
                base = new double[]{0.0, lon_size_in_degrees, 0.0};
                up = new double[]{size_in_degrees, 0.0, 0.0};
                ShadowType.rotateVectors(base, up, text_control.getRotation());
                as[k] = font != null ? PlotText.render_font(text_values[i], font, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : (hfont != null ? PlotText.render_font(text_values[i], hfont, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : PlotText.render_label(text_values[i], start, base, up, justification, verticalJustification, characterRotation, scale, offset));
                int n2 = len = as[k] == null ? 0 : as[k].coordinates.length;
                if (len > 0) {
                    int j;
                    float[] coordinates = as[k].coordinates;
                    float[][] cs = new float[3][len / 3];
                    int m = 0;
                    for (j = 0; j < len / 3; ++j) {
                        cs[0][j] = coordinates[m++];
                        cs[1][j] = coordinates[m++];
                        cs[2][j] = coordinates[m++];
                    }
                    cs = Display.DisplaySphericalCoordSys.toReference(cs);
                    m = 0;
                    for (j = 0; j < len / 3; ++j) {
                        coordinates[m++] = cs[0][j];
                        coordinates[m++] = cs[1][j];
                        coordinates[m++] = cs[2][j];
                    }
                    as[k].coordinates = coordinates;
                    if (font != null) {
                        float[] normals = as[k].normals;
                        for (int j3 = 0; j3 < len; j3 += 3) {
                            float c = (float)Math.sqrt(coordinates[j3 + 0] * coordinates[j3 + 0] + coordinates[j3 + 1] * coordinates[j3 + 1] + coordinates[j3 + 2] * coordinates[j3 + 2]);
                            float cinv = c == 0.0f ? 1.0f : 1.0f / c;
                            normals[j3 + 0] = cinv * coordinates[j3 + 0];
                            normals[j3 + 1] = cinv * coordinates[j3 + 1];
                            normals[j3 + 2] = cinv * coordinates[j3 + 2];
                        }
                        as[k].normals = normals;
                    }
                }
            } else {
                start = new double[]{spatial_values[0][i], spatial_values[1][i], spatial_values[2][i]};
                as[k] = font != null ? PlotText.render_font(text_values[i], font, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : (hfont != null ? PlotText.render_font(text_values[i], hfont, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : PlotText.render_label(text_values[i], start, base, up, justification, verticalJustification, characterRotation, scale, offset));
            }
            int len = as[k] == null ? 0 : as[k].coordinates.length;
            int numPts = len / 3;
            if (len > 0 && color_values != null) {
                byte[] colors = new byte[numPts * color_length];
                if (color_values[0].length > 1) {
                    r = color_values[0][k];
                    g = color_values[1][k];
                    b = color_values[2][k];
                    if (color_length > 3) {
                        a = color_values[3][k];
                    }
                }
                for (int j = 0; j < colors.length; j += color_length) {
                    colors[j] = r;
                    colors[j + 1] = g;
                    colors[j + 2] = b;
                    if (color_length <= 3) continue;
                    colors[j + 3] = a;
                }
                as[k].colors = colors;
            }
            ++k;
        }
        if (k == 0) {
            return null;
        }
        VisADGeometryArray[] arrays = new VisADGeometryArray[k];
        System.arraycopy(as, 0, arrays, 0, k);
        VisADGeometryArray array = null;
        DataRenderer renderer = this.getLink().getRenderer();
        for (int i = 0; i < k; ++i) {
            if (arrays[i] == null) continue;
            if (this.getAdjustProjectionSeam()) {
                arrays[i] = arrays[i].adjustLongitudeBulk(renderer);
            }
            if (array != null) continue;
            array = (VisADGeometryArray)arrays[i].clone();
        }
        if (array != null) {
            VisADGeometryArray.merge(arrays, array);
        }
        return array;
    }

    public byte[][] assembleColor(float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, boolean[] single_missing, ShadowType shadow_api) throws VisADException, RemoteException {
        int len;
        float[][] rgba_values = new float[4][];
        float[] rgba_value_counts = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] rgba_singles = new float[4];
        float[] rgba_single_counts = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        Object tuple_values = new float[3][];
        float[] tuple_value_counts = new float[]{0.0f, 0.0f, 0.0f};
        float[] tuple_singles = new float[3];
        float[] tuple_single_counts = new float[]{0.0f, 0.0f, 0.0f};
        boolean[] mark = new boolean[valueArrayLength];
        for (int i = 0; i < valueArrayLength; ++i) {
            mark[i] = false;
        }
        while (true) {
            TupleType color_tuple = null;
            for (int i = 0; i < valueArrayLength; ++i) {
                float[] values = display_values[i];
                if (values == null || mark[i]) continue;
                int len2 = values.length;
                int displayScalarIndex = valueToScalar[i];
                DisplayRealType real = display.getDisplayScalar(displayScalarIndex);
                DisplayTupleType tuple = real.getTuple();
                if (tuple == null || !tuple.equals(Display.DisplayRGBTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || color_tuple != null && !color_tuple.equals(tuple)) continue;
                if (color_tuple == null) {
                    color_tuple = tuple;
                    for (int j = 0; j < 3; ++j) {
                        tuple_singles[j] = 0.0f;
                        tuple_single_counts[j] = 0.0f;
                        tuple_values[j] = null;
                        tuple_value_counts[j] = 0.0f;
                    }
                }
                int index = real.getTupleIndex();
                if (len2 == 1) {
                    int n = index;
                    tuple_singles[n] = tuple_singles[n] + values[0];
                    int n2 = index;
                    tuple_single_counts[n2] = tuple_single_counts[n2] + 1.0f;
                } else {
                    ShadowType.singleComposite(index, tuple_values, tuple_value_counts, values);
                }
                display_values[i] = null;
                mark[i] = true;
            }
            if (color_tuple == null) break;
            ShadowType.colorSum(3, tuple_values, tuple_value_counts, tuple_singles, tuple_single_counts, display, color_tuple, default_values);
            if (!color_tuple.equals(Display.DisplayRGBTuple)) {
                ShadowType.equalizeAndDefault(tuple_values, display, (DisplayTupleType)color_tuple, default_values);
                CoordinateSystem coord = ((RealTupleType)color_tuple).getCoordinateSystem();
                tuple_values = coord.toReference((float[][])tuple_values);
            }
            ShadowType.colorComposite(rgba_values, rgba_value_counts, tuple_values);
        }
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        for (int i = 0; i < valueArrayLength; ++i) {
            int index;
            float[][] color_values;
            BaseColorControl control;
            float[] values = display_values[i];
            if (values == null || mark[i]) continue;
            len = values.length;
            int displayScalarIndex = valueToScalar[i];
            DisplayRealType real = display.getDisplayScalar(displayScalarIndex);
            if (real.equals(Display.RGB) || real.equals(Display.HSV) || real.equals(Display.CMY)) {
                control = (ColorControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
                color_values = control.lookupValues(values);
                if (real.equals(Display.HSV)) {
                    color_values = Display.DisplayHSVCoordSys.toReference(color_values);
                } else if (real.equals(Display.CMY)) {
                    color_values = Display.DisplayCMYCoordSys.toReference(color_values);
                } else if (!real.equals(Display.RGB)) {
                    throw new DisplayException("unrecognized color CoordinateSsystem: ShadowType.assembleColor");
                }
                if (len == 1) {
                    index = 0;
                    while (index < 3) {
                        int n = index;
                        rgba_singles[n] = rgba_singles[n] + color_values[index][0];
                        int n3 = index++;
                        rgba_single_counts[n3] = rgba_single_counts[n3] + 1.0f;
                    }
                } else {
                    ShadowType.colorComposite(rgba_values, rgba_value_counts, color_values);
                }
                display_values[i] = null;
            }
            if (real.equals(Display.RGBA)) {
                control = (ColorAlphaControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
                color_values = control.lookupValues(values);
                if (len == 1) {
                    index = 0;
                    while (index < 4) {
                        int n = index;
                        rgba_singles[n] = rgba_singles[n] + color_values[index][0];
                        int n4 = index++;
                        rgba_single_counts[n4] = rgba_single_counts[n4] + 1.0f;
                    }
                } else {
                    ShadowType.colorComposite(rgba_values, rgba_value_counts, color_values);
                    for (index = 0; index < 4; ++index) {
                        ShadowType.singleComposite(index, rgba_values, rgba_value_counts, color_values[index]);
                        color_values[index] = null;
                    }
                }
                display_values[i] = null;
            }
            if (!real.equals(Display.Alpha)) continue;
            if (len == 1) {
                rgba_singles[3] = rgba_singles[3] + values[0];
                rgba_single_counts[3] = rgba_single_counts[3] + 1.0f;
            } else {
                ShadowType.singleComposite(3, rgba_values, rgba_value_counts, values);
            }
            display_values[i] = null;
        }
        if (rgba_values[0] == null && rgba_values[1] == null && rgba_values[2] == null && rgba_values[3] == null) {
            for (int index = 0; index < 4; ++index) {
                rgba_values[index] = new float[1];
                if (rgba_single_counts[index] > 0.0f) {
                    rgba_values[index][0] = rgba_singles[index] / rgba_single_counts[index];
                    continue;
                }
                int default_index = ShadowType.getDefaultColorIndex(display, index);
                rgba_values[index][0] = default_values[default_index];
            }
        } else {
            ShadowType.colorSum(4, rgba_values, rgba_value_counts, rgba_singles, rgba_single_counts, display, Display.DisplayRGBTuple, default_values);
            ShadowType.equalizeAndDefault(rgba_values, display, Display.DisplayRGBTuple, default_values);
        }
        int big_len = rgba_values[0].length;
        for (int i = 0; i < 4; ++i) {
            len = rgba_values[i].length;
            for (int j = 0; j < len; ++j) {
                int k;
                if (rgba_values[i][j] == rgba_values[i][j]) continue;
                if (range_select[0] == null) {
                    range_select[0] = new boolean[big_len];
                    for (k = 0; k < big_len; ++k) {
                        range_select[0][k] = true;
                    }
                }
                if (len > 1) {
                    range_select[0][j] = false;
                    rgba_values[i][j] = 0.0f;
                    continue;
                }
                for (k = 0; k < big_len; ++k) {
                    range_select[0][k] = false;
                }
                rgba_values[i][j] = 0.0f;
                single_missing[i] = true;
            }
        }
        byte[][] b = new byte[rgba_values.length][];
        for (int i = 0; i < rgba_values.length; ++i) {
            if (rgba_values[i] == null) continue;
            int len3 = rgba_values[i].length;
            b[i] = new byte[len3];
            for (int j = 0; j < len3; ++j) {
                int k = (int)((double)rgba_values[i][j] * 255.0);
                k = k < 0 ? 0 : (k > 255 ? 255 : k);
                b[i][j] = (byte)(k < 128 ? k : k - 256);
            }
        }
        return b;
    }

    public static final float byteToFloat(byte b) {
        return b < 0 ? ((float)b + 256.0f) / 255.0f : (float)b / 255.0f;
    }

    public static final byte floatToByte(float f) {
        int k = (int)((double)f * 255.0);
        return (byte)(k < 0 ? 0 : (k > 255 ? -1 : (k < 128 ? k : k - 256)));
    }

    static void colorSum(int nindex, float[][] tuple_values, float[] tuple_value_counts, float[] tuple_singles, float[] tuple_single_counts, DisplayImpl display, DisplayTupleType tuple, float[] default_values) throws VisADException {
        for (int index = nindex - 1; index >= 0; --index) {
            if (tuple_values[index] == null) {
                if (!(tuple_single_counts[index] > 0.0f)) continue;
                tuple_values[index] = new float[1];
                tuple_values[index][0] = tuple_singles[index];
                tuple_value_counts[index] = tuple_single_counts[index];
                continue;
            }
            int cm = (int)default_values[display.getDisplayScalarIndex(Display.ColorMode)];
            float inv_count = cm == 1 ? 1.0f : 1.0f / (tuple_value_counts[index] + tuple_single_counts[index]);
            float[] t_values = tuple_values[index];
            for (int j = 0; j < t_values.length; ++j) {
                if (t_values[j] != t_values[j]) continue;
                t_values[j] = inv_count * (t_values[j] + tuple_singles[index]);
            }
        }
    }

    public static int getDefaultColorIndex(DisplayImpl display, int index) {
        return index == 0 ? display.getDisplayScalarIndex(Display.Red) : (index == 1 ? display.getDisplayScalarIndex(Display.Green) : (index == 2 ? display.getDisplayScalarIndex(Display.Blue) : display.getDisplayScalarIndex(Display.Alpha)));
    }

    static void equalizeAndDefault(float[][] tuple_values, DisplayImpl display, DisplayTupleType tuple, float[] default_values) throws VisADException {
        int index;
        int nindex = tuple_values.length;
        for (int index2 = 0; index2 < nindex; ++index2) {
            if (tuple_values[index2] != null) continue;
            tuple_values[index2] = new float[1];
            int default_index = index2 < 3 ? display.getDisplayScalarIndex((DisplayRealType)tuple.getComponent(index2)) : display.getDisplayScalarIndex(Display.Alpha);
            tuple_values[index2][0] = default_values[default_index];
        }
        int len = 1;
        for (index = 0; index < nindex; ++index) {
            len = Math.max(len, tuple_values[index].length);
        }
        for (index = 0; index < 3; ++index) {
            int t_len = tuple_values[index].length;
            if (len <= t_len) continue;
            if (t_len != 1) {
                throw new DisplayException("bad length: ShadowType.equalizeAndDefault");
            }
            float[] t = new float[len];
            float v = tuple_values[index][0];
            for (int i = 0; i < len; ++i) {
                t[i] = v;
            }
            tuple_values[index] = t;
        }
    }

    static void colorComposite(float[][] rgba_values, float[] rgba_value_counts, float[][] tuple_values) throws VisADException {
        for (int index = 0; index < 3; ++index) {
            ShadowType.singleComposite(index, rgba_values, rgba_value_counts, tuple_values[index]);
            tuple_values[index] = null;
        }
    }

    static void singleComposite(int index, float[][] rgba_values, float[] rgba_value_counts, float[] values) throws VisADException {
        if (values == null) {
            return;
        }
        if (rgba_values[index] == null) {
            rgba_values[index] = values;
            rgba_value_counts[index] = 1.0f;
        } else {
            int n = index;
            rgba_value_counts[n] = rgba_value_counts[n] + 1.0f;
            int rgba_len = rgba_values[index].length;
            int values_len = values.length;
            if (rgba_len == values_len) {
                for (int j = 0; j < rgba_len; ++j) {
                    float[] fArray = rgba_values[index];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + values[j];
                }
            } else if (values_len == 1) {
                int j = 0;
                while (j < rgba_len) {
                    float[] fArray = rgba_values[index];
                    int n3 = j++;
                    fArray[n3] = fArray[n3] + values[0];
                }
            } else if (rgba_len == 1) {
                int j = 0;
                while (j < rgba_len) {
                    int n4 = j++;
                    values[n4] = values[n4] + rgba_values[index][0];
                }
                rgba_values[index] = values;
            } else {
                throw new DisplayException("bad length: ShadowType.singleComposite");
            }
        }
    }

    public boolean[][] assembleSelect(float[][] display_values, int domain_length, int valueArrayLength, int[] valueToScalar, DisplayImpl display, ShadowType shadow_api) throws VisADException {
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        boolean[][] range_select = new boolean[1][];
        boolean anySelect = false;
        for (int i = 0; i < valueArrayLength; ++i) {
            int j;
            int displayScalarIndex;
            DisplayRealType real;
            float[] values = display_values[i];
            if (values == null || !(real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i])).equals(Display.SelectRange)) continue;
            if (range_select[0] == null) {
                range_select[0] = new boolean[domain_length];
                for (int j2 = 0; j2 < domain_length; ++j2) {
                    range_select[0][j2] = true;
                }
            }
            RangeControl control = (RangeControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
            float[] range = control.getRange();
            if (values.length == 1) {
                if (values[0] < range[0] || range[1] < values[0]) {
                    for (j = 0; j < domain_length; ++j) {
                        range_select[0][j] = false;
                    }
                    anySelect = true;
                }
            } else {
                for (j = 0; j < values.length; ++j) {
                    if (!(values[j] < range[0]) && !(range[1] < values[j])) continue;
                    range_select[0][j] = false;
                    anySelect = true;
                }
            }
            display_values[i] = null;
        }
        if (range_select[0] != null && !anySelect) {
            range_select[0] = null;
        }
        return range_select;
    }

    public boolean terminalTupleOrScalar(Object group, float[][] display_values, String text_value, TextControl text_control, int valueArrayLength, int[] valueToScalar, float[] default_values, int[] inherited_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        GraphicsModeControl mode = (GraphicsModeControl)this.display.getGraphicsModeControl().clone();
        float pointSize = default_values[this.display.getDisplayScalarIndex(Display.PointSize)];
        mode.setPointSize(pointSize, true);
        float lineWidth = default_values[this.display.getDisplayScalarIndex(Display.LineWidth)];
        mode.setLineWidth(lineWidth, true);
        int lineStyle = (int)default_values[this.display.getDisplayScalarIndex(Display.LineStyle)];
        mode.setLineStyle(lineStyle, true);
        float polygonOffset = default_values[this.display.getDisplayScalarIndex(Display.PolygonOffset)];
        mode.setPolygonOffset(polygonOffset, true);
        float polygonOffsetFactor = default_values[this.display.getDisplayScalarIndex(Display.PolygonOffsetFactor)];
        mode.setPolygonOffsetFactor(polygonOffsetFactor, true);
        float cacheAppearances = default_values[this.display.getDisplayScalarIndex(Display.CacheAppearances)];
        mode.setCacheAppearances(cacheAppearances > 0.5f);
        float mergeArrays = default_values[this.display.getDisplayScalarIndex(Display.MergeGeometries)];
        mode.setMergeGeometries(mergeArrays > 0.5f);
        float[][] flow1_values = new float[3][];
        float[][] flow2_values = new float[3][];
        float[] flowScale = new float[2];
        boolean[][] range_select = new boolean[1][];
        shadow_api.assembleFlow(flow1_values, flow2_values, flowScale, display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, renderer, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        boolean[] swap = new boolean[]{false, false, false};
        int[] spatialDimensions = new int[2];
        float[][] spatial_values = new float[3][];
        shadow_api.assembleSpatial(spatial_values, display_values, valueArrayLength, valueToScalar, this.display, default_values, inherited_values, null, false, false, spatialDimensions, range_select, flow1_values, flow2_values, flowScale, swap, renderer, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        boolean[] single_missing = new boolean[]{false, false, false, false};
        byte[][] color_values = shadow_api.assembleColor(display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, single_missing, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        int LevelOfDifficulty = this.getLevelOfDifficulty();
        if (LevelOfDifficulty == 5) {
            int i;
            VisADGeometryArray array;
            Vector MapVector;
            if (single_missing[0] || single_missing[1] || single_missing[2]) {
                return false;
            }
            float[] constant_color = new float[]{ShadowType.byteToFloat(color_values[0][0]), ShadowType.byteToFloat(color_values[1][0]), ShadowType.byteToFloat(color_values[2][0])};
            float constant_alpha = Float.NaN;
            boolean anyShapeCreated = false;
            int[] valueToMap = this.display.getValueToMap();
            VisADGeometryArray[] arrays = shadow_api.assembleShape(display_values, valueArrayLength, valueToMap, MapVector = this.display.getMapVector(), valueToScalar, this.display, default_values, inherited_values, spatial_values, color_values, range_select, -1, shadow_api);
            if (arrays != null) {
                for (int i2 = 0; i2 < arrays.length; ++i2) {
                    array = arrays[i2];
                    if (array == null) continue;
                    shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                }
                anyShapeCreated = true;
            }
            boolean anyTextCreated = false;
            if (text_value != null && text_control != null) {
                String[] text_values = new String[]{text_value};
                array = shadow_api.makeText(text_values, text_control, spatial_values, color_values, range_select);
                shadow_api.addTextToGroup(group, array, mode, constant_alpha, constant_color);
                anyTextCreated = true;
            }
            boolean anyFlowCreated = false;
            arrays = shadow_api.makeFlow(0, flow1_values, flowScale[0], spatial_values, color_values, range_select);
            if (arrays != null) {
                for (i = 0; i < arrays.length; ++i) {
                    if (arrays[i] == null) continue;
                    shadow_api.addToGroup(group, arrays[i], mode, constant_alpha, constant_color);
                }
                anyFlowCreated = true;
            }
            if ((arrays = shadow_api.makeFlow(1, flow2_values, flowScale[1], spatial_values, color_values, range_select)) != null) {
                for (i = 0; i < arrays.length; ++i) {
                    if (arrays[i] == null) continue;
                    shadow_api.addToGroup(group, arrays[i], mode, constant_alpha, constant_color);
                }
                anyFlowCreated = true;
            }
            if (!(anyFlowCreated || anyTextCreated || anyShapeCreated || (array = ShadowType.makePointGeometry(spatial_values, null)) == null || array.vertexCount <= 0)) {
                shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
            }
            if (renderer.getIsDirectManipulation()) {
                renderer.setSpatialValues(spatial_values);
            }
            return false;
        }
        throw new UnimplementedException("terminal LEGAL unimplemented: ShadowType.terminalTupleOrReal");
    }

    public boolean makeContour(int valueArrayLength, int[] valueToScalar, float[][] display_values, int[] inherited_values, Vector MapVector, int[] valueToMap, int domain_length, boolean[][] range_select, int spatialManifoldDimension, Set spatial_set, byte[][] color_values, boolean indexed, Object group, GraphicsModeControl mode, boolean[] swap, float constant_alpha, float[] constant_color, ShadowType shadow_api, ShadowRealTupleType Domain2, ShadowRealType[] DomainReferenceComponents, Set domain_set, Unit[] domain_units, CoordinateSystem dataCoordinateSystem) throws VisADException {
        RealType real;
        boolean anyContourCreated = false;
        DataRenderer renderer = this.getLink().getRenderer();
        double[] matrix = this.p_cntrl.getMatrix();
        double scale = Double.NaN;
        MouseBehavior mouse = this.display.getMouseBehavior();
        if (mouse != null) {
            double[] rot_a = new double[3];
            double[] trans_a = new double[3];
            double[] scale_a = new double[1];
            mouse.instance_unmake_matrix(rot_a, scale_a, trans_a, matrix);
            scale = scale_a[0];
        }
        boolean isLinearContour3D = this.getIsLinearContour3D() && spatial_set instanceof Linear3DSet;
        ScalarMap[] spatial_maps = new ScalarMap[]{null, null, null};
        int[] permute = new int[]{-1, -1, -1};
        if (isLinearContour3D) {
            RealType[] reals = ((SetType)spatial_set.getType()).getDomain().getRealComponents();
            block6: for (int i = 0; i < valueArrayLength; ++i) {
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                ScalarType sc = map.getScalar();
                real = sc instanceof RealType ? (RealType)sc : null;
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType tuple = dreal.getTuple();
                if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple)) continue;
                int tuple_index = dreal.getTupleIndex();
                for (int j = 0; j < reals.length; ++j) {
                    if (!real.equals(reals[j])) continue;
                    permute[j] = tuple_index;
                    spatial_maps[j] = map;
                    continue block6;
                }
            }
        }
        ShadowRealTupleType domain_reference = null;
        CoordinateSystem coord_sys = null;
        if (this.spatialTuple != null) {
            coord_sys = this.spatialTuple.getCoordinateSystem();
        }
        domain_reference = Domain2.getReference();
        for (int i = 0; i < valueArrayLength; ++i) {
            ScalarMap sm;
            int kk;
            ContourControl control;
            int displayScalarIndex = valueToScalar[i];
            real = this.display.getDisplayScalar(displayScalarIndex);
            if (!real.equals(Display.IsoContour) || display_values[i] == null || display_values[i].length != domain_length || inherited_values[i] != 0) continue;
            VisADGeometryArray array = null;
            this.c_cntrl = control = (ContourControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
            boolean[] bvalues = new boolean[2];
            float[] fvalues = new float[5];
            control.getMainContours(bvalues, fvalues);
            boolean doContour = bvalues[0];
            boolean doLabels = bvalues[1];
            float isoLvl = fvalues[0];
            if (scale != scale) {
                scale = ContourControl.getInitScale();
            }
            double label_size = control.getLabelSize();
            if (spatialManifoldDimension == 3 || spatialManifoldDimension == 2) {
                anyContourCreated = true;
            }
            if (!doContour) continue;
            if (range_select[0] != null) {
                int len = range_select[0].length;
                if (len == 1 || display_values[i].length == 1) break;
                int dlen = display_values[i].length;
                float[] temp = display_values[i];
                display_values[i] = new float[dlen];
                System.arraycopy(temp, 0, display_values[i], 0, dlen);
                for (int j = 0; j < len; ++j) {
                    if (range_select[0][j]) continue;
                    display_values[i][j] = Float.NaN;
                }
            }
            if (spatialManifoldDimension == 3) {
                if (isoLvl != isoLvl) continue;
                if (spatial_set != null) {
                    array = isLinearContour3D ? ((Linear3DSet)spatial_set).makeLinearIsoSurface(isoLvl, display_values[i], color_values, indexed, spatial_maps, permute) : spatial_set.makeIsoSurface(isoLvl, display_values[i], color_values, indexed);
                    if (array != null && this.getAdjustProjectionSeam()) {
                        try {
                            array = array.adjustLongitude(renderer);
                            array = array.adjustSeam(renderer);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                    array = null;
                    continue;
                }
                if (coord_sys == null) continue;
                array = ((Gridded3DSet)domain_set).makeIsoSurfaceMissingSpatial(isoLvl, display_values[i], color_values, indexed, Domain2, domain_reference, domain_units, dataCoordinateSystem, coord_sys, DomainReferenceComponents, this.spatialTuple, this.spatial_offset_values);
                if (array != null) {
                    array = array.removeMissing();
                }
                shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                array = null;
                continue;
            }
            if (spatialManifoldDimension != 2 || spatial_set == null) continue;
            float[] lowhibase = new float[3];
            boolean[] doStyle = new boolean[]{false};
            float[] levs = control.getLevels(lowhibase, doStyle);
            boolean fill = control.contourFilled();
            ScalarMap[] smap = new ScalarMap[2];
            ScalarType sc = ((ScalarMap)MapVector.elementAt(valueToMap[i])).getScalar();
            if (fill) {
                for (kk = 0; kk < MapVector.size(); ++kk) {
                    sm = (ScalarMap)MapVector.elementAt(kk);
                    if (sm == null || !sm.getScalar().equals(sc) || !sm.getDisplayScalar().equals(Display.RGB) && !sm.getDisplayScalar().equals(Display.RGBA)) continue;
                    smap[0] = sm;
                }
                if (smap[0] == null) {
                    throw new DisplayException("IsoContour color-fill is enabled, so " + sc + " must also be mapped to Display.RGB");
                }
            }
            for (kk = 0; kk < MapVector.size(); ++kk) {
                sm = (ScalarMap)MapVector.elementAt(kk);
                if (sm == null || !sm.getScalar().equals(sc) || !sm.getDisplayScalar().equals(Display.IsoContour)) continue;
                smap[1] = sm;
            }
            float[][][] f_array = new float[1][][];
            VisADGeometryArray[][] array_s = spatial_set.makeIsoLines(levs, lowhibase[0], lowhibase[1], lowhibase[2], display_values[i], color_values, swap, doStyle[0], fill, smap, scale, label_size, f_array);
            if (array_s == null) {
                return anyContourCreated;
            }
            boolean adjust = this.getAdjustProjectionSeam();
            if (!fill) {
                for (int j = 0; j < array_s.length; ++j) {
                    if (array_s[j] == null) continue;
                    for (int k = 0; k < array_s[j].length; ++k) {
                        VisADGeometryArray arr = array_s[j][k];
                        if (arr != null) {
                            if (adjust) {
                                arr = arr.adjustLongitude(renderer);
                                arr = arr.adjustSeam(renderer);
                            }
                            arr = arr.removeMissing();
                        }
                        array_s[j][k] = arr;
                    }
                }
            }
            VisADGeometryArray[] uBasicLines = array_s[0];
            VisADGeometryArray[] fillLines = array_s[1];
            VisADGeometryArray[] labelLines = null;
            VisADGeometryArray[] sBasicLines = null;
            if (array_s == null) continue;
            switch (array_s.length) {
                case 4: {
                    sBasicLines = array_s[3];
                }
                case 3: {
                    labelLines = array_s[2];
                }
            }
            if (array_s.length <= 0) continue;
            GraphicsModeControl labelMode = (GraphicsModeControl)mode.clone();
            labelMode.setLineStyle(0, false);
            GraphicsModeControl styledMode = (GraphicsModeControl)mode.clone();
            styledMode.setLineStyle(control.getDashedStyle(), false);
            if (fill) {
                labelMode.setPolygonOffsetFactor(10.0f, false);
                labelMode.setPolygonOffset(1.0f, false);
                if (uBasicLines != null) {
                    for (VisADGeometryArray arr : uBasicLines) {
                        if (arr == null) continue;
                        shadow_api.adjustZ(arr.coordinates);
                    }
                }
                if (sBasicLines != null) {
                    for (VisADGeometryArray arr : sBasicLines) {
                        if (arr == null) continue;
                        shadow_api.adjustZ(arr.coordinates);
                    }
                }
            }
            if (uBasicLines != null) {
                for (VisADGeometryArray arr : uBasicLines) {
                    if (arr == null) continue;
                    shadow_api.addToGroup(group, arr, mode, constant_alpha, constant_color);
                }
            }
            array_s[0] = null;
            uBasicLines = null;
            if (sBasicLines != null) {
                for (VisADGeometryArray arr : sBasicLines) {
                    if (arr == null) continue;
                    shadow_api.addToGroup(group, arr, styledMode, constant_alpha, constant_color);
                }
                sBasicLines = null;
                array_s[3] = null;
            }
            if (doLabels && labelLines != null) {
                shadow_api.addLabelsToGroup(group, labelLines, labelMode, control, this.p_cntrl, this.cnt, constant_alpha, constant_color);
                labelLines = null;
                array_s[2] = null;
            } else if (!doLabels && fillLines != null) {
                shadow_api.addToGroup(group, fillLines[0], mode, constant_alpha, constant_color);
                if (fillLines.length == 2) {
                    shadow_api.addToGroup(group, fillLines[1], styledMode, constant_alpha, constant_color);
                    fillLines[1] = null;
                }
                fillLines[0] = null;
                array_s[1] = null;
            }
            array_s = null;
        }
        return anyContourCreated;
    }

    public int textureWidth(int data_width) {
        return data_width;
    }

    public int textureHeight(int data_height) {
        return data_height;
    }

    public int textureDepth(int data_depth) {
        return data_depth;
    }

    public void adjustZ(float[] coordinates) {
    }

    public void setTexCoords(float[] texCoords, float ratiow, float ratioh) {
    }

    public float[] setTex3DCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        return null;
    }

    public float[] setTexStackCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        return null;
    }

    public Vector getTextMaps(int i, int[] textIndices) {
        return new Vector();
    }

    public boolean addToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        return false;
    }

    public void addLabelsToGroup(Object group, VisADGeometryArray[] arrays, GraphicsModeControl mode, ContourControl control, ProjectionControl p_cntrl, int[] cnt, float constant_alpha, float[] contstant_color) throws VisADException {
    }

    public boolean addTextToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        return this.addToGroup(group, array, mode, constant_alpha, constant_color);
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height) throws VisADException {
    }

    public void texture3DToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] images, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
    }

    public void textureStackToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] imagesX, BufferedImage[] imagesY, BufferedImage[] imagesZ, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
    }

    public Object makeSwitch() {
        return null;
    }

    public Object makeBranch() {
        return null;
    }

    public void addToGroup(Object group, Object branch) throws VisADException {
    }

    public void addToSwitch(Object swit, Object branch) throws VisADException {
    }

    public void addSwitch(Object group, Object swit, Control control, Set domain_set, DataRenderer renderer) throws VisADException {
    }

    public boolean recurseRange(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return false;
    }

    public boolean recurseComponent(int i, Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return false;
    }

    public boolean wantIndexed() {
        return false;
    }

    public TextControl getParentTextControl() {
        return null;
    }

    public String getParentText() {
        return null;
    }

    public void setText(String text, TextControl control) {
    }

    public boolean allowCurvedTexture() {
        return true;
    }

    public boolean allowConstantColorSurfaces() {
        return true;
    }

    public boolean allowLinearContour() {
        return true;
    }

    public String toString() {
        return this.getClass() + " for \n  " + this.Type.toString();
    }
}

