/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import visad.CoordinateSystem;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADSceneGraphObject;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;

public class SceneGraphRenderer {
    private final int DEFAULT_WIDTH = 640;
    private final int DEFAULT_HEIGHT = 512;
    protected int width = 640;
    protected int height = 512;
    public static final int MODE_2D = 2;
    public static final int MODE_3D = 3;
    private int mode = 3;
    protected float pixelWidth = 1.0f;
    private Color pageColour;
    private Color frameColour = Color.black;
    Hatching hatching = new Hatching();
    protected boolean monochrome;
    protected boolean gradientFill = false;
    protected boolean useTransparency = true;
    protected ArrayList colours = new ArrayList();
    private GeneralPath linePath;
    protected boolean plotMap = true;
    protected AffineTransform viewPort;
    CoordinateSystem coordSys;
    MouseBehavior behavior;
    private double lineThickness = 1.0;
    private boolean transformToScreenCoords = false;

    private CoordinateSystem getCoordinateSystem() {
        return this.coordSys;
    }

    private AffineTransform getViewport(DisplayImpl displayImpl) {
        ProjectionControl pc = displayImpl.getProjectionControl();
        this.behavior = displayImpl.getDisplayRenderer().getMouseBehavior();
        double[] tstart = pc.getMatrix();
        double[] rotArray = new double[3];
        double[] scaleArray = new double[3];
        double[] transArray = new double[3];
        this.behavior.instance_unmake_matrix(rotArray, scaleArray, transArray, tstart);
        float lScaleX = (float)scaleArray[0];
        float lScaleY = (float)scaleArray[1];
        float lTransX = (float)transArray[0];
        float lTransY = (float)transArray[1];
        this.viewPort = AffineTransform.getTranslateInstance(lTransX, lTransY);
        AffineTransform scale = AffineTransform.getScaleInstance(lScaleX, lScaleY);
        this.viewPort.concatenate(scale);
        AffineTransform rot = AffineTransform.getRotateInstance(Math.toRadians(-rotArray[2]));
        this.viewPort.concatenate(rot);
        float deviceScaleX = (float)this.width / 2.0f;
        float deviceTransX = (float)this.width / 2.0f;
        float deviceTransY = (float)this.height / 2.0f;
        AffineTransform deviceTrans = AffineTransform.getTranslateInstance(deviceTransX, deviceTransY);
        AffineTransform deviceScale = AffineTransform.getScaleInstance(deviceScaleX, -deviceScaleX);
        deviceTrans.concatenate(deviceScale);
        this.viewPort.preConcatenate(deviceTrans);
        return this.viewPort;
    }

    public float[][] getLonLatSamples(int xSize, int ySize) {
        float xScale = (float)this.width / (float)xSize;
        float yScale = (float)this.height / (float)ySize;
        CoordinateSystem coordSys = this.getCoordinateSystem();
        Object lonLatSamples = null;
        try {
            AffineTransform inverse = this.viewPort.createInverse();
            float[] pixelSamples = this.getPixelSamples(xScale, yScale);
            float[] normSamples = new float[xSize * ySize * 2];
            inverse.transform(pixelSamples, 0, normSamples, 0, xSize * ySize);
            float[][] xys = new float[3][normSamples.length / 2];
            for (int i = 0; i < normSamples.length / 2; ++i) {
                xys[0][i] = normSamples[i * 2];
                xys[1][i] = normSamples[i * 2 + 1];
                xys[2][i] = 0.0f;
            }
            float[][] lonLats3d = coordSys.fromReference(xys);
            float[][] lonLats2D = new float[][]{lonLats3d[1], lonLats3d[0]};
            lonLatSamples = lonLats2D;
        }
        catch (NoninvertibleTransformException e) {
            System.err.println("Chart.getLonLatSamples: " + e);
        }
        catch (VisADException e) {
            System.err.println("Chart.getLonLatSamples: " + e);
        }
        return lonLatSamples;
    }

    private float[] getPixelSamples(float xScale, float yScale) {
        int xSize = (int)((float)this.width / xScale);
        int ySize = (int)((float)this.height / yScale);
        float[] samples = new float[xSize * ySize * 2];
        int cnt = 0;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                samples[cnt] = (float)i * xScale;
                samples[cnt + 1] = (float)j * yScale;
                cnt += 2;
            }
        }
        return samples;
    }

    public Color[] getColours() {
        Color[] colourArr = new Color[this.colours.size()];
        this.colours.toArray(colourArr);
        return colourArr;
    }

    public float getLineWidth() {
        return (float)this.lineThickness;
    }

    private GradientPaint makeGradient(Color colour, float x1, float y1, float x2, float y2) {
        float[] rgb = new float[4];
        colour.getRGBColorComponents(rgb);
        float diff = 0.05f;
        float[] darkRGB = new float[]{rgb[0] * (1.0f - diff), rgb[1] * (1.0f - diff), rgb[2] * (1.0f - diff), rgb[3]};
        float[] lightRGB = new float[]{rgb[0] * (1.0f + diff), rgb[1] * (1.0f + diff), rgb[2] * (1.0f + diff), rgb[3]};
        for (int i = 0; i < 4; ++i) {
            if (!((double)lightRGB[i] > 1.0)) continue;
            lightRGB[i] = 1.0f;
        }
        Color dark = new Color(darkRGB[0], darkRGB[1], darkRGB[2]);
        Color light = new Color(lightRGB[0], lightRGB[1], lightRGB[2]);
        GradientPaint gradient = new GradientPaint(x1, y1, dark, x2, y2, light);
        return gradient;
    }

    private void render(Graphics2D graphics, DisplayImpl display) {
        this.copyVisadDisplay(display, graphics);
    }

    public void plot(Graphics2D graphics, DisplayImpl display, CoordinateSystem cs, int width, int height) {
        this.width = width;
        this.height = height;
        this.coordSys = cs;
        this.viewPort = this.getViewport(display);
        int lineThick = (int)this.lineThickness;
        graphics.setClip(0, 0, width, height);
        this.render(graphics, display);
        this.colours.add(this.frameColour);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex, DisplayImpl display, CoordinateSystem cs) {
        this.coordSys = cs;
        this.viewPort = this.getViewport(display);
        if (pageIndex > 0) {
            return 1;
        }
        this.useTransparency = false;
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            float scale = this.scaleToPage(pageFormat, graphics2D, this.width, this.height);
            this.lineThickness = 1.0 / (double)scale;
            graphics2D.setColor(this.pageColour);
            if (this.plotMap) {
                graphics2D.fillRect(0, 0, this.width, this.height);
            }
            graphics2D.setClip(0, 0, this.width, this.height);
            this.render(graphics2D, display);
            boolean transparent = !this.monochrome && this.useTransparency;
            float legendScale = (float)this.lineThickness * 4.0f;
            this.drawEdge(graphics2D, this.width, this.height, (float)this.lineThickness * 4.0f);
            this.colours.add(this.frameColour);
        } else {
            System.err.println("Wrong graphics type! How did THAT happen?");
        }
        return 0;
    }

    private void drawEdge(Graphics2D graphics, int width, int height, float thickness) {
        graphics.setColor(this.frameColour);
        graphics.setStroke(this.getStroke(thickness));
        float top = 0.0f;
        float bottom = height;
        float left = 0.0f;
        float right = width;
        GeneralPath linePath = new GeneralPath();
        linePath.moveTo(left, top);
        linePath.lineTo(right, top);
        linePath.lineTo(right, bottom);
        linePath.lineTo(left, bottom);
        linePath.lineTo(left, top);
        graphics.draw(linePath);
    }

    private float scaleToPage(PageFormat pageFormat, Graphics2D graphics, int xSize, int ySize) {
        int DPI = 300;
        double pageWidth72 = pageFormat.getImageableWidth();
        double pageHeight72 = pageFormat.getImageableHeight();
        double scaleX = pageWidth72 / (double)xSize;
        double scaleY = pageHeight72 / (double)ySize;
        double scale = scaleX;
        if (scaleY < scaleX) {
            scale = scaleY;
        }
        double transX = pageFormat.getImageableX() / scale;
        double transY = pageFormat.getImageableY() / scale;
        graphics.scale(scale, scale);
        graphics.translate(transX, transY);
        float dotsPerUnit = 4.0f;
        return dotsPerUnit * (float)scale;
    }

    public void drawShapeReprojected(float[][] vertices, Color colour, float width, Graphics2D graphics) {
        this.drawShapeReprojected(vertices, colour, width, 0, graphics);
    }

    public void drawShapeReprojected(float[][] vertices, Color colour, float width, int dashStyle, Graphics2D graphics) {
        this.drawShapeReprojected(vertices, colour, width, dashStyle, graphics, false);
    }

    public void drawShapeReprojected(float[][] vertices, Color colour, float width, int dashStyle, Graphics2D graphics, boolean isScreen) {
        graphics.setColor(colour);
        graphics.setStroke(this.getStroke(width, this.getStrokeDash(dashStyle, this.pixelWidth)));
        GeneralPath line = new GeneralPath();
        line.moveTo(vertices[0][0], vertices[1][0]);
        for (int j = 1; j < vertices[0].length; ++j) {
            line.lineTo(vertices[0][j], vertices[1][j]);
        }
        if (!isScreen) {
            line.transform(this.viewPort);
        }
        line = this.clip(line);
        graphics.setColor(colour);
        graphics.draw(line);
    }

    public void drawShape(float[][] vertices, Color colour, float width, int dashStyle, Graphics2D graphics) throws VisADException {
        CoordinateSystem coordSys = this.getCoordinateSystem();
        boolean crosses = this.crossesDiscontinuity(coordSys, vertices);
        if (!crosses) {
            float[][] reprojected = coordSys.toReference(vertices);
            this.drawShapeReprojected(reprojected, colour, width, dashStyle, graphics);
        }
    }

    public void drawShape(float[][] vertices, Color colour, float width, Graphics2D graphics) throws VisADException {
        this.drawShape(vertices, colour, width, 0, graphics);
    }

    public void fillShapeReprojected(float[][] vertices, Color colour, Graphics2D graphics) {
        this.fillShapeReprojected(vertices, colour, graphics, false);
    }

    public void fillShapeReprojected(float[][] vertices, Color colour, Graphics2D graphics, boolean isScreen) {
        if (this.gradientFill) {
            GradientPaint gradient = this.makeGradient(colour, 0.0f, 0.0f, this.width, this.height);
            graphics.setPaint(gradient);
        } else {
            graphics.setColor(colour);
        }
        GeneralPath shape = new GeneralPath();
        if (vertices[0].length > 0) {
            shape.moveTo(vertices[0][0], vertices[1][0]);
            for (int j = 1; j < vertices[0].length; ++j) {
                shape.lineTo(vertices[0][j], vertices[1][j]);
            }
            if (!isScreen) {
                shape.transform(this.viewPort);
            }
            shape = this.clip(shape);
            graphics.fill(shape);
        }
    }

    public void fillShape(float[][] vertices, Color colour, Graphics2D graphics) throws VisADException {
        CoordinateSystem coordSys = this.getCoordinateSystem();
        boolean crosses = this.crossesDiscontinuity(coordSys, vertices);
        if (!crosses) {
            float[][] reprojected = coordSys.toReference(vertices);
            this.fillShapeReprojected(reprojected, colour, graphics);
        }
    }

    private boolean crossesDiscontinuity(CoordinateSystem coordSys, float[][] vertices) {
        boolean crosses = false;
        return crosses;
    }

    private float[] range(float[] array) {
        int numPoints = array.length;
        if (numPoints <= 1) {
            float[] range = new float[]{array[0], array[0]};
            return range;
        }
        float[] clone = (float[])array.clone();
        Arrays.sort(clone);
        float[] range = new float[]{clone[0], clone[clone.length - 1]};
        return range;
    }

    public void fillShapeReprojected(float[][] vertices, int texture, Graphics2D graphics) {
        this.fillShapeReprojected(vertices, texture, graphics, false);
    }

    public void fillShapeReprojected(float[][] vertices, int texture, Graphics2D graphics, boolean isScreen) {
        BufferedImage fillTexture = this.hatching.getPattern(texture);
        Rectangle anchor = new Rectangle(30, 30);
        TexturePaint hatching = new TexturePaint(fillTexture, anchor);
        graphics.setPaint(hatching);
        GeneralPath shape = new GeneralPath();
        shape.moveTo(vertices[0][0], vertices[1][0]);
        for (int j = 1; j < vertices[0].length; ++j) {
            shape.lineTo(vertices[0][j], vertices[1][j]);
        }
        graphics.setPaint(hatching);
        if (!isScreen) {
            shape.transform(this.viewPort);
        }
        shape = this.clip(shape);
        graphics.fill(shape);
    }

    public void fillShape(float[][] data, int texture, Graphics2D graphics) throws VisADException {
        CoordinateSystem coordSys = this.getCoordinateSystem();
        float[][] reprojected = coordSys.toReference(data);
        this.fillShapeReprojected(reprojected, texture, graphics);
    }

    public void drawString(String text, Font font, Color colour, float x, float y, Graphics2D graphics) throws VisADException {
        if (text.length() < 1) {
            return;
        }
        graphics.setColor(colour);
        int size = font.getSize();
        Font scaledFont = font.deriveFont((float)size * this.pixelWidth);
        double[][] coords = new double[3][1];
        coords[0][0] = x;
        coords[1][0] = y;
        coords[2][0] = 0.0;
        graphics.setFont(scaledFont);
        CoordinateSystem coordSys = this.getCoordinateSystem();
        double[][] reprojected = coordSys.toReference(coords);
        double[] normCoords = new double[]{reprojected[0][0], reprojected[1][0]};
        float[] devCoords = new float[2];
        this.viewPort.transform(normCoords, 0, devCoords, 0, 1);
        if (devCoords[0] > 0.0f && devCoords[0] < (float)this.width && devCoords[1] > 0.0f && devCoords[1] < (float)this.height) {
            graphics.drawString(text, devCoords[0], devCoords[1]);
        }
    }

    private void copyVisadDisplay(DisplayImpl display, Graphics2D graphics) {
        int mode = -1;
        if (display instanceof DisplayImplJ3D) {
            mode = 3;
        } else if (display instanceof DisplayImplJ2D) {
            mode = 2;
        }
        DisplayRenderer displayRenderer = null;
        VisADGroup root = null;
        if (mode == 2) {
            displayRenderer = (DisplayRendererJ2D)display.getDisplayRenderer();
            root = ((DisplayRendererJ2D)displayRenderer).getRoot();
        } else {
            displayRenderer = (DisplayRendererJ3D)display.getDisplayRenderer();
            root = ((DisplayRendererJ3D)displayRenderer).getRoot();
        }
        if (mode == 2) {
            this.copyGroup(root, graphics);
        } else if (mode == 3) {
            this.copyGroup((Group)root, graphics);
        }
    }

    private void copyGroup(VisADGroup root, Graphics2D graphics) {
        for (int i = 0; i < root.numChildren(); ++i) {
            VisADSceneGraphObject child = root.getChild(i);
            if (child instanceof VisADAppearance) {
                VisADAppearance appearance = (VisADAppearance)child;
                VisADGeometryArray geometry = appearance.array;
                Color[] colours = this.getColours(appearance, this.monochrome);
                float fsize = geometry instanceof VisADPointArray ? appearance.pointSize : appearance.lineWidth;
                float thickness = fsize / 2.0f;
                this.plot(geometry, colours, thickness, graphics);
            }
            if (!(child instanceof VisADGroup)) continue;
            this.copyGroup((VisADGroup)child, graphics);
        }
    }

    private void copyGroup(Group root, Graphics2D graphics) {
        int numChildren = 0;
        if (root.getCapability(12)) {
            numChildren = root.numChildren();
        }
        int rendered = -1;
        if (root instanceof Switch && (rendered = ((Switch)root).getWhichChild()) == -1) {
            return;
        }
        for (int i = 0; i < numChildren; ++i) {
            Node child = root.getChild(i);
            if (rendered >= 0 && rendered != i) continue;
            if (child instanceof Group) {
                this.copyGroup((Group)child, graphics);
                continue;
            }
            if (!(child instanceof Shape3D)) continue;
            Shape3D shape = (Shape3D)child;
            int numGeoms = 0;
            if (shape.getCapability(12)) {
                numGeoms = shape.numGeometries();
            }
            Appearance appearance = shape.getAppearance();
            Color[] colours = this.getColours(appearance);
            float thickness = this.getLineThickness(appearance);
            int lineStyle = this.getLineStyle(appearance);
            Texture texture = appearance.getTexture();
            for (int j = 0; j < numGeoms; ++j) {
                GeometryArray geom = (GeometryArray)shape.getGeometry(j);
                this.plot(geom, colours, thickness, texture, lineStyle, graphics);
            }
        }
    }

    private Color[] getColours(VisADAppearance appearance, boolean monochrome) {
        Color[] colours = null;
        VisADGeometryArray geometry = appearance.array;
        if (geometry.colors != null) {
            int numColours = geometry.colors.length;
            int numCoords = geometry.coordinates.length;
            int cr = 3;
            if (numColours != numCoords) {
                cr = numColours / (numColours - numCoords);
            }
            colours = new Color[numColours / cr];
            for (int j = 0; j < numColours; j += cr) {
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                if (!monochrome) {
                    red = this.byteToFloat(geometry.colors[j]);
                    green = this.byteToFloat(geometry.colors[j + 1]);
                    blue = this.byteToFloat(geometry.colors[j + 2]);
                }
                colours[j / cr] = new Color(red, green, blue);
            }
        } else {
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (!monochrome) {
                red = appearance.red;
                green = appearance.green;
                blue = appearance.blue;
            }
            colours = new Color[]{new Color(red, green, blue)};
        }
        return colours;
    }

    private Color[] getColours(Appearance appearance) {
        Color[] colours = null;
        ColoringAttributes colourAttr = appearance.getColoringAttributes();
        int colourFlag = 0;
        TransparencyAttributes transAttr = appearance.getTransparencyAttributes();
        boolean transMFlag = false;
        int transVFlag = 2;
        if (colourAttr != null && colourAttr.getCapability(colourFlag)) {
            Color3f color3f = new Color3f();
            colourAttr.getColor(color3f);
            colours = new Color[1];
            Color color3 = color3f.get();
            float[] colourComps = new float[4];
            colourComps = color3.getColorComponents(colourComps);
            colourComps[3] = 1.0f;
            colours[0] = new Color(colourComps[0], colourComps[1], colourComps[2], colourComps[3]);
        }
        return colours;
    }

    private float getLineThickness(Appearance appearance) {
        float thickness = 0.0f;
        LineAttributes lineAttr = appearance.getLineAttributes();
        if (lineAttr.getCapability(0)) {
            thickness = lineAttr.getLineWidth();
        }
        return thickness;
    }

    private int getLineStyle(Appearance appearance) {
        LineAttributes lineAttr = appearance.getLineAttributes();
        int lineStyle = 0;
        if (lineAttr.getCapability(2)) {
            lineStyle = lineAttr.getLinePattern();
        }
        return lineStyle;
    }

    private float byteToFloat(byte byteVal) {
        float floatVal = 0.0f;
        floatVal = byteVal >= 0 ? (float)byteVal / 256.0f : (float)(byteVal + 256) / 256.0f;
        return floatVal;
    }

    private void plot(VisADGeometryArray geometryArray, Color[] colours, float thickness, Graphics2D graphics) {
        if (geometryArray instanceof VisADPointArray) {
            VisADPointArray pointArray = (VisADPointArray)geometryArray;
            this.plot(pointArray, colours, thickness, graphics);
        } else if (geometryArray instanceof VisADLineStripArray) {
            VisADLineStripArray lineArray = (VisADLineStripArray)geometryArray;
            this.plot(lineArray, colours, thickness, graphics);
        } else if (geometryArray instanceof VisADLineArray) {
            VisADLineArray lineArray = (VisADLineArray)geometryArray;
            this.plot(lineArray, colours, thickness, graphics);
        } else if (geometryArray instanceof VisADTriangleStripArray) {
            VisADTriangleStripArray triangleArray = (VisADTriangleStripArray)geometryArray;
            this.plot(triangleArray, colours, thickness, graphics);
        } else if (geometryArray instanceof VisADIndexedTriangleStripArray) {
            VisADIndexedTriangleStripArray triangleArray = (VisADIndexedTriangleStripArray)geometryArray;
            this.plot(triangleArray, colours, thickness, graphics);
        } else if (geometryArray instanceof VisADTriangleArray) {
            VisADTriangleArray triangleArray = (VisADTriangleArray)geometryArray;
            this.plot(triangleArray, colours, thickness, graphics);
        }
    }

    private void plot(GeometryArray geometryArray, Color[] colours, float thickness, Texture texture, int lineStyle, Graphics2D graphics) {
        if (geometryArray instanceof LineArray) {
            LineArray lineArray = (LineArray)geometryArray;
            this.plot(lineArray, colours, thickness, lineStyle, graphics);
        } else if (geometryArray instanceof TriangleArray) {
            TriangleArray triangleArray = (TriangleArray)geometryArray;
            this.plot(triangleArray, colours, thickness, graphics);
        } else if (geometryArray instanceof QuadArray) {
            QuadArray quadArray = (QuadArray)geometryArray;
            if (texture == null) {
                this.plot(quadArray, colours, thickness, graphics);
            }
        } else if (geometryArray instanceof LineStripArray) {
            LineStripArray lineStripArray = (LineStripArray)geometryArray;
            this.plot(lineStripArray, colours, thickness, lineStyle, graphics);
        } else if (geometryArray instanceof TriangleStripArray) {
            TriangleStripArray triangleArray = (TriangleStripArray)geometryArray;
            if (texture == null) {
                this.plot(triangleArray, colours, thickness, graphics);
            }
        } else if (geometryArray instanceof IndexedTriangleStripArray) {
            IndexedTriangleStripArray triangleArray = (IndexedTriangleStripArray)geometryArray;
            this.plot(triangleArray, colours, thickness, graphics);
        } else if (geometryArray instanceof PointArray) {
            PointArray pointArray = (PointArray)geometryArray;
            this.plot(pointArray, colours, thickness, graphics);
        }
    }

    private void plot(VisADPointArray pointArray, Color[] colours, float size, Graphics2D graphics) {
        graphics.setColor(colours[0]);
        graphics.setStroke(this.getStroke(this.pixelWidth));
        float[] coordinates = pointArray.coordinates;
        float hsize = 0.5f * size;
        for (int i = 0; i < coordinates.length / 3; ++i) {
            float normalX = coordinates[i * 3];
            float normalY = coordinates[i * 3 + 1];
            graphics.fill(new Rectangle2D.Float(normalX - hsize, normalY - hsize, size, size));
        }
    }

    private void plot(VisADLineStripArray lineArray, Color[] colours, float thickness, Graphics2D graphics) {
        graphics.setColor(colours[0]);
        graphics.setStroke(this.getStroke(thickness));
        float[] coordinates = lineArray.coordinates;
        int[] vertexCounts = lineArray.stripVertexCounts;
        int base = 0;
        for (int i = 0; i < vertexCounts.length; ++i) {
            int numCoords = vertexCounts[i];
            if (i < colours.length) {
                graphics.setColor(colours[i]);
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(coordinates[base], coordinates[base + 1]);
            boolean visible = false;
            float nxLast = coordinates[base];
            float nyLast = coordinates[base + 1];
            for (int j = 0; j < numCoords; ++j) {
                float nX = coordinates[base + j * 3];
                float nY = coordinates[base + j * 3 + 1];
                if (this.visible(nxLast, nyLast, nX, nY, graphics)) {
                    visible = true;
                }
                path.lineTo(nX, nY);
                nxLast = nX;
                nyLast = nY;
            }
            if (visible) {
                path.transform(this.viewPort);
                graphics.draw(path);
            }
            base += 3 * numCoords;
        }
    }

    private void plot(VisADLineArray lineArray, Color[] colours, float thickness, Graphics2D graphics) {
        graphics.setColor(colours[0]);
        graphics.setStroke(this.getStroke(thickness));
        float[] coordinates = lineArray.coordinates;
        int numCoords = lineArray.vertexCount;
        for (int j = 0; j < numCoords; j += 2) {
            float nY2;
            float nX2;
            float nY1;
            float nX1;
            if (j < colours.length) {
                graphics.setColor(colours[j]);
            }
            if (!this.visible(nX1 = coordinates[j * 3], nY1 = coordinates[j * 3 + 1], nX2 = coordinates[j * 3 + 3], nY2 = coordinates[j * 3 + 4], graphics)) continue;
            GeneralPath path = new GeneralPath();
            path.moveTo(nX1, nY1);
            path.lineTo(nX2, nY2);
            path.transform(this.viewPort);
            graphics.draw(path);
        }
    }

    private void plot(VisADTriangleStripArray triangleArray, Color[] colours, float thickness, Graphics2D graphics) {
        graphics.setColor(colours[0]);
        graphics.setStroke(this.getStroke(thickness));
        float[] coordinates = triangleArray.coordinates;
        int[] vertexCounts = triangleArray.stripVertexCounts;
        int base = 0;
        for (int i = 0; i < vertexCounts.length; ++i) {
            int numCoords = vertexCounts[i];
            float normalLastX = coordinates[base];
            float normalLastY = coordinates[base + 1];
            GeneralPath path = new GeneralPath();
            path.moveTo(normalLastX, normalLastY);
            for (int j = 0; j < numCoords; ++j) {
                float normalX = coordinates[base + j * 3];
                float normalY = coordinates[base + j * 3 + 1];
                normalLastX = normalX;
                normalLastY = normalY;
                path.lineTo(normalX, normalY);
            }
            path.closePath();
            path.transform(this.viewPort);
            graphics.fill(path);
            base += 3 * numCoords;
        }
    }

    private void plot(VisADTriangleArray triangleArray, Color[] colours, float thickness, Graphics2D graphics) {
        float[] colour = new float[4];
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
            if (!this.useTransparency) {
                colour[3] = 1.0f;
            }
        }
        graphics.setStroke(this.getStroke(thickness));
        int vertexCount = triangleArray.vertexCount;
        float[] coordinates = triangleArray.coordinates;
        for (int i = 0; i < 3 * vertexCount; i += 9) {
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            Color color = new Color(colour[0], colour[1], colour[2], colour[3]);
            graphics.setColor(color);
            float[][] vertices = new float[3][3];
            vertices[0][0] = coordinates[i];
            vertices[1][0] = coordinates[i + 1];
            vertices[0][1] = coordinates[i + 3];
            vertices[1][1] = coordinates[i + 4];
            vertices[0][2] = coordinates[i + 6];
            vertices[1][2] = coordinates[i + 7];
            int clockwise = this.clockwise(vertices[0], vertices[1]);
            if (clockwise >= 0) {
                vertices[0] = this.reverseDirection(vertices[0]);
                vertices[1] = this.reverseDirection(vertices[1]);
            }
            this.fillShapeReprojected(vertices, color, graphics);
        }
    }

    private void plot(VisADIndexedTriangleStripArray triangleArray, Color[] colours, float thickness, Graphics2D graphics) {
        graphics.setColor(colours[0]);
        graphics.setStroke(this.getStroke(thickness));
        float[] coordinates = triangleArray.coordinates;
        int[] indices = triangleArray.indices;
        int[] stripVertexCounts = triangleArray.stripVertexCounts;
        int base = 0;
        for (int strip = 0; strip < stripVertexCounts.length; ++strip) {
            if (strip < colours.length) {
                graphics.setColor(colours[strip]);
            }
            int count = stripVertexCounts[strip];
            int index0 = indices[base];
            int index1 = indices[base + 1];
            GeneralPath path = new GeneralPath(0);
            boolean visible = false;
            for (int i = base + 2; i < base + count; ++i) {
                int index2 = indices[i];
                float normalX0 = coordinates[3 * index0];
                float normalY0 = coordinates[3 * index0 + 1];
                float normalX1 = coordinates[3 * index1];
                float normalY1 = coordinates[3 * index1 + 1];
                float normalX2 = coordinates[3 * index2];
                float normalY2 = coordinates[3 * index2 + 1];
                path.moveTo(normalX0, normalY0);
                path.lineTo(normalX1, normalY1);
                path.lineTo(normalX2, normalY2);
                visible = true;
                index0 = index1;
                index1 = index2;
            }
            if (visible) {
                path.transform(this.viewPort);
                path.closePath();
            }
            base += count;
        }
    }

    private void plot(LineStripArray lineArray, Color[] colours, float thickness, int lineStyle, Graphics2D graphics) {
        int numRefColours;
        int vertexCount = lineArray.getVertexCount();
        boolean hasAlpha = this.hasAlpha((GeometryArray)lineArray);
        boolean byRef = this.isByReference((GeometryArray)lineArray);
        int nCoords = 3 * vertexCount;
        float[] coordinates = null;
        if (byRef) {
            coordinates = lineArray.getCoordRefFloat();
        } else {
            coordinates = new float[nCoords];
            lineArray.getCoordinates(0, coordinates);
        }
        coordinates = this.transformToScreen(coordinates);
        int numStrips = lineArray.getNumStrips();
        int[] vertexCounts = new int[numStrips];
        lineArray.getStripVertexCounts(vertexCounts);
        int base = 0;
        int baseColor = 0;
        float[] colour = new float[4];
        byte[] refColours = null;
        int n = numRefColours = hasAlpha ? 4 : 3;
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
        } else if (byRef) {
            refColours = lineArray.getColorRefByte();
        }
        if (!hasAlpha || !this.useTransparency) {
            colour[3] = 1.0f;
        }
        if (this.monochrome) {
            this.monochromatise(colour);
        }
        for (int i = 0; i < vertexCounts.length; ++i) {
            int numCoords = vertexCounts[i];
            if (colours == null) {
                if (refColours != null) {
                    for (int j = 0; j < numRefColours; ++j) {
                        colour[j] = this.byteToFloat(refColours[baseColor + j]);
                    }
                } else {
                    lineArray.getColor(i, colour);
                }
            }
            if (!this.useTransparency || !hasAlpha) {
                colour[3] = 1.0f;
            }
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            Color color = new Color(colour[0], colour[1], colour[2], colour[3]);
            float[][] vertices = new float[2][numCoords];
            for (int j = 0; j < numCoords; ++j) {
                vertices[0][j] = coordinates[base + j * 3];
                vertices[1][j] = coordinates[base + j * 3 + 1];
            }
            this.drawShapeReprojected(vertices, color, thickness, lineStyle, graphics, this.transformToScreenCoords);
            base += 3 * numCoords;
            baseColor += numRefColours * numCoords;
        }
    }

    private void plot(LineArray lineArray, Color[] colours, float thickness, int lineStyle, Graphics2D graphics) {
        boolean hasAlpha = this.hasAlpha((GeometryArray)lineArray);
        boolean byRef = this.isByReference((GeometryArray)lineArray);
        float[] colour = new float[4];
        byte[] refColours = null;
        int numRefColours = hasAlpha ? 4 : 3;
        int baseColor = 0;
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
        } else if (byRef) {
            refColours = lineArray.getColorRefByte();
            for (int i = 0; i < numRefColours; ++i) {
                colour[i] = this.byteToFloat(refColours[i]);
            }
        } else {
            lineArray.getColor(0, colour);
        }
        if (!this.useTransparency || !hasAlpha) {
            colour[3] = 1.0f;
        }
        if (this.monochrome) {
            this.monochromatise(colour);
        }
        graphics.setStroke(this.getStroke(thickness * 0.5f, this.getStrokeDash(lineStyle, this.pixelWidth)));
        int vertexCount = lineArray.getVertexCount();
        int nCoords = 3 * vertexCount;
        float[] coordinates = null;
        if (byRef) {
            coordinates = lineArray.getCoordRefFloat();
        } else {
            coordinates = new float[nCoords];
            lineArray.getCoordinates(0, coordinates);
        }
        coordinates = this.transformToScreen(coordinates);
        Color lastColor = new Color(colour[0], colour[1], colour[2], colour[3]);
        this.linePath = new GeneralPath();
        graphics.setColor(lastColor);
        for (int j = 0; j < vertexCount; j += 2) {
            float nY2;
            float nX2;
            float nY1;
            float nX1;
            Color color;
            if (colours == null) {
                if (refColours != null) {
                    for (int i = 0; i < numRefColours; ++i) {
                        colour[i] = this.byteToFloat(refColours[baseColor + i]);
                    }
                } else {
                    lineArray.getColor(j, colour);
                }
            }
            if (!this.useTransparency || !hasAlpha) {
                colour[3] = 1.0f;
            }
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            if (!(color = new Color(colour[0], colour[1], colour[2], colour[3])).equals(lastColor)) {
                graphics.setColor(lastColor);
                lastColor = color;
                if (!this.transformToScreenCoords) {
                    this.linePath.transform(this.viewPort);
                }
                graphics.draw(this.linePath);
                this.linePath = new GeneralPath();
            }
            if (!this.visible(nX1 = coordinates[j * 3], nY1 = coordinates[j * 3 + 1], nX2 = coordinates[j * 3 + 3], nY2 = coordinates[j * 3 + 4], graphics, this.transformToScreenCoords)) continue;
            this.linePath.moveTo(nX1, nY1);
            this.linePath.lineTo(nX2, nY2);
            baseColor += numRefColours * 2;
        }
        if (!this.transformToScreenCoords) {
            this.linePath.transform(this.viewPort);
        }
        graphics.draw(this.linePath);
    }

    private void plot(TriangleStripArray triangleArray, Color[] colours, float thickness, Graphics2D graphics) {
        int vertexFormat = triangleArray.getVertexFormat();
        if ((vertexFormat & 0x20) == 32) {
            return;
        }
        boolean hasAlpha = this.hasAlpha((GeometryArray)triangleArray);
        boolean byRef = this.isByReference((GeometryArray)triangleArray);
        byte[] refColours = null;
        int numRefColours = hasAlpha ? 4 : 3;
        int baseColor = 0;
        float[] colour = new float[4];
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
        } else if (byRef) {
            refColours = triangleArray.getColorRefByte();
        }
        if (!this.useTransparency || !hasAlpha) {
            colour[3] = 1.0f;
        }
        if (this.monochrome) {
            this.monochromatise(colour);
        }
        graphics.setStroke(this.getStroke(thickness));
        int vertexCount = triangleArray.getVertexCount();
        int nCoords = 3 * vertexCount;
        float[] coordinates = null;
        if (byRef) {
            coordinates = triangleArray.getCoordRefFloat();
        } else {
            coordinates = new float[nCoords];
            triangleArray.getCoordinates(0, coordinates);
        }
        coordinates = this.transformToScreen(coordinates);
        int cCount = 0;
        int numStrips = triangleArray.getNumStrips();
        int[] vertexCounts = new int[numStrips];
        triangleArray.getStripVertexCounts(vertexCounts);
        int base = 0;
        for (int i = 0; i < numStrips; ++i) {
            int numCoords = vertexCounts[i];
            if (colours == null) {
                if (refColours != null) {
                    for (int j = 0; j < numRefColours; ++j) {
                        colour[j] = this.byteToFloat(refColours[baseColor + j]);
                    }
                } else {
                    triangleArray.getColor(cCount++, colour);
                }
            }
            if (!this.useTransparency || !hasAlpha) {
                colour[3] = 1.0f;
            }
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            Color color = new Color(colour[0], colour[1], colour[2], colour[3]);
            graphics.setColor(color);
            float lastNormX2 = coordinates[base];
            float lastNormY2 = coordinates[base + 1];
            float lastNormX1 = coordinates[base + 3];
            float lastNormY1 = coordinates[base + 3 + 1];
            for (int j = 2; j < numCoords; ++j) {
                float normalX = coordinates[base + j * 3];
                float normalY = coordinates[base + j * 3 + 1];
                float[][] triangle = new float[3][3];
                triangle[0][0] = lastNormX1;
                triangle[1][0] = lastNormY1;
                triangle[0][1] = lastNormX2;
                triangle[1][1] = lastNormY2;
                triangle[0][2] = normalX;
                triangle[1][2] = normalY;
                lastNormX2 = lastNormX1;
                lastNormX1 = normalX;
                lastNormY2 = lastNormY1;
                lastNormY1 = normalY;
                this.fillShapeReprojected(triangle, color, graphics, this.transformToScreenCoords);
            }
            base += 3 * numCoords;
            baseColor += numRefColours * numCoords;
        }
    }

    private void plot(TriangleArray triangleArray, Color[] colours, float thickness, Graphics2D graphics) {
        boolean hasAlpha = this.hasAlpha((GeometryArray)triangleArray);
        boolean byRef = this.isByReference((GeometryArray)triangleArray);
        byte[] refColours = null;
        int numRefColours = hasAlpha ? 4 : 3;
        int baseColor = 0;
        float[] colour = new float[4];
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
        } else if (byRef) {
            refColours = triangleArray.getColorRefByte();
        }
        if (!hasAlpha || !this.useTransparency) {
            colour[3] = 1.0f;
        }
        if (this.monochrome) {
            this.monochromatise(colour);
        }
        graphics.setStroke(this.getStroke(thickness));
        int vertexCount = triangleArray.getVertexCount();
        int nCoords = 3 * vertexCount;
        float[] coordinates = null;
        if (byRef) {
            coordinates = triangleArray.getCoordRefFloat();
        } else {
            coordinates = new float[nCoords];
            triangleArray.getCoordinates(0, coordinates);
        }
        coordinates = this.transformToScreen(coordinates);
        for (int i = 0; i < 3 * vertexCount; i += 9) {
            if (colours == null) {
                if (refColours != null) {
                    for (int j = 0; j < numRefColours; ++j) {
                        colour[j] = this.byteToFloat(refColours[baseColor + j]);
                    }
                } else {
                    triangleArray.getColor(i / 3, colour);
                }
            }
            if (!this.useTransparency || !hasAlpha) {
                colour[3] = 1.0f;
            }
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            Color color = new Color(colour[0], colour[1], colour[2], colour[3]);
            graphics.setColor(color);
            float[][] vertices = new float[2][3];
            vertices[0][0] = coordinates[i];
            vertices[1][0] = coordinates[i + 1];
            vertices[0][1] = coordinates[i + 3];
            vertices[1][1] = coordinates[i + 4];
            vertices[0][2] = coordinates[i + 6];
            vertices[1][2] = coordinates[i + 7];
            int clockwise = this.clockwise(vertices[0], vertices[1]);
            if (clockwise >= 0) {
                vertices[0] = this.reverseDirection(vertices[0]);
                vertices[1] = this.reverseDirection(vertices[1]);
            }
            this.fillShapeReprojected(vertices, color, graphics, this.transformToScreenCoords);
            baseColor += 3 * numRefColours;
        }
    }

    private void plot(QuadArray quadArray, Color[] colours, float thickness, Graphics2D graphics) {
        boolean hasAlpha = this.hasAlpha((GeometryArray)quadArray);
        boolean byRef = this.isByReference((GeometryArray)quadArray);
        byte[] refColours = null;
        int numRefColours = hasAlpha ? 4 : 3;
        int baseColor = 0;
        float[] colour = new float[4];
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
        } else if (byRef) {
            refColours = quadArray.getColorRefByte();
        }
        if (!this.useTransparency || !hasAlpha) {
            colour[3] = 1.0f;
        }
        if (this.monochrome) {
            this.monochromatise(colour);
        }
        graphics.setStroke(this.getStroke(thickness));
        int vertexCount = quadArray.getVertexCount();
        int nCoords = 3 * vertexCount;
        float[] coordinates = null;
        if (byRef) {
            coordinates = quadArray.getCoordRefFloat();
        } else {
            coordinates = new float[nCoords];
            quadArray.getCoordinates(0, coordinates);
        }
        coordinates = this.transformToScreen(coordinates);
        for (int i = 0; i < 3 * vertexCount; i += 12) {
            if (colours == null) {
                if (refColours != null) {
                    for (int j = 0; j < numRefColours; ++j) {
                        colour[j] = this.byteToFloat(refColours[baseColor + j]);
                    }
                } else {
                    quadArray.getColor(i / 4, colour);
                }
            }
            if (!this.useTransparency || !hasAlpha) {
                colour[3] = 1.0f;
            }
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            Color color = new Color(colour[0], colour[1], colour[2], colour[3]);
            graphics.setColor(color);
            float[][] vertices = new float[2][4];
            vertices[0][0] = coordinates[i];
            vertices[1][0] = coordinates[i + 1];
            vertices[0][1] = coordinates[i + 3];
            vertices[1][1] = coordinates[i + 4];
            vertices[0][2] = coordinates[i + 6];
            vertices[1][2] = coordinates[i + 7];
            vertices[0][3] = coordinates[i + 9];
            vertices[1][3] = coordinates[i + 10];
            int clockwise = this.clockwise(vertices[0], vertices[1]);
            if (clockwise >= 0) {
                vertices[0] = this.reverseDirection(vertices[0]);
                vertices[1] = this.reverseDirection(vertices[1]);
            }
            this.fillShapeReprojected(vertices, color, graphics, this.transformToScreenCoords);
            baseColor += 4 * numRefColours;
        }
    }

    private void plot(PointArray pointArray, Color[] colours, float size, Graphics2D graphics) {
        boolean hasAlpha = this.hasAlpha((GeometryArray)pointArray);
        boolean byRef = this.isByReference((GeometryArray)pointArray);
        Object refColours = null;
        int numRefColours = hasAlpha ? 4 : 3;
        boolean baseColor = false;
        float[] colour = new float[4];
        if (colours != null) {
            colour[0] = (float)colours[0].getRed() / 255.0f;
            colour[1] = (float)colours[0].getGreen() / 255.0f;
            colour[2] = (float)colours[0].getBlue() / 255.0f;
            colour[3] = (float)colours[0].getAlpha() / 255.0f;
        }
        if (!hasAlpha || !this.useTransparency) {
            colour[3] = 1.0f;
        }
        if (this.monochrome) {
            this.monochromatise(colour);
        }
        int vertexCount = pointArray.getVertexCount();
        int nCoords = 3 * vertexCount;
        float[] coordinates = null;
        if (byRef) {
            coordinates = pointArray.getCoordRefFloat();
        } else {
            coordinates = new float[nCoords];
            pointArray.getCoordinates(0, coordinates);
        }
        coordinates = this.transformToScreen(coordinates);
        graphics.setStroke(this.getStroke(size));
        float hsize = 0.5f * size;
        for (int i = 0; i < vertexCount; ++i) {
            float x = coordinates[i * 3];
            float y = coordinates[i * 3 + 1];
            float[] vertices = new float[]{x, y};
            if (!this.transformToScreenCoords) {
                float[] device = new float[2];
                this.viewPort.transform(new float[]{x, y}, 0, vertices, 0, 1);
            }
            if (colours == null) {
                if (refColours != null) {
                    for (int j = 0; j < numRefColours; ++j) {
                        colour[j] = this.byteToFloat((byte)refColours[i * numRefColours + j]);
                    }
                } else {
                    pointArray.getColor(i, colour);
                }
            }
            if (!this.useTransparency || !hasAlpha) {
                colour[3] = 1.0f;
            }
            if (this.monochrome) {
                this.monochromatise(colour);
            }
            Color color = new Color(colour[0], colour[1], colour[2], colour[3]);
            graphics.setColor(color);
            graphics.fill(new Rectangle2D.Float(x - hsize, y - hsize, size, size));
        }
    }

    private boolean hasAlpha(GeometryArray array) {
        int vertexFormat = array.getVertexFormat();
        return (vertexFormat & 0xC) == 12;
    }

    private boolean isByReference(GeometryArray array) {
        int vertexFormat = array.getVertexFormat();
        return (vertexFormat & 0x80) != 0;
    }

    private void plot(IndexedTriangleStripArray triangleArray, Color[] colours, float thickness, Graphics2D graphics) {
    }

    private BasicStroke getStroke(float thickness) {
        BasicStroke stroke = new BasicStroke(thickness * (float)this.lineThickness, 0, 0);
        return stroke;
    }

    private BasicStroke getStroke(float thickness, float[] dash) {
        BasicStroke stroke = new BasicStroke(thickness * (float)this.lineThickness, 1, 1, 1.0f, dash, 5.0f);
        return stroke;
    }

    private void monochromatise(float[] colour) {
        if (colour[0] < 0.8f && colour[1] < 0.8f && colour[2] < 0.8f) {
            colour[0] = 0.0f;
            colour[1] = 0.0f;
            colour[2] = 0.0f;
        }
        if (colour.length == 4) {
            colour[3] = 1.0f;
        }
    }

    private int clockwise(float[] xCoords, float[] yCoords) {
        int ccw = 0;
        int numCoords = xCoords.length;
        for (int i = 0; i < numCoords; ++i) {
            int j = (i + 1) % numCoords;
            int k = (i + 2) % numCoords;
            float crossProduct = (xCoords[j] - xCoords[i]) * (yCoords[k] - yCoords[j]);
            if ((crossProduct -= (yCoords[j] - yCoords[i]) * (xCoords[k] - xCoords[j])) > 0.0f) {
                ++ccw;
                continue;
            }
            if (!(crossProduct < 0.0f)) continue;
            --ccw;
        }
        int clockwise = 0;
        if (ccw > 0) {
            clockwise = -1;
        } else if (ccw < 0) {
            clockwise = 1;
        }
        return clockwise;
    }

    private int clockwise(int[] xCoords, int[] yCoords) {
        int ccw = 0;
        int numCoords = xCoords.length;
        for (int i = 0; i < numCoords; ++i) {
            int j = (i + 1) % numCoords;
            int k = (i + 2) % numCoords;
            float crossProduct = (xCoords[j] - xCoords[i]) * (yCoords[k] - yCoords[j]);
            if ((crossProduct -= (float)((yCoords[j] - yCoords[i]) * (xCoords[k] - xCoords[j]))) > 0.0f) {
                ++ccw;
                continue;
            }
            if (!(crossProduct < 0.0f)) continue;
            --ccw;
        }
        int clockwise = 0;
        if (ccw > 0) {
            clockwise = -1;
        } else if (ccw < 0) {
            clockwise = 1;
        }
        return clockwise;
    }

    private int[] reverseDirection(int[] coords) {
        int temp = coords[2];
        coords[2] = coords[1];
        coords[1] = temp;
        return coords;
    }

    private float[] reverseDirection(float[] coords) {
        int numCoords = coords.length;
        float[] temp = new float[numCoords];
        for (int i = 0; i < numCoords; ++i) {
            temp[i] = coords[numCoords - i - 1];
        }
        return temp;
    }

    private boolean visible(double x1, double y1, double x2, double y2, Graphics2D graphics) {
        return this.visible(x1, y1, x2, y2, graphics, false);
    }

    private boolean visible(double x1, double y1, double x2, double y2, Graphics2D graphics, boolean isScreen) {
        double[] coords = new double[]{x1, y1, x2, y2};
        double[] device = new double[4];
        if (!isScreen) {
            this.viewPort.transform(coords, 0, device, 0, 2);
        } else {
            device = coords;
        }
        double xMin = Math.min(device[0], device[2]);
        double xMax = Math.max(device[0], device[2]);
        double yMin = Math.min(device[1], device[3]);
        double yMax = Math.max(device[1], device[3]);
        int x = (int)xMin;
        int y = (int)yMin;
        int width = (int)(xMax - xMin) + 1;
        int height = (int)(yMax - yMin) + 1;
        boolean visible = graphics.hitClip(x, y, width, height);
        return visible;
    }

    private boolean visible(Shape shape) {
        boolean visible = shape.intersects(0.0, 0.0, this.width, this.height);
        return visible;
    }

    private boolean visible(int[] xCoords, int[] yCoords, Graphics2D graphics) {
        int numVertices = xCoords.length;
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (int i = 0; i < numVertices; ++i) {
            float[] display = new float[]{xCoords[i], yCoords[i]};
            float[] device = new float[2];
            this.viewPort.transform(display, 0, device, 0, 2);
            if (device[0] > (float)xMax) {
                xMax = (int)device[0];
            }
            if (device[0] < (float)xMin) {
                xMin = (int)device[0];
            }
            if (device[1] > (float)yMax) {
                yMax = (int)device[1];
            }
            if (!(device[1] < (float)yMin)) continue;
            yMin = (int)device[1];
        }
        int x = xMin;
        int y = yMin;
        int width = xMax - xMin + 1;
        int height = yMax - yMin + 1;
        boolean visible = graphics.hitClip(x, y, width, height);
        return visible;
    }

    private int[][] clip(int[][] inVertexArray) {
        int[][] edge = new int[2][2];
        edge[0][0] = 0;
        edge[1][0] = this.height;
        edge[0][1] = 0;
        edge[1][1] = 0;
        inVertexArray = this.SutherlandHodgmanPolygonClip(inVertexArray, edge);
        edge[0][0] = 0;
        edge[1][0] = 0;
        edge[0][1] = this.width;
        edge[1][1] = 0;
        inVertexArray = this.SutherlandHodgmanPolygonClip(inVertexArray, edge);
        edge[0][0] = this.width;
        edge[1][0] = 0;
        edge[0][1] = this.width;
        edge[1][1] = this.height;
        inVertexArray = this.SutherlandHodgmanPolygonClip(inVertexArray, edge);
        edge[0][0] = this.width;
        edge[1][0] = this.height;
        edge[0][1] = this.width;
        edge[1][1] = this.height;
        inVertexArray = this.SutherlandHodgmanPolygonClip(inVertexArray, edge);
        return inVertexArray;
    }

    private GeneralPath clip(GeneralPath path) {
        float[][] edge = new float[2][2];
        edge[0][0] = 0.0f;
        edge[1][0] = this.height * 10;
        edge[0][1] = 0.0f;
        edge[1][1] = -(this.height * 10);
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        edge[0][0] = -(this.width * 10);
        edge[1][0] = 0.0f;
        edge[0][1] = this.width * 10;
        edge[1][1] = 0.0f;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        edge[0][0] = this.width * 10;
        edge[1][0] = -(this.height * 10);
        edge[0][1] = this.width * 10;
        edge[1][1] = this.height * 10;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        edge[0][0] = this.width * 10;
        edge[1][0] = this.height * 10;
        edge[0][1] = -(this.width * 10);
        edge[1][1] = this.height * 10;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        return path;
    }

    private GeneralPath clip2(GeneralPath path) {
        float[][] edge = new float[2][2];
        edge[0][0] = 0.0f;
        edge[1][0] = this.height;
        edge[0][1] = 0.0f;
        edge[1][1] = 0.0f;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        edge[0][0] = 0.0f;
        edge[1][0] = 0.0f;
        edge[0][1] = this.width;
        edge[1][1] = 0.0f;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        edge[0][0] = this.width;
        edge[1][0] = 0.0f;
        edge[0][1] = this.width;
        edge[1][1] = this.height;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        edge[0][0] = this.width;
        edge[1][0] = this.height;
        edge[0][1] = 0.0f;
        edge[1][1] = this.height;
        path = this.SutherlandHodgmanPolygonClip(path, edge);
        return path;
    }

    private int[][] SutherlandHodgmanPolygonClip(int[][] inVertexArray, int[][] edge) {
        int numVertices = inVertexArray[0].length;
        int[][] outVertexArray = null;
        if (numVertices <= 1) {
            outVertexArray = new int[1][0];
            return outVertexArray;
        }
        ArrayList<Integer> xList = new ArrayList<Integer>();
        ArrayList<Integer> yList = new ArrayList<Integer>();
        int xs = inVertexArray[0][inVertexArray[0].length - 1];
        int ys = inVertexArray[1][inVertexArray[0].length - 1];
        for (int j = 0; j < inVertexArray[0].length; ++j) {
            int[] inter;
            int xp = inVertexArray[0][j];
            int yp = inVertexArray[1][j];
            if (this.insideEdge(xp, yp, edge)) {
                if (this.insideEdge(xs, ys, edge)) {
                    xList.add(new Integer(xp));
                    yList.add(new Integer(yp));
                } else {
                    inter = this.intersect(new int[]{xs, ys}, new int[]{xp, yp}, edge);
                    xList.add(new Integer(inter[0]));
                    yList.add(new Integer(inter[1]));
                    xList.add(new Integer(xp));
                    yList.add(new Integer(yp));
                }
            } else if (this.insideEdge(xs, ys, edge)) {
                inter = this.intersect(new int[]{xs, ys}, new int[]{xp, yp}, edge);
                xList.add(new Integer(inter[0]));
                yList.add(new Integer(inter[1]));
            }
            xs = xp;
            ys = yp;
        }
        outVertexArray = new int[2][xList.size()];
        for (int i = 0; i < xList.size(); ++i) {
            Integer xInt = (Integer)xList.get(i);
            Integer yInt = (Integer)yList.get(i);
            outVertexArray[0][i] = xInt;
            outVertexArray[1][i] = yInt;
        }
        return outVertexArray;
    }

    private GeneralPath SutherlandHodgmanPolygonClip(GeneralPath path, float[][] edge) {
        ArrayList<Float> xList = new ArrayList<Float>();
        ArrayList<Float> yList = new ArrayList<Float>();
        AffineTransform blank = AffineTransform.getScaleInstance(1.0, 1.0);
        PathIterator iterator = path.getPathIterator(blank);
        float[] coords = new float[6];
        iterator.currentSegment(coords);
        float xs = coords[0];
        float ys = coords[1];
        iterator.next();
        if (this.insideEdge(xs, ys, edge)) {
            xList.add(new Float(xs));
            yList.add(new Float(ys));
        }
        while (!iterator.isDone()) {
            float[] inter;
            iterator.currentSegment(coords);
            float xp = coords[0];
            float yp = coords[1];
            if (this.insideEdge(xp, yp, edge)) {
                if (this.insideEdge(xs, ys, edge)) {
                    xList.add(new Float(xp));
                    yList.add(new Float(yp));
                } else {
                    inter = this.intersect(new float[]{xs, ys}, new float[]{xp, yp}, edge);
                    xList.add(new Float(inter[0]));
                    yList.add(new Float(inter[1]));
                    xList.add(new Float(xp));
                    yList.add(new Float(yp));
                }
            } else if (this.insideEdge(xs, ys, edge)) {
                inter = this.intersect(new float[]{xs, ys}, new float[]{xp, yp}, edge);
                xList.add(new Float(inter[0]));
                yList.add(new Float(inter[1]));
            }
            xs = xp;
            ys = yp;
            iterator.next();
        }
        GeneralPath clippedPath = new GeneralPath();
        if (xList.size() < 1) {
            return clippedPath;
        }
        Float xInt = (Float)xList.get(0);
        Float yInt = (Float)yList.get(0);
        clippedPath.moveTo(xInt.floatValue(), yInt.floatValue());
        for (int i = 1; i < xList.size(); ++i) {
            xInt = (Float)xList.get(i);
            yInt = (Float)yList.get(i);
            clippedPath.lineTo(xInt.floatValue(), yInt.floatValue());
        }
        return clippedPath;
    }

    private boolean insideEdge(int x, int y, int[][] edge) {
        boolean X = false;
        boolean Y = true;
        boolean inside = false;
        if (edge[0][1] > edge[0][0] && y >= edge[1][0]) {
            inside = true;
        }
        if (edge[0][1] < edge[0][0] && y <= edge[1][0]) {
            inside = true;
        }
        if (edge[1][1] > edge[1][0] && x <= edge[0][1]) {
            inside = true;
        }
        if (edge[1][1] < edge[1][0] && x >= edge[0][1]) {
            inside = true;
        }
        return inside;
    }

    private boolean insideEdge(float x, float y, float[][] edge) {
        boolean X = false;
        boolean Y = true;
        boolean inside = false;
        if (edge[0][1] > edge[0][0] && y >= edge[1][0]) {
            inside = true;
        }
        if (edge[0][1] < edge[0][0] && y <= edge[1][0]) {
            inside = true;
        }
        if (edge[1][1] > edge[1][0] && x <= edge[0][1]) {
            inside = true;
        }
        if (edge[1][1] < edge[1][0] && x >= edge[0][1]) {
            inside = true;
        }
        return inside;
    }

    private int[] intersect(int[] first, int[] second, int[][] edge) {
        boolean X = false;
        boolean Y = true;
        int[] intersect = new int[2];
        if (edge[1][0] == edge[1][1]) {
            intersect[1] = edge[1][0];
            intersect[0] = first[0] + (edge[1][0] - first[1]) * (second[0] - first[0]) / (second[1] - first[1]);
        } else {
            intersect[0] = edge[0][0];
            intersect[1] = first[1] + (edge[0][0] - first[0]) * (second[1] - first[1]) / (second[0] - first[0]);
        }
        return intersect;
    }

    private float[] intersect(float[] first, float[] second, float[][] edge) {
        boolean X = false;
        boolean Y = true;
        float[] intersect = new float[2];
        if (edge[1][0] == edge[1][1]) {
            intersect[1] = edge[1][0];
            intersect[0] = first[0] + (edge[1][0] - first[1]) * (second[0] - first[0]) / (second[1] - first[1]);
        } else {
            intersect[0] = edge[0][0];
            intersect[1] = first[1] + (edge[0][0] - first[0]) * (second[1] - first[1]) / (second[0] - first[0]);
        }
        return intersect;
    }

    private float[] getStrokeDash(int dashStyle, float pixelWidth) {
        float[] dash = null;
        switch (dashStyle) {
            case 2: {
                dash = new float[]{1.0f * pixelWidth, 7.0f * pixelWidth};
                break;
            }
            case 3: {
                dash = new float[]{7.0f * pixelWidth, 4.0f * pixelWidth, 1.0f * pixelWidth, 4.0f * pixelWidth};
                break;
            }
            case 1: {
                dash = new float[]{8.0f * pixelWidth, 8.0f * pixelWidth};
                break;
            }
        }
        return dash;
    }

    public void setTransformToScreenCoords(boolean value) {
        this.transformToScreenCoords = value;
    }

    private float[] transformToScreen(float[] coords) {
        if (!this.transformToScreenCoords) {
            return coords;
        }
        int numvertex = coords.length / 3;
        float[] retCoords = new float[coords.length];
        for (int i = 0; i < numvertex; ++i) {
            double[] xyz = new double[]{coords[i * 3], coords[i * 3 + 1], coords[i * 3 + 2]};
            int[] screenLocs = this.behavior.getScreenCoords(xyz);
            retCoords[i * 3] = screenLocs[0];
            retCoords[i * 3 + 1] = screenLocs[1];
            retCoords[i * 3 + 2] = 0.0f;
        }
        return retCoords;
    }

    public class Hatching {
        public static final int NUM_PATTERNS = 6;
        public static final int DIAGONAL1 = 0;
        public static final int DIAGONAL2 = 1;
        public static final int DIAGONAL_BOTH = 2;
        public static final int HORIZONTAL = 3;
        public static final int VERTICAL = 4;
        public static final int SQUARE = 5;
        private int width = 300;
        private int height = 300;

        public BufferedImage getPattern(int pattern) {
            int j;
            int i;
            BufferedImage fillTexture = new BufferedImage(this.width, this.height, 1);
            for (i = 0; i < this.width; ++i) {
                for (j = 0; j < this.height; ++j) {
                    this.setPoint(i, j, Color.WHITE, fillTexture);
                }
            }
            for (i = 0; i < this.width; ++i) {
                for (j = 0; j < this.height; ++j) {
                    if (!this.isSet(pattern, i, j)) continue;
                    this.setPoint(i, j, Color.BLACK, fillTexture);
                }
            }
            return fillTexture;
        }

        private boolean isSet(int pattern, int x, int y) {
            boolean isSet = false;
            int repeat = 3;
            if (pattern == 0) {
                int xx = this.width / repeat;
                int yy = this.height / repeat;
                if (x % xx == y % yy) {
                    isSet = true;
                }
            } else if (pattern == 1) {
                int xx = this.width / repeat;
                int yy = this.height / repeat;
                if (x % xx == yy - y % yy) {
                    isSet = true;
                }
            } else if (pattern == 2) {
                int xx = this.width / repeat;
                int yy = this.height / repeat;
                if (x % xx == y % yy || x % xx == yy - y % yy) {
                    isSet = true;
                }
            } else if (pattern == 3) {
                int yy = this.height / repeat;
                if (y % yy == 0) {
                    isSet = true;
                }
            } else if (pattern == 4) {
                int xx = this.width / repeat;
                if (x % xx == 0) {
                    isSet = true;
                }
            } else if (pattern == 5) {
                int xx = this.width / repeat;
                int yy = this.height / repeat;
                if (x % xx == 0 || y % yy == 0) {
                    isSet = true;
                }
            }
            return isSet;
        }

        private void setPoint(int x, int y, Color color, BufferedImage image) {
            int rgb = color.getRGB();
            for (int i = x - 1; i <= x + 1; ++i) {
                for (int j = y - 1; j <= y + 1; ++j) {
                    if (i < 0 || i >= this.width || j < 0 || j >= this.height) continue;
                    image.setRGB(i, j, rgb);
                }
            }
        }
    }

    public class ChartException
    extends Exception {
        public ChartException(String reason) {
            super(reason);
        }
    }
}

