/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.ImageFlatField;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.bom.SwitchNotify;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.VisADImageNode;

public class ShadowImageByRefFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;
    public VisADImageNode imgNode = new VisADImageNode();
    AnimationControlJ3D animControl = null;
    public static final String PROP_IMAGE_8BIT = "visad.java3d.8bit";
    private boolean GRAY = Boolean.parseBoolean(System.getProperty("visad.java3d.8bit", "false"));

    public ShadowImageByRefFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
        System.out.println("Using experimental image byReference rendering");
        if (this.GRAY) {
            System.out.println("8 bit color");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        int[][] x_start_stop;
        int n_x_sub;
        int x_sub_len;
        int k;
        int[][] y_start_stop;
        int n_y_sub;
        int y_sub_len;
        int limit;
        int[] lens;
        int domain_length;
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.getLevelOfDifficulty() == 6) {
            return false;
        }
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        DisplayImpl display = this.getDisplay();
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        boolean anyContour = adaptedShadowType.getAnyContour();
        boolean anyFlow = adaptedShadowType.getAnyFlow();
        boolean anyShape = adaptedShadowType.getAnyShape();
        boolean anyText = adaptedShadowType.getAnyText();
        if (anyContour || anyFlow || anyShape || anyText) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = adaptedShadowType.getInheritedValues();
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0) continue;
            display_values[i] = new float[1];
            display_values[i][0] = value_array[i];
        }
        Set domain_set = ((Field)data).getDomainSet();
        Unit[] dataUnits = null;
        CoordinateSystem dataCoordinateSystem = null;
        int numImages = 1;
        FlatField imgData = null;
        ShadowRealType[] DomainComponents = adaptedShadowType.getDomainComponents();
        if (!adaptedShadowType.getIsTerminal()) {
            ScalarMap map;
            Vector domain_maps = DomainComponents[0].getSelectedMapVector();
            ScalarMap amap = null;
            if (domain_set.getDimension() == 1 && domain_maps.size() == 1 && Display.Animation.equals((map = (ScalarMap)domain_maps.elementAt(0)).getDisplayScalar())) {
                amap = map;
            }
            if (amap == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            this.animControl = (AnimationControlJ3D)amap.getControl();
            double[][] values = domain_set.getDoubles();
            double[] times = values[0];
            int len = times.length;
            double delta = Math.abs((times[len - 1] - times[0]) / (1000.0 * (double)len));
            numImages = len;
            SwitchNotify swit = new SwitchNotify(this.imgNode, len);
            this.addSwitch(group, (Object)swit, this.animControl, domain_set, renderer);
            adaptedShadowType = (ShadowFunctionOrSetType)adaptedShadowType.getRange();
            DomainComponents = adaptedShadowType.getDomainComponents();
            imgData = (FlatField)((FieldImpl)data).getSample(0);
        } else {
            imgData = (FlatField)data;
        }
        BufferedImage[] images = new BufferedImage[numImages];
        int[][] intData = new int[numImages][];
        domain_set = imgData.getDomainSet();
        dataUnits = imgData.getDomainUnits();
        dataCoordinateSystem = imgData.getDomainCoordinateSystem();
        float[][] domain_values = null;
        double[][] domain_doubles = null;
        ShadowRealTupleType Domain2 = adaptedShadowType.getDomain();
        Unit[] domain_units = ((RealTupleType)Domain2.getType()).getDefaultUnits();
        try {
            domain_length = domain_set.getLength();
            int domain_dimension = domain_set.getDimension();
        }
        catch (SetException e) {
            return false;
        }
        float constant_alpha = Float.NaN;
        float[] constant_color = null;
        ShadowRealType[] RangeComponents = adaptedShadowType.getRangeComponents();
        int rangesize = RangeComponents.length;
        if (rangesize != 1 && rangesize != 3) {
            throw new BadMappingException("image values must single or triple");
        }
        ScalarMap cmap = null;
        ScalarMap[] cmaps = null;
        int[] permute = new int[]{-1, -1, -1};
        int color_length = 3;
        if (rangesize == 1) {
            Vector mvector = RangeComponents[0].getSelectedMapVector();
            if (mvector.size() != 1) {
                throw new BadMappingException("image values must be mapped to RGB only");
            }
            cmap = (ScalarMap)mvector.elementAt(0);
            if (Display.RGB.equals(cmap.getDisplayScalar())) {
                color_length = 3;
            } else {
                if (!Display.RGBA.equals(cmap.getDisplayScalar())) throw new BadMappingException("image values must be mapped to RGB or RGBA");
                color_length = 4;
            }
        } else {
            cmaps = new ScalarMap[3];
            for (int i = 0; i < 3; ++i) {
                Vector mvector = RangeComponents[i].getSelectedMapVector();
                if (mvector.size() != 1) {
                    throw new BadMappingException("image values must be mapped to color only");
                }
                cmaps[i] = (ScalarMap)mvector.elementAt(0);
                if (Display.Red.equals(cmaps[i].getDisplayScalar())) {
                    permute[0] = i;
                    continue;
                }
                if (Display.Green.equals(cmaps[i].getDisplayScalar())) {
                    permute[1] = i;
                    continue;
                }
                if (!Display.Blue.equals(cmaps[i].getDisplayScalar())) throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
                permute[2] = i;
            }
            if (permute[0] < 0 || permute[1] < 0 || permute[2] < 0) {
                throw new BadMappingException("image values must be mapped to Red, Green and Blue");
            }
        }
        constant_alpha = default_values[display.getDisplayScalarIndex(Display.Alpha)];
        byte[][] color_bytes = null;
        byte[] byteData = null;
        BufferedImage image = null;
        int[] lengths = ((GriddedSet)domain_set).getLengths();
        int data_width = lengths[0];
        int data_height = lengths[1];
        int texture_width = this.textureWidth(data_width);
        int texture_height = this.textureHeight(data_height);
        if (this.GRAY) {
            color_length = 1;
        }
        if (color_length == 4) {
            image = new BufferedImage(texture_width, texture_height, 6);
        } else if (color_length == 3) {
            image = new BufferedImage(texture_width, texture_height, 5);
        } else if (color_length == 1) {
            image = new BufferedImage(texture_width, texture_height, 10);
        }
        WritableRaster raster = image.getRaster();
        DataBuffer db = raster.getDataBuffer();
        byteData = ((DataBufferByte)db).getData();
        color_bytes = ShadowImageByRefFunctionTypeJ3D.makeColorBytes(imgData, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, color_bytes, byteData, data_width, data_height, texture_width, texture_height);
        images[0] = image;
        if (!Domain2.getAllSpatial() || Domain2.getMultipleDisplayScalar()) {
            throw new BadMappingException("domain must be only spatial");
        }
        boolean isTextureMap = adaptedShadowType.getIsTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
        int cMapCurveSize = (int)default_values[display.getDisplayScalarIndex(Display.CurvedSize)];
        int curved_size = cMapCurveSize > 0 ? cMapCurveSize : display.getGraphicsModeControl().getCurvedSize();
        boolean curvedTexture = adaptedShadowType.getCurvedTexture() && !isTextureMap && curved_size > 0 && (domain_set instanceof Gridded2DSet || domain_set instanceof GriddedSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
        Object coordinates = null;
        Object texCoords = null;
        Object normals = null;
        Object colors = null;
        data_width = 0;
        data_height = 0;
        texture_width = 1;
        texture_height = 1;
        Object coordinatesX = null;
        Object texCoordsX = null;
        Object normalsX = null;
        Object colorsX = null;
        Object coordinatesY = null;
        Object texCoordsY = null;
        Object normalsY = null;
        Object colorsY = null;
        if (color_length == 4) {
            constant_alpha = Float.NaN;
        }
        if (isTextureMap) {
            lens = ((GriddedSet)domain_set).getLengths();
            limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
            y_sub_len = lens[1];
            n_y_sub = 1;
            while (y_sub_len >= limit) {
                y_sub_len /= 2;
                n_y_sub *= 2;
            }
            y_start_stop = new int[n_y_sub][2];
            for (k = 0; k < n_y_sub - 1; ++k) {
                y_start_stop[k][0] = k * y_sub_len;
                y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
            }
            k = n_y_sub - 1;
            y_start_stop[k][0] = k * y_sub_len;
            y_start_stop[k][1] = lens[1] - 1;
            x_sub_len = lens[0];
            n_x_sub = 1;
            while (x_sub_len >= limit) {
                x_sub_len /= 2;
                n_x_sub *= 2;
            }
            x_start_stop = new int[n_x_sub][2];
            for (k = 0; k < n_x_sub - 1; ++k) {
                x_start_stop[k][0] = k * x_sub_len;
                x_start_stop[k][1] = (k + 1) * x_sub_len - 1;
            }
            k = n_x_sub - 1;
            x_start_stop[k][0] = k * x_sub_len;
            x_start_stop[k][1] = lens[0] - 1;
            if (n_y_sub == 1 && n_x_sub == 1) {
                this.buildLinearTexture(group, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytes, display, image);
            } else {
                BranchGroup branch = new BranchGroup();
                branch.setCapability(17);
                branch.setCapability(14);
                branch.setCapability(12);
                branch.setCapability(13);
                int start = 0;
                int i_total = 0;
                for (int i = 0; i < n_y_sub; ++i) {
                    int leny = y_start_stop[i][1] - y_start_stop[i][0] + 1;
                    for (int j = 0; j < n_x_sub; ++j) {
                        int lenx = x_start_stop[j][1] - x_start_stop[j][0] + 1;
                        float[][] g00 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j][0]}, {y_start_stop[i][0]}});
                        float[][] g11 = ((GriddedSet)domain_set).gridToValue(new float[][]{{x_start_stop[j][1]}, {y_start_stop[i][1]}});
                        double x0 = g00[0][0];
                        double x1 = g11[0][0];
                        double y0 = g00[1][0];
                        double y1 = g11[1][0];
                        Linear2DSet dset = new Linear2DSet(x0, x1, lenx, y0, y1, leny);
                        byte[][] color_bytesW = new byte[4][lenx * leny];
                        int cnt = 0;
                        for (k = 0; k < leny; ++k) {
                            start = x_start_stop[j][0] + i_total * lens[0] + k * lens[0];
                            for (int c = 0; c < 4; ++c) {
                                System.arraycopy(color_bytes[c], start, color_bytesW[c], cnt, lenx);
                            }
                            cnt += lenx;
                        }
                        BranchGroup branch1 = new BranchGroup();
                        branch1.setCapability(17);
                        branch1.setCapability(14);
                        branch1.setCapability(12);
                        branch1.setCapability(13);
                        this.buildLinearTexture(branch1, dset, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesW, display, null);
                        branch.addChild((Node)branch1);
                    }
                    i_total += leny;
                }
                if (((Group)group).numChildren() > 0) {
                    ((Group)group).setChild((Node)branch, 0);
                } else {
                    ((Group)group).addChild((Node)branch);
                }
            }
        } else {
            if (!curvedTexture) throw new BadMappingException("must be texture map or curved texture map");
            lens = ((GriddedSet)domain_set).getLengths();
            limit = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
            y_sub_len = lens[1];
            n_y_sub = 1;
            while (y_sub_len >= limit) {
                y_sub_len /= 2;
                n_y_sub *= 2;
            }
            y_start_stop = new int[n_y_sub][2];
            for (k = 0; k < n_y_sub - 1; ++k) {
                y_start_stop[k][0] = k * y_sub_len;
                y_start_stop[k][1] = (k + 1) * y_sub_len - 1;
            }
            k = n_y_sub - 1;
            y_start_stop[k][0] = k * y_sub_len;
            y_start_stop[k][1] = lens[1] - 1;
            x_sub_len = lens[0];
            n_x_sub = 1;
            while (x_sub_len >= limit) {
                x_sub_len /= 2;
                n_x_sub *= 2;
            }
            x_start_stop = new int[n_x_sub][2];
            for (k = 0; k < n_x_sub - 1; ++k) {
                x_start_stop[k][0] = k * x_sub_len;
                x_start_stop[k][1] = (k + 1) * x_sub_len - 1;
            }
            k = n_x_sub - 1;
            x_start_stop[k][0] = k * x_sub_len;
            x_start_stop[k][1] = lens[0] - 1;
            if (n_y_sub == 1 && n_x_sub == 1) {
                this.buildCurvedTexture(group, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytes, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{0, 0}, lens[0], lens[1], null, lens[0], lens[1], image);
            } else {
                float[][] samples = ((GriddedSet)domain_set).getSamples(false);
                BranchGroup branch = new BranchGroup();
                branch.setCapability(17);
                branch.setCapability(14);
                branch.setCapability(12);
                branch.setCapability(13);
                int start = 0;
                int i_total = 0;
                for (int i = 0; i < n_y_sub; ++i) {
                    int leny = y_start_stop[i][1] - y_start_stop[i][0] + 1;
                    for (int j = 0; j < n_x_sub; ++j) {
                        float[][] samplesC;
                        int lenx = x_start_stop[j][1] - x_start_stop[j][0] + 1;
                        if (j > 0) {
                            samplesC = new float[2][4 * leny];
                            byte[][] color_bytesC = new byte[4][4 * leny];
                            int cntv = 0;
                            int startv = x_start_stop[j][0] + i_total * lens[0];
                            for (int iv = 0; iv < leny; ++iv) {
                                samplesC[0][cntv] = samples[0][startv - 2];
                                samplesC[0][cntv + 1] = samples[0][startv - 1];
                                samplesC[0][cntv + 2] = samples[0][startv];
                                samplesC[0][cntv + 3] = samples[0][startv + 1];
                                samplesC[1][cntv] = samples[1][startv - 2];
                                samplesC[1][cntv + 1] = samples[1][startv - 1];
                                samplesC[1][cntv + 2] = samples[1][startv];
                                samplesC[1][cntv + 3] = samples[1][startv + 1];
                                for (int c = 0; c < 4; ++c) {
                                    color_bytesC[c][cntv] = color_bytes[c][startv - 2];
                                    color_bytesC[c][cntv + 1] = color_bytes[c][startv - 1];
                                    color_bytesC[c][cntv + 2] = color_bytes[c][startv];
                                    color_bytesC[c][cntv + 3] = color_bytes[c][startv + 1];
                                }
                                cntv += 4;
                                startv += lens[0];
                            }
                            Gridded2DSet gsetv = new Gridded2DSet(domain_set.getType(), samplesC, 4, leny);
                            BranchGroup branchv = new BranchGroup();
                            branchv.setCapability(17);
                            branchv.setCapability(14);
                            branchv.setCapability(12);
                            branchv.setCapability(13);
                            this.buildCurvedTexture(branchv, gsetv, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesC, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j][0], y_start_stop[i][0]}, lenx, leny, samples, lens[0], lens[1], null);
                            branch.addChild((Node)branchv);
                        }
                        if (i > 0) {
                            int c;
                            samplesC = new float[2][4 * lenx];
                            byte[][] color_bytesC = new byte[4][4 * lenx];
                            int starth = x_start_stop[j][0] + i_total * lens[0];
                            int cnth = 0;
                            System.arraycopy(samples[0], starth - 2 * lens[0], samplesC[0], cnth, lenx);
                            System.arraycopy(samples[1], starth - 2 * lens[0], samplesC[1], cnth, lenx);
                            System.arraycopy(samples[0], starth - 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                            System.arraycopy(samples[1], starth - 1 * lens[0], samplesC[1], cnth, lenx);
                            System.arraycopy(samples[0], starth, samplesC[0], cnth += lenx, lenx);
                            System.arraycopy(samples[1], starth, samplesC[1], cnth, lenx);
                            System.arraycopy(samples[0], starth + 1 * lens[0], samplesC[0], cnth += lenx, lenx);
                            System.arraycopy(samples[1], starth + 1 * lens[0], samplesC[1], cnth, lenx);
                            cnth = 0;
                            for (c = 0; c < 4; ++c) {
                                System.arraycopy(color_bytes[c], starth - 2 * lens[0], color_bytesC[c], cnth, lenx);
                            }
                            cnth += lenx;
                            for (c = 0; c < 4; ++c) {
                                System.arraycopy(color_bytes[c], starth - 1 * lens[0], color_bytesC[c], cnth, lenx);
                            }
                            cnth += lenx;
                            for (c = 0; c < 4; ++c) {
                                System.arraycopy(color_bytes[c], starth, color_bytesC[c], cnth, lenx);
                            }
                            cnth += lenx;
                            for (c = 0; c < 4; ++c) {
                                System.arraycopy(color_bytes[c], starth + 1 * lens[0], color_bytesC[c], cnth, lenx);
                            }
                            Gridded2DSet gseth = new Gridded2DSet(domain_set.getType(), samplesC, lenx, 4);
                            BranchGroup branchh = new BranchGroup();
                            branchh.setCapability(17);
                            branchh.setCapability(14);
                            branchh.setCapability(12);
                            branchh.setCapability(13);
                            this.buildCurvedTexture(branchh, gseth, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesC, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j][0], y_start_stop[i][0]}, lenx, leny, samples, lens[0], lens[1], null);
                            branch.addChild((Node)branchh);
                        }
                        byte[][] color_bytesW = new byte[4][lenx * leny];
                        int cnt = 0;
                        for (k = 0; k < leny; ++k) {
                            start = x_start_stop[j][0] + i_total * lens[0] + k * lens[0];
                            for (int c = 0; c < 4; ++c) {
                                System.arraycopy(color_bytes[c], start, color_bytesW[c], cnt, lenx);
                            }
                            cnt += lenx;
                        }
                        Set gset1 = null;
                        BranchGroup branch1 = new BranchGroup();
                        branch1.setCapability(17);
                        branch1.setCapability(14);
                        branch1.setCapability(12);
                        branch1.setCapability(13);
                        this.buildCurvedTexture(branch1, gset1, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, color_bytesW, display, curved_size, Domain2, dataCoordinateSystem, renderer, adaptedShadowType, new int[]{x_start_stop[j][0], y_start_stop[i][0]}, lenx, leny, samples, lens[0], lens[1], null);
                        branch.addChild((Node)branch1);
                    }
                    i_total += leny;
                }
                color_bytes = null;
                if (((Group)group).numChildren() > 0) {
                    ((Group)group).setChild((Node)branch, 0);
                } else {
                    ((Group)group).addChild((Node)branch);
                }
            }
        }
        lengths = ((GriddedSet)domain_set).getLengths();
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureWidth(data_height);
        for (int k2 = 1; k2 < numImages; ++k2) {
            if (color_length == 4) {
                image = new BufferedImage(texture_width, texture_height, 6);
            } else if (color_length == 3) {
                image = new BufferedImage(texture_width, texture_height, 5);
            } else if (color_length == 1) {
                image = new BufferedImage(texture_width, texture_height, 10);
            }
            images[k2] = image;
            raster = image.getRaster();
            db = raster.getDataBuffer();
            byteData = ((DataBufferByte)db).getData();
            color_bytes = ShadowImageByRefFunctionTypeJ3D.makeColorBytes(((Field)data).getSample(k2), cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, color_bytes, byteData, data_width, data_height, texture_width, texture_height);
        }
        this.imgNode.setImages(images);
        this.ensureNotEmpty(group);
        return false;
    }

    public static byte[][] makeColorBytes(Data data, ScalarMap cmap, ScalarMap[] cmaps, float constant_alpha, ShadowRealType[] RangeComponents, int color_length, int domain_length, int[] permute, byte[][] color_bytes, byte[] byteData, int data_width, int data_height, int texture_width, int texture_height) throws VisADException, RemoteException {
        if (cmap != null) {
            BaseColorControl control = (BaseColorControl)cmap.getControl();
            float[][] table = control.getTable();
            byte[][] bytes = null;
            Set rset = null;
            boolean is_default_unit = false;
            if (data instanceof FlatField) {
                RealType rtype;
                Unit def_unit;
                bytes = ((FlatField)data).grabBytes();
                Set[] rsets = ((FlatField)data).getRangeSets();
                if (rsets != null) {
                    rset = rsets[0];
                }
                if ((def_unit = (rtype = (RealType)RangeComponents[0].getType()).getDefaultUnit()) == null) {
                    is_default_unit = true;
                } else {
                    Unit[][] data_units = ((FlatField)data).getRangeUnits();
                    Unit data_unit = data_units == null ? null : data_units[0][0];
                    is_default_unit = def_unit.equals(data_unit);
                }
            }
            if (table != null) {
                byte[][] itable = new byte[table[0].length][4];
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                for (int j = 0; j < table[0].length; ++j) {
                    int b;
                    c = (int)(255.0 * (double)table[0][j]);
                    int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                    c = (int)(255.0 * (double)table[1][j]);
                    int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                    c = (int)(255.0 * (double)table[2][j]);
                    int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                    if (color_length == 4) {
                        c = (int)(255.0 * (double)table[3][j]);
                        a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    }
                    itable[j][0] = (byte)r;
                    itable[j][1] = (byte)g;
                    itable[j][2] = (byte)b;
                    itable[j][3] = (byte)a;
                }
                int tblEnd = table[0].length - 1;
                int table_scale = table[0].length;
                if (data instanceof ImageFlatField && bytes != null && is_default_unit) {
                    color_bytes = ShadowImageByRefFunctionTypeJ3D.getColorBytes(color_bytes, 4, domain_length);
                    bytes[0] = cmap.scaleValues(bytes[0], table_scale);
                    byte[] bytes0 = bytes[0];
                    for (int i = 0; i < domain_length; ++i) {
                        int j = bytes0[i] & 0xFF;
                        int ndx = j < 0 ? 0 : (j > tblEnd ? tblEnd : j);
                        color_bytes[0][i] = itable[ndx][0];
                        color_bytes[1][i] = itable[ndx][1];
                        color_bytes[2][i] = itable[ndx][2];
                        color_bytes[3][i] = itable[ndx][3];
                    }
                } else if (bytes != null && bytes[0] != null && is_default_unit && rset != null && rset instanceof Linear1DSet) {
                    double first = ((Linear1DSet)rset).getFirst();
                    double step = ((Linear1DSet)rset).getStep();
                    double[] so = new double[2];
                    double[] da = new double[2];
                    double[] di = new double[2];
                    cmap.getScale(so, da, di);
                    double scale = so[0];
                    double offset = so[1];
                    float mult = (float)((double)table_scale * scale * step);
                    float add = (float)((double)table_scale * (offset + scale * first));
                    byte[][] fast_table = new byte[256][];
                    for (int j = 0; j < 256; ++j) {
                        int index = j - 1;
                        if (index < 0) continue;
                        int k = (int)(add + mult * (float)index);
                        int ndx = k < 0 ? 0 : (k > tblEnd ? tblEnd : k);
                        fast_table[j] = itable[ndx];
                    }
                    color_bytes = ShadowImageByRefFunctionTypeJ3D.getColorBytes(color_bytes, 4, domain_length);
                    byte[] bytes0 = bytes[0];
                    for (int i = 0; i < domain_length; ++i) {
                        int ndx = bytes0[i] - -128;
                        color_bytes[0][i] = fast_table[ndx][0];
                        color_bytes[1][i] = fast_table[ndx][1];
                        color_bytes[2][i] = fast_table[ndx][2];
                        color_bytes[3][i] = fast_table[ndx][3];
                    }
                    bytes = null;
                } else {
                    bytes = null;
                    float[][] values = ((Field)data).getFloats(false);
                    values[0] = cmap.scaleValues(values[0]);
                    float[] values0 = values[0];
                    boolean m = false;
                    for (int y = 0; y < data_height; ++y) {
                        for (int x = 0; x < data_width; ++x) {
                            int ndx;
                            int i = x + y * data_width;
                            int k = x + y * texture_width;
                            k *= color_length;
                            if (Float.isNaN(values0[i])) continue;
                            int j = (int)((float)table_scale * values0[i]);
                            int n = j < 0 ? 0 : (ndx = j > tblEnd ? tblEnd : j);
                            if (color_length == 4) {
                                byteData[k] = itable[ndx][3];
                                byteData[k + 1] = itable[ndx][2];
                                byteData[k + 2] = itable[ndx][1];
                                byteData[k + 3] = itable[ndx][0];
                            }
                            if (color_length == 3) {
                                byteData[k] = itable[ndx][2];
                                byteData[k + 1] = itable[ndx][1];
                                byteData[k + 2] = itable[ndx][0];
                            }
                            if (color_length != 1) continue;
                            byteData[k] = itable[ndx][0];
                        }
                    }
                    values = null;
                }
            } else {
                bytes = null;
                float[][] values = ((Field)data).getFloats(false);
                values[0] = cmap.scaleValues(values[0]);
                float[][] color_values = control.lookupValues(values[0]);
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                boolean m = false;
                for (int y = 0; y < data_height; ++y) {
                    for (int x = 0; x < data_width; ++x) {
                        int b;
                        int i = x + y * data_width;
                        int k = x + y * texture_width;
                        k *= color_length;
                        if (Float.isNaN(values[0][i])) continue;
                        c = (int)(255.0 * (double)color_values[0][i]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_values[1][i]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_values[2][i]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            c = (int)(255.0 * (double)color_values[3][i]);
                            int n2 = c < 0 ? 0 : (a = c > 255 ? 255 : c);
                        }
                        if (color_length == 4) {
                            byteData[k] = (byte)a;
                            byteData[k + 1] = (byte)b;
                            byteData[k + 2] = (byte)g;
                            byteData[k + 3] = (byte)r;
                        }
                        if (color_length == 3) {
                            byteData[k] = (byte)b;
                            byteData[k + 1] = (byte)g;
                            byteData[k + 2] = (byte)r;
                        }
                        if (color_length != 1) continue;
                        byteData[k] = (byte)b;
                    }
                }
                values = null;
                color_values = null;
            }
        } else if (cmaps != null) {
            byte[][] bytes = null;
            if (data instanceof ImageFlatField) {
                bytes = ((ImageFlatField)data).grabBytes();
            }
            if (bytes != null) {
                color_bytes = new byte[4][];
                color_bytes[0] = cmaps[permute[0]].scaleValues(bytes[permute[0]], 255);
                color_bytes[1] = cmaps[permute[1]].scaleValues(bytes[permute[1]], 255);
                color_bytes[2] = cmaps[permute[2]].scaleValues(bytes[permute[2]], 255);
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                color_bytes[3] = new byte[domain_length];
                Arrays.fill(color_bytes[3], (byte)c);
            } else {
                Object values = ((Field)data).getFloats(false);
                float[][] new_values = new float[][]{cmaps[permute[0]].scaleValues(values[permute[0]]), cmaps[permute[1]].scaleValues(values[permute[1]]), cmaps[permute[2]].scaleValues(values[permute[2]])};
                values = new_values;
                int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                boolean m = false;
                for (int y = 0; y < data_height; ++y) {
                    for (int x = 0; x < data_width; ++x) {
                        int b;
                        int i = x + y * data_width;
                        int k = x + y * texture_width;
                        k *= color_length;
                        if (Float.isNaN(values[0][i]) || Float.isNaN(values[1][i]) || Float.isNaN(values[2][i])) continue;
                        c = (int)(255.0 * (double)values[0][i]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)values[1][i]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)values[2][i]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            byteData[k] = (byte)a;
                            byteData[k + 1] = (byte)b;
                            byteData[k + 2] = (byte)g;
                            byteData[k + 3] = (byte)r;
                        }
                        if (color_length == 3) {
                            byteData[k] = (byte)b;
                            byteData[k + 1] = (byte)g;
                            byteData[k + 2] = (byte)r;
                        }
                        if (color_length != 1) continue;
                        byteData[k] = (byte)b;
                    }
                }
                values = null;
            }
        } else {
            throw new BadMappingException("cmap == null and cmaps == null ??");
        }
        return color_bytes;
    }

    public static byte[][] getColorBytes(byte[][] color_bytes, int color_length, int length) {
        if (color_bytes == null) {
            color_bytes = new byte[color_length][length];
        }
        return color_bytes;
    }

    public void buildCurvedTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, byte[][] color_bytes, DisplayImpl display, int curved_size, ShadowRealTupleType Domain2, CoordinateSystem dataCoordinateSystem, DataRenderer renderer, ShadowFunctionOrSetType adaptedShadowType, int[] start, int lenX, int lenY, float[][] samples, int bigX, int bigY, BufferedImage image) throws VisADException, DisplayException {
        int len;
        int i;
        int i2;
        int i3;
        RealTupleType ref;
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        int[] lengths = null;
        lengths = domain_set != null ? ((GriddedSet)domain_set).getLengths() : new int[]{lenX, lenY};
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        int size = (data_width + data_height) / 2;
        curved_size = Math.max(2, Math.min(curved_size, size / 32));
        int nwidth = 2 + (data_width - 1) / curved_size;
        int nheight = 2 + (data_height - 1) / curved_size;
        int nn = nwidth * nheight;
        int[] is = new int[nwidth];
        int[] js = new int[nheight];
        for (int i4 = 0; i4 < nwidth; ++i4) {
            is[i4] = Math.min(i4 * curved_size, data_width - 1);
        }
        for (int j = 0; j < nheight; ++j) {
            js[j] = Math.min(j * curved_size, data_height - 1);
        }
        int[] indices = new int[nn];
        int k = 0;
        for (int j = 0; j < nheight; ++j) {
            for (int i5 = 0; i5 < nwidth; ++i5) {
                indices[k] = is[i5] + data_width * js[j];
                ++k;
            }
        }
        float[][] spline_domain = null;
        if (domain_set == null) {
            int kk;
            for (kk = 0; kk < indices.length; ++kk) {
                int x = indices[kk] % lenX;
                int y = indices[kk] / lenX;
                indices[kk] = start[0] + x + (start[1] + y) * bigX;
            }
            spline_domain = new float[2][indices.length];
            for (kk = 0; kk < indices.length; ++kk) {
                spline_domain[0][kk] = samples[0][indices[kk]];
                spline_domain[1][kk] = samples[1][indices[kk]];
            }
        } else {
            spline_domain = domain_set.indexToValue(indices);
        }
        spline_domain = Unit.convertTuple(spline_domain, dataUnits, domain_units, false);
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            ref = (RealTupleType)domain_reference.getType();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            spline_domain = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)Domain2.getType(), dataCoordinateSystem, domain_units, null, spline_domain);
            DC = adaptedShadowType.getDomainReferenceComponents();
        } else {
            ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref_units, (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
        }
        int[] tuple_index = new int[3];
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        ScalarMap[] spatial_maps = new ScalarMap[3];
        DisplayTupleType spatial_tuple = null;
        for (int i6 = 0; i6 < DC.length; ++i6) {
            Enumeration maps = DC[i6].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            spatial_tuple = real.getTuple();
            if (spatial_tuple == null) {
                throw new DisplayException("texture with bad tuple: ShadowImageFunctionTypeJ3D.doTransform");
            }
            tuple_index[i6] = real.getTupleIndex();
            spatial_value_indices[tuple_index[i6]] = map.getValueIndex();
            spatial_maps[tuple_index[i6]] = map;
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowImageFunctionTypeJ3D.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i7 = 0; i7 < valueArrayLength; ++i7) {
            if (inherited_values[i7] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i7]))) continue;
            value2 = value_array[i7];
            break;
        }
        Object spatial_values = new float[3][];
        spatial_values[tuple_index[0]] = spline_domain[0];
        spatial_values[tuple_index[1]] = spline_domain[1];
        spatial_values[tuple_index[2]] = new float[nn];
        for (i3 = 0; i3 < nn; ++i3) {
            spatial_values[tuple_index[2]][i3] = value2;
        }
        for (i3 = 0; i3 < 3; ++i3) {
            if (spatial_maps[i3] == null) continue;
            spatial_values[i3] = spatial_maps[i3].scaleValues(spatial_values[i3], false);
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, null);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            spatial_values = coord.toReference((float[][])spatial_values);
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, null);
        }
        coordinates = new float[3 * nn];
        k = 0;
        for (int i8 = 0; i8 < nn; ++i8) {
            coordinates[k++] = spatial_values[0][i8];
            coordinates[k++] = spatial_values[1][i8];
            coordinates[k++] = spatial_values[2][i8];
        }
        boolean spatial_all_select = true;
        for (i2 = 0; i2 < 3 * nn; ++i2) {
            if (coordinates[i2] == coordinates[i2]) continue;
            spatial_all_select = false;
        }
        normals = Gridded3DSet.makeNormals(coordinates, nwidth, nheight);
        colors = new byte[3 * nn];
        for (i2 = 0; i2 < 3 * nn; ++i2) {
            colors[i2] = 127;
        }
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        float half_width = 0.5f / (float)texture_width;
        float half_height = 0.5f / (float)texture_height;
        float width = 1.0f / (float)texture_width;
        float height = 1.0f / (float)texture_height;
        int mt = 0;
        texCoords = new float[2 * nn];
        for (int j = 0; j < nheight; ++j) {
            for (i = 0; i < nwidth; ++i) {
                float isfactor = (float)is[i] / ((float)data_width - 1.0f);
                float jsfactor = (float)js[j] / ((float)data_height - 1.0f);
                texCoords[mt++] = (ratiow - width) * isfactor + half_width;
                texCoords[mt++] = yUp ? (ratioh - height) * jsfactor + half_height : 1.0f - (ratioh - height) * jsfactor - half_height;
            }
        }
        VisADTriangleStripArray tarray = new VisADTriangleStripArray();
        tarray.stripVertexCounts = new int[nheight - 1];
        for (i = 0; i < nheight - 1; ++i) {
            tarray.stripVertexCounts[i] = 2 * nwidth;
        }
        tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
        tarray.normals = new float[3 * len];
        tarray.coordinates = new float[3 * len];
        tarray.texCoords = new float[2 * len];
        k = 0;
        int kt = 0;
        int nwidth3 = 3 * nwidth;
        int nwidth2 = 2 * nwidth;
        for (int i9 = 0; i9 < nheight - 1; ++i9) {
            int m = i9 * nwidth3;
            mt = i9 * nwidth2;
            for (int j = 0; j < nwidth; ++j) {
                tarray.coordinates[k] = coordinates[m];
                tarray.coordinates[k + 1] = coordinates[m + 1];
                tarray.coordinates[k + 2] = coordinates[m + 2];
                tarray.coordinates[k + 3] = coordinates[m + nwidth3];
                tarray.coordinates[k + 4] = coordinates[m + nwidth3 + 1];
                tarray.coordinates[k + 5] = coordinates[m + nwidth3 + 2];
                tarray.normals[k] = normals[m];
                tarray.normals[k + 1] = normals[m + 1];
                tarray.normals[k + 2] = normals[m + 2];
                tarray.normals[k + 3] = normals[m + nwidth3];
                tarray.normals[k + 4] = normals[m + nwidth3 + 1];
                tarray.normals[k + 5] = normals[m + nwidth3 + 2];
                tarray.texCoords[kt] = texCoords[mt];
                tarray.texCoords[kt + 1] = texCoords[mt + 1];
                tarray.texCoords[kt + 2] = texCoords[mt + nwidth2];
                tarray.texCoords[kt + 3] = texCoords[mt + nwidth2 + 1];
                k += 6;
                m += 3;
                kt += 4;
                mt += 2;
            }
        }
        if (!spatial_all_select) {
            tarray = (VisADTriangleStripArray)tarray.removeMissing();
        }
        if (adaptedShadowType.getAdjustProjectionSeam()) {
            tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
            tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
        }
        this.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, this.imgNode);
    }

    public void buildLinearTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, byte[][] color_bytes, DisplayImpl display, BufferedImage image) throws VisADException, DisplayException {
        float[] coordinates = null;
        float[] texCoords = null;
        float[] normals = null;
        byte[] colors = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        Linear1DSet X = null;
        Linear1DSet Y = null;
        if (domain_set instanceof Linear2DSet) {
            X = ((Linear2DSet)domain_set).getX();
            Y = ((Linear2DSet)domain_set).getY();
        } else {
            X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
            Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
        }
        float[][] limits = new float[2][2];
        limits[0][0] = (float)X.getFirst();
        limits[0][1] = (float)X.getLast();
        limits[1][0] = (float)Y.getFirst();
        limits[1][1] = (float)Y.getLast();
        data_width = X.getLength();
        data_height = Y.getLength();
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        float half_width = 0.5f / (float)(data_width - 1);
        float half_height = 0.5f / (float)(data_height - 1);
        half_width = (limits[0][1] - limits[0][0]) * half_width;
        half_height = (limits[1][1] - limits[1][0]) * half_height;
        float[] fArray = limits[0];
        fArray[0] = fArray[0] - half_width;
        float[] fArray2 = limits[0];
        fArray2[1] = fArray2[1] + half_width;
        float[] fArray3 = limits[1];
        fArray3[0] = fArray3[0] - half_height;
        float[] fArray4 = limits[1];
        fArray4[1] = fArray4[1] + half_height;
        limits = Unit.convertTuple(limits, dataUnits, domain_units);
        int[] tuple_index = new int[3];
        if (DomainComponents.length != 2) {
            throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
        }
        for (int i = 0; i < DomainComponents.length; ++i) {
            Enumeration maps = DomainComponents[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            limits[i] = map.scaleValues(limits[i]);
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                throw new DisplayException("texture with bad tuple: ShadowFunctionOrSetType.doTransform");
            }
            tuple_index[i] = real.getTupleIndex();
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowFunctionOrSetType.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        coordinates = new float[12];
        coordinates[tuple_index[0]] = limits[0][0];
        coordinates[tuple_index[1]] = limits[1][0];
        coordinates[tuple_index[2]] = value2;
        coordinates[3 + tuple_index[0]] = limits[0][1];
        coordinates[3 + tuple_index[1]] = limits[1][0];
        coordinates[3 + tuple_index[2]] = value2;
        coordinates[6 + tuple_index[0]] = limits[0][1];
        coordinates[6 + tuple_index[1]] = limits[1][1];
        coordinates[6 + tuple_index[2]] = value2;
        coordinates[9 + tuple_index[0]] = limits[0][0];
        coordinates[9 + tuple_index[1]] = limits[1][1];
        coordinates[9 + tuple_index[2]] = value2;
        this.adjustZ(coordinates);
        texCoords = new float[8];
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        this.setTexCoords(texCoords, ratiow, ratioh);
        normals = new float[12];
        float n0 = (coordinates[5] - coordinates[2]) * (coordinates[7] - coordinates[1]) - (coordinates[4] - coordinates[1]) * (coordinates[8] - coordinates[2]);
        float n1 = (coordinates[3] - coordinates[0]) * (coordinates[8] - coordinates[2]) - (coordinates[5] - coordinates[2]) * (coordinates[6] - coordinates[0]);
        float n2 = (coordinates[4] - coordinates[1]) * (coordinates[6] - coordinates[0]) - (coordinates[3] - coordinates[0]) * (coordinates[7] - coordinates[1]);
        float nlen = (float)Math.sqrt(n0 * n0 + n1 * n1 + n2 * n2);
        normals[0] = n0 /= nlen;
        normals[1] = n1 /= nlen;
        normals[2] = n2 /= nlen;
        normals[3] = n0;
        normals[4] = n1;
        normals[5] = n2;
        normals[6] = n0;
        normals[7] = n1;
        normals[8] = n2;
        normals[9] = n0;
        normals[10] = n1;
        normals[11] = n2;
        colors = new byte[12];
        for (int i = 0; i < 12; ++i) {
            colors[i] = 127;
        }
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.vertexCount = 4;
        qarray.coordinates = coordinates;
        qarray.texCoords = texCoords;
        qarray.colors = colors;
        qarray.normals = normals;
        this.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, this.imgNode);
    }

    public BufferedImage createImage(int data_width, int data_height, int texture_width, int texture_height, byte[][] color_bytes) throws VisADException {
        ShadowFunctionOrSetType adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        return adaptedShadowType.createImage(data_width, data_height, texture_width, texture_height, color_bytes);
    }
}

