/*
 * Decompiled with CFR 0.152.
 */
package ucar.bufr;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ucar.bufr.BufrIndicatorSection;
import ucar.bufr.BufrNumbers;
import ucar.unidata.io.RandomAccessFile;

final class BufrIdentificationSection {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final int length;
    private final int master_table;
    private final String master_table_filename;
    private final int subcenter_id;
    private final int center_id;
    private final int update;
    private final int optional;
    private final int category;
    private final int subCategory;
    private final int master_table_version;
    private final int local_table_version;
    private final String referenceTime;
    private final long validTime;
    private final String nominalTime;
    private boolean isCompressed = false;

    public BufrIdentificationSection(RandomAccessFile raf, BufrIndicatorSection is) throws IOException {
        this.length = BufrNumbers.int3(raf);
        this.master_table = raf.read();
        if (is.getBufrEdition() < 4) {
            this.subcenter_id = raf.read();
            this.center_id = raf.read();
            this.update = raf.read();
            this.optional = raf.read();
            this.category = raf.read();
            this.subCategory = raf.read();
            this.master_table_version = raf.read();
            this.local_table_version = raf.read();
            int year = raf.read();
            if (year > 100) {
                year -= 100;
            }
            int month = raf.read() - 1;
            int day = raf.read();
            int hour = raf.read();
            int minute = raf.read();
            GregorianCalendar cal = new GregorianCalendar(year += 2000, month, day, hour, minute, 0);
            this.referenceTime = dateFormat.format(cal.getTime());
            if (minute > 45) {
                ((Calendar)cal).add(12, 60 - minute);
            } else {
                ((Calendar)cal).add(12, -minute);
            }
            this.nominalTime = dateFormat.format(cal.getTime());
            cal.set(15, 0);
            cal.set(16, 0);
            this.validTime = (long)((double)cal.getTimeInMillis() * 0.001);
            for (int i = 17; i < this.length; ++i) {
                int extra = raf.read();
            }
        } else {
            this.center_id = BufrNumbers.int2(raf);
            this.subcenter_id = BufrNumbers.int2(raf);
            this.update = raf.read();
            this.optional = raf.read();
            this.category = raf.read();
            this.subCategory = raf.read();
            int localSubCategory = raf.read();
            this.master_table_version = raf.read();
            this.local_table_version = raf.read();
            int year = BufrNumbers.int2(raf);
            int month = raf.read();
            int day = raf.read();
            int hour = raf.read();
            int minute = raf.read();
            int second = raf.read();
            GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, minute, second);
            this.referenceTime = dateFormat.format(cal.getTime());
            if (minute > 45) {
                ((Calendar)cal).add(12, 60 - minute);
            } else {
                ((Calendar)cal).add(12, -minute);
            }
            this.nominalTime = dateFormat.format(cal.getTime());
            cal.set(15, 0);
            cal.set(16, 0);
            this.validTime = (long)((double)cal.getTimeInMillis() * 0.001);
            for (int i = 22; i < this.length; ++i) {
                int extra = raf.read();
            }
        }
        if (this.center_id == 7 || this.center_id == 2) {
            String mt = "B" + Integer.toString(is.getBufrEdition()) + "M-";
            mt = this.master_table == 0 ? mt + "000" : mt + Integer.toString(this.master_table);
            String version = Integer.toString(this.master_table_version);
            this.master_table_filename = version.length() == 1 ? mt + "-00" + version : (version.length() == 2 ? mt + "-0" + version : mt + "-" + version);
        } else {
            this.master_table_filename = this.center_id == 59 ? "B3L-059-003" : (this.center_id == 60 ? "B3L-060-007" : (is.getBufrEdition() < 4 ? "B3M-000-012" : "B4M-000-013"));
        }
    }

    public final int getCenter_id() {
        return this.center_id;
    }

    public final String getCenter_idName(int id) {
        if (this.center_id == 7) {
            switch (id) {
                case 0: {
                    return "WMO Secretariat";
                }
                case 1: {
                    return "NCEP Re-Analysis Project";
                }
                case 2: {
                    return "NCEP Ensemble Products";
                }
                case 3: {
                    return "NCEP Central Operations";
                }
                case 4: {
                    return "Environmental Modeling Center";
                }
                case 5: {
                    return "Hydrometeorological Prediction Center";
                }
                case 6: {
                    return "Marine Prediction Center";
                }
                case 7: {
                    return "Climate Prediction Center";
                }
                case 8: {
                    return "Aviation Weather Center";
                }
                case 9: {
                    return "Storm Prediction Center";
                }
                case 10: {
                    return "Tropical Prediction Center";
                }
                case 11: {
                    return "NWS Techniques Development Laboratory";
                }
                case 12: {
                    return "NESDIS Office of Research and Applications";
                }
                case 13: {
                    return "FAA";
                }
                case 14: {
                    return "NWS Meteorological Development Laboratory";
                }
                case 15: {
                    return "The North American Regional Reanalysis (NARR) Project";
                }
            }
        }
        switch (id) {
            case 0: {
                return "WMO Secretariat";
            }
            case 1: 
            case 2: {
                return "Melbourne";
            }
            case 4: 
            case 5: {
                return "Moscow";
            }
            case 7: {
                return "US National Weather Service (NCEP)";
            }
            case 8: {
                return "US National Weather Service (NWSTG)";
            }
            case 9: {
                return "US National Weather Service (other)";
            }
            case 10: {
                return "Cairo (RSMC/RAFC)";
            }
            case 12: {
                return "Dakar (RSMC/RAFC)";
            }
            case 14: {
                return "Nairobi (RSMC/RAFC)";
            }
            case 18: {
                return "Tunis Casablanca (RSMC)";
            }
            case 20: {
                return "Las Palmas (RAFC)";
            }
            case 21: {
                return "Algiers (RSMC)";
            }
            case 24: {
                return "Pretoria (RSMC)";
            }
            case 25: {
                return "La R?union (RSMC)";
            }
            case 26: {
                return "Khabarovsk (RSMC)";
            }
            case 28: {
                return "New Delhi (RSMC/RAFC)";
            }
            case 30: {
                return "Novosibirsk (RSMC)";
            }
            case 32: {
                return "Tashkent (RSMC)";
            }
            case 33: {
                return "eddah (RSMC)";
            }
            case 34: {
                return "Tokyo (RSMC), Japan Meteorological Agency";
            }
            case 36: {
                return "Bangkok";
            }
            case 37: {
                return "Ulan Bator";
            }
            case 38: {
                return "Beijing (RSMC)";
            }
            case 40: {
                return "Seoul";
            }
            case 41: {
                return "Buenos Aires (RSMC/RAFC)";
            }
            case 43: {
                return "Brasilia (RSMC/RAFC)";
            }
            case 45: {
                return "Santiago";
            }
            case 46: {
                return "Brazilian Space Agency ? INPE";
            }
            case 51: {
                return "Miami (RSMC/RAFC)";
            }
            case 52: {
                return "Miami RSMC, National Hurricane Center";
            }
            case 53: {
                return "Montreal (RSMC)";
            }
            case 55: {
                return "San Francisco";
            }
            case 57: {
                return "Air Force Weather Agency";
            }
            case 58: {
                return "Fleet Numerical Meteorology and Oceanography Center";
            }
            case 59: {
                return "The NOAA Forecast Systems Laboratory";
            }
            case 60: {
                return "United States National Centre for Atmospheric Research (NCAR)";
            }
            case 64: {
                return "Honolulu";
            }
            case 65: {
                return "Darwin (RSMC)";
            }
            case 67: {
                return "Melbourne (RSMC)";
            }
            case 69: {
                return "Wellington (RSMC/RAFC)";
            }
            case 71: {
                return "Nadi (RSMC)";
            }
            case 74: {
                return "UK Meteorological Office Bracknell (RSMC)";
            }
            case 76: {
                return "Moscow (RSMC/RAFC)";
            }
            case 78: {
                return "Offenbach (RSMC)";
            }
            case 80: {
                return "Rome (RSMC)";
            }
            case 82: {
                return "Norrk?ping";
            }
            case 85: {
                return "Toulouse (RSMC)";
            }
            case 86: {
                return "Helsinki";
            }
            case 87: {
                return "Belgrade";
            }
            case 88: {
                return "Oslo";
            }
            case 89: {
                return "Prague";
            }
            case 90: {
                return "Episkopi";
            }
            case 91: {
                return "Ankara";
            }
            case 92: {
                return "Frankfurt/Main (RAFC)";
            }
            case 93: {
                return "London (WAFC)";
            }
            case 94: {
                return "Copenhagen";
            }
            case 95: {
                return "Rota";
            }
            case 96: {
                return "Athens";
            }
            case 97: {
                return "European Space Agency (ESA)";
            }
            case 98: {
                return "ECMWF, RSMC";
            }
            case 99: {
                return "De Bilt";
            }
            case 110: {
                return "Hong-Kong";
            }
            case 160: {
                return "US NOAA/NESDIS";
            }
            case 210: {
                return "Frascati (ESA/ESRIN)";
            }
            case 211: {
                return "Lanion";
            }
            case 212: {
                return "Lisboa";
            }
            case 213: {
                return "Reykjavik";
            }
            case 254: {
                return "EUMETSAT Operation Centre";
            }
        }
        return "Unknown";
    }

    public final int getSubCenter_id() {
        return this.subcenter_id;
    }

    public final String getMasterTableFilename() {
        return this.master_table_filename;
    }

    public final String getReferenceTime() {
        return this.referenceTime;
    }

    public final String getNominalTime() {
        return this.nominalTime;
    }

    public final int getCategory() {
        return this.category;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }
}

