/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenChar;
import java.util.Vector;

final class RETokenOneOf
extends REToken {
    private Vector options;
    private boolean negative;

    RETokenOneOf(int subIndex, String optionsStr, boolean negative, boolean insens) {
        super(subIndex);
        this.options = new Vector();
        this.negative = negative;
        int i = 0;
        while (i < optionsStr.length()) {
            this.options.addElement(new RETokenChar(subIndex, optionsStr.charAt(i), insens));
            ++i;
        }
    }

    RETokenOneOf(int subIndex, Vector options, boolean negative) {
        super(subIndex);
        this.options = options;
        this.negative = negative;
    }

    int getMinimumLength() {
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.options.size()) {
            int x = ((REToken)this.options.elementAt(i)).getMinimumLength();
            if (x < min) {
                min = x;
            }
            ++i;
        }
        return min;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        if (this.negative && input.charAt(mymatch.index) == '\uffff') {
            return false;
        }
        REMatch newMatch = null;
        REMatch last = null;
        int i = 0;
        while (i < this.options.size()) {
            REMatch tryMatch;
            REToken tk = (REToken)this.options.elementAt(i);
            if (tk.match(input, tryMatch = (REMatch)mymatch.clone())) {
                if (this.negative) {
                    return false;
                }
                if (this.next(input, tryMatch)) {
                    if (last == null) {
                        newMatch = tryMatch;
                        last = tryMatch;
                    } else {
                        last.next = tryMatch;
                        last = tryMatch;
                    }
                }
            }
            ++i;
        }
        if (newMatch != null) {
            if (this.negative) {
                return false;
            }
            mymatch.assignFrom(newMatch);
            return true;
        }
        if (this.negative) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    void dump(StringBuffer os) {
        os.append(this.negative ? "[^" : "(?:");
        int i = 0;
        while (i < this.options.size()) {
            if (!this.negative && i > 0) {
                os.append('|');
            }
            ((REToken)this.options.elementAt(i)).dumpAll(os);
            ++i;
        }
        os.append(this.negative ? (char)']' : ')');
    }
}

