/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceType {
    private static List<ServiceType> members = new ArrayList<ServiceType>(20);
    public static final ServiceType NONE = new ServiceType("");
    public static final ServiceType ADDE = new ServiceType("ADDE");
    public static final ServiceType DODS = new ServiceType("DODS");
    public static final ServiceType OPENDAP = new ServiceType("OPENDAP");
    public static final ServiceType OPENDAPG = new ServiceType("OPENDAP-G");
    public static final ServiceType HTTPServer = new ServiceType("HTTPServer");
    public static final ServiceType FTP = new ServiceType("FTP");
    public static final ServiceType GRIDFTP = new ServiceType("GridFTP");
    public static final ServiceType FILE = new ServiceType("File");
    public static final ServiceType NetcdfServer = new ServiceType("NetcdfServer");
    public static final ServiceType NetcdfSubset = new ServiceType("NetcdfSubset");
    public static final ServiceType NetcdfStream = new ServiceType("NetcdfStream");
    public static final ServiceType LAS = new ServiceType("LAS");
    public static final ServiceType WMS = new ServiceType("WMS");
    public static final ServiceType WFS = new ServiceType("WFS");
    public static final ServiceType WCS = new ServiceType("WCS");
    public static final ServiceType WSDL = new ServiceType("WSDL");
    public static final ServiceType WebForm = new ServiceType("WebForm");
    public static final ServiceType CATALOG = new ServiceType("Catalog");
    public static final ServiceType QC = new ServiceType("QueryCapability");
    public static final ServiceType RESOLVER = new ServiceType("Resolver");
    public static final ServiceType COMPOUND = new ServiceType("Compound");
    public static final ServiceType THREDDS = new ServiceType("THREDDS");
    public static final ServiceType NETCDF = new ServiceType("NetCDF");
    public static final ServiceType HTTP = new ServiceType("HTTP");
    private String name;

    private ServiceType(String s) {
        this.name = s;
        members.add(this);
    }

    private ServiceType(String name, boolean fake) {
        this.name = name;
    }

    public static Collection<ServiceType> getAllTypes() {
        return members;
    }

    public static ServiceType findType(String name) {
        if (name == null) {
            return null;
        }
        for (ServiceType serviceType : members) {
            if (!serviceType.name.equalsIgnoreCase(name)) continue;
            return serviceType;
        }
        return null;
    }

    public static ServiceType getType(String name) {
        if (name == null) {
            return null;
        }
        ServiceType type = ServiceType.findType(name);
        return type != null ? type : new ServiceType(name, false);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceType)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }
}

