/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.ArrayList;
import java.util.List;
import thredds.catalog.DataFormatType;
import thredds.catalog2.Access;
import thredds.catalog2.Service;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.DatasetImpl;
import thredds.catalog2.simpleImpl.ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessImpl
implements Access,
AccessBuilder {
    private final DatasetImpl parentDs;
    private ServiceImpl service;
    private String urlPath;
    private DataFormatType dataFormat;
    private long dataSize;
    private boolean isBuilt = false;

    protected AccessImpl(DatasetImpl parentDataset) {
        this.parentDs = parentDataset;
    }

    @Override
    public void setServiceBuilder(ServiceBuilder service) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        if (service == null) {
            throw new IllegalArgumentException("Service must not be null.");
        }
        this.service = (ServiceImpl)service;
    }

    @Override
    public void setUrlPath(String urlPath) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        if (urlPath == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.urlPath = urlPath;
    }

    @Override
    public void setDataFormat(DataFormatType dataFormat) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        this.dataFormat = dataFormat != null ? dataFormat : DataFormatType.NONE;
    }

    @Override
    public void setDataSize(long dataSize) {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        if (dataSize < -1L) {
            throw new IllegalArgumentException("Value must be zero or greater, or -1 if unknown.");
        }
        this.dataSize = dataSize;
    }

    @Override
    public Service getService() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Access has escaped its AccessBuilder before build() was called.");
        }
        return this.service;
    }

    @Override
    public ServiceBuilder getServiceBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This AccessBuilder has been built.");
        }
        return this.service;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public DataFormatType getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public boolean isBuildable(List<BuilderIssue> issues) {
        if (this.isBuilt) {
            return true;
        }
        ArrayList<BuilderIssue> localIssues = new ArrayList<BuilderIssue>();
        if (this.service == null) {
            localIssues.add(new BuilderIssue("Dataset[\"" + this.parentDs.getName() + "\"] not accessible[\"" + this.urlPath + "\"] due to null service.", this));
        }
        if (this.urlPath == null) {
            localIssues.add(new BuilderIssue("Dataset[\"" + this.parentDs.getName() + "\"] not accessible[\"" + this.service != null ? this.service.getName() : "\"] due to null urlPath.", this));
        }
        if (this.service != null) {
            this.service.isBuildable(localIssues);
        }
        if (localIssues.isEmpty()) {
            return true;
        }
        issues.addAll(localIssues);
        return false;
    }

    @Override
    public Access build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        ArrayList<BuilderIssue> issues = new ArrayList<BuilderIssue>();
        if (!this.isBuildable(issues)) {
            throw new BuilderException(issues);
        }
        this.service.build();
        this.isBuilt = true;
        return this;
    }
}

