/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import thredds.catalog2.Metadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.MetadataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataImpl
implements Metadata,
MetadataBuilder {
    private boolean isContainedContent;
    private String title;
    private URI externalReference;
    private String content;
    private boolean isBuilt;

    public MetadataImpl() {
        this.isContainedContent = true;
        this.isBuilt = false;
    }

    public MetadataImpl(boolean isContainedContent) {
        this.isContainedContent = isContainedContent;
        this.isBuilt = false;
    }

    public MetadataImpl(String title, URI externalReference) {
        if (title == null) {
            throw new IllegalArgumentException("Title may not be null.");
        }
        if (externalReference == null) {
            throw new IllegalArgumentException("External reference URI may not be null.");
        }
        this.isContainedContent = false;
        this.title = title;
        this.externalReference = externalReference;
        this.content = null;
        this.isBuilt = false;
    }

    public MetadataImpl(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content string may not be null.");
        }
        this.isContainedContent = true;
        this.title = null;
        this.externalReference = null;
        this.content = content;
        this.isBuilt = false;
    }

    @Override
    public void setContainedContent(boolean isContainedContent) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        this.isContainedContent = isContainedContent;
    }

    @Override
    public boolean isContainedContent() {
        return this.isContainedContent;
    }

    @Override
    public void setTitle(String title) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        if (this.isContainedContent) {
            throw new IllegalStateException("This MetadataBuilder contains content, cannot set title.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Title may not be null.");
        }
        this.title = title;
    }

    @Override
    public String getTitle() {
        if (this.isContainedContent) {
            throw new IllegalStateException("Metadata with contained content has no title.");
        }
        return this.title;
    }

    @Override
    public void setExternalReference(URI externalReference) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        if (this.isContainedContent) {
            throw new IllegalStateException("This MetadataBuilder contains content, cannot set external reference.");
        }
        if (externalReference == null) {
            throw new IllegalArgumentException("External reference may not be null.");
        }
        this.externalReference = externalReference;
    }

    @Override
    public URI getExternalReference() {
        if (this.isContainedContent) {
            throw new IllegalStateException("Metadata with contained content has no external reference.");
        }
        return this.externalReference;
    }

    @Override
    public void setContent(String content) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        if (!this.isContainedContent) {
            throw new IllegalStateException("This MetadataBuilder has external reference, cannot set content.");
        }
        if (this.externalReference == null) {
            throw new IllegalArgumentException("External reference may not be null.");
        }
    }

    @Override
    public String getContent() {
        if (!this.isContainedContent) {
            throw new IllegalStateException("Metadata with external reference has no content, dereference external reference to obtain metadata content.");
        }
        return this.content;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public boolean isBuildable(List<BuilderIssue> issues) {
        if (this.isBuilt) {
            return true;
        }
        if (this.isContainedContent) {
            if (this.content == null) {
                issues.add(new BuilderIssue("MetadataBuilder contains null content.", this));
                return false;
            }
        } else if (this.title == null || this.externalReference == null) {
            issues.add(new BuilderIssue("MetadataBuilder with link has null title and/or link URI.", this));
            return false;
        }
        return true;
    }

    @Override
    public Metadata build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        ArrayList<BuilderIssue> issues = new ArrayList<BuilderIssue>();
        if (!this.isBuildable(issues)) {
            throw new BuilderException(issues);
        }
        if (this.isContainedContent) {
            this.title = null;
            this.externalReference = null;
        } else {
            this.content = null;
        }
        this.isBuilt = true;
        return this;
    }
}

