/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Service;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceContainer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, ServiceImpl> servicesMap = null;
    private final ServiceContainer rootContainer;
    private Map<String, ServiceImpl> servicesByGloballyUniqueName;
    private boolean isBuilt = false;

    ServiceContainer(ServiceContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    ServiceContainer getRootServiceContainer() {
        if (this.rootContainer != null) {
            return this.rootContainer;
        }
        return this;
    }

    public boolean isServiceNameInUseGlobally(String name) {
        return this.getServiceByGloballyUniqueName(name) != null;
    }

    protected boolean addServiceByGloballyUniqueName(ServiceImpl service) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceContainer has been built.");
        }
        if (service == null) {
            return false;
        }
        if (this.rootContainer != null) {
            return this.rootContainer.addServiceByGloballyUniqueName(service);
        }
        if (this.servicesByGloballyUniqueName == null) {
            this.servicesByGloballyUniqueName = new HashMap<String, ServiceImpl>();
        }
        if (this.servicesByGloballyUniqueName.containsKey(service.getName())) {
            return false;
        }
        ServiceImpl replacedService = this.servicesByGloballyUniqueName.put(service.getName(), service);
        if (replacedService == null) {
            return true;
        }
        String msg = "ServiceContainer in bad state [containsKey(" + service.getName() + ")==false then put()!=null].";
        this.log.error("addServiceByGloballyUniqueName(): " + msg);
        throw new IllegalStateException(msg);
    }

    protected boolean removeServiceByGloballyUniqueName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceContainer has been built.");
        }
        if (name == null) {
            return false;
        }
        if (this.rootContainer != null) {
            return this.rootContainer.removeServiceByGloballyUniqueName(name);
        }
        if (this.servicesByGloballyUniqueName == null) {
            return false;
        }
        ServiceImpl removedService = this.servicesByGloballyUniqueName.remove(name);
        return removedService != null;
    }

    protected ServiceImpl getServiceByGloballyUniqueName(String name) {
        if (name == null) {
            return null;
        }
        if (this.rootContainer != null) {
            return this.rootContainer.getServiceByGloballyUniqueName(name);
        }
        if (this.servicesByGloballyUniqueName == null) {
            return null;
        }
        return this.servicesByGloballyUniqueName.get(name);
    }

    public boolean isEmpty() {
        if (this.servicesMap == null) {
            return true;
        }
        return this.servicesMap.isEmpty();
    }

    public int size() {
        if (this.servicesMap == null) {
            return 0;
        }
        return this.servicesMap.size();
    }

    public void addService(ServiceImpl service) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceContainer has been built.");
        }
        if (this.servicesMap == null) {
            this.servicesMap = new LinkedHashMap<String, ServiceImpl>();
        }
        if (!this.addServiceByGloballyUniqueName(service)) {
            throw new IllegalStateException("Service name is already being used.");
        }
        if (null != this.servicesMap.put(service.getName(), service)) {
            this.log.error("addService(): reset service name [" + service.getName() + "].");
        }
    }

    public ServiceImpl removeService(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceContainer has been built.");
        }
        if (name == null) {
            return null;
        }
        if (this.servicesMap == null) {
            return null;
        }
        ServiceImpl removedService = this.servicesMap.remove(name);
        if (removedService == null) {
            return null;
        }
        if (!this.removeServiceByGloballyUniqueName(name)) {
            String msg = "Unique service name removal inconsistent with service removal [" + name + "].";
            this.log.error("removeService(): " + msg);
            throw new IllegalStateException(msg);
        }
        return removedService;
    }

    public List<Service> getServices() {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being finished().");
        }
        if (this.servicesMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ServiceImpl>(this.servicesMap.values()));
    }

    public boolean containsServiceName(String name) {
        if (name == null) {
            return false;
        }
        if (this.servicesMap == null) {
            return false;
        }
        return this.servicesMap.get(name) != null;
    }

    public Service getServiceByName(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("This Service has escaped from its ServiceBuilder without being finished().");
        }
        if (name == null) {
            return null;
        }
        if (this.servicesMap == null) {
            return null;
        }
        return this.servicesMap.get(name);
    }

    public List<ServiceBuilder> getServiceBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been finished().");
        }
        if (this.servicesMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ServiceImpl>(this.servicesMap.values()));
    }

    public ServiceBuilder getServiceBuilderByName(String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This ServiceBuilder has been finished().");
        }
        if (name == null) {
            return null;
        }
        if (this.servicesMap == null) {
            return null;
        }
        return this.servicesMap.get(name);
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public boolean isBuildable(List<BuilderIssue> issues) {
        if (this.isBuilt) {
            return true;
        }
        ArrayList<BuilderIssue> localIssues = new ArrayList<BuilderIssue>();
        if (this.servicesMap != null) {
            for (ServiceImpl sb : this.servicesMap.values()) {
                sb.isBuildable(localIssues);
            }
        }
        if (localIssues.isEmpty()) {
            return true;
        }
        issues.addAll(localIssues);
        return false;
    }

    public void build() throws BuilderException {
        if (this.isBuilt) {
            return;
        }
        ArrayList<BuilderIssue> issues = new ArrayList<BuilderIssue>();
        if (!this.isBuildable(issues)) {
            throw new BuilderException(issues);
        }
        if (this.servicesMap != null) {
            for (ServiceImpl sb : this.servicesMap.values()) {
                sb.build();
            }
        }
        this.isBuilt = true;
    }
}

