/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.sax;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogEntityResolver
implements EntityResolver {
    private Map<String, RegisteredEntity> entityMap = new HashMap<String, RegisteredEntity>();

    public void setEntityMap(Map<String, RegisteredEntity> entityMap) {
        this.entityMap = entityMap != null ? entityMap : new HashMap();
    }

    public void addEntity(RegisteredEntity entity) {
        if (entity != null) {
            this.entityMap.put(entity.getSystemId(), entity);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.entityMap.containsKey(systemId)) {
            RegisteredEntity entity = this.entityMap.get(systemId);
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(entity.getResourceName());
            if (inStream == null) {
                return null;
            }
            InputSource inSource = new InputSource(inStream);
            inSource.setPublicId(publicId);
            inSource.setSystemId(systemId);
            return inSource;
        }
        return null;
    }

    public static class RegisteredEntity {
        private String publicId;
        private String systemId;
        private String resourceName;

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }
    }
}

