/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;

public abstract class AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected final XMLEventReader reader;
    protected final QName elementName;

    AbstractElementParser(XMLEventReader reader, QName elementName) {
        this.reader = reader;
        this.elementName = elementName;
    }

    protected static boolean isSelfElement(XMLEvent event, QName selfElementName) {
        QName elemName = null;
        if (event.isStartElement()) {
            elemName = event.asStartElement().getName();
        } else if (event.isEndElement()) {
            elemName = event.asEndElement().getName();
        } else {
            return false;
        }
        return elemName.equals(selfElementName);
    }

    protected abstract boolean isSelfElement(XMLEvent var1);

    protected abstract ThreddsBuilder parseStartElement(StartElement var1) throws ThreddsXmlParserException;

    protected abstract void handleChildStartElement(StartElement var1, ThreddsBuilder var2) throws ThreddsXmlParserException;

    protected abstract void postProcessing(ThreddsBuilder var1) throws ThreddsXmlParserException;

    public final ThreddsBuilder parse() throws ThreddsXmlParserException {
        try {
            XMLEvent event = this.reader.nextEvent();
            if (!event.isStartElement()) {
                throw new ThreddsXmlParserException("Next XML event not a start element.");
            }
            ThreddsBuilder builder = this.parseStartElement(event.asStartElement());
            while (this.reader.hasNext()) {
                event = this.reader.peek();
                if (event.isStartElement()) {
                    this.handleChildStartElement(event.asStartElement(), builder);
                    continue;
                }
                if (event.isEndElement()) {
                    if (this.isSelfElement(event.asEndElement())) {
                        this.reader.next();
                        break;
                    }
                    this.log.error("parse(): Unrecognized end element [" + event.asEndElement().getName() + "].");
                    this.reader.next();
                    continue;
                }
                this.log.debug("parse(): Unhandled event [" + event.getLocation() + "--" + event + "].");
                this.reader.next();
            }
            this.postProcessing(builder);
            return builder;
        }
        catch (XMLStreamException e) {
            this.log.error("parse(): Failed to parse " + this.elementName + " element: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse " + this.elementName + " element: " + e.getMessage(), e);
        }
    }
}

