/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.util.CatalogNamespace;

public class AccessElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final QName elementName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), "access");
    private static final QName serviceNameAttName = new QName("", "serviceName");
    private static final QName urlPathAttName = new QName("", "urlPath");
    private static final QName dataFormatAttName = new QName("", "dataFormat");
    private final DatasetBuilder datasetBuilder;

    public AccessElementParser(XMLEventReader reader, DatasetBuilder datasetBuilder) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.datasetBuilder = datasetBuilder;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return AccessElementParser.isSelfElement(event, elementName);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return AccessElementParser.isSelfElement(event, elementName);
    }

    protected AccessBuilder parseStartElement(StartElement startElement) throws ThreddsXmlParserException {
        if (!startElement.getName().equals(elementName)) {
            throw new IllegalArgumentException("Start element must be an 'access' element.");
        }
        AccessBuilder builder = null;
        if (this.datasetBuilder == null) {
            throw new ThreddsXmlParserException("");
        }
        builder = this.datasetBuilder.addAccessBuilder();
        Attribute serviceNameAtt = startElement.getAttributeByName(serviceNameAttName);
        String serviceName = serviceNameAtt.getValue();
        ServiceBuilder serviceBuilder = this.datasetBuilder.getParentCatalogBuilder().findServiceBuilderByNameGlobally(serviceName);
        Attribute urlPathAtt = startElement.getAttributeByName(urlPathAttName);
        String urlPath = urlPathAtt.getValue();
        builder.setServiceBuilder(serviceBuilder);
        builder.setUrlPath(urlPath);
        Attribute dataFormatAtt = startElement.getAttributeByName(dataFormatAttName);
        if (dataFormatAtt != null) {
            builder.setDataFormat(DataFormatType.getType(dataFormatAtt.getValue()));
        }
        return builder;
    }

    protected void handleChildStartElement(StartElement startElement, ThreddsBuilder builder) throws ThreddsXmlParserException {
        StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

