/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogBuilderFactory;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.ServiceElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.util.CatalogNamespace;

public class CatalogElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final QName elementName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), "catalog");
    private static final QName nameAttName = new QName("", "name");
    private static final QName versionAttName = new QName("", "version");
    private static final QName expiresAttName = new QName("", "expires");
    private static final QName lastModifiedAttName = new QName("", "lastModified");
    private final String docBaseUriString;
    private final CatalogBuilderFactory catBuilderFactory;

    public CatalogElementParser(String docBaseUriString, XMLEventReader reader, CatalogBuilderFactory catBuilderFactory) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.docBaseUriString = docBaseUriString;
        this.catBuilderFactory = catBuilderFactory;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return CatalogElementParser.isSelfElement(event, elementName);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return CatalogElementParser.isSelfElement(event, elementName);
    }

    protected CatalogBuilder parseStartElement(StartElement startElement) throws ThreddsXmlParserException {
        if (!startElement.getName().equals(elementName)) {
            throw new IllegalArgumentException("Start element not 'catalog' element.");
        }
        Attribute nameAtt = startElement.getAttributeByName(nameAttName);
        String nameString = nameAtt != null ? nameAtt.getValue() : null;
        Attribute versionAtt = startElement.getAttributeByName(versionAttName);
        String versionString = versionAtt != null ? versionAtt.getValue() : null;
        Attribute expiresAtt = startElement.getAttributeByName(expiresAttName);
        Date expiresDate = null;
        Attribute lastModifiedAtt = startElement.getAttributeByName(lastModifiedAttName);
        Date lastModifiedDate = null;
        URI docBaseUri = null;
        try {
            docBaseUri = new URI(this.docBaseUriString);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad catalog base URI [" + this.docBaseUriString + "]: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Bad catalog base URI [" + this.docBaseUriString + "]: " + e.getMessage(), e);
        }
        return this.catBuilderFactory.newCatalogBuilder(nameString, docBaseUri, versionString, expiresDate, lastModifiedDate);
    }

    protected void handleChildStartElement(StartElement startElement, ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof CatalogBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        CatalogBuilder catalogBuilder = (CatalogBuilder)builder;
        if (ServiceElementParser.isSelfElementStatic(startElement)) {
            ServiceElementParser serviceElemParser = new ServiceElementParser(this.reader, catalogBuilder);
            serviceElemParser.parse();
        } else if (PropertyElementParser.isSelfElementStatic(startElement)) {
            PropertyElementParser parser = new PropertyElementParser(this.reader, catalogBuilder);
            parser.parse();
        } else if (DatasetElementParser.isSelfElementStatic(startElement)) {
            DatasetElementParser parser = new DatasetElementParser(this.reader, catalogBuilder, null);
            parser.parse();
        } else {
            StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader);
        }
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

