/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogBuilderFactory;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserUtils;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.util.CatalogNamespace;

public class CatalogRefElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final QName elementName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), "catalogRef");
    protected static final QName xlinkTitleAttName = new QName(CatalogNamespace.XLINK.getNamespaceUri(), "title");
    protected static final QName xlinkHrefAttName = new QName(CatalogNamespace.XLINK.getNamespaceUri(), "href");
    protected static final QName xlinkTypeAttName = new QName(CatalogNamespace.XLINK.getNamespaceUri(), "type");
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final CatalogBuilderFactory catBuilderFactory;
    private final DatasetNodeElementParserUtils datasetNodeElementParserUtils;

    public CatalogRefElementParser(XMLEventReader reader, CatalogBuilder catBuilder, DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserUtils = new DatasetNodeElementParserUtils(parentDatasetNodeElementParserUtils);
    }

    public CatalogRefElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserUtils = new DatasetNodeElementParserUtils(parentDatasetNodeElementParserUtils);
    }

    public CatalogRefElementParser(XMLEventReader reader, CatalogBuilderFactory catBuilderFactory, DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserUtils = new DatasetNodeElementParserUtils(parentDatasetNodeElementParserUtils);
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return CatalogRefElementParser.isSelfElement(event, elementName);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return CatalogRefElementParser.isSelfElement(event, elementName);
    }

    protected DatasetNodeBuilder parseStartElement(StartElement startElement) throws ThreddsXmlParserException {
        if (!startElement.getName().equals(elementName)) {
            throw new IllegalArgumentException("Start element not 'catalogRef' element.");
        }
        Attribute titleAtt = startElement.getAttributeByName(xlinkTitleAttName);
        String title = titleAtt.getValue();
        Attribute hrefAtt = startElement.getAttributeByName(xlinkHrefAttName);
        String href = hrefAtt.getValue();
        URI hrefUri = null;
        try {
            hrefUri = new URI(href);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad catalog base URI [" + href + "]: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Bad catalog base URI [" + href + "]: " + e.getMessage(), e);
        }
        CatalogRefBuilder catalogRefBuilder = null;
        if (this.catBuilder != null) {
            catalogRefBuilder = this.catBuilder.addCatalogRef(title, hrefUri);
        } else if (this.datasetNodeBuilder != null) {
            catalogRefBuilder = this.datasetNodeBuilder.addCatalogRef(title, hrefUri);
        } else if (this.catBuilderFactory != null) {
            catalogRefBuilder = this.catBuilderFactory.newCatalogRefBuilder(title, hrefUri);
        } else {
            throw new ThreddsXmlParserException("");
        }
        this.datasetNodeElementParserUtils.parseStartElementIdAttribute(startElement, catalogRefBuilder);
        this.datasetNodeElementParserUtils.parseStartElementIdAuthorityAttribute(startElement, catalogRefBuilder);
        return catalogRefBuilder;
    }

    protected void handleChildStartElement(StartElement startElement, ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof CatalogRefBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        if (this.datasetNodeElementParserUtils.handleBasicChildStartElement(startElement, this.reader, (CatalogRefBuilder)builder)) {
            return;
        }
        StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

