/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogBuilderFactory;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.AccessElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserUtils;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.util.CatalogNamespace;

public class DatasetElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final QName elementName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), "dataset");
    private static final QName nameAttName = new QName("", "name");
    private static final QName idAttName = new QName("", "ID");
    private static final QName urlPathAttName = new QName("", "urlPath");
    private static final QName serviceNameAttName = new QName("", "serviceName");
    private static final QName collectionTypeAttName = new QName("", "collectionType");
    private static final QName harvestAttName = new QName("", "harvest");
    private static final QName restrictedAccessAttName = new QName("", "resourceControl");
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final CatalogBuilderFactory catBuilderFactory;
    private final DatasetNodeElementParserUtils datasetNodeElementParserUtils;

    public DatasetElementParser(XMLEventReader reader, CatalogBuilder catBuilder, DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserUtils = new DatasetNodeElementParserUtils(parentDatasetNodeElementParserUtils);
    }

    public DatasetElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserUtils = new DatasetNodeElementParserUtils(parentDatasetNodeElementParserUtils);
    }

    public DatasetElementParser(XMLEventReader reader, CatalogBuilderFactory catBuilderFactory, DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserUtils = new DatasetNodeElementParserUtils(parentDatasetNodeElementParserUtils);
    }

    protected void setDefaultServiceName(String defaultServiceName) {
        this.datasetNodeElementParserUtils.setDefaultServiceName(defaultServiceName);
    }

    protected String getDefaultServiceName() {
        return this.datasetNodeElementParserUtils.getDefaultServiceName();
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return DatasetElementParser.isSelfElement(event, elementName);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return DatasetElementParser.isSelfElement(event, elementName);
    }

    protected DatasetBuilder parseStartElement(StartElement startElement) throws ThreddsXmlParserException {
        Attribute urlPathAtt;
        if (!startElement.getName().equals(elementName)) {
            throw new IllegalArgumentException("Start element is not 'dataset' element.");
        }
        Attribute nameAtt = startElement.getAttributeByName(nameAttName);
        String name = nameAtt.getValue();
        DatasetBuilder datasetBuilder = null;
        if (this.catBuilder != null) {
            datasetBuilder = this.catBuilder.addDataset(name);
        } else if (this.datasetNodeBuilder != null) {
            datasetBuilder = this.datasetNodeBuilder.addDataset(name);
        } else if (this.catBuilderFactory != null) {
            datasetBuilder = this.catBuilderFactory.newDatasetBuilder(name);
        } else {
            throw new ThreddsXmlParserException("");
        }
        this.datasetNodeElementParserUtils.parseStartElementIdAttribute(startElement, datasetBuilder);
        this.datasetNodeElementParserUtils.parseStartElementIdAuthorityAttribute(startElement, datasetBuilder);
        Attribute serviceNameAtt = startElement.getAttributeByName(serviceNameAttName);
        if (serviceNameAtt != null) {
            this.setDefaultServiceName(serviceNameAtt.getValue());
        }
        if ((urlPathAtt = startElement.getAttributeByName(urlPathAttName)) != null) {
            AccessBuilder accessBuilder = datasetBuilder.addAccessBuilder();
            accessBuilder.setUrlPath(urlPathAtt.getValue());
        }
        return datasetBuilder;
    }

    protected void handleChildStartElement(StartElement startElement, ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof DatasetBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        DatasetBuilder datasetBuilder = (DatasetBuilder)builder;
        if (this.datasetNodeElementParserUtils.handleBasicChildStartElement(startElement, this.reader, datasetBuilder)) {
            return;
        }
        if (this.datasetNodeElementParserUtils.handleCollectionChildStartElement(startElement, this.reader, datasetBuilder)) {
            return;
        }
        if (AccessElementParser.isSelfElementStatic(startElement)) {
            AccessElementParser parser = new AccessElementParser(this.reader, datasetBuilder);
            parser.parse();
            return;
        }
        StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader);
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof DatasetBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetBuilder.");
        }
        DatasetBuilder datasetBuilder = (DatasetBuilder)builder;
        this.datasetNodeElementParserUtils.postProcessing(builder);
        if (this.getDefaultServiceName() != null && !datasetBuilder.getAccessBuilders().isEmpty()) {
            ServiceBuilder defaultServiceBuilder = datasetBuilder.getParentCatalogBuilder().findServiceBuilderByNameGlobally(this.getDefaultServiceName());
            for (AccessBuilder curAB : datasetBuilder.getAccessBuilders()) {
                if (curAB.getServiceBuilder() != null) continue;
                curAB.setServiceBuilder(defaultServiceBuilder);
            }
        }
    }
}

