/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.CatalogRefElementParser;
import thredds.catalog2.xml.parser.stax.DatasetElementParser;
import thredds.catalog2.xml.parser.stax.MetadataElementParser;
import thredds.catalog2.xml.parser.stax.PropertyElementParser;
import thredds.catalog2.xml.parser.stax.ThreddsMetadataElementParser;

public class DatasetNodeElementParserUtils {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final QName nameAttName = new QName("", "name");
    protected static final QName idAttName = new QName("", "ID");
    protected static final QName authorityAttName = new QName("", "authority");
    private final DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils;
    private ThreddsMetadataElementParser threddsMetadataElementParser;
    private String idAuthorityThatGetsInherited;
    private String defaultServiceName;
    private String defaultServiceNameThatGetsInherited;

    DatasetNodeElementParserUtils(DatasetNodeElementParserUtils parentDatasetNodeElementParserUtils) {
        this.parentDatasetNodeElementParserUtils = parentDatasetNodeElementParserUtils;
    }

    public void setIdAuthorityThatGetsInherited(String idAuthorityThatGetsInherited) {
        this.idAuthorityThatGetsInherited = idAuthorityThatGetsInherited;
    }

    public String getIdAuthorityThatGetsInherited() {
        return this.idAuthorityThatGetsInherited;
    }

    public void parseStartElementNameAttribute(StartElement startElement, DatasetNodeBuilder dsNodeBuilder) {
        Attribute att = startElement.getAttributeByName(nameAttName);
        if (att != null) {
            dsNodeBuilder.setName(att.getValue());
        }
    }

    public void parseStartElementIdAttribute(StartElement startElement, DatasetNodeBuilder dsNodeBuilder) {
        Attribute att = startElement.getAttributeByName(idAttName);
        if (att != null) {
            dsNodeBuilder.setId(att.getValue());
        }
    }

    public void parseStartElementIdAuthorityAttribute(StartElement startElement, DatasetNodeBuilder dsNodeBuilder) {
        Attribute att = startElement.getAttributeByName(authorityAttName);
        if (att != null) {
            dsNodeBuilder.setId(att.getValue());
        }
    }

    public boolean handleBasicChildStartElement(StartElement startElement, XMLEventReader reader, DatasetNodeBuilder dsNodeBuilder) throws ThreddsXmlParserException {
        if (PropertyElementParser.isSelfElementStatic(startElement)) {
            PropertyElementParser parser = new PropertyElementParser(reader, dsNodeBuilder);
            parser.parse();
            return true;
        }
        if (MetadataElementParser.isSelfElementStatic(startElement)) {
            MetadataElementParser parser = new MetadataElementParser(reader, dsNodeBuilder, this);
            parser.parse();
            return true;
        }
        if (ThreddsMetadataElementParser.isSelfElementStatic(startElement)) {
            if (this.threddsMetadataElementParser == null) {
                this.threddsMetadataElementParser = new ThreddsMetadataElementParser(reader, dsNodeBuilder, this);
            }
            this.threddsMetadataElementParser.parse();
            return true;
        }
        return false;
    }

    public boolean handleCollectionChildStartElement(StartElement startElement, XMLEventReader reader, DatasetNodeBuilder dsNodeBuilder) throws ThreddsXmlParserException {
        if (DatasetElementParser.isSelfElementStatic(startElement)) {
            DatasetElementParser parser = new DatasetElementParser(reader, dsNodeBuilder, this);
            parser.parse();
            return true;
        }
        if (CatalogRefElementParser.isSelfElementStatic(startElement)) {
            CatalogRefElementParser parser = new CatalogRefElementParser(reader, dsNodeBuilder, this);
            parser.parse();
            return true;
        }
        return false;
    }

    public void postProcessing(ThreddsBuilder builder) {
        if (!(builder instanceof DatasetNodeBuilder)) {
            throw new IllegalArgumentException("Given ThreddsBuilder must be an instance of DatasetNodeBuilder.");
        }
        DatasetNodeBuilder datasetNodeBuilder = (DatasetNodeBuilder)builder;
        if (this.defaultServiceName == null) {
            this.defaultServiceName = this.getInheritedDefaultServiceName(this);
        }
    }

    String getDefaultServiceName() {
        return this.defaultServiceName;
    }

    void setDefaultServiceName(String defaultServiceName) {
        this.defaultServiceName = defaultServiceName;
    }

    protected void setDefaultServiceNameThatGetsInherited(String defaultServiceNameThatGetsInherited) {
        this.defaultServiceNameThatGetsInherited = defaultServiceNameThatGetsInherited;
    }

    protected String getDefaultServiceNameThatGetsInherited() {
        return this.defaultServiceNameThatGetsInherited;
    }

    private String getInheritedDefaultServiceName(DatasetNodeElementParserUtils selfOrAncestor) {
        if (selfOrAncestor == null) {
            return null;
        }
        String curDefServiceName = selfOrAncestor.getDefaultServiceNameThatGetsInherited();
        if (curDefServiceName == null) {
            curDefServiceName = this.getInheritedDefaultServiceName(selfOrAncestor.parentDatasetNodeElementParserUtils);
        }
        return curDefServiceName;
    }
}

