/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilderFactory;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserUtils;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.util.CatalogNamespace;

public class MetadataElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final QName elementName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), "metadata");
    private static final QName inheritedAttName = new QName(CatalogNamespace.XLINK.getNamespaceUri(), "inherited");
    private static final QName titleAttName = new QName(CatalogNamespace.XLINK.getNamespaceUri(), "title");
    private static final QName externalRefAttName = new QName(CatalogNamespace.XLINK.getNamespaceUri(), "href");
    private final DatasetNodeBuilder datasetBuilder;
    private final CatalogBuilderFactory catBuilderFactory;
    private final DatasetNodeElementParserUtils datasetNodeElementParserUtils;
    private boolean isMetadataElementInherited;
    private StringBuilder content = null;

    public MetadataElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder, DatasetNodeElementParserUtils datasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.datasetBuilder = datasetNodeBuilder;
        this.catBuilderFactory = null;
        this.datasetNodeElementParserUtils = datasetNodeElementParserUtils;
        this.isMetadataElementInherited = false;
    }

    public MetadataElementParser(XMLEventReader reader, CatalogBuilderFactory catBuilderFactory, DatasetNodeElementParserUtils datasetNodeElementParserUtils) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.datasetBuilder = null;
        this.catBuilderFactory = catBuilderFactory;
        this.datasetNodeElementParserUtils = datasetNodeElementParserUtils;
        this.isMetadataElementInherited = false;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return MetadataElementParser.isSelfElement(event, elementName);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return MetadataElementParser.isSelfElement(event, elementName);
    }

    public boolean doesMetadataElementGetInherited() {
        return this.isMetadataElementInherited;
    }

    protected MetadataBuilder parseStartElement(StartElement startElement) throws ThreddsXmlParserException {
        if (!startElement.getName().equals(elementName)) {
            throw new IllegalArgumentException("Start element is not 'metadata' element.");
        }
        MetadataBuilder builder = null;
        if (this.datasetBuilder != null) {
            builder = this.datasetBuilder.addMetadata();
        } else if (this.catBuilderFactory != null) {
            builder = this.catBuilderFactory.newMetadataBuilder();
        } else {
            throw new ThreddsXmlParserException("");
        }
        Attribute inheritedAtt = startElement.getAttributeByName(inheritedAttName);
        if (inheritedAtt != null && inheritedAtt.getValue().equalsIgnoreCase("true")) {
            this.isMetadataElementInherited = true;
        }
        Attribute titleAtt = startElement.getAttributeByName(titleAttName);
        Attribute externalRefAtt = startElement.getAttributeByName(externalRefAttName);
        if (titleAtt == null && externalRefAtt == null) {
            builder.setContainedContent(true);
            return builder;
        }
        if (titleAtt == null || externalRefAtt == null) {
            throw new ThreddsXmlParserException("MetadataBuilder with link has a null title or link URL ");
        }
        String title = titleAtt.getValue();
        String uriString = externalRefAtt.getValue();
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new ThreddsXmlParserException("MetadataBuilder with link has link with bad URI syntax.", e);
        }
        builder.setContainedContent(false);
        builder.setTitle(title);
        builder.setExternalReference(uri);
        return builder;
    }

    protected void handleChildStartElement(StartElement startElement, ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (this.content == null) {
            this.content = new StringBuilder();
        }
        this.content.append(StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader));
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!(builder instanceof MetadataBuilder)) {
            throw new IllegalArgumentException("Builder must be a MetadataBuilder.");
        }
        MetadataBuilder mdBldr = (MetadataBuilder)builder;
        if (this.content != null) {
            mdBldr.setContent(this.content.toString());
        }
    }
}

