/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.util.CatalogNamespace;

public class PropertyElementParser
extends AbstractElementParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final QName elementName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), "property");
    private static final QName nameAttName = new QName("", "name");
    private static final QName valueAttName = new QName("", "value");
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final ServiceBuilder serviceBuilder;

    public boolean isChildElement(XMLEvent event) {
        return false;
    }

    public PropertyElementParser(XMLEventReader reader, CatalogBuilder catBuilder) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.serviceBuilder = null;
    }

    public PropertyElementParser(XMLEventReader reader, DatasetNodeBuilder datasetNodeBuilder) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.serviceBuilder = null;
    }

    public PropertyElementParser(XMLEventReader reader, ServiceBuilder serviceBuilder) throws ThreddsXmlParserException {
        super(reader, elementName);
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.serviceBuilder = serviceBuilder;
    }

    protected static boolean isSelfElementStatic(XMLEvent event) {
        return PropertyElementParser.isSelfElement(event, elementName);
    }

    protected boolean isSelfElement(XMLEvent event) {
        return PropertyElementParser.isSelfElement(event, elementName);
    }

    protected ThreddsBuilder parseStartElement(StartElement startElement) throws ThreddsXmlParserException {
        if (!startElement.getName().equals(elementName)) {
            throw new IllegalArgumentException("Start element must be a 'property' element.");
        }
        Attribute nameAtt = startElement.getAttributeByName(nameAttName);
        String name = nameAtt.getValue();
        Attribute valueAtt = startElement.getAttributeByName(valueAttName);
        String value = valueAtt.getValue();
        if (this.catBuilder != null) {
            this.catBuilder.addProperty(name, value);
        } else if (this.datasetNodeBuilder != null) {
            this.datasetNodeBuilder.addProperty(name, value);
        } else if (this.serviceBuilder != null) {
            this.serviceBuilder.addProperty(name, value);
        } else {
            throw new ThreddsXmlParserException("Unknown builder - for addProperty().");
        }
        return null;
    }

    protected void handleChildStartElement(StartElement startElement, ThreddsBuilder builder) throws ThreddsXmlParserException {
        if (!this.isChildElement(startElement)) {
            StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader);
        }
    }

    protected void postProcessing(ThreddsBuilder builder) throws ThreddsXmlParserException {
    }
}

