/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Catalog;
import thredds.catalog2.Dataset;
import thredds.catalog2.Metadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.simpleImpl.CatalogBuilderFactoryImpl;
import thredds.catalog2.xml.parser.ThreddsXmlParser;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.CatalogElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.util.HttpUriResolver;
import thredds.util.HttpUriResolverFactory;

public class StaxThreddsXmlParser
implements ThreddsXmlParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private XMLEventReader reader;

    private StaxThreddsXmlParser() {
        this.factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.reader = null;
    }

    public static StaxThreddsXmlParser newInstance() {
        return new StaxThreddsXmlParser();
    }

    private CatalogBuilder readCatalogXML(Source source) throws ThreddsXmlParserException {
        try {
            this.reader = this.factory.createXMLEventReader(source);
            CatalogBuilderFactoryImpl catBuilderFac = new CatalogBuilderFactoryImpl();
            CatalogBuilder catBuilder = null;
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.peek();
                if (event.isEndDocument()) {
                    this.reader.next();
                    continue;
                }
                if (event.isStartDocument()) {
                    this.reader.next();
                    continue;
                }
                if (event.isStartElement()) {
                    if (CatalogElementParser.isSelfElementStatic(event.asStartElement())) {
                        CatalogElementParser catElemParser = new CatalogElementParser(source.getSystemId(), this.reader, catBuilderFac);
                        catBuilder = (CatalogBuilder)catElemParser.parse();
                        continue;
                    }
                    StaxThreddsXmlParserUtils.readElementAndAnyContent(this.reader);
                    this.log.warn("readCatalogXML(): Unrecognized start element [" + event.asStartElement().getName() + "].");
                    this.reader.next();
                    continue;
                }
                if (event.isEndElement()) {
                    if (CatalogElementParser.isSelfElementStatic(event.asEndElement())) break;
                    this.log.error("readCatalogXML(): Unrecognized end element [" + event.asEndElement().getName() + "].");
                    break;
                }
                this.log.debug("readCatalogXML(): Unhandled event [" + event.getLocation() + "--" + event + "].");
                this.reader.next();
            }
            this.reader.close();
            if (catBuilder == null) {
                return null;
            }
            return catBuilder;
        }
        catch (XMLStreamException e) {
            this.log.error("readCatalogXML(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    public Catalog parse(URI documentUri) throws ThreddsXmlParserException {
        HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver(documentUri);
        InputStream is = null;
        try {
            httpUriResolver.makeRequest();
            is = httpUriResolver.getResponseBodyAsInputStream();
        }
        catch (IOException e) {
            throw new ThreddsXmlParserException("", e);
        }
        StreamSource s = new StreamSource(is, documentUri.toString());
        try {
            return this.readCatalogXML(s).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    public Catalog parse(File file, URI docBaseUri) throws ThreddsXmlParserException {
        try {
            return this.parseIntoBuilder(file, docBaseUri).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    public Catalog parse(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        try {
            return this.parseIntoBuilder(reader, docBaseUri).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    public Catalog parse(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        try {
            return this.parseIntoBuilder(is, docBaseUri).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    public CatalogBuilder parseIntoBuilder(URI documentUri) throws ThreddsXmlParserException {
        HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver(documentUri);
        InputStream is = null;
        try {
            httpUriResolver.makeRequest();
            is = httpUriResolver.getResponseBodyAsInputStream();
        }
        catch (IOException e) {
            throw new ThreddsXmlParserException("", e);
        }
        StreamSource s = new StreamSource(is, documentUri.toString());
        return this.readCatalogXML(s);
    }

    public CatalogBuilder parseIntoBuilder(File file, URI docBaseUri) throws ThreddsXmlParserException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        StreamSource s = null;
        if (docBaseUri == null) {
            s = new StreamSource(file);
        } else {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                this.log.error("parseIntoBuilder(): Couldn't find file []: " + e.getMessage(), e);
                throw new ThreddsXmlParserException("Couldn't find file []: " + e.getMessage(), e);
            }
            s = new StreamSource(is, docBaseUri.toString());
        }
        return this.readCatalogXML(s);
    }

    public CatalogBuilder parseIntoBuilder(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        StreamSource source = new StreamSource(reader, docBaseUri.toString());
        return this.readCatalogXML(source);
    }

    public CatalogBuilder parseIntoBuilder(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        StreamSource source = new StreamSource(is, docBaseUri.toString());
        return this.readCatalogXML(source);
    }

    public Dataset parseDataset(URI documentUri) throws ThreddsXmlParserException {
        return null;
    }

    public Dataset parseDataset(File file, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public Dataset parseDataset(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public Dataset parseDataset(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public DatasetBuilder parseDatasetIntoBuilder(URI documentUri) throws ThreddsXmlParserException {
        return null;
    }

    public DatasetBuilder parseDatasetIntoBuilder(File file, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public DatasetBuilder parseDatasetIntoBuilder(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public DatasetBuilder parseDatasetIntoBuilder(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public Metadata parseMetadata(URI documentUri) throws ThreddsXmlParserException {
        return null;
    }

    public Metadata parseMetadata(File file, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public Metadata parseMetadata(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public Metadata parseMetadata(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public MetadataBuilder parseMetadataIntoBuilder(URI documentUri) throws ThreddsXmlParserException {
        return null;
    }

    public MetadataBuilder parseMetadataIntoBuilder(File file, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public MetadataBuilder parseMetadataIntoBuilder(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }

    public MetadataBuilder parseMetadataIntoBuilder(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        return null;
    }
}

