/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import thredds.util.HttpUriResolver;
import thredds.util.HttpUriResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CatalogNamespace {
    CATALOG_1_0("", "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "/resources/thredds/schemas/InvCatalog.1.0.2.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.1.0.2.xsd"),
    CATALOG_0_6("oldThredds", "http://www.unidata.ucar.edu/thredds", "/resources/thredds/schemas/InvCatalog.0.6.xsd", "http://www.unidata.ucar.edu/schemas/thredds/InvCatalog.0.6.xsd"),
    XLINK("xlink", "http://www.w3.org/1999/xlink", "/resources/thredds/schemas/xlink.xsd", "");

    private String standardPrefix;
    private String namespaceUri;
    private String resourceName;
    private URI resourceUri;

    private CatalogNamespace(String standardPrefix, String namespaceUri, String resourceName, String resourceUri) {
        this.standardPrefix = standardPrefix;
        this.namespaceUri = namespaceUri;
        this.resourceName = resourceName;
        try {
            this.resourceUri = new URI(resourceUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Badly formed resource URI [" + resourceUri + "].", e);
        }
    }

    public String getStandardPrefix() {
        return this.standardPrefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public URI getResourceUri() {
        return this.resourceUri;
    }

    public static CatalogNamespace getNamespace(String namespaceUri) {
        if (namespaceUri == null) {
            return null;
        }
        for (CatalogNamespace curNs : CatalogNamespace.values()) {
            if (!curNs.namespaceUri.equals(namespaceUri)) continue;
            return curNs;
        }
        return null;
    }

    public InputStream resolveNamespace() throws IOException {
        InputStream inStream = null;
        if (this.getResourceName() != null) {
            inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getResourceName());
        }
        if (inStream == null && this.getResourceUri() != null) {
            HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver(this.getResourceUri());
            httpUriResolver.makeRequest();
            inStream = httpUriResolver.getResponseBodyAsInputStream();
        }
        return inStream;
    }

    public Schema resolveNamespaceAsSchema() throws IOException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource source = new StreamSource(this.resolveNamespace());
        source.setSystemId(this.getResourceUri().toString());
        return schemaFactory.newSchema(source);
    }
}

