/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.writer.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Catalog;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.xml.util.CatalogNamespace;
import thredds.catalog2.xml.writer.ThreddsXmlWriterException;
import thredds.catalog2.xml.writer.stax.AbstractElementWriter;
import thredds.catalog2.xml.writer.stax.PropertyElementWriter;
import thredds.catalog2.xml.writer.stax.ServiceElementWriter;
import thredds.catalog2.xml.writer.stax.StaxWriter;
import ucar.nc2.units.DateFormatter;

public class CatalogElementWriter
implements AbstractElementWriter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void writeElement(Catalog catalog, XMLStreamWriter writer, int nestLevel) throws ThreddsXmlWriterException {
        String indentString = StaxWriter.getIndentString(nestLevel);
        try {
            boolean isEmptyElement;
            if (nestLevel == 0) {
                writer.writeStartDocument();
                writer.writeCharacters("\n");
            } else {
                writer.writeCharacters(indentString);
            }
            boolean bl = isEmptyElement = catalog.getServices().isEmpty() && catalog.getProperties().isEmpty() && catalog.getDatasets().isEmpty();
            if (isEmptyElement) {
                writer.writeEmptyElement("catalog");
            } else {
                writer.writeStartElement("catalog");
            }
            if (nestLevel == 0) {
                writer.writeNamespace(CatalogNamespace.CATALOG_1_0.getStandardPrefix(), CatalogNamespace.CATALOG_1_0.getNamespaceUri());
                writer.writeNamespace(CatalogNamespace.XLINK.getStandardPrefix(), CatalogNamespace.XLINK.getNamespaceUri());
            }
            if (catalog.getName() != null) {
                writer.writeAttribute("name", catalog.getName());
            }
            if (catalog.getVersion() != null) {
                writer.writeAttribute("version", catalog.getVersion());
            }
            DateFormatter df = new DateFormatter();
            if (catalog.getExpires() != null) {
                writer.writeAttribute("expires", df.toDateTimeStringISO(catalog.getExpires()));
            }
            if (catalog.getLastModified() != null) {
                writer.writeAttribute("lastModified", df.toDateTimeStringISO(catalog.getLastModified()));
            }
            writer.writeCharacters("\n");
            for (Service curService : catalog.getServices()) {
                new ServiceElementWriter().writeElement(curService, writer, nestLevel + 1);
            }
            for (Property curProperty : catalog.getProperties()) {
                new PropertyElementWriter().writeElement(curProperty, writer, nestLevel + 1);
            }
            if (!isEmptyElement) {
                writer.writeCharacters(indentString);
                writer.writeEndElement();
                writer.writeCharacters("\n");
            }
            if (nestLevel == 0) {
                writer.writeEndDocument();
            }
            writer.flush();
            if (nestLevel == 0) {
                writer.close();
            }
        }
        catch (XMLStreamException e) {
            this.log.error("writeElement(): Failed while writing to XMLStreamWriter: " + e.getMessage());
            throw new ThreddsXmlWriterException("Failed while writing to XMLStreamWriter: " + e.getMessage(), e);
        }
    }
}

