/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.writer.stax;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Property;
import thredds.catalog2.xml.util.CatalogNamespace;
import thredds.catalog2.xml.writer.ThreddsXmlWriterException;
import thredds.catalog2.xml.writer.stax.AbstractElementWriter;
import thredds.catalog2.xml.writer.stax.StaxWriter;

public class PropertyElementWriter
implements AbstractElementWriter {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void writeElement(Property property, XMLStreamWriter writer, int nestLevel) throws ThreddsXmlWriterException {
        String indentString = StaxWriter.getIndentString(nestLevel);
        try {
            if (nestLevel == 0) {
                writer.writeStartDocument();
                writer.writeCharacters("\n");
            } else {
                writer.writeCharacters(indentString);
            }
            writer.writeEmptyElement("property");
            if (nestLevel == 0) {
                writer.writeNamespace(CatalogNamespace.CATALOG_1_0.getStandardPrefix(), CatalogNamespace.CATALOG_1_0.getNamespaceUri());
                writer.writeNamespace(CatalogNamespace.XLINK.getStandardPrefix(), CatalogNamespace.XLINK.getNamespaceUri());
            }
            writer.writeAttribute("name", property.getName());
            writer.writeAttribute("value", property.getValue());
            writer.writeCharacters("\n");
            if (nestLevel == 0) {
                writer.writeEndDocument();
            }
            writer.flush();
            if (nestLevel == 0) {
                writer.close();
            }
        }
        catch (XMLStreamException e) {
            this.log.error("writeElement(): Failed while writing to XMLStreamWriter: " + e.getMessage());
            throw new ThreddsXmlWriterException("Failed while writing to XMLStreamWriter: " + e.getMessage(), e);
        }
    }
}

