/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_1;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.Request;
import thredds.wcs.v1_0_0_1.WcsCoverage;
import thredds.wcs.v1_0_0_1.WcsDataset;
import thredds.wcs.v1_0_0_1.WcsException;
import thredds.wcs.v1_0_0_1.WcsRequest;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ogc.EPSG_OGC_CF_Helper;

public class GetCoverage
extends WcsRequest {
    private static Logger log = LoggerFactory.getLogger(GetCoverage.class);
    private WcsCoverage coverage;
    private LatLonRect bboxLatLonRect = null;
    private DateRange timeRange;
    private WcsCoverage.VerticalRange rangeSetAxisValueRange;
    private Request.Format format;
    private boolean isSingleTimeRequest = false;
    private boolean isSingleVerticalRequest = false;

    public GetCoverage(Request.Operation operation, String version, WcsDataset dataset, String coverageId, String crs, String responseCRS, Request.BoundingBox bbox, DateRange timeRange, WcsCoverage.VerticalRange verticalRange, Request.Format format) throws WcsException {
        super(operation, version, dataset);
        if (coverageId == null) {
            throw new WcsException(WcsException.Code.MissingParameterValue, "coverage", "Coverage identifier required.");
        }
        if (!this.getDataset().isAvailableCoverageName(coverageId)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "coverage", "Unknown coverage identifier <" + coverageId + ">.");
        }
        this.coverage = this.getDataset().getAvailableCoverage(coverageId);
        if (this.coverage == null) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "coverage", "Unknown coverage identifier <" + coverageId + ">.");
        }
        if (crs == null) {
            throw new WcsException(WcsException.Code.MissingParameterValue, "CRS", "Request CRS required.");
        }
        if (!crs.equalsIgnoreCase(this.coverage.getDefaultRequestCrs())) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "CRS", "Request CRS <" + crs + "> not allowed <" + this.coverage.getDefaultRequestCrs() + ">.");
        }
        String nativeCRS = EPSG_OGC_CF_Helper.getWcs1_0CrsId(this.coverage.getCoordinateSystem().getProjection());
        if (nativeCRS == null) {
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Coverage not in recognized CRS. (???)");
        }
        if (responseCRS == null) {
            if (!nativeCRS.equalsIgnoreCase(this.coverage.getDefaultRequestCrs())) {
                throw new WcsException(WcsException.Code.MissingParameterValue, "Response_CRS", "Response CRS required.");
            }
        } else if (!responseCRS.equalsIgnoreCase(nativeCRS)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "response_CRS", "Respnse CRS <" + responseCRS + "> not allowed <" + nativeCRS + ">.");
        }
        if (bbox != null) {
            this.bboxLatLonRect = this.convertBoundingBox(bbox, this.coverage.getCoordinateSystem());
        }
        this.timeRange = timeRange;
        this.isSingleTimeRequest = timeRange.isPoint();
        this.rangeSetAxisValueRange = verticalRange;
        this.isSingleVerticalRequest = verticalRange.isSinglePoint();
        if (format == null) {
            log.error("GetCoverage(): FORMAT parameter required.");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", "FORMAT parameter required.");
        }
        if (!this.coverage.isSupportedCoverageFormat(this.format)) {
            String msg = "Unsupported format value [" + (Object)((Object)format) + "].";
            log.error("GetCoverage(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msg);
        }
        this.format = format;
        if (!(this.format != Request.Format.GeoTIFF && this.format != Request.Format.GeoTIFF_Float || this.isSingleTimeRequest || this.isSingleVerticalRequest)) {
            StringBuffer msgB = new StringBuffer("GeoTIFF supported only for requests at a single time [");
            if (this.timeRange != null) {
                msgB.append(this.timeRange);
            }
            msgB.append("] and a single vertical level [");
            if (verticalRange != null) {
                msgB.append(verticalRange);
            }
            msgB.append("].");
            log.error("GetCoverage(): " + msgB);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msgB.toString());
        }
    }

    public Request.Format getFormat() {
        return this.format;
    }

    public File writeCoverageDataToFile() throws WcsException {
        return this.coverage.writeCoverageDataToFile(this.format, this.bboxLatLonRect, this.rangeSetAxisValueRange, this.timeRange);
    }

    private LatLonRect convertBoundingBox(Request.BoundingBox bbox, GridCoordSystem gcs) throws WcsException {
        if (bbox == null) {
            return null;
        }
        LatLonPointImpl minll = new LatLonPointImpl(bbox.getMinPointValue(1), bbox.getMinPointValue(0));
        LatLonPointImpl maxll = new LatLonPointImpl(bbox.getMaxPointValue(1), bbox.getMaxPointValue(0));
        LatLonRect bboxLatLonRect = new LatLonRect(minll, maxll);
        return bboxLatLonRect;
    }
}

