/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grid.GridRecord;

public final class GribGridRecord
implements GridRecord {
    public int productType;
    public int discipline;
    public int category;
    public int paramNumber;
    public int typeGenProcess;
    public int levelType1;
    public int levelType2;
    public double levelValue1;
    public double levelValue2;
    public int gdsKey;
    public long offset1;
    public long offset2;
    public Date refTime;
    public int forecastTime;
    public int decimalScale = -9999;
    public boolean bmsExists = true;
    public int center = -1;
    public int subCenter = -1;
    public int table = -1;
    private Date validTime = null;

    public GribGridRecord() {
    }

    public GribGridRecord(int productType, int discipline, int category, int param, int typeGenProcess, int levelType1, float levelValue1, int levelType2, float levelValue2, Date refTime, int foreTime, int gdsKey, long offset1, long offset2, int decimalScale, boolean bmsExists, int center, int subCenter, int table) {
        try {
            this.gdsKey = gdsKey;
            this.productType = productType;
            this.discipline = discipline;
            this.category = category;
            this.paramNumber = param;
            this.typeGenProcess = typeGenProcess;
            this.levelType1 = levelType1;
            this.levelValue1 = levelValue1;
            this.levelType2 = levelType2;
            this.levelValue2 = levelValue2;
            this.refTime = refTime;
            this.forecastTime = foreTime;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTime(refTime);
            calendar.add(10, this.forecastTime);
            this.validTime = calendar.getTime();
            this.offset1 = offset1;
            this.offset2 = offset2;
            if (decimalScale != -9999) {
                this.decimalScale = decimalScale;
                this.bmsExists = bmsExists;
                this.center = center;
                this.subCenter = subCenter;
                this.table = table;
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
    }

    GribGridRecord(String productTypeS, String disciplineS, String categoryS, String paramS, String typeGenProcessS, String levelType1S, String levelValue1S, String levelType2S, String levelValue2S, String refTimeS, String foreTimeS, String gdsKeyS, String offset1S, String offset2S, String decimalScaleS, String bmsExistsS, String centerS, String subCenterS, String tableS) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.gdsKey = gdsKeyS.hashCode();
            this.productType = Integer.parseInt(productTypeS);
            this.discipline = Integer.parseInt(disciplineS);
            this.category = Integer.parseInt(categoryS);
            this.paramNumber = Integer.parseInt(paramS);
            this.typeGenProcess = Integer.parseInt(typeGenProcessS);
            this.levelType1 = Integer.parseInt(levelType1S);
            this.levelValue1 = Float.parseFloat(levelValue1S);
            this.levelType2 = Integer.parseInt(levelType2S);
            this.levelValue2 = Float.parseFloat(levelValue2S);
            this.refTime = dateFormat.parse(refTimeS);
            this.forecastTime = Integer.parseInt(foreTimeS);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTime(this.refTime);
            calendar.add(10, this.forecastTime);
            this.validTime = calendar.getTime();
            this.offset1 = Long.parseLong(offset1S);
            this.offset2 = Long.parseLong(offset2S);
            if (decimalScaleS != null) {
                this.decimalScale = Integer.parseInt(decimalScaleS);
            }
            if (bmsExistsS != null) {
                this.bmsExists = bmsExistsS.equals("true");
            }
            if (centerS != null) {
                this.center = Integer.parseInt(centerS);
            }
            if (subCenterS != null) {
                this.subCenter = Integer.parseInt(subCenterS);
            }
            if (tableS != null) {
                this.table = Integer.parseInt(tableS);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public double getLevel1() {
        return this.levelValue1;
    }

    public double getLevel2() {
        return this.levelValue2;
    }

    public int getLevelType1() {
        return this.levelType1;
    }

    public int getLevelType2() {
        return this.levelType2;
    }

    public Date getReferenceTime() {
        return this.refTime;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Date t) {
        this.validTime = t;
    }

    public int getValidTimeOffset() {
        return this.forecastTime;
    }

    public String getParameterName() {
        return null;
    }

    public int getGridDefRecordIdInt() {
        return this.gdsKey;
    }

    public String getGridDefRecordId() {
        return Integer.toString(this.gdsKey);
    }

    public int getGridNumber() {
        return 0;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }
}

