/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribReadTextIndex;
import ucar.grid.GridDefRecord;
import ucar.grid.GridIndex;

public class GribReadIndex {
    private static boolean debugTiming = true;
    private static boolean debugParse = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public GribReadIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        if (ios == null) {
            return null;
        }
        return this.open(location, ios);
    }

    public final GridIndex open(String location, InputStream ios) throws IOException {
        long start = System.currentTimeMillis();
        FilterInputStream dis = null;
        try {
            GridIndex gridIndex = new GridIndex();
            dis = new DataInputStream(new BufferedInputStream(ios));
            long lastModified = ((DataInputStream)dis).readLong();
            if (lastModified == 7597120008394602085L) {
                dis.close();
                dis = null;
                GridIndex gridIndex2 = new GribReadTextIndex().open(location);
                return gridIndex2;
            }
            Date refTime = null;
            boolean grid_edition_1 = false;
            String line = ((DataInputStream)dis).readUTF();
            if (debugParse) {
                System.out.println(line);
            }
            String[] split = line.split("\\s");
            for (int i = 0; i < split.length; i += 2) {
                gridIndex.addGlobalAttribute(split[i], split[i + 1]);
                if (split[i].equals("reftime")) {
                    refTime = this.dateFormat.parse(split[i + 1]);
                    continue;
                }
                if (!split[i].equals("grid_edition")) continue;
                grid_edition_1 = split[i + 1].equals("1");
            }
            int number = ((DataInputStream)dis).readInt();
            int decimalScale = -9999;
            int center = -1;
            int subCenter = -1;
            int table = -1;
            boolean bmsExists = false;
            for (int i = 0; i < number; ++i) {
                int productType = ((DataInputStream)dis).readInt();
                int discipline = ((DataInputStream)dis).readInt();
                int category = ((DataInputStream)dis).readInt();
                int param = ((DataInputStream)dis).readInt();
                int typeGenProcess = ((DataInputStream)dis).readInt();
                int levelType1 = ((DataInputStream)dis).readInt();
                float levelValue1 = ((DataInputStream)dis).readFloat();
                int levelType2 = ((DataInputStream)dis).readInt();
                float levelValue2 = ((DataInputStream)dis).readFloat();
                int foreTime = ((DataInputStream)dis).readInt();
                int gdsKey = ((DataInputStream)dis).readInt();
                long offset1 = ((DataInputStream)dis).readLong();
                long offset2 = ((DataInputStream)dis).readLong();
                if (grid_edition_1) {
                    decimalScale = ((DataInputStream)dis).readInt();
                    bmsExists = ((DataInputStream)dis).readBoolean();
                    center = ((DataInputStream)dis).readInt();
                    subCenter = ((DataInputStream)dis).readInt();
                    table = ((DataInputStream)dis).readInt();
                }
                GribGridRecord ggr = new GribGridRecord(productType, discipline, category, param, typeGenProcess, levelType1, levelValue1, levelType2, levelValue2, refTime, foreTime, gdsKey, offset1, offset2, decimalScale, bmsExists, center, subCenter, table);
                gridIndex.addGridRecord(ggr);
            }
            while (!(line = ((DataInputStream)dis).readUTF()).equals("End")) {
                GribGridDefRecord gds = new GribGridDefRecord(line);
                gridIndex.addHorizCoordSys(gds);
            }
            if (debugTiming) {
                long took = System.currentTimeMillis() - start;
                System.out.println(" Index read " + location + " count=" + gridIndex.getGridCount() + " took=" + took + " msec ");
            }
            GridIndex gridIndex3 = gridIndex;
            return gridIndex3;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModifiedTime(String location) throws IOException {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(location));
            long l = ((DataInputStream)dis).readLong();
            return l;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String testName = "C:/data/NDFD.grib2.gbx";
        debugTiming = true;
        GridIndex index = args.length < 1 ? new GribReadIndex().open("C:/data/NDFD.grib2.gbx") : new GribReadIndex().open(args[0]);
        List<GridDefRecord> gcs = index.getHorizCoordSys();
        for (GridDefRecord gdr : gcs) {
            String wind = gdr.getParam("Winds");
            int nx = gdr.getParamInt("Nx");
            System.out.println("Nx =" + nx);
            nx = gdr.getParamInt("Nx");
            System.out.println("Nx =" + nx);
            double la1 = gdr.getParamDouble("La1");
            System.out.println("La1 =" + la1);
            la1 = gdr.getParamDouble("La1");
            System.out.println("La1 =" + la1);
        }
    }
}

