/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.TimeZone;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grid.GridIndex;

public class GribReadTextIndex {
    private static boolean debugTiming = true;
    private static boolean debugParse = false;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public GribReadTextIndex() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final GridIndex open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return this.open(location, ios);
    }

    public final GridIndex open(String location, InputStream ios) throws IOException {
        GribGridDefRecord gds;
        String line;
        String line2;
        long start = System.currentTimeMillis();
        GridIndex gridIndex = new GridIndex();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while (true) {
            if ((line2 = dataIS.readLine()) == null || line2.length() == 0) {
                return gridIndex;
            }
            if (line2.startsWith("--")) break;
            int pos = line2.indexOf(" = ");
            if (pos <= 0) continue;
            String key = line2.substring(0, pos);
            String value = line2.substring(pos + 3);
            gridIndex.addGlobalAttribute(key, value);
        }
        while (true) {
            if ((line2 = dataIS.readLine()) == null || line2.length() == 0) {
                return gridIndex;
            }
            if (line2.startsWith("--")) break;
            StringTokenizer stoke = new StringTokenizer(line2);
            String productType = stoke.nextToken();
            String discipline = stoke.nextToken();
            String category = stoke.nextToken();
            String param = stoke.nextToken();
            String typeGenProcess = stoke.nextToken();
            String levelType1 = stoke.nextToken();
            String levelValue1 = stoke.nextToken();
            String levelType2 = stoke.nextToken();
            String levelValue2 = stoke.nextToken();
            String refTime = stoke.nextToken();
            String foreTime = stoke.nextToken();
            String gdsKey = stoke.nextToken();
            String offset1 = stoke.nextToken();
            String offset2 = stoke.nextToken();
            String decimalScale = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String bmsExists = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String center = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String subCenter = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String table = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            GribGridRecord ggr = new GribGridRecord(productType, discipline, category, param, typeGenProcess, levelType1, levelValue1, levelType2, levelValue2, refTime, foreTime, gdsKey, offset1, offset2, decimalScale, bmsExists, center, subCenter, table);
            gridIndex.addGridRecord(ggr);
            if (!debugParse) continue;
            System.out.println(ggr.toString());
        }
        StringBuilder sb = new StringBuilder();
        while ((line = dataIS.readLine()) != null && line.length() != 0) {
            if (line.startsWith("--")) {
                String sbChk = sb.toString();
                sbChk = sbChk.replace("grid_radius_spherical_earth", "radius_spherical_earth");
                sbChk = sbChk.replace("grid_major_axis_earth", "major_axis_earth");
                sbChk = sbChk.replace("grid_minor_axis_earth", "minor_axis_earth");
                gds = new GribGridDefRecord(sbChk);
                sb.setLength(0);
                gridIndex.addHorizCoordSys(gds);
                continue;
            }
            int pos = line.indexOf(" = ");
            if (line.startsWith("GDSkey")) {
                int hc = line.substring(pos + 3).hashCode();
                sb.append(line.substring(0, pos) + "\t" + Integer.toString(hc));
                continue;
            }
            if (pos <= 0) continue;
            sb.append("\t" + line.substring(0, pos) + "\t" + line.substring(pos + 3));
        }
        String sbChk = sb.toString();
        sbChk = sbChk.replace("grid_radius_spherical_earth", "radius_spherical_earth");
        sbChk = sbChk.replace("grid_major_axis_earth", "major_axis_earth");
        sbChk = sbChk.replace("grid_minor_axis_earth", "minor_axis_earth");
        gds = new GribGridDefRecord(sbChk);
        gridIndex.addHorizCoordSys(gds);
        dataIS.close();
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" Index read " + location + " count=" + gridIndex.getGridCount() + " took=" + took + " msec ");
        }
        return gridIndex;
    }
}

