/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Index {
    private static boolean debugTiming = false;
    private static boolean debugParse = false;
    public static final String current_index_version = "6.0";
    private final List<GribRecord> index = new ArrayList<GribRecord>();
    private final List<GdsRecord> gcs = new ArrayList<GdsRecord>();
    private final Map<String, String> atts = new HashMap<String, String>();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Index() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final boolean open(String location) throws IOException {
        InputStream ios;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return this.open(location, ios);
    }

    public final boolean open(String location, InputStream ios) throws IOException {
        String line;
        String line2;
        long start = System.currentTimeMillis();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while (true) {
            if ((line2 = dataIS.readLine()) == null || line2.length() == 0) {
                return false;
            }
            if (line2.startsWith("--")) break;
            int pos = line2.indexOf(" = ");
            if (pos <= 0) continue;
            String key = line2.substring(0, pos);
            String value = line2.substring(pos + 3);
            this.atts.put(key, value);
        }
        while (true) {
            if ((line2 = dataIS.readLine()) == null || line2.length() == 0) {
                return false;
            }
            if (line2.startsWith("--")) break;
            StringTokenizer stoke = new StringTokenizer(line2);
            String productType = stoke.nextToken();
            String discipline = stoke.nextToken();
            String category = stoke.nextToken();
            String param = stoke.nextToken();
            String typeGenProcess = stoke.nextToken();
            String levelType1 = stoke.nextToken();
            String levelValue1 = stoke.nextToken();
            String levelType2 = stoke.nextToken();
            String levelValue2 = stoke.nextToken();
            String refTime = stoke.nextToken();
            String foreTime = stoke.nextToken();
            String gdsKey = stoke.nextToken();
            String offset1 = stoke.nextToken();
            String offset2 = stoke.nextToken();
            String decimalScale = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String bmsExists = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String center = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String subCenter = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String table = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            GribRecord s = new GribRecord(productType, discipline, category, param, typeGenProcess, levelType1, levelValue1, levelType2, levelValue2, refTime, foreTime, gdsKey, offset1, offset2, decimalScale, bmsExists, center, subCenter, table);
            this.index.add(s);
            if (!debugParse) continue;
            System.out.println(s.typeGenProcess);
        }
        GdsRecord gds = new GdsRecord();
        this.gcs.add(gds);
        while ((line = dataIS.readLine()) != null) {
            if (line.length() == 0) {
                return false;
            }
            if (line.startsWith("--")) {
                gds.finish();
                gds = new GdsRecord();
                this.gcs.add(gds);
                continue;
            }
            int pos = line.indexOf(" = ");
            if (pos <= 0) continue;
            gds.addParam(line.substring(0, pos), line.substring(pos + 3));
        }
        gds.finish();
        dataIS.close();
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" Index read " + location + " count=" + this.index.size() + " took=" + took + " msec ");
        }
        return true;
    }

    public final Map<String, String> getGlobalAttributes() {
        return this.atts;
    }

    public final String getGlobalAttribute(String key) {
        return this.atts.get(key);
    }

    public final List<GribRecord> getGribRecords() {
        return this.index;
    }

    public final List<GdsRecord> getHorizCoordSys() {
        return this.gcs;
    }

    public final void addGribRecord(GribRecord gr) {
        this.index.add(gr);
    }

    public final void addHorizCoordSys(GdsRecord gds) {
        this.gcs.add(gds);
    }

    public final void addGlobalAttribute(String name, String value) {
        this.atts.put(name, value);
    }

    public GribRecord getGribRecord() {
        return new GribRecord();
    }

    public static void main(String[] args) throws IOException {
        String testName = "/home/rkambic/code/grib/20070420_1800.grib2.gbx";
        if (args.length < 1) {
            new Index().open("/home/rkambic/code/grib/20070420_1800.grib2.gbx");
        } else {
            new Index().open(args[0]);
        }
    }

    public static final class GdsRecord {
        public HashMap params = new HashMap();
        public String gdsKey;
        public String winds;
        public int grid_type;
        public int nx;
        public int ny;
        public int resolution;
        public double dx;
        public double dy;
        public double latin1;
        public double latin2;
        public double La1;
        public double Lo1;
        public double LaD;
        public double LoV;
        public int grid_shape_code;
        public double radius_spherical_earth;
        public double major_axis_earth;
        public double minor_axis_earth;

        public final void addParam(String key, String value) {
            if (debugParse) {
                System.out.println(" adding " + key + " = " + value);
            }
            this.params.put(key.trim(), value);
        }

        final void finish() {
            try {
                this.gdsKey = ((String)this.params.get("GDSkey")).trim();
                this.grid_type = Integer.parseInt((String)this.params.get("grid_type"));
                this.grid_shape_code = Integer.parseInt((String)this.params.get("grid_shape_code"));
                this.nx = Integer.parseInt((String)this.params.get("Nx"));
                this.ny = Integer.parseInt((String)this.params.get("Ny"));
                this.dx = this.readDouble("Dx");
                this.dy = this.readDouble("Dy");
                this.latin1 = this.readDouble("Latin1");
                this.latin2 = this.readDouble("Latin2");
                this.La1 = this.readDouble("La1");
                this.Lo1 = this.readDouble("Lo1");
                this.LaD = this.readDouble("LaD");
                this.LoV = this.readDouble("LoV");
                this.winds = (String)this.params.get("Winds");
                if (this.winds != null) {
                    this.winds = this.winds.trim();
                }
                this.radius_spherical_earth = this.readDouble("radius_spherical_earth");
                this.major_axis_earth = this.readDouble("major_axis_earth");
                this.minor_axis_earth = this.readDouble("minor_axis_earth");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        public final double readDouble(String name) {
            String s = (String)this.params.get(name);
            if (s == null) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return Double.NaN;
            }
        }
    }

    public final class GribRecord {
        public int productType;
        public int discipline;
        public int category;
        public int paramNumber;
        public String typeGenProcess;
        public int levelType1;
        public int levelType2;
        public float levelValue1;
        public float levelValue2;
        public String gdsKey;
        public long offset1;
        public long offset2;
        public Date refTime;
        public int forecastTime;
        public int decimalScale = 0;
        public boolean bmsExists = true;
        public int center;
        public int subCenter;
        public int table;
        private Date validTime = null;

        public GribRecord() {
        }

        GribRecord(String productTypeS, String disciplineS, String categoryS, String paramS, String typeGenProcessS, String levelType1S, String levelValue1S, String levelType2S, String levelValue2S, String refTime, String foreTimeS, String gdsKeyS, String offset1S, String offset2S, String decimalScaleS, String bmsExistsS, String centerS, String subCenterS, String tableS) {
            try {
                this.refTime = Index.this.dateFormat.parse(refTime);
                this.gdsKey = gdsKeyS.trim().intern();
                this.productType = Integer.parseInt(productTypeS);
                this.discipline = Integer.parseInt(disciplineS);
                this.category = Integer.parseInt(categoryS);
                this.paramNumber = Integer.parseInt(paramS);
                this.typeGenProcess = typeGenProcessS.intern();
                this.levelType1 = Integer.parseInt(levelType1S);
                this.levelValue1 = Float.parseFloat(levelValue1S);
                this.levelType2 = Integer.parseInt(levelType2S);
                this.levelValue2 = Float.parseFloat(levelValue2S);
                this.forecastTime = Integer.parseInt(foreTimeS);
                this.offset1 = Long.parseLong(offset1S);
                this.offset2 = Long.parseLong(offset2S);
                if (decimalScaleS != null) {
                    this.decimalScale = Integer.parseInt(decimalScaleS);
                }
                if (bmsExistsS != null) {
                    this.bmsExists = bmsExistsS.equals("true");
                }
                if (centerS != null) {
                    this.center = Integer.parseInt(centerS);
                }
                if (subCenterS != null) {
                    this.subCenter = Integer.parseInt(subCenterS);
                }
                if (tableS != null) {
                    this.table = Integer.parseInt(tableS);
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public Date getValidTime() {
            return this.validTime;
        }

        public void setValidTime(Date t) {
            this.validTime = t;
        }
    }
}

