/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.GribReadIndex;
import ucar.grib.Index;

public class TestGribReadIndex {
    private void readIndex(String type, int stop, String sDir) throws IOException {
        long start = System.currentTimeMillis();
        Date now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... Start of TestGribReadIndex");
        sDir = type.equals("binary") ? sDir + File.separator + "binary" : sDir + File.separator + "text";
        File dir = new File(sDir);
        if (dir.isDirectory()) {
            System.out.println("In directory " + dir.getParent() + File.separator + dir.getName());
            String[] children = dir.list();
            int count = 0;
            for (String child : children) {
                if (!child.endsWith("gbx")) continue;
                if (count == stop) break;
                ++count;
                String[] args = new String[2];
                args[0] = dir + File.separator + child;
                if (type.equals("binary")) {
                    args[1] = dir + File.separator + "binary" + File.separator + child + ".gbx";
                    GribReadIndex.main(args);
                    continue;
                }
                args[1] = dir + File.separator + "text" + File.separator + child + ".gbx";
                Index.main(args);
            }
        }
        System.out.println("Total time = " + (System.currentTimeMillis() - start) + " msec");
    }

    public static void main(String[] args) throws IOException {
        TestGribReadIndex tg2ri = new TestGribReadIndex();
        tg2ri.readIndex(args[0], Integer.parseInt(args[1]), args[2]);
    }
}

