/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Dump {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans file");
        System.out.println("<output file> file to store results");
        System.out.println("<true or false> whether to read/display data too");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <output file> <true or false>");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Grib1Dump func = new Grib1Dump();
        if (args.length < 1) {
            Class<?> cl = func.getClass();
            Grib1Dump.usage(cl.getName());
        }
        boolean displayData = false;
        Date now = Calendar.getInstance().getTime();
        PrintStream ps = System.out;
        try {
            RandomAccessFile raf = null;
            if (args.length == 3) {
                raf = new RandomAccessFile(args[0], "r");
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[1], false)));
                displayData = args[2].equalsIgnoreCase("true");
            } else if (args.length == 2) {
                raf = new RandomAccessFile(args[0], "r");
                if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("false")) {
                    displayData = args[1].equalsIgnoreCase("true");
                } else {
                    ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(args[1], false)));
                }
            } else if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
            } else {
                System.exit(0);
            }
            raf.order(0);
            Grib1Input g1i = new Grib1Input(raf);
            g1i.scan(false, false);
            ArrayList records = g1i.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                Grib1Record record = (Grib1Record)records.get(i);
                Grib1IndicatorSection is = record.getIs();
                Grib1ProductDefinitionSection pds = record.getPDS();
                Grib1GridDefinitionSection gds = record.getGDS();
                ps.println("--------------------------------------------------------------------");
                ps.println("                        Header : " + record.getHeader());
                Grib1Dump.printIS(is, ps);
                Grib1Dump.printPDS(pds, ps);
                Grib1Dump.printGDS(gds, pds, ps);
                ps.println();
                if (!displayData) continue;
                float[] data = null;
                ps.println("--------------------------------------------------------------------");
                Grib1Data gd = new Grib1Data(raf);
                data = gd.getData(record.getDataOffset(), pds.getDecimalScale(), pds.bmsExists());
                if (data == null) break;
                for (int j = 0; j < data.length; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
                break;
            }
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        finally {
            ps.close();
        }
        now = Calendar.getInstance().getTime();
    }

    private static void printIS(Grib1IndicatorSection is, PrintStream ps) {
        ps.println("                    Discipline : 0 Meteorological Products");
        ps.println("                  GRIB Edition : " + is.getGribEdition());
        ps.println("                   GRIB length : " + is.getGribLength());
    }

    private static void printGDS(Grib1GridDefinitionSection gds, Grib1ProductDefinitionSection pds, PrintStream ps) {
        int numberOfPoints = 0;
        numberOfPoints = pds.getTypeGenProcess() == 96 ? 3447 : gds.getNx() * gds.getNy();
        ps.println("         Number of data points : " + numberOfPoints);
        ps.println("                     Grid Name : " + gds.getName());
        String winds = GribNumbers.isBitSet(gds.getResolution(), 8) ? "Relative" : "True";
        switch (gds.getGdtn()) {
            case 0: 
            case 4: 
            case 10: 
            case 40: 
            case 201: 
            case 202: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gds.getShapeRadius());
                } else if (gds.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gds.getShapeMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getShapeMinorAxis());
                }
                ps.println("                            Nx : " + gds.getNx());
                ps.println("                            Ny : " + gds.getNy());
                ps.println("                           La1 : " + gds.getLa1());
                ps.println("                           Lo1 : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           La2 : " + gds.getLa2());
                ps.println("                           Lo2 : " + gds.getLo2());
                ps.println("                            Dx : " + gds.getDx());
                if (gds.getGdtn() == 4) {
                    ps.println("                            Np : " + gds.getNp());
                } else {
                    ps.println("                            Dy : " + gds.getDy());
                }
                ps.println("                 Scanning mode : " + gds.getScanMode());
                if (gds.getGdtn() == 10) {
                    ps.println("     Latitude of southern pole : " + gds.getSpLat());
                    ps.println("    Longitude of southern pole : " + gds.getSpLon());
                    ps.println("             Angle of Rotation : " + gds.getAngle());
                    break;
                }
                if (gds.getGdtn() == 2 || gds.getGdtn() != 3) break;
                ps.println("     Latitude of southern pole : " + gds.getSpLat());
                ps.println("    Longitude of southern pole : " + gds.getSpLon());
                break;
            }
            case 1: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gds.getShapeRadius());
                } else if (gds.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gds.getShapeMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getShapeMinorAxis());
                }
                ps.println("                            Nx : " + gds.getNx());
                ps.println("                            Ny : " + gds.getNy());
                ps.println("                           La1 : " + gds.getLa1());
                ps.println("                           Lo1 : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           La2 : " + gds.getLa2());
                ps.println("                           Lo2 : " + gds.getLo2());
                ps.println("                         Latin : " + gds.getLatin());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                ps.println("                            Dx : " + gds.getDx());
                ps.println("                            Dy : " + gds.getDy());
                break;
            }
            case 5: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gds.getShapeRadius());
                } else if (gds.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gds.getShapeMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getShapeMinorAxis());
                }
                ps.println("                            Nx : " + gds.getNx());
                ps.println("                            Ny : " + gds.getNy());
                ps.println("                           La1 : " + gds.getLa1());
                ps.println("                           Lo1 : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           LoV : " + gds.getLov());
                ps.println("                            Dx : " + gds.getDx());
                ps.println("                            Dy : " + gds.getDy());
                ps.println("             Projection center : " + gds.getProjectionCenter());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                break;
            }
            case 3: {
                ps.println("                    Grid Shape : " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gds.getShapeRadius());
                } else if (gds.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gds.getShapeMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getShapeMinorAxis());
                }
                ps.println("                            Nx : " + gds.getNx());
                ps.println("                            Ny : " + gds.getNy());
                ps.println("                           La1 : " + gds.getLa1());
                ps.println("                           Lo1 : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("                           LoV : " + gds.getLov());
                ps.println("                            Dx : " + gds.getDx());
                ps.println("                            Dy : " + gds.getDy());
                ps.println("             Projection center : " + gds.getProjectionCenter());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                ps.println("                        Latin1 : " + gds.getLatin1());
                ps.println("                        Latin2 : " + gds.getLatin2());
                ps.println("                         SpLat : " + gds.getSpLat());
                ps.println("                         SpLon : " + gds.getSpLon());
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 0) {
                    ps.println("         Spherical earth radius: " + gds.getShapeRadius());
                } else if (gds.getShape() == 1) {
                    ps.println("         Oblate earth major axis: " + gds.getShapeMajorAxis());
                    ps.println("         Oblate earth minor axis: " + gds.getShapeMinorAxis());
                }
                ps.println("Number of points along parallel: " + gds.getNx());
                ps.println("Number of points along meridian: " + gds.getNy());
                ps.println("  Latitude of first grid point : " + gds.getLa1());
                ps.println(" Longitude of first grid point : " + gds.getLo1());
                ps.println("  Resolution & Component flags : " + gds.getResolution());
                ps.println("                         Winds : " + winds);
                ps.println("   Latitude of last grid point : " + gds.getLa2());
                ps.println("  Longitude of last grid point : " + gds.getLo2());
                ps.println("         i direction increment : " + gds.getDx());
                ps.println("                 Scanning mode : " + gds.getScanMode());
                if (gds.getGdtn() == 41) {
                    ps.println("     Latitude of southern pole : " + gds.getSpLat());
                    ps.println("    Longitude of southern pole : " + gds.getSpLon());
                    break;
                }
                if (gds.getGdtn() == 42 || gds.getGdtn() != 43) break;
                ps.println("     Latitude of southern pole : " + gds.getSpLat());
                ps.println("    Longitude of southern pole : " + gds.getSpLon());
                break;
            }
            default: {
                ps.println("Unknown Grid Type : " + gds.getGdtn());
            }
        }
    }

    private static void printPDS(Grib1ProductDefinitionSection pds, PrintStream ps) {
        ps.println("            Originating Center : " + pds.getCenter() + " " + pds.getCenter_idName());
        ps.println("        Originating Sub-Center : " + pds.getSubCenter() + " " + pds.getSubCenter_idName(pds.getSubCenter()));
        ps.println("            Product Definition : " + pds.getProductDefinition() + " " + Grib1ProductDefinitionSection.getProductDefinitionName(pds.getProductDefinition()));
        ps.println("            Parameter Category : -1 Meteorological Parameters");
        ps.println("                Parameter Name : " + pds.getParameterNumber() + " " + pds.getType() + " " + pds.getDescription());
        ps.println("               Parameter Units : " + pds.getUnit());
        ps.println("                Reference Time : " + dateFormat.format(pds.getBaseTime()));
        ps.println("                    Time Units : " + pds.getTimeUnit());
        ps.println("          Time Range Indicator : " + pds.getTimeRangeString());
        ps.println("                   Time 1 (P1) : " + pds.getP1());
        ps.println("                   Time 2 (P2) : " + pds.getP2());
        String tgp = Integer.toString(pds.getTypeGenProcess());
        ps.println("       Generating Process Type : " + tgp + " " + Grib1ProductDefinitionSection.getTypeGenProcessName(tgp));
        ps.println("                    Level Type : " + pds.getLevelType() + " " + pds.getLevelName());
        ps.println("                 Level Value 1 : " + pds.getLevelValue1());
        ps.println("                 Level Value 2 : " + pds.getLevelValue2());
        ps.println("                    GDS Exists : " + pds.gdsExists());
        ps.println("                    BMS Exists : " + pds.bmsExists());
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

