/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1ExtractRawData {
    private RandomAccessFile raf = null;
    private String header = "GRIB";
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");

    public Grib1ExtractRawData(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final boolean scan(int parmNumber) throws NotSupportedException, IOException {
        long start = System.currentTimeMillis();
        HashMap gdsCounter = new HashMap();
        Grib1ProductDefinitionSection pds = null;
        Object gds = null;
        long gdsOffset = 0L;
        DataOutputStream dos = new DataOutputStream(System.out);
        while (this.raf.getFilePointer() < this.raf.length()) {
            if (!this.seekHeader(this.raf, this.raf.length())) continue;
            Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
            long EOR = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
            long SOR = this.raf.getFilePointer() - (long)is.getLength();
            if (is.getGribEdition() == 2) {
                this.raf.seek(EOR);
                continue;
            }
            if (parmNumber == -1) {
                this.raf.seek(SOR);
                byte[] oneRecord = new byte[(int)is.getGribLength()];
                this.raf.read(oneRecord);
                dos.write(oneRecord, 0, oneRecord.length);
                dos.flush();
                break;
            }
            long dataOffset = 0L;
            try {
                pds = new Grib1ProductDefinitionSection(this.raf);
                if (pds.getLengthErr()) {
                    this.raf.seek(EOR);
                    continue;
                }
                if (parmNumber == pds.getParameterNumber()) {
                    this.raf.seek(SOR);
                    byte[] oneRecord = new byte[(int)is.getGribLength()];
                    this.raf.read(oneRecord);
                    dos.write(oneRecord, 0, oneRecord.length);
                    dos.flush();
                }
                this.raf.seek(EOR);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.raf.seek(EOR);
            }
        }
        dos.close();
        return true;
    }

    public final int getEdition() throws IOException, NotSupportedException {
        long length;
        boolean check = false;
        long l = length = this.raf.length() < 4000L ? this.raf.length() : 4000L;
        if (!this.seekHeader(this.raf, length)) {
            return 0;
        }
        Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
        return is.getGribEdition();
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            char c = (char)raf.read();
            hdr.append(c);
            if (c == 'G') {
                match = 1;
                continue;
            }
            if (c == 'R' && match == 1) {
                match = 2;
                continue;
            }
            if (c == 'I' && match == 2) {
                match = 3;
                continue;
            }
            if (c == 'B' && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB1";
                return true;
            }
            match = 0;
        }
        return false;
    }

    public static void main(String[] args) throws IOException, NotSupportedException {
        String fileName;
        int number = -1;
        if (args.length == 1) {
            fileName = args[0];
        } else if (args.length == 2) {
            fileName = args[0];
            number = Integer.parseInt(args[1]);
        } else {
            System.out.println("Not correct number of parms, either 1 or 2");
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        Grib1ExtractRawData erd = new Grib1ExtractRawData(raf);
        erd.scan(number);
    }
}

