/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import ucar.grib.GribGridDefRecord;
import ucar.grib.GribGridRecord;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grid.GridIndex;
import ucar.unidata.io.RandomAccessFile;

public class Grib1WriteIndex {
    private static boolean debugTiming = true;

    public final GridIndex writeFileIndex(RandomAccessFile inputRaf, DataOutputStream out, boolean makeIndex) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = Calendar.getInstance().getTime();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib1WriteIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        GridIndex index = makeIndex ? new GridIndex() : null;
        try {
            inputRaf.seek(0L);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            File g1 = new File(inputRaf.getLocation());
            out.writeLong(g1.lastModified());
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 7.0");
            sb.append(" grid_edition 1");
            sb.append(" location " + inputRaf.getLocation());
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            ArrayList products = g1i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = (Grib1Product)products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                if (i == 0) {
                    sb.append(" center " + pds.getCenter());
                    sb.append(" sub_center " + pds.getSubCenter());
                    sb.append(" table_version " + pds.getTableVersion());
                    sb.append(" reftime " + dateFormat.format(pds.getBaseTime()));
                    out.writeUTF(sb.toString());
                    if (makeIndex) {
                        String[] split = sb.toString().split("\\s");
                        for (int j = 0; j < split.length; j += 2) {
                            index.addGlobalAttribute(split[j], split[j + 1]);
                        }
                    }
                    out.writeInt(products.size());
                }
                out.writeInt(pds.getProductDefinition());
                out.writeInt(product.getDiscipline());
                out.writeInt(product.getCategory());
                out.writeInt(pds.getParameterNumber());
                out.writeInt(pds.getTypeGenProcess());
                out.writeInt(pds.getLevelType());
                out.writeFloat(pds.getLevelValue1());
                out.writeInt(255);
                out.writeFloat(pds.getLevelValue2());
                out.writeInt(pds.getForecastTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getDataOffset());
                out.writeLong(product.getEndRecordOffset());
                out.writeInt(pds.getDecimalScale());
                out.writeBoolean(pds.bmsExists());
                out.writeInt(pds.getCenter());
                out.writeInt(pds.getSubCenter());
                out.writeInt(pds.getTableVersion());
                if (makeIndex) {
                    GribGridRecord gr = new GribGridRecord(pds.getProductDefinition(), product.getDiscipline(), product.getCategory(), pds.getParameterNumber(), pds.getTypeGenProcess(), pds.getLevelType(), pds.getLevelValue1(), 255, pds.getLevelValue2(), pds.getBaseTime(), pds.getForecastTime(), product.getGDSkeyInt(), product.getDataOffset(), product.getEndRecordOffset(), pds.getDecimalScale(), pds.bmsExists(), pds.getCenter(), pds.getSubCenter(), pds.getTableVersion());
                    index.addGridRecord(gr);
                }
                ++count;
            }
            HashMap gdsHM = g1i.getGDSs();
            for (String key : gdsHM.keySet()) {
                Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key);
                String gdsStr = this.printGDS(key, gds, out);
                if (!makeIndex) continue;
                GribGridDefRecord ggdr = new GribGridDefRecord(gdsStr);
                index.addHorizCoordSys(ggdr);
            }
            out.writeUTF("End");
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return index;
    }

    protected String printGDS(String key, Grib1GridDefinitionSection gds, DataOutputStream out) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("GDSkey\t" + key);
        sb.append("\tgrid_type\t" + gds.getGdtn());
        sb.append("\tgrid_name\t" + gds.getName());
        if (gds.getGdtn() != 50) {
            sb.append("\tgrid_shape_code\t" + gds.getShape());
            sb.append("\tgrid_shape\t" + gds.getShapeName());
            if (gds.getShape() == 0) {
                sb.append("\tradius_spherical_earth\t" + gds.getShapeRadius());
            } else {
                sb.append("\tmajor_axis_earth\t" + gds.getShapeMajorAxis());
                sb.append("\tminor_axis_earth\t" + gds.getShapeMinorAxis());
            }
            sb.append("\tNx\t" + gds.getNx());
            sb.append("\tNy\t" + gds.getNy());
            sb.append("\tLa1\t" + gds.getLa1());
            sb.append("\tLo1\t" + gds.getLo1());
            sb.append("\tResCompFlag\t" + gds.getResolution());
            String winds = GribNumbers.isBitSet(gds.getResolution(), 8) ? "Relative" : "True";
            sb.append("\tWinds\t" + winds);
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 4: 
            case 10: 
            case 40: 
            case 201: 
            case 202: {
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tDx\t" + gds.getDx());
                if (gds.getGdtn() == 4) {
                    sb.append("\tNumberParallels\t" + gds.getNp());
                } else {
                    sb.append("\tDy\t" + gds.getDy());
                }
                if (gds.getGdtn() != 10) break;
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                sb.append("\tAngle\t" + gds.getAngle());
                break;
            }
            case 1: {
                sb.append("\tLa2\t" + gds.getLa2());
                sb.append("\tLo2\t" + gds.getLo2());
                sb.append("\tLatin\t" + gds.getLatin());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                break;
            }
            case 3: {
                sb.append("\tLoV\t" + gds.getLov());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                sb.append("\tLatin1\t" + gds.getLatin1());
                sb.append("\tLatin2\t" + gds.getLatin2());
                sb.append("\tSpLat\t" + gds.getSpLat());
                sb.append("\tSpLon\t" + gds.getSpLon());
                break;
            }
            case 5: {
                sb.append("\tLoV\t" + gds.getLov());
                sb.append("\tDx\t" + gds.getDx());
                sb.append("\tDy\t" + gds.getDy());
                sb.append("\tProjFlag\t" + gds.getProjectionCenter());
                sb.append("\tNpProj\t" + ((gds.getProjectionCenter() & 0x80) == 0));
                break;
            }
            default: {
                sb.append("\tUnknown Grid Type\t" + gds.getGdtn());
            }
        }
        out.writeUTF(sb.toString());
        return sb.toString();
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> scans for index creation");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1WriteIndex indexer = new Grib1WriteIndex();
        debugTiming = true;
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib1WriteIndex.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = null;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        if (args.length == 2) {
            String idxfile = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            File idx = new File(idxfile);
            idxfile = idxfile + ".tmp";
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(idxfile, false)));
            indexer.writeFileIndex(raf, out, false);
            out.close();
            File tidx = new File(idxfile);
            tidx.renameTo(idx);
        } else if (args.length == 1) {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(args[0] + ".gbx", false)));
            indexer.writeFileIndex(raf, out, true);
            out.close();
        }
    }
}

