/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import ucar.grib.GribChecker;
import ucar.unidata.io.RandomAccessFile;

public final class TestGrib1Edition
extends TestCase {
    private String dataPath;
    private String testPath;

    protected final void setUp() {
        this.dataPath = "/upc/share/testdata/grid/grib/grib1/data/";
        this.testPath = "/upc/share/testdata/grid/grib/grib1/test/";
    }

    public static Test suite() {
        return new TestSuite(TestGrib1Edition.class);
    }

    public final void testEdition() throws IOException {
        int edition = 0;
        System.out.println("\nTesting GRIB edition of RUC.wmo");
        RandomAccessFile raf = new RandomAccessFile(this.dataPath + "RUC.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"RUC.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of AVN.wmo");
        raf = new RandomAccessFile(this.dataPath + "AVN.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"AVN.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of MRF.wmo");
        raf = new RandomAccessFile(this.dataPath + "MRF.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"MRF.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of OCEAN.wmo");
        raf = new RandomAccessFile(this.dataPath + "OCEAN.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"OCEAN.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of RUC2.wmo");
        raf = new RandomAccessFile(this.dataPath + "RUC2.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"RUC2.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of WAVE.wmo");
        raf = new RandomAccessFile(this.dataPath + "WAVE.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"WAVE.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of ecmf.wmo");
        raf = new RandomAccessFile(this.dataPath + "ecmf.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"ecmf.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of ensemble.wmo");
        raf = new RandomAccessFile(this.dataPath + "ensemble.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"ensemble.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of extended.wmo");
        raf = new RandomAccessFile(this.dataPath + "extended.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"extended.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of thin.wmo");
        raf = new RandomAccessFile(this.dataPath + "thin.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"thin.wmo edition", (int)1, (int)edition);
        System.out.println("\nTesting GRIB edition of ukm.wmo");
        raf = new RandomAccessFile(this.dataPath + "ukm.wmo", "r");
        edition = GribChecker.getEdition(raf);
        TestGrib1Edition.assertEquals((String)"ukm.wmo edition", (int)1, (int)edition);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGrib1Edition.suite());
    }
}

