/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2EndSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2LocalUseSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2ExtractRawData {
    private RandomAccessFile raf = null;
    private String header = "GRIB";
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");
    private final ArrayList records = new ArrayList();
    private final ArrayList products = new ArrayList();
    private final HashMap gdsHM = new HashMap();

    public Grib2ExtractRawData(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final boolean scan(int discipline, int category, int number) throws NotSupportedException, IOException {
        long start = System.currentTimeMillis();
        Grib2IndicatorSection is = null;
        Grib2IdentificationSection id = null;
        Grib2LocalUseSection lus = null;
        Grib2GridDefinitionSection gds = null;
        if (this.raf.getFilePointer() > 4L) {
            this.raf.seek(this.raf.getFilePointer() - 4L);
            Grib2EndSection es = new Grib2EndSection(this.raf);
            if (!es.getEndFound()) {
                return false;
            }
        }
        long EOR = 0L;
        long SOR = 0L;
        boolean startAtHeader = true;
        boolean processGDS = true;
        long GdsOffset = 0L;
        long PdsOffset = 0L;
        Grib2ProductDefinitionSection pds = null;
        Object drs = null;
        Object bms = null;
        Object ds = null;
        DataOutputStream dos = new DataOutputStream(System.out);
        while (this.raf.getFilePointer() < this.raf.length()) {
            byte[] oneRecord;
            if (startAtHeader) {
                if (!this.seekHeader(this.raf, this.raf.length())) {
                    return false;
                }
                is = new Grib2IndicatorSection(this.raf);
                EOR = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
                SOR = this.raf.getFilePointer() - (long)is.getLength();
                if (is.getGribEdition() == 1) {
                    this.raf.seek(EOR);
                    continue;
                }
                if (discipline == -1) {
                    this.raf.seek(SOR);
                    oneRecord = new byte[(int)is.getGribLength()];
                    this.raf.read(oneRecord);
                    dos.write(oneRecord, 0, oneRecord.length);
                    dos.flush();
                    break;
                }
                id = new Grib2IdentificationSection(this.raf);
            }
            try {
                if (processGDS) {
                    lus = new Grib2LocalUseSection(this.raf);
                    GdsOffset = this.raf.getFilePointer();
                    gds = new Grib2GridDefinitionSection(this.raf, true);
                }
                PdsOffset = this.raf.getFilePointer();
                pds = new Grib2ProductDefinitionSection(this.raf);
                if (discipline == is.getDiscipline() && category == pds.getParameterCategory() && number == pds.getParameterNumber()) {
                    this.raf.seek(SOR);
                    oneRecord = new byte[(int)is.getGribLength()];
                    this.raf.read(oneRecord);
                    dos.write(oneRecord, 0, oneRecord.length);
                    dos.flush();
                }
                this.raf.seek(EOR);
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        dos.close();
        return true;
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            byte c = raf.readByte();
            hdr.append((char)c);
            if (c == 71) {
                match = 1;
                continue;
            }
            if (c == 82 && match == 1) {
                match = 2;
                continue;
            }
            if (c == 73 && match == 2) {
                match = 3;
                continue;
            }
            if (c == 66 && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB2";
                return true;
            }
            match = 0;
        }
        return false;
    }

    public final ArrayList getProducts() {
        return this.products;
    }

    public final ArrayList getRecords() {
        return this.records;
    }

    public final HashMap getGDSs() {
        return this.gdsHM;
    }

    public static void main(String[] args) throws IOException, NotSupportedException {
        String fileName;
        int discipline = -1;
        int category = -1;
        int number = -1;
        if (args.length == 1) {
            fileName = args[0];
        } else if (args.length == 4) {
            fileName = args[0];
            discipline = Integer.parseInt(args[1]);
            category = Integer.parseInt(args[2]);
            number = Integer.parseInt(args[3]);
        } else {
            System.out.println("Not correct number of parms, either 1 or 4");
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        Grib2ExtractRawData erd = new Grib2ExtractRawData(raf);
        erd.scan(discipline, category, number);
    }
}

